/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control.test;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.WebOffice;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.control.model.WebOfficeMark;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;

public class DocDetailPlugIn
extends AbstractFormPlugin
implements UploadListener {
    private static final Log LOG = LogFactory.getLog(DocDetailPlugIn.class);

    public void afterCreateNewData(EventObject e) {
        FormShowParameter param = this.getView().getFormShowParameter();
        Object tplId = param.getCustomParam("tplId");
        if (tplId != null) {
            this.initDocGrid(tplId);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        Object tplId = param.getCustomParam("tplId");
        DynamicObject tpl = BusinessDataServiceHelper.loadSingle((Object)tplId, (String)"test_wb_doc_templete");
        DynamicObjectCollection perms = tpl.getDynamicObjectCollection("entity_edit_perm");
        String userId = RequestContext.get().getUserId();
        ArrayList<String> marks = new ArrayList<String>();
        for (DynamicObject perm : perms) {
            String id;
            DynamicObject user = (DynamicObject)perm.get("edit_user");
            if (user == null || !userId.equals(id = user.getPkValue().toString())) continue;
            marks.add(perm.getString("bookmark"));
        }
        String url = tpl.getString("current_doc_url");
        if (StringUtils.isNotBlank((CharSequence)url)) {
            url = UrlService.getAttachmentFullUrl((String)url);
            WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
            webOffice.open(url);
            if (!marks.isEmpty()) {
                webOffice.setEditableAreas(marks, "webofficeap");
            } else {
                for (DynamicObject perm : perms) {
                    DynamicObject user = (DynamicObject)perm.get("edit_user");
                    String id = user.getPkValue().toString();
                    if (userId.equals(id)) continue;
                    webOffice.deleteSelectedAreaEditBookmark(perm.getString("bookmark"));
                }
            }
        }
    }

    private void initDocGrid(Object id) {
        DynamicObjectCollection perms;
        String markValue;
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)"test_wb_doc_templete");
        DynamicObjectCollection list = object.getDynamicObjectCollection("entry_variable");
        if (null != list && !list.isEmpty()) {
            this.getModel().batchCreateNewEntryRow("entryentity_doc", list.size());
            for (int i = 0; i < list.size(); ++i) {
                DynamicObject obj = (DynamicObject)list.get(i);
                String name = obj.getString("variable_name");
                String markKey = obj.getString("variable_key");
                markValue = obj.getString("variable_value");
                String varaible = obj.getString("variable_map");
                this.getModel().setValue("doc_name", (Object)name, i);
                this.getModel().setValue("doc_variable", (Object)varaible, i);
                this.getModel().setValue("doc_key", (Object)markKey, i);
                this.getModel().setValue("doc_value", (Object)markValue, i);
                this.getModel().setValue("doc_del", (Object)"delete bookmark", i);
                this.getModel().setValue("doc_location", (Object)"position bookmark", i);
            }
        }
        if (null != (perms = object.getDynamicObjectCollection("entity_edit_perm")) && !perms.isEmpty()) {
            this.getModel().batchCreateNewEntryRow("entity_edit", perms.size());
            for (int i = 0; i < perms.size(); ++i) {
                DynamicObject obj = (DynamicObject)perms.get(i);
                DynamicObject editor = obj.getDynamicObject("edit_user");
                markValue = obj.getString("bookmark");
                this.getModel().setValue("editor", (Object)editor, i);
                this.getModel().setValue("edit_bookmark", (Object)markValue, i);
                this.getModel().setValue("edit_operation", (Object)"delete bookmark", i);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getControl("toolbarap");
        toolbar.addItemClickListener((ItemClickListener)this);
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.addUploadListener(this);
    }

    public void afterUpload(UploadEvent evt) {
        String key;
        super.afterUpload(evt);
        Object[] urls = evt.getUrls();
        if (null == urls || urls.length == 0) {
            this.getView().showErrorNotification("please upload file");
            return;
        }
        Object urlData = urls[0];
        String filePath = "";
        String fileName = "";
        String url = "";
        if (urlData instanceof String) {
            filePath = urlData.toString();
            fileName = filePath.substring(filePath.lastIndexOf(47));
            String[] files = fileName.split("\\.");
            String tFileName = files.length == 2 ? files[0] : UUID.randomUUID().toString();
            try {
                tFileName = URLEncoder.encode(tFileName, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                LOG.error(e.getMessage());
            }
            String tExtend = files.length == 2 ? files[1] : "doc";
            fileName = tFileName + "." + tExtend;
            url = filePath;
        } else if (urlData instanceof Map) {
            filePath = ((Map)urlData).get("url").toString();
            fileName = UUID.randomUUID().toString();
            url = filePath;
        }
        if (url.contains("tempfile")) {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            InputStream in = cache.getInputStream(url);
            FileService service = FileServiceFactory.getAttachmentFileService();
            String suffix = ".doc";
            this.getPageCache().remove("opentype");
            String path = "/webofficedemo_" + System.currentTimeMillis() + "/" + fileName + suffix;
            try {
                fileName = URLEncoder.encode(fileName, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                LOG.error(e.getMessage());
            }
            fileName = fileName + suffix;
            FileItem fileItem = new FileItem(fileName, path, in);
            fileItem.setCreateNewFileWhenExists(true);
            String turl = service.upload(fileItem);
            cache.remove(url);
            url = turl;
        }
        if ("webofficeap".equals(key = evt.getCallbackKey())) {
            int versionCode;
            DynamicObjectCollection bookMarks = this.getModel().getEntryEntity("entryentity_doc");
            FormShowParameter param = this.getView().getFormShowParameter();
            Long tplId = (Long)param.getCustomParam("tplId");
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)tplId, (String)"test_wb_doc_templete");
            object.set("current_doc_url", (Object)url);
            object.set("current_doc_name", (Object)fileName);
            DynamicObjectCollection versions = object.getDynamicObjectCollection("entry_version");
            int n = versionCode = versions == null || versions.isEmpty() ? 1 : ((DynamicObject)versions.get(versions.size() - 1)).getInt("version") + 1;
            if (versions != null) {
                DynamicObject version = new DynamicObject(versions.getDynamicObjectType());
                version.set("version_name", (Object)fileName);
                version.set("version_url", (Object)url);
                version.set("version", (Object)versionCode);
                version.set("seq", (Object)versionCode);
                versions.add((Object)version);
            }
            DynamicObjectCollection list = object.getDynamicObjectCollection("entry_variable");
            list.clear();
            int index = 1;
            for (DynamicObject mark : bookMarks) {
                DynamicObject obj = new DynamicObject(list.getDynamicObjectType());
                obj.set("variable_name", mark.get("doc_name"));
                obj.set("variable_key", mark.get("doc_key"));
                obj.set("variable_value", mark.get("doc_value"));
                obj.set("variable_map", mark.get("doc_variable"));
                obj.set("seq", (Object)index++);
                list.add((Object)obj);
            }
            DynamicObjectCollection permMarks = this.getModel().getEntryEntity("entity_edit");
            DynamicObjectCollection perms = object.getDynamicObjectCollection("entity_edit_perm");
            perms.clear();
            index = 1;
            for (DynamicObject mark : permMarks) {
                DynamicObject obj = new DynamicObject(perms.getDynamicObjectType());
                obj.set("edit_user", mark.get("editor"));
                obj.set("bookmark", mark.get("edit_bookmark"));
                obj.set("seq", (Object)index++);
                WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
                webOffice.setSelectedAreaEditBookmark((String)mark.get("edit_bookmark"));
                perms.add((Object)obj);
            }
            BusinessDataWriter.save((IDataEntityType)object.getDynamicObjectType(), (Object[])new Object[]{object});
            this.getView().showSuccessNotification("save success");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "btn_replace": {
                this.replaceDoc();
                break;
            }
            case "save": {
                this.save();
            }
        }
    }

    private void save() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.save("Contract Number");
    }

    private void replaceDoc() {
        FormShowParameter param = this.getView().getFormShowParameter();
        Long id = (Long)param.getCustomParam("id");
        Long tplId = (Long)param.getCustomParam("tplId");
        DynamicObject tpl = BusinessDataServiceHelper.loadSingle((Object)tplId, (String)"test_wb_doc_templete");
        DynamicObjectCollection tplVariables = tpl.getDynamicObjectCollection("entry_variable");
        DynamicObject doc = BusinessDataServiceHelper.loadSingle((Object)id, (String)"test_wb_doc");
        ArrayList<WebOfficeMark> marks = new ArrayList<WebOfficeMark>();
        for (DynamicObject variable : tplVariables) {
            String map = variable.getString("variable_map");
            String key = variable.getString("variable_key");
            if ("".equals(map)) continue;
            String value = StringUtil.toSafeString((Object)doc.get(map));
            marks.add(new WebOfficeMark(key, value));
        }
        if (!marks.isEmpty()) {
            WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
            webOffice.modifyMarks(marks);
        }
    }

    public static FormShowParameter show(Long id, Long tplId) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("test_wb_doc_detail");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("id", (Object)id);
        param.setCustomParam("tplId", (Object)tplId);
        return param;
    }
}

