/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.form.helper;

import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class WebOfficeBrowserParam {
    private static final String PROTOCOL_NORMAL = "WebOffice://|Officectrl|";
    private static final String PROTOCOL_HIDE_ADDRESS_BAR = "WebOffice://|Officectrl.com|";
    private static final String PROTOCOL_SEPERATOR = "|";
    private Integer width;
    private Integer height;
    private Integer topX;
    private Integer topY;
    private boolean hideAddressBar = false;
    private String formId;
    private String billFormId;
    private String pkId;
    private BillOperationStatus status;
    private Map<String, Object> params;

    public WebOfficeBrowserParam(String formId) {
        this.formId = formId;
    }

    public WebOfficeBrowserParam(String formId, String pkId, BillOperationStatus status) {
        this.pkId = pkId;
        this.formId = formId;
        this.status = status;
    }

    public WebOfficeBrowserParam(String formId, Map<String, Object> params) {
        this.formId = formId;
        this.params = params;
    }

    public WebOfficeBrowserParam(String formId, String billFormId) {
        this.formId = formId;
        this.billFormId = billFormId;
    }

    public WebOfficeBrowserParam(String formId, String billFormId, Map<String, Object> params) {
        this.formId = formId;
        this.billFormId = billFormId;
        this.params = params;
    }

    public WebOfficeBrowserParam setBrowserSize(Integer width, Integer height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public WebOfficeBrowserParam setBrowserPosition(Integer topX, Integer topY) {
        this.topX = topX;
        this.topY = topY;
        return this;
    }

    public WebOfficeBrowserParam setHideAddressBar(boolean hideAddressBar) {
        this.hideAddressBar = hideAddressBar;
        return this;
    }

    public WebOfficeBrowserParam setParams(Map<String, Object> params) {
        this.params = params;
        return this;
    }

    public WebOfficeBrowserParam setStatus(BillOperationStatus status) {
        this.status = status;
        return this;
    }

    public String getPkId() {
        return this.pkId;
    }

    public WebOfficeBrowserParam setPkId(String pkId) {
        this.pkId = pkId;
        return this;
    }

    public BillOperationStatus getStatus() {
        return this.status;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public Integer getTopX() {
        return this.topX;
    }

    public Integer getTopY() {
        return this.topY;
    }

    public boolean isHideAddressBar() {
        return this.hideAddressBar;
    }

    public String getFormId() {
        return this.formId;
    }

    public String getBillFormId() {
        return this.billFormId;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public String getProtocol() {
        StringBuilder protocol = new StringBuilder();
        if (this.hideAddressBar) {
            protocol.append(PROTOCOL_HIDE_ADDRESS_BAR);
        } else {
            protocol.append(PROTOCOL_NORMAL);
        }
        if (null != this.width && null != this.height) {
            protocol.append('(').append(this.width).append(',').append(this.height).append(')').append(PROTOCOL_SEPERATOR);
            if (null != this.topX && null != this.topY) {
                protocol.append('(').append(this.topX).append('(').append(this.topY).append('(').append(PROTOCOL_SEPERATOR);
            }
        }
        return protocol.toString();
    }
}

