/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.kit;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.earlywarn.kit.CollectionKit;
import kd.bos.designer.earlywarn.kit.StringKit;
import kd.bos.entity.earlywarn.warnschedule.RunCycle;
import kd.bos.entity.earlywarn.warnschedule.WarnSchedule;
import kd.bos.entity.earlywarn.warnschedule.runcycle.RunCyclePeriod;
import kd.bos.entity.earlywarn.warnschedule.runcycle.RunCyclePeriodType;
import kd.bos.entity.earlywarn.warnschedule.runcycle.RunCycleRangeType;
import kd.bos.lang.Lang;
import kd.bos.metadata.earlywarn.warnschedule.WarnScheduleMetadata;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.RepeatModeEnum;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.earlywarn.WarnScheduleMetaServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class JobKit {
    private static final String MONTH_TAG = "month";

    public static void sync(WarnScheduleMetadata meta) {
        WarnSchedule schedule = meta.getWarnSchedule();
        JobDispatcherProxy jobProxy = new JobDispatcherProxy();
        String jobId = JobKit.syncJob(jobProxy, schedule);
        String planId = JobKit.syncPlan(jobProxy, schedule, jobId);
        schedule.setJobId(jobId);
        schedule.setPlanId(planId);
        schedule.setLastSyncTime(KDDateUtils.now());
        WarnScheduleMetaServiceHelper.save(meta);
    }

    private static String syncPlan(JobDispatcherProxy jobProxy, WarnSchedule schedule, String jobId) {
        RunCycle runCycle = schedule.getRunCycle();
        PlanInfo planInfo = JobKit.createPlanInfo(runCycle);
        String planId = schedule.getPlanId();
        planInfo.setName(schedule.getName().getLocaleValue());
        planInfo.setNumber("EW_" + schedule.getNumber());
        planInfo.setEnable(schedule.isEnable());
        planInfo.setJobId(jobId);
        planInfo.setId(planId);
        boolean isPlanIdExisted = QueryServiceHelper.exists((String)"sch_schedule", (Object)planId);
        if (StringKit.isNotBlank(planId) && isPlanIdExisted) {
            return jobProxy.updatePlan(planInfo);
        }
        return jobProxy.createPlan(planInfo);
    }

    public static PlanInfo createPlanInfo(RunCycle runCycle) {
        String executeType;
        Calendar endTime;
        String endTimeStr;
        DateFormat sdf;
        PlanInfo planInfo = new PlanInfo();
        Calendar startTime = Calendar.getInstance();
        String startDateStr = runCycle.getStartDate() + " " + runCycle.getRunTimeStr();
        Date startDate = KDDateUtils.parseDateTime((String)startDateStr);
        startTime.setTime(startDate);
        planInfo.setStartTime(startTime);
        Date endDate = runCycle.getEndDateObj();
        RunCycleRangeType rangeType = RunCycleRangeType.getByName(runCycle.getRangeType());
        if (RunCycleRangeType.DateRange == rangeType) {
            endDate = null != endDate ? endDate : KDDateUtils.addYears((Date)new Date(), (int)100);
            sdf = KDDateFormatUtils.getDateFormat();
            endTimeStr = sdf.format(endDate) + " " + runCycle.getRunTimeStr();
            endTime = Calendar.getInstance();
            endTime.setTime(KDDateUtils.parseDateTime((String)endTimeStr));
            planInfo.setEndTime(endTime);
        } else {
            endDate = KDDateUtils.addYears((Date)startDate, (int)100);
            sdf = KDDateFormatUtils.getDateFormat();
            endTimeStr = sdf.format(endDate) + " " + runCycle.getRunTimeStr();
            endTime = Calendar.getInstance();
            endTime.setTime(KDDateUtils.parseDateTime((String)endTimeStr));
            planInfo.setEndTime(endTime);
        }
        RunCyclePeriodType periodType = RunCyclePeriodType.getByValue(runCycle.getPeriodType());
        if (RunCyclePeriodType.Day == periodType) {
            planInfo.setRepeatMode(RepeatModeEnum.ByDays);
            planInfo.setPeriod(runCycle.getPeriod());
        } else if (RunCyclePeriodType.Week == periodType) {
            List weeks = runCycle.getPeriodValues().stream().map(d -> d.getCronValue()).collect(Collectors.toList());
            planInfo.setRepeatMode(RepeatModeEnum.ByWeeks);
            planInfo.setWeekdaysExp(StringKit.join(weeks));
            planInfo.setPeriod(runCycle.getPeriod());
        } else if (RunCyclePeriodType.Month == periodType) {
            executeType = runCycle.getExecuteType();
            List dayOrWeek = runCycle.getPeriodValues().stream().map(d -> d.getCronValue()).collect(Collectors.toList());
            if (StringUtils.equals((CharSequence)executeType, (CharSequence)"by_week")) {
                String week = StringKit.join(dayOrWeek) + "#" + runCycle.getWhichNumber();
                planInfo.setWeekdaysExp(week);
            } else {
                planInfo.setDaysExp(StringKit.join(dayOrWeek));
            }
            planInfo.setRepeatMode(RepeatModeEnum.ByMonths);
            planInfo.setPeriod(runCycle.getPeriod());
        } else if (RunCyclePeriodType.Year == periodType) {
            executeType = runCycle.getExecuteType();
            Map<String, String> periodValueMap = JobKit.getPeriodValueMap(runCycle.getPeriodValues());
            if (MapUtils.isNotEmpty(periodValueMap)) {
                if (StringUtils.equals((CharSequence)executeType, (CharSequence)"by_week")) {
                    String week = periodValueMap.get("dayOrWeek") + "#" + runCycle.getWhichNumber();
                    planInfo.setWeekdaysExp(week);
                } else {
                    planInfo.setDaysExp(periodValueMap.get("dayOrWeek"));
                }
            }
            planInfo.setMonthsExp(periodValueMap.get(MONTH_TAG));
            planInfo.setRepeatMode(RepeatModeEnum.ByYears);
            planInfo.setPeriod(runCycle.getPeriod());
        } else if (RunCyclePeriodType.Minute == periodType) {
            planInfo.setRepeatMode(RepeatModeEnum.ByMinutes);
            planInfo.setPeriod(runCycle.getPeriod());
        } else if (RunCyclePeriodType.Hour == periodType) {
            planInfo.setRepeatMode(RepeatModeEnum.ByHours);
            planInfo.setPeriod(runCycle.getPeriod());
        } else if (RunCyclePeriodType.Cron == periodType) {
            planInfo.setCronExpression(runCycle.getCronExpr());
        }
        return planInfo;
    }

    private static Map<String, String> getPeriodValueMap(List<RunCyclePeriod> runCyclePeriods) {
        HashMap<String, String> stringMap = new HashMap<String, String>(2);
        if (CollectionUtils.isEmpty(runCyclePeriods)) {
            return stringMap;
        }
        ArrayList<String> months = new ArrayList<String>(16);
        ArrayList<String> dayOrWeek = new ArrayList<String>(16);
        for (RunCyclePeriod periodValue : runCyclePeriods) {
            String value = periodValue.getValue();
            if (value.endsWith(MONTH_TAG)) {
                months.add(periodValue.getCronValue());
                continue;
            }
            dayOrWeek.add(periodValue.getCronValue());
        }
        stringMap.put(MONTH_TAG, StringKit.join(months));
        stringMap.put("dayOrWeek", StringKit.join(dayOrWeek));
        return stringMap;
    }

    private static String dispatchJob(JobDispatcherProxy jobProxy, WarnSchedule schedule) {
        String jobId = schedule.getJobId();
        String appNumber = BizAppServiceHelp.getAppNumByAppId((String)schedule.getBizAppId());
        JobInfo jobInfo = new JobInfo();
        if (StringKit.isNotBlank(jobId)) {
            jobInfo.setId(jobId);
        }
        jobInfo.setlName(schedule.getName());
        jobInfo.setNumber(schedule.getNumber());
        jobInfo.setRunByUserId(1L);
        jobInfo.setTaskClassname("kd.bos.service.earlywarn.EarlyWarnScheduleTask");
        jobInfo.setEnable(schedule.isEnable());
        jobInfo.setAppId(appNumber);
        jobInfo.setJobType(JobType.BIZ);
        JobKit.createTaskDefineId(jobInfo, schedule);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("warnScheduleId", schedule.getId());
        jobInfo.setParams(params);
        return jobProxy.dispatch(jobInfo);
    }

    private static String syncJob(JobDispatcherProxy jobProxy, WarnSchedule schedule) {
        boolean success;
        String jobId = schedule.getJobId();
        if (StringKit.isNotBlank(jobId) && (success = jobProxy.deleteJob(jobId))) {
            ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
            scheduleManager.afterUpdateJob(jobId);
        }
        String appNumber = BizAppServiceHelp.getAppNumByAppId((String)schedule.getBizAppId());
        JobInfo jobInfo = new JobInfo();
        jobInfo.setId(jobId);
        jobInfo.setlName(schedule.getName());
        jobInfo.setNumber(schedule.getNumber());
        jobInfo.setRunByUserId(1L);
        jobInfo.setTaskClassname("kd.bos.service.earlywarn.EarlyWarnScheduleTask");
        jobInfo.setEnable(schedule.isEnable());
        jobInfo.setAppId(appNumber);
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setRunByLang(Lang.get());
        JobKit.createTaskDefineId(jobInfo, schedule);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("warnScheduleId", schedule.getId());
        jobInfo.setParams(params);
        return jobProxy.createJob(jobInfo);
    }

    private static void createTaskDefineId(JobInfo jobInfo, WarnSchedule schedule) {
        String taskDefinedId = "EW_" + schedule.getId();
        jobInfo.setTaskDefineId(taskDefinedId);
        if (!QueryServiceHelper.exists((String)"sch_taskdefine", (Object)taskDefinedId)) {
            DynamicObject taskDefine = BusinessDataServiceHelper.newDynamicObject((String)"sch_taskdefine");
            taskDefine.set("id", (Object)taskDefinedId);
            taskDefine.set("classname", (Object)jobInfo.getTaskClassname());
            taskDefine.set("number", (Object)jobInfo.getNumber());
            taskDefine.set("name", (Object)ResManager.getLocaleString((String)"\u9884\u8b66\u76d1\u63a7\u65b9\u6848\u6267\u884c\u7c7b", (String)"JobKit_0", (String)"bos-earlywarn"));
            String appId = jobInfo.getAppId();
            taskDefine.set("appid", (Object)(StringUtils.isBlank((CharSequence)appId) ? "bos" : appId));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskDefine});
        }
    }

    public static void deleteBatch(DynamicObjectCollection deleteJobList) {
        if (CollectionKit.isEmpty(deleteJobList)) {
            return;
        }
        JobDispatcherProxy jobProxy = new JobDispatcherProxy();
        for (DynamicObject obj : deleteJobList) {
            String jobId = obj.getString("job_id");
            String planId = obj.getString("plan_id");
            if (StringKit.isNotBlank(jobId)) {
                jobProxy.deleteJob(jobId);
            }
            if (!StringKit.isNotBlank(planId)) continue;
            jobProxy.deletePlan(planId);
        }
    }
}

