/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.schedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.earlywarn.utils.FormulaEditUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.func.FuncSettingHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.FormulaException;

public class FormulaConditionPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    public static final String CustParamKey_TreeNodes = "treenodes";
    public static final String FILED_EXPRESSION = "fexpression";
    public static final String FILED_DESCRIPTION = "fdescription";
    public static final String FILED_TRANSLATION = "ftranexpr";
    public static final String CONTROL_TREE_VIEW = "tv_fields";
    public static final String KEY_FUNCTION = "btnfunction";
    public static final String KEY_CLR = "clr";
    public static final String KEY_BACKSPACE = "backspace";
    public static final String KEY_ADD = "btnadd";
    public static final String KEY_SUBTRACT = "btnsubtraction";
    public static final String KEY_MULTIPLE = "btnmultiplication";
    public static final String KEY_DIVISION = "btndivison";
    public static final String KEY_EQUAL = "btnequal";
    public static final String KEY_NOT_EQUAL = "btnnotequal";
    public static final String KEY_LESS_THEN = "btnlessthen";
    public static final String KEY_MORE_THEN = "btnmorethen";
    public static final String KEY_LESS_EQUAL = "btnlessequal";
    public static final String KEY_MORE_EQUAL = "btnmoreequal";
    public static final String KEY_AND = "btnand";
    public static final String KEY_OR = "btnor";
    public static final String KEY_LEFT = "btnleft";
    public static final String KEY_RIGHT = "btnright";
    static final Map<String, String> operationCharacter = new HashMap<String, String>(){
        {
            this.put(FormulaConditionPlugin.KEY_ADD, "+");
            this.put(FormulaConditionPlugin.KEY_SUBTRACT, "-");
            this.put(FormulaConditionPlugin.KEY_MULTIPLE, "*");
            this.put(FormulaConditionPlugin.KEY_DIVISION, "/");
            this.put(FormulaConditionPlugin.KEY_EQUAL, "=");
            this.put(FormulaConditionPlugin.KEY_NOT_EQUAL, "!=");
            this.put(FormulaConditionPlugin.KEY_LESS_THEN, "<");
            this.put(FormulaConditionPlugin.KEY_LESS_EQUAL, "<=");
            this.put(FormulaConditionPlugin.KEY_LEFT, "(");
            this.put(FormulaConditionPlugin.KEY_MORE_THEN, ">");
            this.put(FormulaConditionPlugin.KEY_MORE_EQUAL, ">=");
            this.put(FormulaConditionPlugin.KEY_RIGHT, ")");
            this.put(FormulaConditionPlugin.KEY_AND, "and");
            this.put(FormulaConditionPlugin.KEY_OR, "or");
            this.put(FormulaConditionPlugin.KEY_CLR, "CLR");
            this.put(FormulaConditionPlugin.KEY_BACKSPACE, "Backspace");
        }
    };

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{FILED_EXPRESSION, FILED_DESCRIPTION, FILED_TRANSLATION});
        this.addClickListeners(new String[]{KEY_FUNCTION, KEY_CLR, KEY_BACKSPACE, KEY_ADD, KEY_SUBTRACT, KEY_MULTIPLE, KEY_DIVISION, KEY_EQUAL, KEY_NOT_EQUAL, KEY_LESS_THEN, KEY_MORE_THEN, KEY_LESS_EQUAL, KEY_MORE_EQUAL, KEY_AND, KEY_OR, KEY_LEFT, KEY_RIGHT});
        TreeView treeView = (TreeView)this.getView().getControl(CONTROL_TREE_VIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)KEY_FUNCTION, (CharSequence)control.getKey())) {
            this.showFuncSetting();
            return;
        }
        if (operationCharacter.containsKey(control.getKey())) {
            this.operationKey(control.getKey());
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        FormulaEditUtils.insertExpression(this.getView(), CONTROL_TREE_VIEW, FILED_EXPRESSION, evt.getNodeId().toString());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (StringUtils.equals((CharSequence)FILED_EXPRESSION, (CharSequence)e.getProperty().getName())) {
            String expression = (String)this.getModel().getValue(FILED_EXPRESSION);
            String tranExpr = "";
            try {
                tranExpr = this.tranExpression(expression);
            }
            catch (FormulaException exp) {
                tranExpr = exp.getCause() != null ? exp.getCause().getMessage() : exp.getMessage();
            }
            catch (Exception exp) {
                tranExpr = ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u8bed\u6cd5\u89e3\u6790\u9519\u8bef\uff0c\u81ea\u52a8\u7ffb\u8bd1\u5931\u8d25", (String)"FormulaEdit_1", (String)"bos-earlywarn", (Object[])new Object[0]);
            }
            this.getModel().setValue(FILED_TRANSLATION, (Object)tranExpr);
        }
    }

    private String tranExpression(String expression) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return "";
        }
        String expressionDesc = expression;
        String[] vars = new String[]{};
        vars = FormulaEngine.extractVariables((String)expression);
        if (vars.length == 0 || StringUtils.isBlank((CharSequence)vars[0])) {
            return expressionDesc;
        }
        String json = this.getPageCache().get(CustParamKey_TreeNodes);
        TreeNode rootNode = new TreeNode();
        if (StringUtils.isNotBlank((CharSequence)json)) {
            rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
        }
        ArrayList<String> orderVars = new ArrayList<String>(10);
        orderVars.addAll(Arrays.asList(vars));
        orderVars.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.length() > o2.length()) {
                    return -1;
                }
                if (o1.length() < o2.length()) {
                    return 1;
                }
                return o2.compareTo(o1);
            }
        });
        HashMap<String, String> tmpVariables = new HashMap<String, String>(16);
        int i = 1;
        for (String string : orderVars) {
            String tempVariable = String.format("###%s###", String.valueOf(i));
            String varCaption = string;
            TreeNode node = rootNode.getTreeNode(string, 5);
            if (node != null) {
                varCaption = node.getText();
            }
            tmpVariables.put(tempVariable, varCaption);
            expressionDesc = expressionDesc.replace(string, tempVariable);
            ++i;
        }
        for (Map.Entry entry : tmpVariables.entrySet()) {
            expressionDesc = expressionDesc.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return expressionDesc;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)KEY_FUNCTION, (CharSequence)closedCallBackEvent.getActionId())) {
            Object expression = closedCallBackEvent.getReturnData();
            if (StringUtils.isBlank((Object)expression)) {
                return;
            }
            FormulaEditUtils.insertExpression(this.getView(), KEY_FUNCTION, FILED_EXPRESSION, (String)expression);
        }
    }

    private void showFuncSetting() {
        String funcsXML = (String)this.getView().getFormShowParameter().getCustomParam("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsXML) && StringUtils.isBlank((CharSequence)(funcsXML = this.getPageCache().get("functiontypes")))) {
            FunctionTypes functionTypes = FunctionTypes.getCommonFuncs();
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put("functiontypes", funcsXML);
        }
        String jsonNode = this.getPageCache().get(CustParamKey_TreeNodes);
        String entityNumber = this.getPageCache().get("entitynumber");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_FUNCTION);
        FuncSettingHelper.show((String)funcsXML, (String)entityNumber, (String)jsonNode, null, (IFormView)this.getView(), (CloseCallBack)closeCallBack);
    }

    private void operationKey(String key) {
        String character = operationCharacter.get(key);
        if (StringUtils.equals((CharSequence)key, (CharSequence)KEY_CLR)) {
            this.getModel().setValue(FILED_EXPRESSION, (Object)"");
            FormulaEditUtils.setCursorIndex(this.getView(), FILED_EXPRESSION, 0);
            return;
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)KEY_BACKSPACE)) {
            FormulaEditUtils.backSpaceExpression(this.getView(), key, FILED_EXPRESSION);
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)character)) {
            FormulaEditUtils.insertExpression(this.getView(), key, FILED_EXPRESSION, character);
        }
    }
}

