/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.schedule;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.earlywarn.kit.CollectionKit;
import kd.bos.designer.earlywarn.kit.StringKit;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.earlywarn.kit.StringTemplateParser;
import kd.bos.entity.earlywarn.warnschedule.MessageContent;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;

public class WSMessageEditPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
IConfirmCallBack {
    private static final String BOS_EARLYWARN = "bos-earlywarn";
    private static final String FORM_NUMBER = "bos_warn_message_edit";
    private static final String TXT_TEXT = "text";
    private static final String QUICK_PROCESS = "quick_process";
    private static final String TREE_VIEW = "tree_view";
    private static final String BTN_OK = "btn_ok";
    private static final String PARAM_TEXT = "param_text";
    private static final String PARAM_TREE = "param_tree";
    private static final String LEFT_BRACKET = "{";
    public static final String RIGHT_BRACKET = "}";
    public static final String KEY_SPECIAL_FIELD = "special_field";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
        TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void click(EventObject e) {
        super.click(e);
        Control control = (Control)e.getSource();
        if (BTN_OK.equals(control.getKey())) {
            String checkResultMessage;
            block5: {
                String text = StringKit.toSafeString(this.getModel().getValue(TXT_TEXT));
                checkResultMessage = "";
                try {
                    checkResultMessage = this.checkText(text);
                }
                catch (KDBizException exception) {
                    if (!"InvalidTemplate".equals(exception.getErrorCode().getCode())) break block5;
                    this.getView().showErrorNotification(exception.getMessage());
                    return;
                }
            }
            if (checkResultMessage.length() > 0) {
                this.getView().showConfirm(checkResultMessage, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(KEY_SPECIAL_FIELD, (IConfirmCallBack)this));
            } else {
                IFormView view = this.getView();
                view.returnDataToParent(this.getReturnData());
                view.close();
            }
        }
    }

    private String checkText(String text) {
        List fieldNodeList;
        StringBuilder errorText = new StringBuilder();
        TreeNode rootNode = this.getRootNode();
        if (rootNode == null) {
            return "";
        }
        String fieldNodeListJson = this.getPageCache().get("fieldNodeList");
        if (StringUtils.isBlank((CharSequence)fieldNodeListJson)) {
            fieldNodeList = this.getFieldNodeList(rootNode);
            this.getPageCache().put("fieldNodeList", SerializationUtils.toJsonString((Object)fieldNodeList));
        } else {
            fieldNodeList = SerializationUtils.fromJsonStringToList((String)fieldNodeListJson, String.class);
        }
        StringTemplateParser parser = new StringTemplateParser();
        ArrayList fieldList = new ArrayList();
        parser.parse(text, macroName -> {
            if (macroName != null) {
                fieldList.add(macroName);
            }
            return "";
        });
        for (String field : fieldList) {
            if (fieldNodeList.contains(field)) continue;
            errorText.append(LEFT_BRACKET).append(field).append(RIGHT_BRACKET).append("\u3001");
        }
        if (errorText.length() != 0) {
            errorText.deleteCharAt(errorText.length() - 1);
            String errTextPre = ResManager.loadKDString((String)"\u9884\u8b66\u5185\u5bb9\u4e2d\u8f93\u5165\u7684\u5173\u952e\u5b57\uff1a", (String)"WSMessageEditPlugin_0", (String)BOS_EARLYWARN, (Object[])new Object[0]);
            String errorTextSuf = ResManager.loadKDString((String)"\u7cfb\u7edf\u65e0\u6cd5\u8bc6\u522b\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6309\u6587\u672c\u5904\u7406\u3002", (String)"WSMessageEditPlugin_1", (String)BOS_EARLYWARN, (Object[])new Object[0]);
            errorText.insert(0, errTextPre).append("\uff0c").append(errorTextSuf);
        }
        return errorText.toString();
    }

    private List<String> getFieldNodeList(TreeNode node) {
        ArrayList<String> fieldNodeList = new ArrayList<String>(10);
        List children = node.getChildren();
        if (children == null) {
            fieldNodeList.add(node.getId());
            return fieldNodeList;
        }
        for (TreeNode childNode : children) {
            fieldNodeList.addAll(this.getFieldNodeList(childNode));
        }
        return fieldNodeList;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equalsIgnoreCase((CharSequence)KEY_SPECIAL_FIELD, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            IFormView view = this.getView();
            view.returnDataToParent(this.getReturnData());
            view.close();
        }
    }

    public void afterCreateNewData(EventObject e) {
        TreeNode root = this.getRootNode();
        if (null != root) {
            root.setIsOpened(true);
            TreeView treeView = this.getTreeView();
            treeView.addNode(root);
        }
        FormShowParameter param = this.getView().getFormShowParameter();
        String text = (String)param.getCustomParam(PARAM_TEXT);
        boolean isQuickProcessing = (Boolean)param.getCustomParam("param_isQuickProcessing");
        boolean isMergeSendMessage = (Boolean)param.getCustomParam("param_isMergeSendMessage");
        try {
            MessageContent messageContent = (MessageContent)SerializationUtils.fromJsonString((String)text, MessageContent.class);
            this.getModel().setValue(TXT_TEXT, (Object)messageContent.getMessageHead());
        }
        catch (Exception exception) {
            this.getModel().setValue(TXT_TEXT, (Object)text);
        }
        this.getModel().setValue(QUICK_PROCESS, (Object)isQuickProcessing);
        if (isMergeSendMessage) {
            this.getView().setVisible(Boolean.FALSE, new String[]{QUICK_PROCESS});
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        int cursorFocusIndex;
        String nodeId = StringKit.toSafeString(e.getNodeId());
        if (StringKit.isBlank(nodeId)) {
            return;
        }
        TreeNode root = this.getRootNode();
        if (null == root) {
            return;
        }
        TreeNode selectedNode = root.getTreeNode(nodeId, 16);
        if (null == selectedNode) {
            return;
        }
        if (CollectionKit.isNotEmpty(selectedNode.getChildren())) {
            return;
        }
        IDataModel model = this.getModel();
        String text = StringKit.toSafeString(model.getValue(TXT_TEXT));
        String postText = text.substring(cursorFocusIndex = this.getCursorFocusIndex(this.getView(), TREE_VIEW, TXT_TEXT));
        if (postText.indexOf(LEFT_BRACKET) > postText.indexOf(RIGHT_BRACKET) || !postText.contains(LEFT_BRACKET) && postText.contains(RIGHT_BRACKET)) {
            cursorFocusIndex += postText.indexOf(RIGHT_BRACKET) + 1;
            postText = text.substring(cursorFocusIndex);
        }
        String preText = text.substring(0, cursorFocusIndex);
        StringBuilder showText = new StringBuilder().append(preText).append(LEFT_BRACKET).append(nodeId).append(RIGHT_BRACKET).append(postText);
        model.setValue(TXT_TEXT, (Object)showText);
    }

    private int getCursorFocusIndex(IFormView view, String buttonKey, String textFieldKey) {
        String textValue = (String)view.getModel().getValue(textFieldKey);
        int cursorIndex = StringUtils.isBlank((CharSequence)textValue) ? 0 : textValue.length();
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        Object listPostData = proxy.getViewState(buttonKey);
        if (listPostData instanceof Map) {
            Map map = (Map)listPostData;
            if (map.get("focus") != null) {
                Map focus = (Map)map.get("focus");
                if (focus.get(textFieldKey) != null && focus.get(textFieldKey) instanceof Integer) {
                    cursorIndex = (Integer)focus.get(textFieldKey);
                }
            } else if (map.get(textFieldKey) != null) {
                cursorIndex = (Integer)map.get(textFieldKey);
            }
        }
        return cursorIndex;
    }

    private TreeView getTreeView() {
        return (TreeView)this.getView().getControl(TREE_VIEW);
    }

    private TreeNode getRootNode() {
        FormShowParameter param = this.getView().getFormShowParameter();
        String json = (String)param.getCustomParam(PARAM_TREE);
        if (StringKit.isNotBlank(json)) {
            return (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
        }
        return null;
    }

    public static FormShowParameter show(String message, TreeNode treeRoot, CloseCallBack callback) {
        String treeJson = treeRoot == null ? "" : SerializationUtils.toJsonString((Object)treeRoot);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(FORM_NUMBER);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(PARAM_TEXT, (Object)message);
        parameter.setCustomParam(PARAM_TREE, (Object)treeJson);
        parameter.setCloseCallBack(callback);
        return parameter;
    }

    private Map<String, Object> getReturnData() {
        HashMap<String, Object> returnDataMap = new HashMap<String, Object>(16);
        String text = StringKit.toSafeString(this.getModel().getValue(TXT_TEXT));
        boolean isQuickProcessing = (Boolean)this.getModel().getValue(QUICK_PROCESS);
        returnDataMap.put(TXT_TEXT, text);
        returnDataMap.put("isQuickProcessing", isQuickProcessing);
        return returnDataMap;
    }
}

