/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.schedule;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.earlywarn.kit.CollectionKit;
import kd.bos.designer.earlywarn.schedule.bo.WSPeriodBo;
import kd.bos.designer.earlywarn.schedule.widget.WSPeriodDialogViewHolder;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.earlywarn.warnschedule.runcycle.RunCyclePeriodType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;

public class WarnSchedulePeriodDialogPlugin
extends AbstractFormPlugin {
    private static final String FORM_NUMBER = "bos_warnschedule_period";
    private static final String BTN_CONFIRM = "btn_confirm";
    private static final String DATE_RANGE = "date_range";
    private static final String FROM_START_DATE = "from_start_date";
    private static final String MONITOR_START_TIME = "monitor_start_time";
    private static final String MONITOR_TIME_RANGE = "monitor_time_range";
    private static final String START_DATE = "start_date";
    private static final String END_DATE = "end_date";
    private static final String RANGE_TYPE = "range_type";
    private static final String PERIOD_REPEAT = "period_repeat";
    private static final String PERIOD_TYPE = "period_type";
    private static final String PERIOD_CRON = "period_cron";
    private static final String BOS_EARLYWARN = "bos-earlywarn";
    private WSPeriodDialogViewHolder viewHolder;

    public void initialize() {
        super.initialize();
        this.viewHolder = new WSPeriodDialogViewHolder(this.getView(), this.getModel());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CONFIRM});
    }

    public void afterCreateNewData(EventObject e) {
        this.viewHolder.init();
        FormShowParameter showParam = this.getView().getFormShowParameter();
        Map data = showParam.getCustomParams();
        WSPeriodBo period = new WSPeriodBo(data);
        this.viewHolder.show(period);
        if (DATE_RANGE.equals(period.getRangeType().getName())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{MONITOR_START_TIME});
        } else if (FROM_START_DATE.equals(period.getRangeType().getName())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{MONITOR_TIME_RANGE});
            this.getModel().getDataEntity().set(MONITOR_START_TIME, this.getModel().getDataEntity().get(START_DATE));
        }
    }

    public void click(EventObject e) {
        super.click(e);
        Control control = (Control)e.getSource();
        String key = control.getKey();
        if (BTN_CONFIRM.equals(key)) {
            this.doConfirm();
        }
    }

    private void doConfirm() {
        if (!this.viewHolder.checkData()) {
            return;
        }
        WSPeriodBo period = this.viewHolder.buildPeriodData();
        if (FROM_START_DATE.equals(this.getModel().getDataEntity().get(RANGE_TYPE))) {
            period.setStartDate((Date)this.getModel().getDataEntity().get(MONITOR_START_TIME));
            period.setEndDate((Date)this.getModel().getDataEntity().get(MONITOR_START_TIME));
        }
        this.getView().returnDataToParent(period.convertToMap());
        this.getView().close();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String newValue;
        Object[] changeDataArr = e.getChangeSet();
        if (CollectionKit.isEmpty(changeDataArr)) {
            return;
        }
        IDataEntityProperty property = e.getProperty();
        this.viewHolder.propertyChange(property, (ChangeData)changeDataArr[0]);
        if (StringUtils.equals((CharSequence)PERIOD_REPEAT, (CharSequence)property.getName()) || StringUtils.equals((CharSequence)PERIOD_TYPE, (CharSequence)property.getName())) {
            int periodValue = changeDataArr[0].getDataEntity().getInt(PERIOD_REPEAT);
            this.checkPeriodData(periodValue);
        }
        if (StringUtils.equals((CharSequence)PERIOD_CRON, (CharSequence)property.getName())) {
            this.viewHolder.checkCron(changeDataArr[0].getDataEntity().getString(property));
        }
        if (DATE_RANGE.equals(newValue = (String)changeDataArr[0].getDataEntity().get(RANGE_TYPE))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{MONITOR_START_TIME});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{MONITOR_TIME_RANGE});
            this.getModel().getDataEntity().set(MONITOR_START_TIME, changeDataArr[0].getDataEntity().get(START_DATE));
        } else if (FROM_START_DATE.equals(newValue)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{MONITOR_TIME_RANGE});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{MONITOR_START_TIME});
            this.getModel().getDataEntity().set(START_DATE, changeDataArr[0].getDataEntity().get(MONITOR_START_TIME));
            this.getModel().getDataEntity().set(END_DATE, changeDataArr[0].getDataEntity().get(MONITOR_START_TIME));
        }
    }

    private void checkPeriodData(int periodValue) {
        String typeValue = (String)this.getModel().getValue(PERIOD_TYPE);
        RunCyclePeriodType periodType = RunCyclePeriodType.getByValue(typeValue);
        if (RunCyclePeriodType.Minute == periodType && periodValue > 59) {
            this.getModel().setValue(PERIOD_REPEAT, (Object)59);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u91cd\u590d\u65f6\u95f4\u5355\u4f4d\u4e3a\u5206\u949f\uff0c\u6700\u591a\u53ea\u80fd\u6bcf59\u5206\u949f\u91cd\u590d\u6267\u884c\u3002", (String)"WarnSchedulePeriodDialogPlugin_0", (String)BOS_EARLYWARN, (Object[])new Object[0]));
        } else if (RunCyclePeriodType.Hour == periodType && periodValue > 23) {
            this.getModel().setValue(PERIOD_REPEAT, (Object)23);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u91cd\u590d\u65f6\u95f4\u5355\u4f4d\u4e3a\u5c0f\u65f6\uff0c\u6700\u591a\u53ea\u80fd\u6bcf23\u5c0f\u65f6\u91cd\u590d\u6267\u884c\u3002", (String)"WarnSchedulePeriodDialogPlugin_1", (String)BOS_EARLYWARN, (Object[])new Object[0]));
        } else if (RunCyclePeriodType.Day == periodType && periodValue > 31) {
            this.getModel().setValue(PERIOD_REPEAT, (Object)31);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u91cd\u590d\u65f6\u95f4\u5355\u4f4d\u4e3a\u5929\uff0c\u6700\u591a\u53ea\u80fd\u6bcf31\u5929\u91cd\u590d\u6267\u884c\u3002", (String)"WarnSchedulePeriodDialogPlugin_2", (String)BOS_EARLYWARN, (Object[])new Object[0]));
        } else if (RunCyclePeriodType.Week == periodType && periodValue != 1) {
            this.getModel().setValue(PERIOD_REPEAT, (Object)1);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u91cd\u590d\u65f6\u95f4\u5355\u4f4d\u4e3a\u5468\uff0c\u6682\u53ea\u652f\u6301\u6bcf\u5468\u91cd\u590d\u6267\u884c\u3002", (String)"WarnSchedulePeriodDialogPlugin_7", (String)BOS_EARLYWARN, (Object[])new Object[0]));
        } else if (RunCyclePeriodType.Month == periodType && periodValue > 12) {
            this.getModel().setValue(PERIOD_REPEAT, (Object)12);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u91cd\u590d\u65f6\u95f4\u5355\u4f4d\u4e3a\u6708\uff0c\u6700\u591a\u53ea\u80fd\u6bcf12\u6708\u91cd\u590d\u6267\u884c\u3002", (String)"WarnSchedulePeriodDialogPlugin_3", (String)BOS_EARLYWARN, (Object[])new Object[0]));
        } else if (RunCyclePeriodType.Year == periodType && periodValue > 1) {
            this.getModel().setValue(PERIOD_REPEAT, (Object)1);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u91cd\u590d\u65f6\u95f4\u5355\u4f4d\u4e3a\u5e74\uff0c\u6682\u53ea\u652f\u6301\u6bcf\u5e74\u91cd\u590d\u6267\u884c\u3002", (String)"WarnSchedulePeriodDialogPlugin_4", (String)BOS_EARLYWARN, (Object[])new Object[0]));
        }
    }

    public static FormShowParameter show(WSPeriodBo period, CloseCallBack callback) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId(FORM_NUMBER);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParams(period.convertToMap());
        param.setCloseCallBack(callback);
        return param;
    }
}

