/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.schedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.earlywarn.kit.StringKit;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageReceiver;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageReceiverType;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageReceiverTypeEnum;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnSchedulePersonField;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnSchedulePersonRelation;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.UserProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;

public class WarnScheduleReceiverUserVariablePlugIn
extends AbstractFormPlugin {
    private static final String FORM_NUMBER = "bos_warn_receiver_userval";
    private static final String PARAM_DATA_SOURCE = "dataSource";
    private static final String PARAM_DATA_RECEIVER = "receivers";
    private static final String TOOL_BAR = "tru_container_toolbar";
    private static final String ENTRY_ENTITY = "tru_entry";
    private static final String BTN_ADD = "tru_btn_add";
    private static final String BTN_DELETE = "tru_btn_delete";
    private static final String RELATION_REF_PERSON = "tru_ref_person";
    private static final String RELATION = "tru_relation";
    private static final String BTN_OK = "btn_ok";
    private static final String BOS_USER = "bos_user";
    private static final String PERSON_FIELDS_CACHE = "person_fields_cache";

    private String getDataSource() {
        FormShowParameter param = this.getView().getFormShowParameter();
        return StringKit.toSafeString(param.getCustomParam(PARAM_DATA_SOURCE));
    }

    private boolean isUserField(IDataEntityProperty property) {
        if (property instanceof UserProp) {
            return true;
        }
        if (property instanceof BasedataProp && BOS_USER.equals(((BasedataProp)property).getBaseEntityId())) {
            return true;
        }
        return property instanceof MulBasedataProp && BOS_USER.equals(((MulBasedataProp)property).getBaseEntityId());
    }

    private List<WarnSchedulePersonField> getPersonFields() {
        IPageCache cache = this.getPageCache();
        String json = cache.get(PERSON_FIELDS_CACHE);
        if (StringKit.isNotBlank(json)) {
            return SerializationUtils.fromJsonStringToList((String)json, WarnSchedulePersonField.class);
        }
        ArrayList<WarnSchedulePersonField> personFields = new ArrayList<WarnSchedulePersonField>();
        String dataSource = this.getDataSource();
        if (StringKit.isBlank(dataSource)) {
            return personFields;
        }
        MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)dataSource);
        DataEntityPropertyCollection properties = mainEntity.getProperties();
        for (IDataEntityProperty property : properties) {
            if (!this.isUserField(property)) continue;
            LocaleString name = property.getDisplayName();
            String field = property.getName();
            personFields.add(new WarnSchedulePersonField(dataSource, field, name.getLocaleValue()));
        }
        if (!personFields.isEmpty()) {
            json = SerializationUtils.toJsonString(personFields);
            cache.put(PERSON_FIELDS_CACHE, json);
        }
        return personFields;
    }

    private List<ComboItem> getPersonFieldComboItems() {
        List<WarnSchedulePersonField> personFields = this.getPersonFields();
        return personFields.stream().map(field -> new ComboItem(new LocaleString(field.getName()), field.getField())).collect(Collectors.toList());
    }

    public void afterCreateNewData(EventObject e) {
        List receivers;
        String dataSource = this.getDataSource();
        if (StringKit.isBlank(dataSource)) {
            return;
        }
        MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)dataSource);
        if (null == mainEntity) {
            return;
        }
        List<ComboItem> personFields = this.getPersonFieldComboItems();
        ComboEdit personFiledCombo = (ComboEdit)this.getView().getControl(RELATION_REF_PERSON);
        personFiledCombo.setComboItems(personFields);
        List personRelations = Arrays.stream(WarnSchedulePersonRelation.values()).filter(r -> r != WarnSchedulePersonRelation.Empty).map(r -> new ComboItem(new LocaleString(r.getName()), r.getValue())).collect(Collectors.toList());
        ComboEdit personRelationCombo = (ComboEdit)this.getView().getControl(RELATION);
        personRelationCombo.setComboItems(personRelations);
        FormShowParameter param = this.getView().getFormShowParameter();
        String json = (String)param.getCustomParam(PARAM_DATA_RECEIVER);
        List list = receivers = StringKit.isBlank(json) ? new ArrayList() : SerializationUtils.fromJsonStringToList((String)json, WarnMessageReceiver.class);
        if (receivers.isEmpty()) {
            return;
        }
        IDataModel model = this.getModel();
        model.getEntryEntity(ENTRY_ENTITY).clear();
        model.batchCreateNewEntryRow(ENTRY_ENTITY, receivers.size());
        for (int i = 0; i < receivers.size(); ++i) {
            WarnMessageReceiver receiver = (WarnMessageReceiver)receivers.get(i);
            model.setValue(RELATION_REF_PERSON, (Object)receiver.getField(), i);
            model.setValue(RELATION, (Object)receiver.getRelation(), i);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOL_BAR});
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void click(EventObject e) {
        super.click(e);
        Control control = (Control)e.getSource();
        if (!StringKit.equals(BTN_OK, control.getKey())) {
            return;
        }
        List<WarnSchedulePersonField> personFields = this.getPersonFields();
        HashMap<String, WarnSchedulePersonField> personFieldMap = new HashMap<String, WarnSchedulePersonField>(16);
        for (WarnSchedulePersonField field : personFields) {
            personFieldMap.put(field.getField(), field);
        }
        DynamicObjectCollection list = this.getModel().getEntryEntity(ENTRY_ENTITY);
        LinkedList<WarnMessageReceiver> receivers = new LinkedList<WarnMessageReceiver>();
        String receiverType = WarnMessageReceiverTypeEnum.RelationPerson.getId();
        for (DynamicObject obj : list) {
            WarnSchedulePersonRelation relationEnum;
            String person = obj.getString(RELATION_REF_PERSON);
            String relation = obj.getString(RELATION);
            WarnSchedulePersonField personField = (WarnSchedulePersonField)personFieldMap.get(person);
            if (null == personField || null == (relationEnum = WarnSchedulePersonRelation.getBy(relation))) continue;
            String name = personField.getName() + "-" + relationEnum.getName();
            WarnMessageReceiver receiver = new WarnMessageReceiver();
            receiver.setReceiverType(receiverType);
            receiver.setId(person + "-" + relation);
            receiver.setName(name);
            receiver.setDataSource(this.getDataSource());
            receiver.setField(person);
            receiver.setRelation(relation);
            receivers.add(receiver);
        }
        WarnMessageReceiverType type = new WarnMessageReceiverType();
        type.setType(receiverType);
        type.setReceivers(receivers);
        this.getView().returnDataToParent((Object)type);
        this.getView().close();
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        switch (e.getItemKey()) {
            case "tru_btn_add": {
                this.addItem();
                break;
            }
            case "tru_btn_delete": {
                this.deleteItem();
                break;
            }
        }
    }

    private void addItem() {
        this.getModel().createNewEntryRow(ENTRY_ENTITY);
    }

    private void deleteItem() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int focusedRowIndex = entryGrid.getEntryState().getFocusRow();
        if (-1 == focusedRowIndex) {
            return;
        }
        this.getModel().deleteEntryRow(ENTRY_ENTITY, focusedRowIndex);
    }

    public static FormShowParameter show(String dataSource, List<WarnMessageReceiver> receivers, CloseCallBack callBack) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId(FORM_NUMBER);
        param.setCustomParam(PARAM_DATA_SOURCE, (Object)dataSource);
        param.setCustomParam(PARAM_DATA_RECEIVER, (Object)SerializationUtils.toJsonString(receivers));
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(callBack);
        return param;
    }
}

