/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.schedule;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.earlywarn.kit.BillListKit;
import kd.bos.designer.earlywarn.kit.CollectionKit;
import kd.bos.designer.earlywarn.kit.JobKit;
import kd.bos.designer.earlywarn.kit.StringKit;
import kd.bos.designer.earlywarn.permission.EarlyWarnPermission;
import kd.bos.designer.earlywarn.permission.EarlyWarnPermissionEnum;
import kd.bos.designer.earlywarn.schedule.WarnScheduleEditPlugin;
import kd.bos.designer.earlywarn.utils.LogUtils;
import kd.bos.designer.earlywarn.utils.TreeNodeUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.metadata.earlywarn.warnschedule.WarnScheduleMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.earlywarn.WarnScheduleMetaServiceHelper;
import kd.bos.svc.util.TreeNodeFilter;

public class WarnScheduleTreeListPlugin
extends StandardTreeListPlugin {
    private static final String BTN_NEW = "btn_new";
    private static final String BTN_COPY = "btn_copy";
    private static final String BTN_DELETE = "btn_del";
    private static final String BTN_ENABLE = "btn_enable";
    private static final String BTN_DISABLE = "btn_disable";
    private static final String ENTITY_NAME = "bos_warnschedule";
    private static final String APPID = "cts";
    private static final String BOS_EARLYWARN = "bos-earlywarn";
    private static final String BTN_TREENEW = "btnnew";
    private static final String BTN_TREEEDIT = "btnedit";
    private static final String BTN_TREEDELETE = "btndel";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_TREENEW, BTN_TREEEDIT, BTN_TREEDELETE});
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        HyperLinkClickEvent e = args.getHyperLinkClickEvent();
        BillList billList = (BillList)e.getSource();
        if (BillListKit.isF7Open(billList)) {
            return;
        }
        ListSelectedRow selectedRow = billList.getCurrentSelectedRowInfo();
        String id = StringKit.toSafeString(selectedRow.getPrimaryKeyValue());
        if (StringUtils.isEmpty((CharSequence)id)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4fee\u6539\u7684\u76d1\u63a7\u65b9\u6848\u3002", (String)"WarnScheduleTreeListPlugin_0", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        boolean isView = !EarlyWarnPermission.permissionVerification(EarlyWarnPermissionEnum.MODIFY, RequestContext.get().getCurrUserId(), APPID, ENTITY_NAME);
        this.showEditForm("", id, Boolean.FALSE, isView);
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        switch (e.getItemKey()) {
            case "btn_new": {
                if (!EarlyWarnPermission.permissionVerification(EarlyWarnPermissionEnum.NEW, Long.parseLong(RequestContext.get().getUserId()), APPID, ENTITY_NAME)) {
                    this.showNoPermissionErrorNotification(ResManager.loadKDString((String)"\u65b0\u589e", (String)"WarnScheduleTreeListPlugin_17", (String)BOS_EARLYWARN, (Object[])new Object[0]));
                    break;
                }
                this.showEditForm(this.getBizAppId(), "new_warn_schedule", Boolean.FALSE, Boolean.FALSE);
                OpLogAppInfo logInfo = new OpLogAppInfo();
                MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u65b0\u589e", "WarnScheduleTreeListPlugin_17", BOS_EARLYWARN);
                logInfo.setOpName("add", opNameBridge);
                MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u65b0\u589e\u6210\u529f\u3002", "WarnScheduleTreeListPlugin_16", BOS_EARLYWARN);
                logInfo.setOpDesc(opDescBridge, new String[0]);
                logInfo.setBizObjID(ENTITY_NAME);
                LogUtils.addLog(this.getView(), (AppLogInfo)logInfo);
                break;
            }
            case "btn_copy": {
                this.doCopy();
                break;
            }
            case "btn_enable": {
                this.showEnableConfirm();
                break;
            }
            case "btn_disable": {
                this.showDisableConfirm();
                break;
            }
            case "btn_del": {
                this.showDeleteConfirm();
                break;
            }
        }
    }

    private void showDeleteConfirm() {
        if (!EarlyWarnPermission.permissionVerification(EarlyWarnPermissionEnum.DELETE, Long.parseLong(RequestContext.get().getUserId()), APPID, ENTITY_NAME)) {
            this.showNoPermissionErrorNotification(ResManager.loadKDString((String)"\u5220\u9664", (String)"WarnScheduleTreeListPlugin_18", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        IListView view = (IListView)this.getView();
        ListSelectedRowCollection collection = view.getSelectedRows();
        if (null == collection || collection.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u76d1\u63a7\u65b9\u6848\u3002", (String)"WarnScheduleTreeListPlugin_1", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        for (ListSelectedRow listSelectedRow : collection) {
            boolean isEnable = WarnScheduleMetaServiceHelper.loadMetaById((String)listSelectedRow.getPrimaryKeyValue(), false).getWarnSchedule().isEnable();
            if (!isEnable) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u76d1\u63a7\u65b9\u6848\u4e2d\u5b58\u5728\u5df2\u542f\u7528\u7684\u65b9\u6848\uff0c\u4e0d\u53ef\u5220\u9664\uff0c\u8bf7\u7981\u7528\u5df2\u542f\u7528\u7684\u65b9\u6848\u540e\u91cd\u8bd5\u3002", (String)"WarnScheduleTreeListPlugin_14", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        ConfirmCallBackListener callBack = new ConfirmCallBackListener(BTN_DELETE, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"EarlyWarnTreeListPlugin_25", (String)BOS_EARLYWARN, (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Delete, callBack);
    }

    private void showDisableConfirm() {
        if (!EarlyWarnPermission.permissionVerification(EarlyWarnPermissionEnum.DISABLE, Long.parseLong(RequestContext.get().getUserId()), APPID, ENTITY_NAME)) {
            this.showNoPermissionErrorNotification(ResManager.loadKDString((String)"\u7981\u7528", (String)"WarnScheduleTreeListPlugin_20", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        IListView view = (IListView)this.getView();
        ListSelectedRowCollection collection = view.getSelectedRows();
        if (null == collection || collection.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u7981\u7528\u7684\u76d1\u63a7\u65b9\u6848\u3002", (String)"WarnScheduleTreeListPlugin_3", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        if (collection.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u6279\u91cf\u7981\u7528\u76d1\u63a7\u65b9\u6848\u3002", (String)"WarnScheduleTreeListPlugin_4", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        ConfirmCallBackListener callBack = new ConfirmCallBackListener(BTN_DISABLE, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u7981\u7528\u76d1\u63a7\u65b9\u6848\u5417\uff1f", (String)"WarnScheduleTreeListPlugin_5", (String)BOS_EARLYWARN, (Object[])new Object[0]), options, callBack);
    }

    private void showEnableConfirm() {
        if (!EarlyWarnPermission.permissionVerification(EarlyWarnPermissionEnum.ENABLE, Long.parseLong(RequestContext.get().getUserId()), APPID, ENTITY_NAME)) {
            this.showNoPermissionErrorNotification(ResManager.loadKDString((String)"\u542f\u7528", (String)"WarnScheduleTreeListPlugin_21", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        IListView view = (IListView)this.getView();
        ListSelectedRowCollection collection = view.getSelectedRows();
        if (null == collection || collection.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u542f\u7528\u7684\u76d1\u63a7\u65b9\u6848\u3002", (String)"WarnScheduleTreeListPlugin_6", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        if (collection.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u6279\u91cf\u542f\u7528\u76d1\u63a7\u65b9\u6848\u3002", (String)"WarnScheduleTreeListPlugin_7", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        ConfirmCallBackListener callBack = new ConfirmCallBackListener(BTN_ENABLE, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u542f\u7528\u76d1\u63a7\u65b9\u6848\u5417\uff1f", (String)"WarnScheduleTreeListPlugin_8", (String)BOS_EARLYWARN, (Object[])new Object[0]), options, callBack);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (MessageBoxResult.Yes != e.getResult()) {
            return;
        }
        switch (e.getCallBackId()) {
            case "btn_enable": {
                this.doEnable();
                break;
            }
            case "btn_disable": {
                this.doDisable();
                break;
            }
            case "btn_del": {
                this.doDelete();
                break;
            }
        }
    }

    private void doDelete() {
        IListView view = (IListView)this.getView();
        ListSelectedRowCollection collection = view.getSelectedRows();
        List<String> pkIds = collection.stream().map(d -> String.valueOf(d.getPrimaryKeyValue())).collect(Collectors.toList());
        DynamicObjectCollection jobInfos = WarnScheduleMetaServiceHelper.getJobInfosBy(pkIds);
        WarnScheduleMetaServiceHelper.delete(pkIds);
        JobKit.deleteBatch(jobInfos);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"WarnScheduleTreeListPlugin_9", (String)BOS_EARLYWARN, (Object[])new Object[0]));
        ((IListView)this.getView()).clearSelection();
        ((IListView)this.getView()).refresh();
        OpLogAppInfo logInfo = new OpLogAppInfo();
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u5220\u9664", "WarnScheduleTreeListPlugin_18", BOS_EARLYWARN);
        logInfo.setOpName("delete", opNameBridge);
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u5220\u9664\u6210\u529f\u3002", "WarnScheduleTreeListPlugin_9", BOS_EARLYWARN);
        logInfo.setOpDesc(opDescBridge, new String[0]);
        logInfo.setBizObjID(ENTITY_NAME);
        LogUtils.addLog(this.getView(), (AppLogInfo)logInfo);
    }

    private void doEnable() {
        IListView view = (IListView)this.getView();
        ListSelectedRowCollection collection = view.getSelectedRows();
        String id = collection.isEmpty() ? "" : StringKit.toSafeString(collection.get(0).getPrimaryKeyValue());
        WarnScheduleMetaServiceHelper.enable(id);
        WarnScheduleMetadata meta = WarnScheduleMetaServiceHelper.loadMetaById(id, false);
        meta.getWarnSchedule().setEnable(true);
        JobKit.sync(meta);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"WarnScheduleTreeListPlugin_10", (String)BOS_EARLYWARN, (Object[])new Object[0]));
        ((IListView)this.getView()).clearSelection();
        ((IListView)this.getView()).refresh();
        OpLogAppInfo logInfo = new OpLogAppInfo();
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u542f\u7528", "WarnScheduleTreeListPlugin_21", BOS_EARLYWARN);
        logInfo.setOpName("enable", opNameBridge);
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u542f\u7528\u6210\u529f\u3002", "WarnScheduleTreeListPlugin_10", BOS_EARLYWARN);
        logInfo.setOpDesc(opDescBridge, new String[0]);
        logInfo.setBizObjID(ENTITY_NAME);
        LogUtils.addLog(this.getView(), (AppLogInfo)logInfo);
    }

    private void doDisable() {
        IListView view = (IListView)this.getView();
        ListSelectedRowCollection collection = view.getSelectedRows();
        String id = collection.isEmpty() ? "" : StringKit.toSafeString(collection.get(0).getPrimaryKeyValue());
        WarnScheduleMetaServiceHelper.disable(id);
        WarnScheduleMetadata meta = WarnScheduleMetaServiceHelper.loadMetaById(id, false);
        meta.getWarnSchedule().setEnable(false);
        JobKit.sync(meta);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"WarnScheduleTreeListPlugin_11", (String)BOS_EARLYWARN, (Object[])new Object[0]));
        ((IListView)this.getView()).clearSelection();
        ((IListView)this.getView()).refresh();
        OpLogAppInfo logInfo = new OpLogAppInfo();
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u7981\u7528", "WarnScheduleTreeListPlugin_20", BOS_EARLYWARN);
        logInfo.setOpName("disable", opNameBridge);
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u7981\u7528\u6210\u529f\u3002", "WarnScheduleTreeListPlugin_11", BOS_EARLYWARN);
        logInfo.setOpDesc(opDescBridge, new String[0]);
        logInfo.setBizObjID(ENTITY_NAME);
        LogUtils.addLog(this.getView(), (AppLogInfo)logInfo);
    }

    private void doCopy() {
        if (!EarlyWarnPermission.permissionVerification(EarlyWarnPermissionEnum.COPY, Long.parseLong(RequestContext.get().getUserId()), APPID, ENTITY_NAME)) {
            this.showNoPermissionErrorNotification(ResManager.loadKDString((String)"\u590d\u5236", (String)"WarnScheduleTreeListPlugin_22", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        IListView view = (IListView)this.getView();
        ListSelectedRowCollection collection = view.getSelectedRows();
        if (null == collection || collection.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u590d\u5236\u7684\u76d1\u63a7\u65b9\u6848\u3002", (String)"WarnScheduleTreeListPlugin_12", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        if (collection.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u6279\u91cf\u590d\u5236\u76d1\u63a7\u65b9\u6848\u3002", (String)"WarnScheduleTreeListPlugin_13", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        String id = StringKit.toSafeString(collection.get(0).getPrimaryKeyValue());
        this.showEditForm("", id, Boolean.TRUE, Boolean.FALSE);
    }

    private String getBizAppId() {
        String nodeId = this.getTreeListView().getTreeView().getTreeState().getFocusNodeId();
        if ("rootNode".equals(nodeId)) {
            return "";
        }
        List appIds = BizAppServiceHelp.getAppsIdByCloudId((String)nodeId);
        if (CollectionKit.isNotEmpty(appIds)) {
            return "";
        }
        return nodeId;
    }

    private void showEditForm(String bizAppId, String id, boolean copy, boolean isView) {
        CloseCallBack callback = new CloseCallBack((IFormPlugin)this, BTN_NEW);
        FormShowParameter parameter = WarnScheduleEditPlugin.show(bizAppId, id, copy, callback);
        String cacheKey = copy ? id + "_copy" : id;
        String pageId = this.getPageCache().get(cacheKey);
        if (pageId == null) {
            this.getView().getPageCache().put(cacheKey, parameter.getPageId());
        } else {
            parameter.setPageId(pageId);
        }
        if (isView) {
            parameter.setStatus(OperationStatus.VIEW);
        }
        this.getView().showForm(parameter);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getTreeListView().focusRootNode();
    }

    public void initializeTree(EventObject e) {
        TreeNode root = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree(null, null, null, (String)"app");
        root.setChildren(TreeNodeUtils.filterCloudTreeNode(root.getChildren()));
        this.getTreeModel().setRoot(root);
        if (root != null) {
            this.getTreeModel().setCurrentNodeId((Object)root.getId());
        }
        this.setBarItemEnable(false, true);
    }

    private void setBarItemEnable(boolean enable, boolean isSetAll) {
        if (isSetAll) {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{BTN_TREENEW, BTN_TREEEDIT, BTN_TREEDELETE});
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        super.buildTreeListFilter(e);
        String nodeId = e.getNodeId().toString();
        if ("rootNode".equals(nodeId)) {
            return;
        }
        List appIds = BizAppServiceHelp.getAppsIdByCloudId((String)nodeId);
        if (CollectionKit.isNotEmpty(appIds)) {
            QFilter filter = new QFilter("biz_app", "in", (Object)appIds);
            e.addQFilter(filter);
            return;
        }
        QFilter filter = new QFilter("biz_app", "=", (Object)nodeId);
        e.addQFilter(filter);
        e.setCancel(true);
    }

    public void setFilter(SetFilterEvent e) {
        TreeNodeFilter treeNodeFilter;
        QFilter appFilter;
        if (TreeNodeUtils.isUseNewAppInfo() && (appFilter = (treeNodeFilter = new TreeNodeFilter()).getAppFilter("biz_app_id")) != null) {
            e.addCustomQFilter(appFilter);
        }
        e.setOrderBy("sync_time desc");
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        switch (e.getActionId()) {
            case "btn_new": 
            case "btn_copy": {
                ((IListView)this.getView()).refresh();
                break;
            }
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        TreeNode treeNode;
        String nodeId = StringKit.toSafeString(e.getNodeId());
        if (StringKit.isBlank(nodeId)) {
            return;
        }
        TreeNode root = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree(null, null, null, (String)"app");
        root.setChildren(TreeNodeUtils.filterCloudTreeNode(root.getChildren()));
        if (root != null && (treeNode = root.getTreeNode(nodeId, 16)) != null) {
            e.setChildNodes(treeNode.getChildren());
        }
        this.getTreeModel().setRoot(root);
    }

    private void showNoPermissionErrorNotification(String opName) {
        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u529f\u80fd\u64cd\u4f5c\u6743\u9650\u3002", (String)"WarnScheduleTreeListPlugin_23", (String)BOS_EARLYWARN, (Object[])new Object[0]), this.getView().getFormShowParameter().getCaption(), opName));
    }
}

