/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.schedule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageReceiver;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class WarnSchemeExternalReceiverPlugin
extends AbstractFormPlugin {
    private static final String PHONE_ENTRY = "phoneentryentity";
    private static final String PHONE_FIELD = "telephonefield";
    private static final String EMAIL_ENTRY = "emailentryentity";
    private static final String EMAIL_FIELD = "emailfield";
    private static final String BTN_OK = "btnok";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        Object externalReceivers = this.getView().getFormShowParameter().getCustomParam("existed_external_receivers");
        if (null == externalReceivers) {
            return;
        }
        List receivers = SerializationUtils.fromJsonStringToList((String)externalReceivers.toString(), WarnMessageReceiver.class);
        ArrayList<String> phoneList = new ArrayList<String>();
        ArrayList<String> emailList = new ArrayList<String>();
        for (WarnMessageReceiver externalReceiver : receivers) {
            if (StringUtils.equals((CharSequence)externalReceiver.getRelation(), (CharSequence)"phone")) {
                phoneList.add(externalReceiver.getId());
                continue;
            }
            if (!StringUtils.equals((CharSequence)externalReceiver.getRelation(), (CharSequence)"email")) continue;
            emailList.add(externalReceiver.getId());
        }
        if (CollectionUtils.isNotEmpty(phoneList)) {
            if (phoneList.size() > 1) {
                this.getModel().batchCreateNewEntryRow(PHONE_ENTRY, phoneList.size() - 1);
            }
            for (int i = 0; i < phoneList.size(); ++i) {
                this.getModel().setValue(PHONE_FIELD, phoneList.get(i), i);
            }
        }
        if (CollectionUtils.isNotEmpty(emailList)) {
            if (emailList.size() > 1) {
                this.getModel().batchCreateNewEntryRow(EMAIL_ENTRY, emailList.size() - 1);
            }
            for (int i = 0; i < emailList.size(); ++i) {
                this.getModel().setValue(EMAIL_FIELD, emailList.get(i), i);
            }
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)BTN_OK, (CharSequence)key)) {
            DynamicObjectCollection emailEntry;
            HashMap collectData = new HashMap();
            DynamicObjectCollection phoneEntry = this.getModel().getEntryEntity(PHONE_ENTRY);
            if (CollectionUtils.isNotEmpty((Collection)phoneEntry)) {
                phoneEntry.forEach(phoneData -> {
                    if (StringUtils.isNotBlank((CharSequence)phoneData.getString(PHONE_FIELD))) {
                        collectData.computeIfAbsent("phone", k -> new ArrayList()).add(phoneData.getString(PHONE_FIELD));
                    }
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)(emailEntry = this.getModel().getEntryEntity(EMAIL_ENTRY)))) {
                emailEntry.forEach(emailData -> {
                    if (StringUtils.isNotBlank((CharSequence)emailData.getString(EMAIL_FIELD))) {
                        collectData.computeIfAbsent("email", k -> new ArrayList()).add(emailData.getString(EMAIL_FIELD));
                    }
                });
            }
            this.getView().returnDataToParent(collectData);
            this.getView().close();
        }
    }
}

