/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.schedule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.earlywarn.kit.StringKit;
import kd.bos.designer.earlywarn.utils.ParamsUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.earlywarn.warn.EWPlugin;
import kd.bos.entity.earlywarn.warn.EarlyWarnElement;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageReceiver;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageReceiverType;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageReceiverTypeEnum;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnScheduleOrgReceiver;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnScheduleRelationReceiver;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.earlywarn.warn.EarlyWarnMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.earlywarn.EarlyWarnMetaServicHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class WarnSchemeReceiverPlugin
extends AbstractFormPlugin {
    private static final String PARAM_DATA_SOURCE = "dataSource";
    private static final String PARAM_TYPES_DATA = "types";
    private static final String USER_TYPE_AMOUNT = "userselectamount";
    private static final String EXTERNAL_TYPE_AMOUNT = "externalselectamount";
    private static final String ROLE_TYPE_AMOUNT = "roleselectamount";
    private static final String ORG_TYPE_AMOUNT = "orgselectamount";
    private static final String RELATION_TYPE_AMOUNT = "relationselectamount";
    private static final String USER_TYPE_VALUE = "userselectvalue";
    private static final String EXTERNAL_TYPE_VALUE = "externalselectvalue";
    private static final String ROLE_TYPE_VALUE = "roleselectvalue";
    private static final String ORG_TYPE_VALUE = "orgselectvalue";
    private static final String RELATION_TYPE_VALUE = "relationselectvalue";
    private static final String CUSTOM_TYPE_VALUE = "customselectvalue";
    private static final String USER_TYPE_NEW = "userbuttonnew";
    private static final String EXTERNAL_TYPE_NEW = "externalbuttonnew";
    private static final String ROLE_TYPE_NEW = "rolebuttonnew";
    private static final String ORG_TYPE_NEW = "orgbuttonnew";
    private static final String RELATION_TYPE_NEW = "relationbuttonnew";
    private static final String USER_TYPE_EDIT = "userbuttonedit";
    private static final String EXTERNAL_TYPE_EDIT = "externalbuttonedit";
    private static final String ROLE_TYPE_EDIT = "rolebuttonedit";
    private static final String ORG_TYPE_EDIT = "orgbuttonedit";
    private static final String RELATION_TYPE_EDIT = "relationbuttonedit";
    private static final String BTN_OK = "btnok";
    private static final String BOS_USER_TREE_LIST_F7 = "bos_usertreelistf7";
    private static final String BOS_TEMPLATE_TREE_LIST_F7 = "bos_templatetreelistf7";
    private static final String BOS_ROLE_LIST_CALLBACK = "bos_role_tree_list_callback_id";
    private static final String BOS_ORG_RECEIVER_FORM = "bos_warn_org_receiver";
    private static final String BOS_RELATION_RECEIVER_FORM = "bos_warn_relationreceiver";
    private static final String BOS_EXTERNAL_RECEIVER_FORM = "bos_warn_externalreceiver";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{USER_TYPE_NEW, ROLE_TYPE_NEW, ORG_TYPE_NEW, RELATION_TYPE_NEW, USER_TYPE_EDIT, ROLE_TYPE_EDIT, ORG_TYPE_EDIT, RELATION_TYPE_EDIT, BTN_OK, EXTERNAL_TYPE_NEW, EXTERNAL_TYPE_EDIT});
    }

    public void beforeBindData(EventObject e) {
        this.initReceiverTypesCard();
    }

    private void initReceiverTypesCard() {
        this.initCustomReceiverComboItem();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object typeData = formShowParameter.getCustomParam(PARAM_TYPES_DATA);
        if (StringUtils.isBlank((Object)typeData)) {
            return;
        }
        List selectedItems = SerializationUtils.fromJsonStringToList((String)((String)typeData), WarnMessageReceiverType.class);
        for (WarnMessageReceiverType receiverType : selectedItems) {
            this.setReceiverTypeData(receiverType);
        }
    }

    private void initCustomReceiverComboItem() {
        EarlyWarnMetadata meta;
        Object earlyWarn = this.getView().getParentView().getModel().getValue("early_warn");
        if (null == earlyWarn) {
            return;
        }
        String earlyWarnNumber = (String)((DynamicObject)earlyWarn).get("number");
        EarlyWarnMetadata earlyWarnMetadata = meta = StringKit.isBlank(earlyWarnNumber) ? null : EarlyWarnMetaServicHelper.loadMetaByNumber(earlyWarnNumber, true);
        if (meta == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9884\u8b66\u5bf9\u8c61%s\u4e3a\u7a7a\u6216\u8005\u4e0d\u5b58\u5728", (String)"WarnSchemeReceiverPlugin_0", (String)"bos-earlywarn", (Object[])new Object[0]), earlyWarnNumber));
        }
        EarlyWarnElement earlyWarnElement = meta.getWarnElement();
        ArrayList comboItems = new ArrayList();
        if (earlyWarnElement != null && earlyWarnElement.getCustomReceivers() != null) {
            List<EWPlugin> customReceiversPlugins = earlyWarnElement.getCustomReceivers();
            customReceiversPlugins.forEach(plugin -> {
                if (plugin.isEnabled()) {
                    ComboItem comboItem = new ComboItem(new LocaleString(plugin.getClassName()), plugin.getClassName());
                    comboItems.add(comboItem);
                }
            });
        }
        ((ComboEdit)this.getView().getControl(CUSTOM_TYPE_VALUE)).setComboItems(comboItems);
    }

    private void setReceiverTypeData(WarnMessageReceiverType receiverType) {
        if (receiverType == null) {
            return;
        }
        List<WarnMessageReceiver> receivers = receiverType.getReceivers();
        String type = receiverType.getType();
        if (CollectionUtils.isEmpty(receivers)) {
            this.clearReceiverTypeData(type);
            return;
        }
        if (WarnMessageReceiverTypeEnum.CustomReceiver == WarnMessageReceiverTypeEnum.getBy(type)) {
            this.getModel().setValue(CUSTOM_TYPE_VALUE, (Object)receivers.get(0).getName());
            return;
        }
        this.getModel().setValue(this.getTypeAmountField(type), (Object)receivers.size());
        LinkedHashMap<WarnMessageReceiver, String> relations = new LinkedHashMap<WarnMessageReceiver, String>(20);
        this.handlereceivers(receivers, relations);
        this.getPageCache().put(this.getCacheTypeKey(type), SerializationUtils.toJsonString(receivers));
        String fieldValue = String.join((CharSequence)"\uff0c", relations.values());
        if (relations.size() >= 20) {
            fieldValue = fieldValue + "\uff0c...";
        }
        this.getModel().setValue(this.getTypeValueField(type), (Object)fieldValue);
    }

    private void handlereceivers(List<WarnMessageReceiver> receivers, Map<WarnMessageReceiver, String> relations) {
        HashSet<Long> emptyNameReceiverIds = new HashSet<Long>(20);
        int count = 0;
        for (WarnMessageReceiver receiver : receivers) {
            if (count == 20) break;
            String receiverId = receiver.getId();
            String name = receiver.getName();
            if (name == null) {
                emptyNameReceiverIds.add(Long.parseLong(receiverId));
            }
            relations.put(receiver, name);
            ++count;
        }
        if (!emptyNameReceiverIds.isEmpty()) {
            QFilter qFilter = new QFilter("id", "in", emptyNameReceiverIds);
            Map emptyNameReceivers = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"name", (QFilter[])new QFilter[]{qFilter});
            block1: for (Object emptyNameReceiverId : emptyNameReceivers.keySet()) {
                for (WarnMessageReceiver receiver : relations.keySet()) {
                    String receiverId = receiver.getId();
                    if (!StringUtils.equals((CharSequence)emptyNameReceiverId.toString(), (CharSequence)receiverId)) continue;
                    String name = ((DynamicObject)emptyNameReceivers.get(emptyNameReceiverId)).getString("name");
                    relations.replace(receiver, name);
                    receiver.setName(name);
                    continue block1;
                }
            }
        }
    }

    private void clearReceiverTypeData(String type) {
        this.getPageCache().remove(this.getCacheTypeKey(type));
        if (WarnMessageReceiverTypeEnum.CustomReceiver == WarnMessageReceiverTypeEnum.getBy(type)) {
            this.getModel().setValue(CUSTOM_TYPE_VALUE, (Object)"");
            return;
        }
        this.getModel().setValue(this.getTypeAmountField(type), (Object)0);
        this.getModel().setValue(this.getTypeValueField(type), (Object)"");
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)USER_TYPE_NEW, (CharSequence)key) || StringUtils.equals((CharSequence)USER_TYPE_EDIT, (CharSequence)key)) {
            this.showUserForm();
            return;
        }
        if (StringUtils.equals((CharSequence)EXTERNAL_TYPE_NEW, (CharSequence)key) || StringUtils.equals((CharSequence)EXTERNAL_TYPE_EDIT, (CharSequence)key)) {
            this.showExternalForm();
            return;
        }
        if (StringUtils.equals((CharSequence)ROLE_TYPE_NEW, (CharSequence)key) || StringUtils.equals((CharSequence)ROLE_TYPE_EDIT, (CharSequence)key)) {
            this.showRoleForm();
            return;
        }
        if (StringUtils.equals((CharSequence)ORG_TYPE_NEW, (CharSequence)key) || StringUtils.equals((CharSequence)ORG_TYPE_EDIT, (CharSequence)key)) {
            this.showOrgForm();
            return;
        }
        if (StringUtils.equals((CharSequence)RELATION_TYPE_NEW, (CharSequence)key) || StringUtils.equals((CharSequence)RELATION_TYPE_EDIT, (CharSequence)key)) {
            this.showRelationForm();
            return;
        }
        if (StringUtils.equals((CharSequence)BTN_OK, (CharSequence)key)) {
            this.returnData();
        }
    }

    private void returnData() {
        ArrayList<WarnMessageReceiverType> types = new ArrayList<WarnMessageReceiverType>();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        for (WarnMessageReceiverTypeEnum typeEnum : WarnMessageReceiverTypeEnum.values()) {
            if (WarnMessageReceiverTypeEnum.CustomReceiver == typeEnum) {
                if (!StringUtils.isNotBlank((CharSequence)dataEntity.getString(CUSTOM_TYPE_VALUE))) continue;
                WarnMessageReceiverType customType = new WarnMessageReceiverType();
                customType.setType(typeEnum.getId());
                customType.setReceivers(this.getCustomReceiverValue());
                types.add(customType);
                continue;
            }
            String typeId = typeEnum.getId();
            if (dataEntity.getInt(this.getTypeAmountField(typeId)) <= 0) continue;
            WarnMessageReceiverType receiverType = new WarnMessageReceiverType();
            receiverType.setType(typeId);
            receiverType.setReceivers(this.getCacheReceiver(typeId));
            types.add(receiverType);
        }
        this.getView().returnDataToParent(types);
        this.getView().close();
    }

    private List<WarnMessageReceiver> getCustomReceiverValue() {
        Object value = this.getModel().getValue(CUSTOM_TYPE_VALUE);
        if (StringUtils.isBlank((Object)value)) {
            return null;
        }
        WarnMessageReceiver warnMessageReceiver = new WarnMessageReceiver();
        String receiverType = WarnMessageReceiverTypeEnum.CustomReceiver.getId();
        warnMessageReceiver.setReceiverType(receiverType);
        warnMessageReceiver.setId(receiverType);
        warnMessageReceiver.setName((String)value);
        ArrayList<WarnMessageReceiver> warnMessageReceiverList = new ArrayList<WarnMessageReceiver>(2);
        warnMessageReceiverList.add(warnMessageReceiver);
        return warnMessageReceiverList;
    }

    private String getTypeAmountField(String typeId) {
        if (StringUtils.equals((CharSequence)WarnMessageReceiverTypeEnum.User.getId(), (CharSequence)typeId)) {
            return USER_TYPE_AMOUNT;
        }
        if (StringUtils.equals((CharSequence)WarnMessageReceiverTypeEnum.ExternalPerson.getId(), (CharSequence)typeId)) {
            return EXTERNAL_TYPE_AMOUNT;
        }
        if (StringUtils.equals((CharSequence)WarnMessageReceiverTypeEnum.Org.getId(), (CharSequence)typeId)) {
            return ORG_TYPE_AMOUNT;
        }
        if (StringUtils.equals((CharSequence)WarnMessageReceiverTypeEnum.Role.getId(), (CharSequence)typeId)) {
            return ROLE_TYPE_AMOUNT;
        }
        if (StringUtils.equals((CharSequence)WarnMessageReceiverTypeEnum.RelationPerson.getId(), (CharSequence)typeId)) {
            return RELATION_TYPE_AMOUNT;
        }
        return USER_TYPE_AMOUNT;
    }

    private String getTypeValueField(String typeId) {
        if (StringUtils.equals((CharSequence)WarnMessageReceiverTypeEnum.User.getId(), (CharSequence)typeId)) {
            return USER_TYPE_VALUE;
        }
        if (StringUtils.equals((CharSequence)WarnMessageReceiverTypeEnum.ExternalPerson.getId(), (CharSequence)typeId)) {
            return EXTERNAL_TYPE_VALUE;
        }
        if (StringUtils.equals((CharSequence)WarnMessageReceiverTypeEnum.Org.getId(), (CharSequence)typeId)) {
            return ORG_TYPE_VALUE;
        }
        if (StringUtils.equals((CharSequence)WarnMessageReceiverTypeEnum.Role.getId(), (CharSequence)typeId)) {
            return ROLE_TYPE_VALUE;
        }
        if (StringUtils.equals((CharSequence)WarnMessageReceiverTypeEnum.RelationPerson.getId(), (CharSequence)typeId)) {
            return RELATION_TYPE_VALUE;
        }
        return USER_TYPE_AMOUNT;
    }

    private void showUserForm() {
        ArrayList pkIds = new ArrayList();
        List<WarnMessageReceiver> cacheReceiver = this.getCacheReceiver(WarnMessageReceiverTypeEnum.User.getId());
        if (CollectionUtils.isNotEmpty(cacheReceiver)) {
            cacheReceiver.forEach(receiver -> pkIds.add(receiver.getId()));
        }
        ListShowParameter param = this.getCommonListShowParameter();
        param.setFormId(BOS_USER_TREE_LIST_F7);
        param.setBillFormId("bos_user");
        param.setSelectedRows(pkIds.toArray(new Object[0]));
        CloseCallBack callback = new CloseCallBack((IFormPlugin)this, BOS_USER_TREE_LIST_F7);
        param.setCloseCallBack(callback);
        this.getView().showForm((FormShowParameter)param);
    }

    private void showExternalForm() {
        List<WarnMessageReceiver> cacheReceiver = this.getCacheReceiver(WarnMessageReceiverTypeEnum.ExternalPerson.getId());
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(BOS_EXTERNAL_RECEIVER_FORM);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("existed_external_receivers", (Object)SerializationUtils.toJsonString(cacheReceiver));
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, BOS_EXTERNAL_RECEIVER_FORM);
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void showRoleForm() {
        ArrayList pkIds = new ArrayList();
        List<WarnMessageReceiver> cacheReceiver = this.getCacheReceiver(WarnMessageReceiverTypeEnum.Role.getId());
        if (CollectionUtils.isNotEmpty(cacheReceiver)) {
            cacheReceiver.forEach(receiver -> pkIds.add(receiver.getId()));
        }
        ListShowParameter parameter = this.getCommonListShowParameter();
        parameter.setFormId(BOS_TEMPLATE_TREE_LIST_F7);
        parameter.setBillFormId("perm_role");
        parameter.setSelectedRows(pkIds.toArray(new Object[0]));
        CloseCallBack callback = new CloseCallBack((IFormPlugin)this, BOS_ROLE_LIST_CALLBACK);
        parameter.setCloseCallBack(callback);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showOrgForm() {
        ArrayList orgReceivers = new ArrayList();
        List<WarnMessageReceiver> cacheReceiver = this.getCacheReceiver(WarnMessageReceiverTypeEnum.Org.getId());
        if (CollectionUtils.isNotEmpty(cacheReceiver)) {
            cacheReceiver.forEach(receiver -> orgReceivers.add(new WarnScheduleOrgReceiver(receiver.getId(), receiver.getRelationshipType(), receiver.getScope())));
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(BOS_ORG_RECEIVER_FORM);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("existed_org_receivers", (Object)SerializationUtils.toJsonString(orgReceivers));
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, BOS_ORG_RECEIVER_FORM);
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void showRelationForm() {
        List<WarnMessageReceiver> cacheReceiver = this.getCacheReceiver(WarnMessageReceiverTypeEnum.RelationPerson.getId());
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(BOS_RELATION_RECEIVER_FORM);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(PARAM_DATA_SOURCE, this.getView().getFormShowParameter().getCustomParam(PARAM_DATA_SOURCE));
        parameter.setCustomParam("existed_relation_receivers", (Object)SerializationUtils.toJsonString(cacheReceiver));
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, BOS_RELATION_RECEIVER_FORM);
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private ListShowParameter getCommonListShowParameter() {
        ListShowParameter parameter = new ListShowParameter();
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.getOpenStyle().setInlineStyleCss(css);
        parameter.setShowTitle(false);
        parameter.setMultiSelect(true);
        parameter.setLookUp(true);
        parameter.setMustInput(false);
        parameter.setCustomParam("isFromCommonFilterColumn", (Object)true);
        return parameter;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (StringKit.isBlank(actionId) || returnData == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)BOS_USER_TREE_LIST_F7, (CharSequence)actionId)) {
            this.handleListReturnData((ListSelectedRowCollection)returnData, WarnMessageReceiverTypeEnum.User);
            return;
        }
        if (StringUtils.equals((CharSequence)BOS_EXTERNAL_RECEIVER_FORM, (CharSequence)actionId)) {
            this.handleExternalReturnData((Map)returnData);
            return;
        }
        if (StringUtils.equals((CharSequence)BOS_ROLE_LIST_CALLBACK, (CharSequence)actionId)) {
            this.handleListReturnData((ListSelectedRowCollection)returnData, WarnMessageReceiverTypeEnum.Role);
            return;
        }
        if (StringUtils.equals((CharSequence)BOS_ORG_RECEIVER_FORM, (CharSequence)actionId)) {
            this.handleOrgReturnData((List)returnData);
            return;
        }
        if (StringUtils.equals((CharSequence)BOS_RELATION_RECEIVER_FORM, (CharSequence)actionId)) {
            this.handleRelationReturnData((List)returnData);
        }
    }

    private void handleListReturnData(ListSelectedRowCollection returnData, WarnMessageReceiverTypeEnum receiverType) {
        WarnMessageReceiverType type = new WarnMessageReceiverType();
        type.setType(receiverType.getId());
        if (CollectionUtils.isEmpty((Collection)returnData)) {
            this.setReceiverTypeData(type);
            return;
        }
        ArrayList<WarnMessageReceiver> receivers = new ArrayList<WarnMessageReceiver>();
        for (ListSelectedRow selectedRow : returnData) {
            String id = StringKit.toSafeString(selectedRow.getPrimaryKeyValue());
            String name = selectedRow.getName();
            WarnMessageReceiver receiver = new WarnMessageReceiver();
            receiver.setReceiverType(receiverType.getId());
            receiver.setId(id);
            receiver.setName(name);
            receivers.add(receiver);
        }
        type.setReceivers(receivers);
        this.setReceiverTypeData(type);
    }

    private void handleExternalReturnData(Map<String, List<String>> returnData) {
        WarnMessageReceiverType type = new WarnMessageReceiverType();
        String externalType = WarnMessageReceiverTypeEnum.ExternalPerson.getId();
        type.setType(externalType);
        if (MapUtils.isEmpty(returnData)) {
            this.setReceiverTypeData(type);
        }
        ArrayList<WarnMessageReceiver> receivers = new ArrayList<WarnMessageReceiver>();
        for (Map.Entry<String, List<String>> entry : returnData.entrySet()) {
            String key = entry.getKey();
            List<String> entryValue = entry.getValue();
            if (CollectionUtils.isEmpty(entryValue)) continue;
            for (String receiverId : entryValue) {
                WarnMessageReceiver messageReceiver = new WarnMessageReceiver();
                messageReceiver.setReceiverType(externalType);
                messageReceiver.setId(receiverId);
                messageReceiver.setName(receiverId);
                messageReceiver.setRelation(key);
                receivers.add(messageReceiver);
            }
        }
        type.setReceivers(receivers);
        this.setReceiverTypeData(type);
    }

    private void handleOrgReturnData(List<WarnScheduleOrgReceiver> returnData) {
        WarnMessageReceiverType type = new WarnMessageReceiverType();
        String orgType = WarnMessageReceiverTypeEnum.Org.getId();
        type.setType(orgType);
        if (CollectionUtils.isEmpty(returnData)) {
            this.setReceiverTypeData(type);
        }
        ArrayList<WarnMessageReceiver> receivers = new ArrayList<WarnMessageReceiver>(16);
        for (WarnScheduleOrgReceiver orgReceiver : returnData) {
            WarnMessageReceiver receiver = new WarnMessageReceiver();
            receiver.setReceiverType(orgType);
            receiver.setId(orgReceiver.getPkId());
            receiver.setRelationshipType(orgReceiver.getIncludeType());
            receiver.setScope(orgReceiver.getScope());
            receiver.setName(orgReceiver.getName());
            receivers.add(receiver);
        }
        type.setReceivers(receivers);
        this.setReceiverTypeData(type);
    }

    private void handleRelationReturnData(List<WarnScheduleRelationReceiver> returnData) {
        WarnMessageReceiverType type = new WarnMessageReceiverType();
        String relationType = WarnMessageReceiverTypeEnum.RelationPerson.getId();
        type.setType(relationType);
        if (CollectionUtils.isEmpty(returnData)) {
            this.setReceiverTypeData(type);
        }
        ArrayList<WarnMessageReceiver> receivers = new ArrayList<WarnMessageReceiver>(16);
        for (WarnScheduleRelationReceiver relationReceiver : returnData) {
            WarnMessageReceiver receiver = new WarnMessageReceiver();
            receiver.setId(relationReceiver.getDataSource() + "." + relationReceiver.getField());
            receiver.setReceiverType(relationType);
            receiver.setField(relationReceiver.getField());
            receiver.setFieldName(relationReceiver.getFieldName());
            receiver.setDataSource(relationReceiver.getDataSource());
            receiver.setName(relationReceiver.getFieldName());
            receiver.setRelationshipType(relationReceiver.getRelationTypeEnum().getId());
            receivers.add(receiver);
        }
        type.setReceivers(receivers);
        this.setReceiverTypeData(type);
    }

    private String getCacheTypeKey(String type) {
        return type + "_receiver";
    }

    private List<WarnMessageReceiver> getCacheReceiver(String type) {
        String cacheValue = this.getPageCache().get(this.getCacheTypeKey(type));
        return StringKit.isBlank(cacheValue) ? new ArrayList() : SerializationUtils.fromJsonStringToList((String)cacheValue, WarnMessageReceiver.class);
    }

    public static FormShowParameter getFormShowParameter(String dataSource, List<WarnMessageReceiverType> types, CloseCallBack callBack) {
        boolean isUseNewEarlyWarn = ParamsUtils.isUserNewWarnScheme();
        if (!isUseNewEarlyWarn) {
            return WarnSchemeReceiverPlugin.getOldFormShowParameter(dataSource, types, callBack);
        }
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bos_warn_scheme_receiver");
        param.setCustomParam(PARAM_TYPES_DATA, (Object)SerializationUtils.toJsonString(types));
        param.setCustomParam(PARAM_DATA_SOURCE, (Object)dataSource);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(callBack);
        return param;
    }

    private static List<WarnMessageReceiverType> getOldReceiverTypes(List<WarnMessageReceiverType> types) {
        ArrayList<WarnMessageReceiverType> oldTypes = new ArrayList<WarnMessageReceiverType>();
        for (WarnMessageReceiverType type : types) {
            if (!type.getType().equals("user") && !type.getType().equals("relation_person") && !type.getType().equals("custom_receiver")) continue;
            oldTypes.add(type);
        }
        return oldTypes;
    }

    public static FormShowParameter getOldFormShowParameter(String dataSource, List<WarnMessageReceiverType> types, CloseCallBack callBack) {
        List<WarnMessageReceiverType> oldTypes = WarnSchemeReceiverPlugin.getOldReceiverTypes(types);
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bos_warnschedule_receiver");
        param.setCustomParam(PARAM_TYPES_DATA, (Object)SerializationUtils.toJsonString(oldTypes));
        param.setCustomParam(PARAM_DATA_SOURCE, (Object)dataSource);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(callBack);
        return param;
    }
}

