/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.schedule.bo;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.earlywarn.kit.CollectionKit;
import kd.bos.designer.earlywarn.kit.JobKit;
import kd.bos.designer.earlywarn.kit.StringKit;
import kd.bos.entity.earlywarn.warnschedule.RunCycle;
import kd.bos.entity.earlywarn.warnschedule.runcycle.RunCycleNumberEnum;
import kd.bos.entity.earlywarn.warnschedule.runcycle.RunCyclePeriod;
import kd.bos.entity.earlywarn.warnschedule.runcycle.RunCyclePeriodType;
import kd.bos.entity.earlywarn.warnschedule.runcycle.RunCycleRangeType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.server.schedulecreator.ScheduleCreator;
import kd.bos.service.KDDateUtils;
import org.quartz.TriggerUtils;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class WSPeriodBo
implements Serializable {
    private static final Log log = LogFactory.getLog(WSPeriodBo.class);
    private static final String PARAM_RANGE_TYPE = "rangeType";
    private static final String PARAM_START_DATE = "startDate";
    private static final String PARAM_END_DATE = "endDate";
    private static final String PARAM_PERIOD_TYPE = "periodType";
    private static final String PARAM_PERIOD_VALUE = "periodValue";
    private static final String PARAM_RUNTIME = "runTime";
    private static final String PARAM_CRON = "periodCron";
    private static final String PARAM_REPEAT = "periodRepeat";
    private static final String MONTH_TAG = "month";
    private static final String FORMAT_DATE = "yyyy-MM-dd";
    private static final String EXECUTE_TYPE = "execute_type";
    private static final String WHICH_WEEK = "which_week";
    private static final String PERIOD_SINGLE_WEEK = "period_single_week";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String BOS_EARLYWARN = "bos-earlywarn";
    private static final long serialVersionUID = -4337833272334494318L;
    private RunCycleRangeType rangeType;
    private Date startDate;
    private Date endDate;
    private RunCyclePeriodType periodType;
    private List<RunCyclePeriod> periodValues;
    private Integer runTime;
    private int period = 1;
    private String cronExpr;
    private String executeType;
    private String whichNumber;

    public WSPeriodBo() {
        this.rangeType = RunCycleRangeType.FromStartDate;
        this.startDate = KDDateUtils.now();
        this.periodType = RunCyclePeriodType.Minute;
        this.periodValues = new ArrayList<RunCyclePeriod>();
        this.runTime = null;
    }

    public WSPeriodBo(RunCycle runCycle) {
        this.rangeType = runCycle.getRunCycleRangeType();
        this.startDate = runCycle.getStartDateObj();
        this.startDate = this.startDate == null ? KDDateUtils.now() : this.startDate;
        this.endDate = runCycle.getEndDateObj();
        this.endDate = this.endDate == null ? KDDateUtils.now() : this.endDate;
        this.periodType = RunCyclePeriodType.getByValue(runCycle.getPeriodType());
        this.periodValues = runCycle.getPeriodValues();
        this.runTime = runCycle.getRunTime();
        this.cronExpr = runCycle.getCronExpr();
        this.period = runCycle.getPeriod();
        String executeType = runCycle.getExecuteType();
        this.executeType = StringUtils.isBlank((CharSequence)executeType) ? "by_day" : executeType;
        this.whichNumber = runCycle.getWhichNumber();
    }

    public WSPeriodBo(Map<String, Object> data) {
        if (null == data) {
            return;
        }
        String tRangeType = (String)data.get(PARAM_RANGE_TYPE);
        this.rangeType = RunCycleRangeType.getByName(tRangeType);
        String tStartDate = StringKit.toSafeString(data.get(PARAM_START_DATE));
        this.startDate = StringKit.strToDate(tStartDate, FORMAT_DATE);
        this.startDate = this.startDate == null ? KDDateUtils.now() : this.startDate;
        String tEndDate = StringKit.toSafeString(data.get(PARAM_END_DATE));
        this.endDate = StringKit.strToDate(tEndDate, FORMAT_DATE);
        this.endDate = this.endDate == null ? KDDateUtils.now() : this.endDate;
        String tPeriodType = (String)data.get(PARAM_PERIOD_TYPE);
        this.periodType = RunCyclePeriodType.getByValue(tPeriodType);
        String periodValue = (String)data.get(PARAM_PERIOD_VALUE);
        this.periodValues = RunCyclePeriod.getList(periodValue);
        this.runTime = (Integer)data.get(PARAM_RUNTIME);
        Object periodData = data.get(PARAM_REPEAT);
        this.period = periodData == null ? 1 : (Integer)periodData;
        Object cron = data.get(PARAM_CRON);
        this.cronExpr = cron == null ? "" : (String)cron;
    }

    public String getDescription() {
        String count;
        boolean isMinuteOrHour;
        if (null == this.startDate) {
            return "";
        }
        StringBuilder description = new StringBuilder();
        String startDateStr = this.getStartDateStr();
        String endDateStr = this.getEndDateStr();
        boolean bl = isMinuteOrHour = RunCyclePeriodType.Minute == this.periodType || RunCyclePeriodType.Hour == this.periodType;
        if (isMinuteOrHour) {
            startDateStr = startDateStr + " " + this.getRunTimeStr();
        }
        String fromStartDate = String.format(ResManager.loadKDString((String)"\u4ece%s\u5f00\u59cb", (String)"WSPeriodBo_1", (String)BOS_EARLYWARN, (Object[])new Object[0]), startDateStr);
        description.append(fromStartDate).append("\uff0c");
        if (RunCycleRangeType.DateRange == this.rangeType) {
            if (isMinuteOrHour) {
                endDateStr = endDateStr + " " + this.getRunTimeStr();
            }
            description.append(String.format(ResManager.loadKDString((String)"\u81f3%s\u6b62 ", (String)"WSPeriodBo_2", (String)BOS_EARLYWARN, (Object[])new Object[0]), endDateStr));
        }
        String string = count = this.period == 1 ? "" : String.valueOf(this.period);
        if (RunCyclePeriodType.Day == this.periodType) {
            description.append(String.format(ResManager.loadKDString((String)"\u6bcf%s\u5929", (String)"WSPeriodBo_4", (String)BOS_EARLYWARN, (Object[])new Object[0]), count));
        } else if (RunCyclePeriodType.Week == this.periodType && CollectionKit.isNotEmpty(this.periodValues)) {
            description.append(String.format(ResManager.loadKDString((String)"\u6bcf%1$s\u5468%2$s", (String)"WSPeriodBo_5", (String)BOS_EARLYWARN, (Object[])new Object[0]), count, this.getPeriodNameStr()));
        } else if (RunCyclePeriodType.Month == this.periodType && CollectionKit.isNotEmpty(this.periodValues)) {
            String desc = RunCycleNumberEnum.getDesc(this.getWhichNumber());
            description.append(String.format(ResManager.loadKDString((String)"\u6bcf%1$s\u6708%2$s%3$s", (String)"WSPeriodBo_6", (String)BOS_EARLYWARN, (Object[])new Object[0]), count, desc, this.getPeriodNameStr()));
        } else if (RunCyclePeriodType.Year == this.periodType && CollectionKit.isNotEmpty(this.periodValues)) {
            Map<String, String> periodDesc = this.getYearPeriodDesc();
            String month = periodDesc.get(MONTH_TAG);
            String desc = RunCycleNumberEnum.getDesc(this.getWhichNumber());
            String dayOrWeek = periodDesc.get("dayOrWeek");
            description.append(String.format(ResManager.loadKDString((String)"\u6bcf%1$s\u5e74%2$s\u7684%3$s%4$s", (String)"WSPeriodBo_8", (String)BOS_EARLYWARN, (Object[])new Object[0]), count, month, desc, dayOrWeek));
        } else if (RunCyclePeriodType.Hour == this.periodType) {
            description.append(String.format(ResManager.loadKDString((String)"\u6bcf%s\u5c0f\u65f6", (String)"WSPeriodBo_9", (String)BOS_EARLYWARN, (Object[])new Object[0]), count));
        } else if (RunCyclePeriodType.Minute == this.periodType) {
            description.append(String.format(ResManager.loadKDString((String)"\u6bcf%s\u5206\u949f", (String)"WSPeriodBo_10", (String)BOS_EARLYWARN, (Object[])new Object[0]), count));
        }
        String runTimeStr = isMinuteOrHour ? " " : " " + this.getRunTimeStr();
        description.append(String.format(ResManager.loadKDString((String)"%s\u6267\u884c", (String)"WSPeriodBo_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), runTimeStr));
        String nextTimeDesc = this.getNextTimeDesc();
        if (StringUtils.isNotBlank((CharSequence)nextTimeDesc)) {
            description.append("\r\n").append(nextTimeDesc);
        }
        return description.toString();
    }

    private String getNextTimeDesc() {
        PlanInfo planInfo = JobKit.createPlanInfo(this.convertToRunCycleForPlanInfo());
        try {
            String fireTimesDesc;
            ScheduleCreator scheduleCreator = new ScheduleCreator();
            Map objectMap = scheduleCreator.create(planInfo);
            String cron = (String)objectMap.get("fplan");
            Date startTime = planInfo.getStartTime().getTime();
            Calendar now = Calendar.getInstance();
            if (now.getTime().after(startTime)) {
                startTime = now.getTime();
            }
            if (StringUtils.isBlank((CharSequence)(fireTimesDesc = this.computeFireTimes(cron, startTime, 10)))) {
                return "";
            }
            String desc = ResManager.loadKDString((String)"\u9884\u8ba1\u6700\u8fd1\u5341\u6b21\u7684\u6267\u884c\u65f6\u95f4\uff1a\r\n", (String)"WarnSchedulePeriodDialogPlugin_8", (String)BOS_EARLYWARN, (Object[])new Object[0]);
            return desc + fireTimesDesc;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return "";
        }
    }

    private String computeFireTimes(String cronExp, Date startDate, int numTimes) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            CronTriggerImpl cronTriggerImpl = new CronTriggerImpl();
            cronTriggerImpl.setCronExpression(cronExp);
            cronTriggerImpl.setStartTime(startDate);
            List dateList = TriggerUtils.computeFireTimes((OperableTrigger)cronTriggerImpl, null, (int)numTimes);
            ArrayList<String> dateStr = new ArrayList<String>(10);
            for (Date date : dateList) {
                dateStr.add(dateFormat.format(date));
            }
            return dateStr.stream().collect(Collectors.joining("\r\n"));
        }
        catch (ParseException e) {
            log.error((Throwable)e);
            return "";
        }
    }

    public RunCycleRangeType getRangeType() {
        return this.rangeType;
    }

    public void setRangeType(RunCycleRangeType rangeType) {
        this.rangeType = rangeType;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public String getStartDateStr() {
        return StringKit.formatDate(this.startDate, FORMAT_DATE);
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getEndDateStr() {
        return StringKit.formatDate(this.endDate, FORMAT_DATE);
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public RunCyclePeriodType getPeriodType() {
        return this.periodType;
    }

    public void setPeriodType(RunCyclePeriodType periodType) {
        this.periodType = periodType;
    }

    public List<RunCyclePeriod> getPeriodValues() {
        return this.periodValues;
    }

    public void setPeriodValues(List<RunCyclePeriod> periodValues) {
        this.periodValues = periodValues;
    }

    public String getPeriodValueStr() {
        if (CollectionKit.isEmpty(this.periodValues)) {
            return "";
        }
        List tmpList = this.periodValues.stream().map(d -> d.getValue()).collect(Collectors.toList());
        return StringKit.join(tmpList);
    }

    public Map<String, String> getPeriodValueStrMap() {
        HashMap<String, String> stringMap = new HashMap<String, String>(2);
        if (CollectionKit.isEmpty(this.periodValues)) {
            return stringMap;
        }
        ArrayList<String> months = new ArrayList<String>(16);
        ArrayList<String> days = new ArrayList<String>(16);
        for (RunCyclePeriod periodValue : this.periodValues) {
            String value = periodValue.getValue();
            if (value.endsWith(MONTH_TAG)) {
                months.add(value);
                continue;
            }
            days.add(value);
        }
        stringMap.put(MONTH_TAG, StringKit.join(months));
        stringMap.put("dayOrWeek", StringKit.join(days));
        return stringMap;
    }

    public Map<String, String> getYearPeriodDesc() {
        HashMap<String, String> stringMap = new HashMap<String, String>(2);
        if (CollectionKit.isEmpty(this.periodValues)) {
            return stringMap;
        }
        ArrayList<String> months = new ArrayList<String>(16);
        ArrayList<String> days = new ArrayList<String>(16);
        for (RunCyclePeriod periodValue : this.periodValues) {
            String value = periodValue.getValue();
            if (value.endsWith(MONTH_TAG)) {
                months.add(periodValue.getName());
                continue;
            }
            days.add(periodValue.getName());
        }
        stringMap.put(MONTH_TAG, String.join((CharSequence)"\u3001", months));
        stringMap.put("dayOrWeek", String.join((CharSequence)"\u3001", days));
        return stringMap;
    }

    public String getPeriodNameStr() {
        if (CollectionKit.isEmpty(this.periodValues)) {
            return "";
        }
        List tmpList = this.periodValues.stream().map(d -> d.getName()).collect(Collectors.toList());
        return StringKit.join(tmpList);
    }

    public String getRunTimeStr() {
        if (null == this.runTime) {
            return "";
        }
        return StringKit.secondToTime(this.runTime);
    }

    public Integer getRunTime() {
        return this.runTime;
    }

    public void setRunTime(Integer runTime) {
        this.runTime = runTime;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public String getCronExpr() {
        return this.cronExpr;
    }

    public void setCronExpr(String cronExpr) {
        this.cronExpr = cronExpr;
    }

    public String getExecuteType() {
        return this.executeType;
    }

    public void setExecuteType(String executeType) {
        this.executeType = executeType;
    }

    public String getWhichNumber() {
        return this.whichNumber;
    }

    public void setWhichNumber(String whichNumber) {
        this.whichNumber = whichNumber;
    }

    public Map<String, Object> convertToMap() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(PARAM_RANGE_TYPE, this.rangeType.getName());
        data.put(PARAM_START_DATE, StringKit.formatDate(this.startDate, FORMAT_DATE));
        data.put(PARAM_END_DATE, StringKit.formatDate(this.endDate, FORMAT_DATE));
        data.put(PARAM_PERIOD_TYPE, this.periodType.getValue());
        data.put(PARAM_PERIOD_VALUE, this.getPeriodValueStr());
        data.put(PARAM_RUNTIME, this.runTime);
        data.put(PARAM_CRON, this.getCronExpr());
        data.put(PARAM_REPEAT, this.getPeriod());
        return data;
    }

    public RunCycle convertToRunCycle() {
        RunCycle cycle = new RunCycle();
        cycle.setStartDate(this.getStartDateStr());
        cycle.setEndDate(this.getEndDateStr());
        cycle.setRangeType(this.getRangeType().getName());
        cycle.setPeriodType(this.getPeriodType().getValue());
        cycle.setRunTime(this.getRunTime());
        cycle.setDescription(new LocaleString(this.getDescription()));
        cycle.setPeriodValues(this.getPeriodValues());
        cycle.setCronExpr(this.getCronExpr());
        cycle.setPeriod(this.getPeriod());
        cycle.setExecuteType(this.getExecuteType());
        cycle.setWhichNumber(this.getWhichNumber());
        return cycle;
    }

    private RunCycle convertToRunCycleForPlanInfo() {
        RunCycle cycle = new RunCycle();
        cycle.setStartDate(this.getStartDateStr());
        cycle.setEndDate(this.getEndDateStr());
        cycle.setRangeType(this.getRangeType().getName());
        cycle.setPeriodType(this.getPeriodType().getValue());
        cycle.setRunTime(this.getRunTime());
        cycle.setPeriodValues(this.getPeriodValues());
        cycle.setCronExpr(this.getCronExpr());
        cycle.setPeriod(this.getPeriod());
        cycle.setExecuteType(this.getExecuteType());
        cycle.setWhichNumber(this.getWhichNumber());
        return cycle;
    }

    public boolean checkData() {
        if (null == this.rangeType || null == this.startDate || null == this.periodType || null == this.runTime) {
            return false;
        }
        if (RunCycleRangeType.DateRange == this.rangeType && null == this.endDate) {
            return false;
        }
        return RunCyclePeriodType.Day == this.periodType || !this.periodValues.isEmpty();
    }
}

