/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.schedule.widget;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.earlywarn.kit.StringKit;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.GetFilterFieldsParameter;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.earlywarn.warn.EarlyWarnCache;
import kd.bos.entity.earlywarn.warn.EarlyWarnElement;
import kd.bos.entity.earlywarn.warnschedule.FormulaCondition;
import kd.bos.entity.earlywarn.warnschedule.WarnCondition;
import kd.bos.entity.earlywarn.warnschedule.WarnSchedule;
import kd.bos.entity.filter.CompareInputType;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.CompareTypeDto;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.param.CustomParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.TreeView;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.FormulaException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.earlywarn.warn.EarlyWarnMetadata;
import kd.bos.metadata.earlywarn.warn.EarlyWarnReader;
import kd.bos.metadata.earlywarn.warnschedule.WarnScheduleMetadata;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.mservice.earlywarn.ConditionCheckResult;
import kd.bos.param.impl.ParameterReaderServiceImpl;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.earlywarn.EarlyWarnMetaServicHelper;

public class WSEditConditionViewHolder {
    public static final String BOS_EARLYWARN = "bos-earlywarn";
    public static final String CUSTOM_FORM_CONTAINER = "container_custom_form";
    private static final String CUSTOM_FORM_PAGE_ID = "custom_form_page_id";
    private static final String COMMON_FILTER = "common_filter";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String DEFAULT_CONDITION = "default_condition";
    private static final String TREE_VIEW = "tv_fields";
    private static final String EXPRESSION = "fexpression";
    private static final String TRANSLATION = "ftranexpr";
    private static final String ISUSEAPPEXT = "isuseappext_earlywarn";
    private static Log logger = LogFactory.getLog(WSEditConditionViewHolder.class);
    private IFormView view;
    private IPageCache cache;

    public WSEditConditionViewHolder(IFormView view, IPageCache cache) {
        this.view = view;
        this.cache = cache;
    }

    public void init(WarnScheduleMetadata meta, CloseCallBack customConditionFormCallback) {
        WarnCondition condition;
        String earlyWarnId = meta.getWarnSchedule().getEarlyWarnId();
        String customFormId = "";
        EarlyWarnElement warnElement = null;
        if (StringKit.isNotBlank(earlyWarnId) && EarlyWarnReader.idExists(earlyWarnId)) {
            warnElement = EarlyWarnCache.load(earlyWarnId);
            customFormId = warnElement == null ? "" : warnElement.getConditionFormId();
        }
        condition = (condition = meta.getWarnSchedule().getWarnCondition()) == null ? new WarnCondition() : condition;
        String customDataJson = condition.getCustomDataJson();
        HashMap<String, Object> customDataMap = StringKit.isBlank(customDataJson) ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)customDataJson, Map.class);
        this.initCustomForm(customFormId, customDataMap, customConditionFormCallback);
        this.initGridFilter(warnElement, meta.getBizappId());
        this.initExpressionCondition(warnElement, condition);
    }

    private void initCustomForm(String customFormId, Map<String, Object> customDataMap, CloseCallBack customCallBack) {
        if (StringKit.isBlank(customFormId)) {
            this.view.setVisible(Boolean.valueOf(false), new String[]{CUSTOM_FORM_CONTAINER});
            return;
        }
        this.view.setVisible(Boolean.valueOf(true), new String[]{CUSTOM_FORM_CONTAINER});
        this.view.setVisible(Boolean.valueOf(false), new String[]{COMMON_FILTER});
        this.view.setVisible(Boolean.valueOf(false), new String[]{"tab_advanced_condition"});
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(CUSTOM_FORM_CONTAINER);
        formShowParameter.setFormId(customFormId);
        formShowParameter.setParentFormId(this.view.getFormShowParameter().getParentFormId());
        formShowParameter.setCustomParams(customDataMap);
        formShowParameter.setCloseCallBack(customCallBack);
        String pageId = formShowParameter.getPageId();
        this.cache.put(CUSTOM_FORM_PAGE_ID, pageId);
        this.view.showForm(formShowParameter);
    }

    private void initGridFilter(EarlyWarnElement earlyWarn, String bizAppId) {
        String earlyWarnId = earlyWarn == null ? "" : earlyWarn.getId();
        String entityNumber = earlyWarn == null ? "" : earlyWarn.getDataSourceId();
        String tEntityNumber = "";
        List cols = new ArrayList();
        MainEntityType mainEntityType = null;
        if (StringKit.isNotBlank(entityNumber) && StringKit.isNotBlank(bizAppId)) {
            try {
                mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                tEntityNumber = mainEntityType.getName();
                boolean isUseExt = false;
                ParameterReaderServiceImpl service = new ParameterReaderServiceImpl();
                HashSet<String> set = new HashSet<String>(1);
                set.add(ISUSEAPPEXT);
                CustomParam customParam = new CustomParam(set);
                Map map = service.loadCustomParameterFromCache(customParam);
                if (map != null && map.get(ISUSEAPPEXT) != null) {
                    isUseExt = Boolean.parseBoolean((String)map.get(ISUSEAPPEXT));
                }
                String appNumber = mainEntityType.getAppId();
                if (isUseExt) {
                    appNumber = BizAppServiceHelp.getAppNumByAppId((String)bizAppId);
                }
                cols = (List)DispatchServiceHelper.invokeBOSService((String)appNumber, (String)"EarlyWarnService", (String)"getCommonFilterColumns", (Object[])new Object[]{earlyWarnId, entityNumber});
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        ArrayList arrayList = cols = cols == null ? new ArrayList() : cols;
        if (mainEntityType == null) {
            logger.warn("mainEntityType is null ,entityNumber = " + entityNumber);
            return;
        }
        List<CompareType> customCompareTypeList = this.buildCustomCompareTypeList();
        FilterGrid filterGrid = (FilterGrid)this.view.getControl(COMMON_FILTER);
        GetFilterFieldsParameter getFilterFieldsParameter = new GetFilterFieldsParameter((IDataEntityType)mainEntityType);
        for (Map col : cols) {
            if (!"datetime".equals(col.get("type")) && !"date".equals(col.get("type")) || !(col.get("fieldName") instanceof String)) continue;
            String fieldName = (String)col.get("fieldName");
            getFilterFieldsParameter.addCustomCompareTypes(fieldName, customCompareTypeList);
            filterGrid.addCustomCompareTypes(fieldName, customCompareTypeList);
        }
        List filterColumns = EntityTypeUtil.createFilterColumns((GetFilterFieldsParameter)getFilterFieldsParameter);
        filterGrid.setEntityNumber(tEntityNumber);
        this.trySortCustomCompareType(filterColumns);
        filterGrid.setFilterColumns(filterColumns);
    }

    private void trySortCustomCompareType(List<Map<String, Object>> filterColumns) {
        try {
            block2: for (Map<String, Object> filterColumn : filterColumns) {
                CompareTypeDto compareType;
                int i;
                if (!"datetime".equals(filterColumn.get("type")) && !"date".equals(filterColumn.get("type")) || !(filterColumn.get("compareTypes") instanceof ArrayList)) continue;
                List compareTypes = (List)filterColumn.get("compareTypes");
                ArrayList<CompareTypeDto> customCompareTypeList = new ArrayList<CompareTypeDto>(3);
                ArrayList<Integer> customCompareTypeIndexList = new ArrayList<Integer>(3);
                for (i = 0; i < compareTypes.size(); ++i) {
                    compareType = (CompareTypeDto)compareTypes.get(i);
                    if (this.isCustomCompareType(compareType.getId())) {
                        customCompareTypeList.add(compareType);
                        customCompareTypeIndexList.add(i);
                    }
                    if (customCompareTypeList.size() == 3) break;
                }
                if (customCompareTypeList.size() != 3) continue;
                Collections.sort(customCompareTypeIndexList, Collections.reverseOrder());
                for (Integer index : customCompareTypeIndexList) {
                    compareTypes.remove(index);
                }
                for (i = 0; i < compareTypes.size(); ++i) {
                    compareType = (CompareTypeDto)compareTypes.get(i);
                    if (!CompareTypeEnum.NDAYSBEFORE.getId().equals(compareType.getId())) continue;
                    compareTypes.addAll(i, customCompareTypeList);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
    }

    private List<CompareType> buildCustomCompareTypeList() {
        String afterNDaysString = ResManager.loadKDString((String)"N\u5929\u540e", (String)"WSEditConditionViewHolder_4", (String)BOS_EARLYWARN, (Object[])new Object[0]);
        String nDaysAfterString = ResManager.loadKDString((String)"\u540eN\u5929", (String)"WSEditConditionViewHolder_5", (String)BOS_EARLYWARN, (Object[])new Object[0]);
        String atNDaysAfterString = ResManager.loadKDString((String)"\u540e\u7b2cN\u5929", (String)"WSEditConditionViewHolder_6", (String)BOS_EARLYWARN, (Object[])new Object[0]);
        CompareType afterNDays = CompareType.createContant((String)"earlywarn_afterNDays", (LocaleString)new LocaleString(afterNDaysString), (String)"", (boolean)true, (CompareInputType)CompareInputType.INTEGER);
        CompareType nDaysAfter = CompareType.createContant((String)"earlywarn_nDaysAfter", (LocaleString)new LocaleString(nDaysAfterString), (String)"", (boolean)true, (CompareInputType)CompareInputType.INTEGER);
        CompareType atNDaysAfter = CompareType.createContant((String)"earlywarn_atNDaysAfter", (LocaleString)new LocaleString(atNDaysAfterString), (String)"", (boolean)true, (CompareInputType)CompareInputType.INTEGER);
        ArrayList<CompareType> customCompareTypeList = new ArrayList<CompareType>(3);
        customCompareTypeList.add(afterNDays);
        customCompareTypeList.add(nDaysAfter);
        customCompareTypeList.add(atNDaysAfter);
        return customCompareTypeList;
    }

    private void initExpressionCondition(EarlyWarnElement warnElement, WarnCondition warnCondition) {
        FormulaCondition formulaCondition = warnCondition.getFormulaCondition();
        if (null != formulaCondition) {
            this.view.getModel().setValue(EXPRESSION, (Object)formulaCondition.getExpression());
            this.view.getModel().setValue(TRANSLATION, (Object)formulaCondition.getTranslation());
            this.view.getModel().setValue("fdescription", (Object)formulaCondition.getDescription());
        }
        if (null == warnElement) {
            return;
        }
        String dataSource = warnElement.getDataSourceId();
        if (StringUtils.isBlank((CharSequence)dataSource)) {
            return;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)dataSource);
        HashSet<String> selectedEntity = new HashSet<String>();
        selectedEntity.add(mainEntityType.getName());
        PropTreeBuildOption propTreeBuildOption = new PropTreeBuildOption(selectedEntity, (IDataEntityProperty)null);
        propTreeBuildOption.setCurrentEntity(mainEntityType.getName());
        propTreeBuildOption.setIncludeChildEntity(false);
        propTreeBuildOption.setIncludeParentEntity(false);
        propTreeBuildOption.setIncludeEntryEntityAsKeyPrefix(true);
        TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainEntityType, (PropTreeBuildOption)propTreeBuildOption);
        TreeView treeView = (TreeView)this.view.getControl(TREE_VIEW);
        treeView.addNode(treeNode);
        this.cache.put("treenodes", SerializationUtils.toJsonString((Object)treeNode));
        this.cache.put("entitynumber", dataSource);
    }

    public void initFilterGridData(FilterCondition filterCondition) {
        FilterGrid filterGrid = (FilterGrid)this.view.getControl(COMMON_FILTER);
        if (filterCondition != null) {
            filterGrid.SetValue(filterCondition);
        }
    }

    public void changeEarlyWarn(String earlyWarnNumber, CloseCallBack callback) {
        EarlyWarnMetadata meta = StringKit.isBlank(earlyWarnNumber) ? null : EarlyWarnMetaServicHelper.loadMetaByNumber(earlyWarnNumber, true);
        EarlyWarnElement warnElement = meta == null ? null : meta.getWarnElement();
        String customFormId = warnElement == null ? "" : warnElement.getConditionFormId();
        HashMap<String, Object> customDataMap = new HashMap<String, Object>();
        this.initCustomForm(customFormId, customDataMap, callback);
        String bizAppId = meta == null ? "" : meta.getBizappId();
        this.initGridFilter(warnElement, bizAppId);
        this.initExpressionCondition(warnElement, new WarnCondition());
        FilterGrid filterGrid = (FilterGrid)this.view.getControl(COMMON_FILTER);
        filterGrid.SetValue(new ArrayList());
        filterGrid.bindData(null);
        this.view.getModel().setValue(EXPRESSION, (Object)"");
        this.view.getModel().setValue(TRANSLATION, (Object)"");
        this.view.getModel().setValue("fdescription", (Object)"");
    }

    public boolean checkData(String bizAppId) {
        FilterGrid filterGrid = (FilterGrid)this.view.getControl(COMMON_FILTER);
        String entityNumber = filterGrid.getEntityNumber();
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
            FilterCondition filterCondition = filterGridState.getFilterCondition();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)filterGrid.getEntityNumber());
            List filterRowList = filterCondition.getFilterRow();
            for (SimpleFilterRow filterRow : filterRowList) {
                if (!this.checkCustomCompareValue(filterRow)) {
                    return false;
                }
                FilterField filterField = FilterBuilder.getFilterField((MainEntityType)mainEntityType, (String)filterRow.getFieldName());
                if (filterField != null) continue;
                this.view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%1$s\u4e0d\u5b58\u5728\u5b57\u6bb5%2$s\uff0c\u9519\u8bef\u4ee3\u7801: %3$s\u3002", (String)"WSEditConditionViewHolder_2", (String)BOS_EARLYWARN, (Object[])new Object[0]), mainEntityType.getName(), filterRow.getFieldName(), "FIELDNOTEXISTS000023"));
                return false;
            }
            if (!this.checkExpression()) {
                return false;
            }
        }
        String pageId = this.cache.get(CUSTOM_FORM_PAGE_ID);
        if (StringUtils.isBlank((CharSequence)bizAppId) || StringUtils.isBlank((CharSequence)pageId)) {
            return true;
        }
        String appNumber = BizAppServiceHelp.getAppNumByAppId((String)bizAppId);
        ConditionCheckResult checkInfo = (ConditionCheckResult)DispatchServiceHelper.invokeBOSService((String)appNumber, (String)"WarnScheduleFormService", (String)"checkCustomConditionParams", (Object[])new Object[]{pageId});
        if (!checkInfo.isSuccess()) {
            this.view.showTipNotification(checkInfo.getMessage());
        }
        return checkInfo.isSuccess();
    }

    private boolean checkCustomCompareValue(SimpleFilterRow filterRow) {
        String compareType = filterRow.getCompareType();
        if (!this.isCustomCompareType(compareType)) {
            return true;
        }
        for (FilterValue filterValue : filterRow.getValue()) {
            if (!"0".equals(filterValue.getValue()) && !StringUtils.isBlank((Object)filterValue.getValue())) continue;
            this.view.showErrorNotification(ResManager.loadKDString((String)"N\u5929\u540e\u3001\u540eN\u5929\u3001\u540e\u7b2cN\u5929\u4f5c\u4e3a\u6761\u4ef6\uff0c\u503c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"WSEditConditionViewHolder_7", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isCustomCompareType(String compareType) {
        return "earlywarn_afterNDays".equals(compareType) || "earlywarn_nDaysAfter".equals(compareType) || "earlywarn_atNDaysAfter".equals(compareType);
    }

    private boolean checkExpression() {
        Object formula = this.view.getModel().getValue(EXPRESSION);
        if (StringUtils.isBlank((Object)formula)) {
            return true;
        }
        try {
            FormulaEngine.extractVariables((String)((String)formula));
            FormulaEngine.parseFormula((String)((String)formula));
        }
        catch (FormulaException formulaExp) {
            String tranError;
            String string = tranError = formulaExp.getCause() != null ? formulaExp.getCause().getMessage() : formulaExp.getMessage();
            if (tranError.lastIndexOf(46) == tranError.length() - 1) {
                tranError = tranError.substring(0, tranError.length() - 1);
            }
            this.view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u8bed\u6cd5\u9519\u8bef\uff1a%s\uff0c\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f\u3002", (String)"WSEditConditionViewHolder_1", (String)BOS_EARLYWARN, (Object[])new Object[0]), tranError.replaceAll("\n", "")));
            return false;
        }
        catch (Exception exp) {
            String message = ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u8bed\u6cd5\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f\u3002", (String)"WSEditConditionViewHolder_0", (String)BOS_EARLYWARN, (Object[])new Object[0]);
            this.view.showErrorNotification(message);
            return false;
        }
        return true;
    }

    public void assemble(WarnScheduleMetadata meta) {
        WarnCondition warnCondition = new WarnCondition();
        String pageId = this.cache.get(CUSTOM_FORM_PAGE_ID);
        Map customDataMap = new HashMap();
        String bizAppId = meta.getWarnSchedule().getBizAppId();
        if (StringKit.isNotBlank(pageId) && StringKit.isNotBlank(bizAppId)) {
            String appNumber = BizAppServiceHelp.getAppNumByAppId((String)bizAppId);
            customDataMap = (Map)DispatchServiceHelper.invokeBOSService((String)appNumber, (String)"WarnScheduleFormService", (String)"getCustomConditionParams", (Object[])new Object[]{pageId});
        }
        customDataMap = null == customDataMap ? new HashMap() : customDataMap;
        String customDataJson = SerializationUtils.toJsonString(customDataMap);
        warnCondition.setCustomDataJson(customDataJson);
        FilterGrid filterGrid = (FilterGrid)this.view.getControl(COMMON_FILTER);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition filterCondition = filterGridState.getFilterCondition();
        warnCondition.setFilterCondition(filterCondition);
        FormulaCondition formulaCondition = new FormulaCondition();
        formulaCondition.setExpression((String)this.view.getModel().getValue(EXPRESSION));
        formulaCondition.setTranslation((String)this.view.getModel().getValue(TRANSLATION));
        formulaCondition.setDescription((String)this.view.getModel().getValue("fdescription"));
        warnCondition.setFormulaCondition(formulaCondition);
        WarnSchedule schedule = meta.getWarnSchedule();
        schedule.setWarnCondition(warnCondition);
    }
}

