/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.schedule.widget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.earlywarn.kit.StringKit;
import kd.bos.designer.earlywarn.utils.MulilangConfig;
import kd.bos.designer.earlywarn.utils.ParamsUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.earlywarn.warnschedule.MessageContent;
import kd.bos.entity.earlywarn.warnschedule.WarnMessageConfig;
import kd.bos.entity.earlywarn.warnschedule.WarnSchedule;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageReceiver;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageReceiverType;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageSendType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.metadata.earlywarn.warn.EarlyWarnMetadata;
import kd.bos.metadata.earlywarn.warn.EarlyWarnReader;
import kd.bos.metadata.earlywarn.warnschedule.WarnScheduleMetadata;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class WSEditMessageViewHolder {
    private static final String MSG_TYPE_CENTER = "msg_type_center";
    private static final String MSG_TYPE_YZJ = "msg_type_yzj";
    private static final String MSG_TYPE_SMS = "msg_type_sms";
    private static final String MSG_TYPE_EMAIL = "msg_type_email";
    private static final String MSG_TYPE_QYWEIXIN = "msg_type_qyweixin";
    public static final String MSG_RECEIVER = "msg_receiver";
    public static final String MSG_TITLE = "msg_title";
    private static final String MSG_MERGE_MSG = "merge_msg";
    public static final String MSG_SINGLE_CONTENT = "msg_single_content";
    public static final String MSG_MERGE_CONTENT = "msg_merge_content";
    private static final String SELECTED_RECEIVER_CACHE = "selected_receiver_cache";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String MSG_CHANNEL = "msg_channel";
    private static final String MSG_TYPE = "msg_type";
    private static final String QUICK_PROCESS = "quick_process";
    private static final String GROUP_FIELD = "groupfield";
    private static final String LANG_COMBO = "langcombo";
    private IFormView view;
    private IDataModel model;
    private IPageCache cache;

    public WSEditMessageViewHolder(IFormView view, IDataModel model, IPageCache cache) {
        this.cache = cache;
        this.model = model;
        this.view = view;
    }

    public void init(WarnScheduleMetadata meta) {
        WarnSchedule warnSchedule = meta.getWarnSchedule();
        WarnMessageConfig config = warnSchedule.getMessageConfig();
        config = config == null ? new WarnMessageConfig() : config;
        this.setMessageType(config.getSendTypes());
        String typeNumbers = config.getSendTypeNumbers();
        this.model.setValue(MSG_TYPE, (Object)typeNumbers);
        this.setSelectedReceiverTypes(config.getReceiverTypes());
        this.model.setValue(MSG_TITLE, (Object)config.getTitle());
        this.model.setValue(MSG_MERGE_MSG, (Object)config.isMergeSendMessage());
        this.model.setValue(MSG_SINGLE_CONTENT, (Object)config.getSingleContent());
        this.model.setValue(QUICK_PROCESS, (Object)config.isQuickProcessing());
        this.setMergeMessage(config, null);
        this.setMsgContentByLang(config);
        this.initGroupFieldCombo(meta.getWarnSchedule().getEarlyWarnId());
        this.model.setValue(GROUP_FIELD, (Object)config.getGroupField());
    }

    private void setMsgContentByLang(WarnMessageConfig config) {
        List<MulilangConfig> mulilangConfigs = config.getMulilangConfigs();
        String langValue = this.model.getValue(LANG_COMBO).toString();
        for (MulilangConfig mulilangConfig : mulilangConfigs) {
            if (!mulilangConfig.getLangType().equals(langValue)) continue;
            this.model.setValue(MSG_TITLE, (Object)mulilangConfig.getTitle());
            this.model.setValue(MSG_SINGLE_CONTENT, (Object)mulilangConfig.getSingleContent());
            this.setMergeMessage(config, mulilangConfig);
            break;
        }
    }

    private void setMergeMessage(WarnMessageConfig config, MulilangConfig mulilangConfig) {
        String oldMergeContent;
        MessageContent messageContentByLang = mulilangConfig == null ? null : mulilangConfig.getMessageContent();
        String mergeContentByLang = mulilangConfig == null ? null : mulilangConfig.getMergeContent();
        MessageContent newContent = messageContentByLang != null ? messageContentByLang : config.getMergeMessageContent();
        String string = oldMergeContent = StringUtils.isNotBlank((CharSequence)mergeContentByLang) ? mergeContentByLang : config.getMergeContent();
        if (ParamsUtils.isUserNewWarnScheme()) {
            if (newContent != null) {
                this.model.setValue(MSG_MERGE_CONTENT, (Object)SerializationUtils.toJsonString((Object)newContent));
            } else {
                MessageContent messageContent = new MessageContent();
                messageContent.setMessageHead(oldMergeContent);
                this.model.setValue(MSG_MERGE_CONTENT, (Object)SerializationUtils.toJsonString((Object)messageContent));
            }
            return;
        }
        if (StringUtils.isBlank((CharSequence)oldMergeContent) && newContent != null) {
            this.model.setValue(MSG_MERGE_CONTENT, (Object)newContent.getMessageHead());
        } else {
            this.model.setValue(MSG_MERGE_CONTENT, (Object)oldMergeContent);
        }
    }

    private void initGroupFieldCombo(String earlyWarnId) {
        if (StringUtils.isBlank((CharSequence)earlyWarnId)) {
            return;
        }
        EarlyWarnMetadata earlyWarn = EarlyWarnReader.loadMeta(earlyWarnId, true);
        if (null == earlyWarn) {
            return;
        }
        String dataSourceId = earlyWarn.getWarnElement().getDataSourceId();
        if (StringUtils.isBlank((CharSequence)dataSourceId)) {
            return;
        }
        this.setComboItems(dataSourceId);
    }

    public void setComboItems(String dataSourceId) {
        if (StringUtils.isBlank((CharSequence)dataSourceId)) {
            return;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)dataSourceId);
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        List<ComboItem> comboItems = this.getFieldListCombo(properties, false, null);
        ComboEdit comboEdit = (ComboEdit)this.view.getControl(GROUP_FIELD);
        comboEdit.setComboItems(comboItems);
    }

    private List<ComboItem> getFieldListCombo(DataEntityPropertyCollection properties, boolean onlySimpleProp, IDataEntityProperty parentProp) {
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
        if (CollectionUtils.isEmpty((Collection)properties)) {
            return comboItemList;
        }
        List simpleProperties = properties.getSimpleProperties(false);
        List complexProperties = properties.getComplexProperties(false);
        if (CollectionUtils.isNotEmpty((Collection)simpleProperties)) {
            for (ISimpleProperty simpleProperty : simpleProperties) {
                LocaleString displayName = simpleProperty.getDisplayName();
                String propertyName = simpleProperty.getName();
                if (null == displayName || StringUtils.isBlank((CharSequence)propertyName)) continue;
                if (parentProp != null) {
                    propertyName = parentProp.getName() + "." + propertyName;
                    displayName = new LocaleString(parentProp.getDisplayName().getLocaleValue() + "." + displayName.getLocaleValue());
                }
                comboItemList.add(new ComboItem(displayName, propertyName));
            }
        }
        if (!onlySimpleProp && CollectionUtils.isNotEmpty((Collection)complexProperties)) {
            for (IComplexProperty complexProperty : complexProperties) {
                if (!(complexProperty instanceof BasedataProp)) continue;
                String propertyName = complexProperty.getName();
                LocaleString displayName = complexProperty.getDisplayName();
                if (null == displayName || StringUtils.isBlank((CharSequence)propertyName)) continue;
                IDataEntityType baseDataEntityType = complexProperty.getComplexType();
                comboItemList.addAll(this.getFieldListCombo(baseDataEntityType.getProperties(), true, (IDataEntityProperty)complexProperty));
            }
        }
        return comboItemList;
    }

    public void setMessageType(List<WarnMessageSendType> sendTypes) {
        ComboItem comboItem;
        List<WarnMessageSendType> msgChannelItem = this.getMsgChannelItem();
        ArrayList<String> msgChannelValues = new ArrayList<String>(msgChannelItem.size());
        ArrayList<ComboItem> comboEditList = new ArrayList<ComboItem>(msgChannelItem.size());
        ComboItem center = new ComboItem();
        center.setValue("message_center");
        String centerType = ResManager.loadKDString((String)"\u6d88\u606f\u4e2d\u5fc3", (String)"WSEditMessageViewHolder_5", (String)"bos-earlywarn", (Object[])new Object[0]);
        center.setCaption(new LocaleString(centerType));
        comboEditList.add(center);
        for (WarnMessageSendType type : msgChannelItem) {
            comboItem = new ComboItem();
            comboItem.setValue(type.getValue());
            msgChannelValues.add(type.getValue());
            comboItem.setCaption(new LocaleString(type.getName()));
            comboEditList.add(comboItem);
        }
        for (WarnMessageSendType sendType : sendTypes) {
            if (!StringUtils.isBlank((Object)sendType.getId()) || msgChannelValues.contains(sendType.getRealSendType()) || StringUtils.equals((CharSequence)sendType.getValue(), (CharSequence)"message_center")) continue;
            comboItem = new ComboItem();
            comboItem.setValue(sendType.getValue());
            comboItem.setCaption(new LocaleString(sendType.getName()));
            comboEditList.add(comboItem);
            msgChannelItem.add(sendType);
        }
        msgChannelItem.add(new WarnMessageSendType(null, centerType, "message_center"));
        ComboEdit comboEdit = (ComboEdit)this.view.getControl(MSG_TYPE);
        comboEdit.setComboItems(comboEditList);
        this.cache.put("earlywarn_msg_channel", SerializationUtils.toJsonString(msgChannelItem));
    }

    public void changeEarlyWarn() {
        this.model.setValue(MSG_TITLE, (Object)"");
        this.model.setValue(MSG_SINGLE_CONTENT, (Object)"");
        this.model.setValue(MSG_MERGE_CONTENT, (Object)"");
        this.view.getPageCache().remove("mulilangConfig");
    }

    public String getSingleContent() {
        return StringKit.toSafeString(this.model.getValue(MSG_SINGLE_CONTENT));
    }

    public void setSingleContent(String message) {
        this.model.setValue(MSG_SINGLE_CONTENT, (Object)message);
    }

    public boolean isQuickProcessing() {
        return (Boolean)this.model.getValue(QUICK_PROCESS);
    }

    public void setQuickProcessing(boolean quickProcessing) {
        this.model.setValue(QUICK_PROCESS, (Object)quickProcessing);
    }

    public String getMergeContent() {
        return StringKit.toSafeString(this.model.getValue(MSG_MERGE_CONTENT));
    }

    public void setMergeContent(String message) {
        this.model.setValue(MSG_MERGE_CONTENT, (Object)message);
    }

    public void setSelectedReceiverTypes(List<WarnMessageReceiverType> list) {
        String json = CollectionUtils.isEmpty(list) ? "" : SerializationUtils.toJsonString(list);
        this.cache.put(SELECTED_RECEIVER_CACHE, json);
        String receiverNames = this.getReceiverNames(list);
        if (receiverNames.length() > 25) {
            receiverNames = receiverNames.substring(0, 25) + "...";
        }
        this.model.setValue(MSG_RECEIVER, (Object)receiverNames);
    }

    public List<WarnMessageReceiverType> getSelectedReceiverTypes() {
        String json = this.cache.get(SELECTED_RECEIVER_CACHE);
        return StringKit.isBlank(json) ? new ArrayList() : SerializationUtils.fromJsonStringToList((String)json, WarnMessageReceiverType.class);
    }

    private String getReceiverNames(List<WarnMessageReceiverType> list) {
        LinkedList<String> names = new LinkedList<String>();
        for (WarnMessageReceiverType type : list) {
            for (WarnMessageReceiver receiver : type.getReceivers()) {
                names.add(receiver.getName());
            }
        }
        return StringKit.join(names);
    }

    public boolean checkData() {
        Object type = this.model.getValue(MSG_TYPE);
        if (StringUtils.isBlank((Object)type)) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9884\u8b66\u6d88\u606f\u53d1\u9001\u65b9\u5f0f\u3002", (String)"WSEditMessageViewHolder_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isBlank((Object)this.model.getValue(MSG_RECEIVER))) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9884\u8b66\u6d88\u606f\u63a5\u6536\u4eba\u3002", (String)"WSEditMessageViewHolder_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (StringKit.isBlank(this.getTitle())) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u9884\u8b66\u6d88\u606f\u6807\u9898\u3002", (String)"WSEditMessageViewHolder_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (StringKit.isBlank(this.getSingleContent())) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u9884\u8b66\u5185\u5bb9\u3002", (String)"WSEditMessageViewHolder_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (this.getBooleanValue(MSG_MERGE_MSG) && StringKit.isBlank(this.getMergeContent())) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5408\u5e76\u9884\u8b66\u5185\u5bb9\u3002", (String)"WSEditMessageViewHolder_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void setTitle(String title) {
        this.model.setValue(MSG_TITLE, (Object)title);
    }

    public String getTitle() {
        return StringKit.toSafeString(this.model.getValue(MSG_TITLE));
    }

    private boolean getBooleanValue(String key) {
        Boolean value = (Boolean)this.model.getValue(key);
        return value == null ? false : value;
    }

    private List<WarnMessageSendType> getSendTypes() {
        String msgChannel = this.cache.get("earlywarn_msg_channel");
        List types = SerializationUtils.fromJsonStringToList((String)msgChannel, WarnMessageSendType.class);
        String type = (String)this.model.getValue(MSG_TYPE);
        String[] splitType = StringUtils.split((String)type, (String)",");
        ArrayList<WarnMessageSendType> resultTypes = new ArrayList<WarnMessageSendType>();
        block0: for (String typeNumber : splitType) {
            for (WarnMessageSendType messageSendType : types) {
                if (!StringUtils.equals((CharSequence)typeNumber, (CharSequence)messageSendType.getValue())) continue;
                resultTypes.add(messageSendType);
                continue block0;
            }
        }
        return resultTypes;
    }

    public void assemble(WarnScheduleMetadata meta) {
        WarnMessageConfig config = new WarnMessageConfig();
        config.setSendTypes(this.getSendTypes());
        config.setReceiverTypes(this.getSelectedReceiverTypes());
        config.setTitle(this.getTitle());
        config.setSingleContent(this.getSingleContent());
        config.setMergeSendMessage(this.getBooleanValue(MSG_MERGE_MSG));
        config.setQuickProcessing(this.getBooleanValue(QUICK_PROCESS));
        config.setMulilangConfigs(this.getMulilangConfigs());
        String mergeContent = StringKit.toSafeString(this.model.getValue(MSG_MERGE_CONTENT));
        if (ParamsUtils.isUserNewWarnScheme()) {
            config.setMergeMessageContent(this.getMergeMessageContent(mergeContent));
            config.setGroupField(this.getGroupFieldValue());
        } else {
            MessageContent content = this.getMergeMessageContent(mergeContent);
            config.setMergeContent(content.getMessageHead());
        }
        WarnSchedule schedule = meta.getWarnSchedule();
        schedule.setMessageConfig(config);
    }

    private List<MulilangConfig> getMulilangConfigs() {
        String mulilangConfigStr = this.cache.get("mulilangConfigList");
        if (StringUtils.isBlank((CharSequence)mulilangConfigStr)) {
            return new ArrayList<MulilangConfig>();
        }
        List mulilangConfigs = SerializationUtils.fromJsonStringToList((String)mulilangConfigStr, MulilangConfig.class);
        for (MulilangConfig mulilangConfig : mulilangConfigs) {
            MessageContent mergeMessageContent = this.getMergeMessageContent(mulilangConfig.getMergeContent());
            if (ParamsUtils.isUserNewWarnScheme()) {
                mulilangConfig.setMessageContent(mergeMessageContent);
                continue;
            }
            mulilangConfig.setMergeContent(mergeMessageContent.getMessageHead());
        }
        return mulilangConfigs;
    }

    private MessageContent getMergeMessageContent(String mergeContent) {
        MessageContent content;
        try {
            content = (MessageContent)SerializationUtils.fromJsonString((String)mergeContent, MessageContent.class);
        }
        catch (Exception e) {
            content = new MessageContent(mergeContent);
        }
        return content;
    }

    private String getGroupFieldValue() {
        return StringKit.toSafeString(this.model.getValue(GROUP_FIELD));
    }

    private List<WarnMessageSendType> getMsgChannelItem() {
        DynamicObject[] channelArray = BusinessDataServiceHelper.load((String)MSG_CHANNEL, (String)"id, number, name, enable", null);
        ArrayList<WarnMessageSendType> typeItemList = new ArrayList<WarnMessageSendType>(10);
        if (channelArray != null && channelArray.length > 0) {
            for (DynamicObject channelDo : channelArray) {
                String name = channelDo.getString("name");
                String number = channelDo.getString("number");
                boolean enable = channelDo.getBoolean("enable");
                if (!enable || "sysnotice".equalsIgnoreCase(number)) continue;
                WarnMessageSendType msgType = new WarnMessageSendType(channelDo.getPkValue(), name, number);
                typeItemList.add(msgType);
            }
        }
        return typeItemList;
    }
}

