/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.warn;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.designer.earlywarn.warn.bo.EWCopyBo;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.earlywarn.EarlyWarnMetaServicHelper;
import kd.bos.util.StringUtils;

public class EarlyWarnCopyPlugin
extends AbstractFormPlugin {
    private static final String FORM_NUMBER = "warn_earlywarn_copy";
    private static final String PARAM_NUMBER = "number";
    private static final String PARAM_NAME = "name";
    private static final String PARAM_BIZ_APP_ID = "bizAppId";
    private static final String TXT_NUMBER = "number";
    private static final String TXT_NAME = "name";
    private static final String TXT_BIZ_APP_ID = "biz_app";
    private static final String BOS_EARLYWARN = "bos-designer-plugin";
    private static final String BTN_SAVE = "btn_save";
    private static final Log log = LogFactory.getLog(EarlyWarnCopyPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_SAVE});
    }

    public void click(EventObject e) {
        super.click(e);
        Control control = (Control)e.getSource();
        String key = control.getKey();
        if (!BTN_SAVE.equals(key)) {
            return;
        }
        IDataModel model = this.getModel();
        String number = (String)model.getValue("number");
        if (StringUtils.isEmpty((String)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u7f16\u7801\u3002", (String)"EarlyWarnCopyPlugin_0", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        String newNodeNumber = number + "_extend";
        if (newNodeNumber.length() > 36) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u8b66\u5bf9\u8c61\u7f16\u7801\u8fc7\u957f\uff0c\u8bf7\u7f29\u77ed\u7f16\u7801\u957f\u5ea6\uff0c\u5426\u5219\u65e0\u6cd5\u4fdd\u5b58\u5165\u5e93\u3002", (String)"EarlyWarnDesignerEditPlugin_28", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        if (EarlyWarnMetaServicHelper.exists(number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7f16\u7801\u5df2\u88ab\u5176\u5b83\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u4f7f\u7528\u3002", (String)"EarlyWarnCopyPlugin_1", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        OrmLocaleValue name = (OrmLocaleValue)model.getValue("name");
        if (null == name || StringUtils.isEmpty((String)name.getLocaleValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u540d\u79f0\u3002", (String)"EarlyWarnCopyPlugin_2", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        DynamicObject bizApp = (DynamicObject)model.getValue(TXT_BIZ_APP_ID);
        if (null == bizApp) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u6240\u5c5e\u5e94\u7528\u3002", (String)"EarlyWarnCopyPlugin_3", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        String bizAppId = bizApp.getString("id");
        EWCopyBo data = new EWCopyBo(number, name, bizAppId);
        this.getView().returnDataToParent((Object)data);
        this.getView().close();
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter param = this.getView().getFormShowParameter();
        String number = (String)param.getCustomParam("number");
        String name = (String)param.getCustomParam("name");
        String bizAppId = (String)param.getCustomParam(PARAM_BIZ_APP_ID);
        this.getModel().setValue("number", (Object)number);
        this.getModel().setValue("name", (Object)new LocaleString(name));
        this.getModel().setValue(TXT_BIZ_APP_ID, (Object)bizAppId);
    }

    public static FormShowParameter show(String number, String name, String bizAppId, CloseCallBack callback) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId(FORM_NUMBER);
        param.setCustomParam("number", (Object)number);
        param.setCustomParam("name", (Object)name);
        param.setCustomParam(PARAM_BIZ_APP_ID, (Object)bizAppId);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(callback);
        return param;
    }
}

