/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.warn;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.EventObject;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.designer.earlywarn.utils.LogUtils;
import kd.bos.designer.earlywarn.warn.kit.FileKit;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.earlywarn.warn.EarlyWarnMetadata;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.earlywarn.EarlyWarnMetaServicHelper;

public class EarlyWarnExportPlugin
extends AbstractFormPlugin {
    private static final String FORM_NUMBER = "warn_earlywarn_export";
    private static final String PARAM_MASTER_ID = "masterId";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String TXT_NAME = "name";
    private static final String TXT_NUMBER = "number";
    private static final String BTN_CONFIRM = "btn_confirm";
    private static final String BOS_EARLYWARN = "bos-earlywarn";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CONFIRM});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void click(EventObject e) {
        super.click(e);
        Control control = (Control)e.getSource();
        String key = control.getKey();
        if (!BTN_CONFIRM.equals(key)) {
            return;
        }
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRY_ENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        if (selectIndex.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u3002", (String)"EarlyWarnExportPlugin_0", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        if (selectIndex.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5355\u4e2a\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u5bfc\u51fa\u3002", (String)"EarlyWarnExportPlugin_1", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        String number = (String)this.getModel().getValue(TXT_NUMBER, selectIndex[0]);
        EarlyWarnMetadata meta = EarlyWarnMetaServicHelper.loadMetaByNumber(number, false);
        List list = MetadataDao.getEarlyWarnDeployFile((String)meta.getId());
        if (null == list || list.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6DeployFile\u5931\u8d25\u3002", (String)"EarlyWarnExportPlugin_2", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        String bizAppId = meta.getBizappId();
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String exportPath = FileKit.getExportPath(appMeta, "warn");
        for (DeployFile deployFile : list) {
            FileKit.mkdirs(exportPath);
            String fileName = deployFile.getFileName();
            File file = new File(exportPath, fileName);
            if (!FileKit.endWithOne(fileName, ".warn", "zh_CN.warnx")) continue;
            FileKit.writeFile(file, deployFile.getFileContent());
        }
        String bizPath = FileKit.getBizPath(appMeta);
        File zipFile = new File(bizPath, number + "(EarlyWarn).zip");
        FileKit.zipFile(new File(exportPath), "datamodel", zipFile);
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u5bfc\u51fa\u6210\u529f\u3002", "EarlyWarnExportPlugin_3", BOS_EARLYWARN);
        try (FileInputStream in = new FileInputStream(zipFile.getCanonicalFile());){
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(number + "(EarlyWarn).zip", (InputStream)in, 5000);
            this.getView().openUrl(url);
            this.getView().close();
        }
        catch (Exception error) {
            this.getView().showErrorNotification(error.getMessage());
            opDescBridge = new MultiLangEnumBridge("\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u5bfc\u51fa\u5931\u8d25\u3002", "EarlyWarnExportPlugin_4", BOS_EARLYWARN);
        }
        finally {
            String tracePath = FileKit.getTracePath(appMeta);
            FileKit.deleteFile(new File(tracePath));
            String appPath = FileKit.getAppPath(appMeta);
            FileKit.deleteFile(new File(appPath));
        }
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        TimeService timeService = new TimeService();
        logInfo.setOpTime(timeService.getCurrentSystemTime());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u5bfc\u51fa", "EarlyWarnExportPlugin_5", BOS_EARLYWARN);
        logInfo.setOpName("export", opNameBridge);
        logInfo.setOpDesc(opDescBridge, new String[0]);
        logInfo.setBizObjID("warn_earlywarn");
        LogUtils.addLog(this.getView(), (AppLogInfo)logInfo);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter param = this.getView().getFormShowParameter();
        String masterId = (String)param.getCustomParam(PARAM_MASTER_ID);
        List<EarlyWarnMetadata> list = EarlyWarnMetaServicHelper.loadMetasByMasterId(masterId);
        if (list.isEmpty()) {
            return;
        }
        IDataModel model = this.getModel();
        model.batchCreateNewEntryRow(ENTRY_ENTITY, list.size());
        for (int i = 0; i < list.size(); ++i) {
            EarlyWarnMetadata meta = list.get(i);
            model.setValue(TXT_NAME, (Object)meta.getName().getLocaleValue(), i);
            model.setValue(TXT_NUMBER, (Object)meta.getNumber(), i);
        }
    }

    public static FormShowParameter show(String masterId) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId(FORM_NUMBER);
        param.setCustomParam(PARAM_MASTER_ID, (Object)masterId);
        param.getOpenStyle().setShowType(ShowType.Modal);
        return param;
    }
}

