/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.warn;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.designer.earlywarn.warn.bo.EWImportBo;
import kd.bos.designer.earlywarn.warn.kit.FileKit;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployMetadata;
import kd.bos.metadata.earlywarn.warn.DesignEarlyWarnMeta;
import kd.bos.servicehelper.earlywarn.EarlyWarnMetaServicHelper;
import kd.bos.util.StringUtils;

public class EarlyWarnImportPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final String FORM_NUMBER = "warn_earlywarn_import";
    private static final String BTN_OK = "btn_ok";
    private static final String ATTACHMENT_PANEL = "attachmentpanelap";
    private static final String ATTACHMENT_CACHE = "ATTACHMENT_CACHE";
    private static final String BOS_EARLYWARN = "bos-earlywarn";
    private static final Log log = LogFactory.getLog(EarlyWarnImportPlugin.class);
    private static final int LIMIT_SIZE = 0x500000;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
        AttachmentPanel panel = (AttachmentPanel)this.getView().getControl(ATTACHMENT_PANEL);
        panel.addUploadListener((UploadListener)this);
    }

    public void click(EventObject e) {
        super.click(e);
        Control control = (Control)e.getSource();
        String key = control.getKey();
        if (!BTN_OK.equals(key)) {
            return;
        }
        JSONArray attachments = this.getAttachmentCache();
        if (attachments.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u9700\u8981\u5b89\u88c5\u7684\u90e8\u7f72\u5305\u3002", (String)"EarlyWarnImportPlugin_0", (String)BOS_EARLYWARN, (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        for (int i = 0; i < attachments.size(); ++i) {
            JSONObject attachment = attachments.getJSONObject(i);
            if (this.loadDataSingle(attachment)) continue;
            return;
        }
        this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"EarlyWarnImportPlugin_1", (String)BOS_EARLYWARN, (Object[])new Object[0]));
        this.getView().sendFormAction(this.getView().getParentView());
        this.getView().returnDataToParent((Object)"success");
        this.getView().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadDataSingle(JSONObject attachment) {
        String url = attachment.getString("url");
        log.info("early warn import url=" + url);
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        log.info("early warn import cache=" + cache.toString());
        ArrayList<EWImportBo> files = new ArrayList<EWImportBo>();
        try {
            InputStream in = cache.getInputStream(url);
            Object object = null;
            try (ZipInputStream zipIn2 = new ZipInputStream(in);){
                ZipEntry zipEntry = zipIn2.getNextEntry();
                while (null != zipEntry) {
                    String fileName = zipEntry.getName();
                    if (!zipEntry.isDirectory() && FileKit.endWithOne(fileName, ".warn", ".warnx")) {
                        int readByte;
                        int len = 0;
                        byte[] bufArr = new byte[0x500000];
                        while ((readByte = zipIn2.read()) != -1) {
                            bufArr[len] = (byte)readByte;
                            ++len;
                        }
                        String content = new String(bufArr, 0, len, StandardCharsets.UTF_8);
                        EWImportBo bo = new EWImportBo(zipEntry.getName(), content);
                        files.add(bo);
                        zipIn2.closeEntry();
                    }
                    zipEntry = zipIn2.getNextEntry();
                }
            }
            catch (Throwable zipIn2) {
                object = zipIn2;
                throw zipIn2;
            }
            finally {
                if (in != null) {
                    if (object != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable zipIn2) {
                            ((Throwable)object).addSuppressed(zipIn2);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("early warn import error", (Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u538b\u7f29\u5305\u6570\u636e\u4e0d\u6b63\u786e\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"EarlyWarnImportPlugin_7", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return false;
        }
        if (files.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u4e0d\u5230\u6709\u6548\u7684\u5bfc\u5165\u4fe1\u606f\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"EarlyWarnImportPlugin_3", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return false;
        }
        try (TXHandle tx = TX.required((String)"Warn_EarlyWarn_Import");){
            for (EWImportBo bo : files) {
                if (FileKit.endWithOne(bo.getName(), ".warn")) {
                    DcxmlSerializer serializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
                    serializer.setColloctionIgnorePKValue(true);
                    DeployMetadata newDeployMeta = (DeployMetadata)serializer.deserializeFromString(bo.getContent(), null);
                    DesignMeta meta = (DesignMeta)newDeployMeta.getDesignMetas().get(0);
                    if (StringUtils.isNotEmpty((String)meta.getParentId()) && !EarlyWarnMetaServicHelper.idExists(meta.getParentId())) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u672a\u80fd\u627e\u5230\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\uff1a%s\u7684\u7236\u8282\u70b9\uff0c\u8bf7\u5148\u5bfc\u5165\u7236\u8282\u70b9\u3002", (String)"EarlyWarnImportPlugin_8", (String)BOS_EARLYWARN, (Object[])new Object[0]), meta.getNumber()));
                        boolean readByte = false;
                        return readByte;
                    }
                    String id = MetadataDao.getIdByNumber((String)((DesignEarlyWarnMeta)meta).getDataSourceId(), (MetaCategory)MetaCategory.Entity);
                    if (id == null) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u9884\u8b66\u5bf9\u8c61\u6570\u636e\u6e90\u4e0d\u5b58\u5728\u3002", (String)"EarlyWarnImportPlugin_9", (String)BOS_EARLYWARN, (Object[])new Object[0]), meta.getNumber()));
                        boolean bl = false;
                        return bl;
                    }
                }
                MetadataDao.deployMetadata((String)bo.getContent());
            }
        }
        return true;
    }

    public void upload(UploadEvent e) {
        if (null == e) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u5668zk\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"EarlyWarnImportPlugin_6", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        Object[] args = e.getUrls();
        if (null == args) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u5668zk\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"EarlyWarnImportPlugin_6", (String)BOS_EARLYWARN, (Object[])new Object[0]));
            return;
        }
        JSONArray list = new JSONArray();
        for (Object arg : args) {
            Map argMap = (Map)arg;
            String name = (String)argMap.get("name");
            String url = (String)argMap.get("url");
            JSONObject obj = new JSONObject();
            obj.put("name", (Object)name);
            obj.put("url", (Object)url);
            list.add((Object)obj);
        }
        this.updateCache(list);
    }

    private JSONArray getAttachmentCache() {
        String json = this.getPageCache().get(ATTACHMENT_CACHE);
        return StringUtils.isEmpty((String)json) ? new JSONArray() : JSONArray.parseArray((String)json);
    }

    private void updateCache(JSONArray list) {
        JSONObject obj;
        int i;
        if (list.isEmpty()) {
            return;
        }
        JSONArray cacheList = this.getAttachmentCache();
        HashMap<String, JSONObject> cacheMap = new HashMap<String, JSONObject>(16);
        for (i = 0; i < cacheList.size(); ++i) {
            obj = cacheList.getJSONObject(i);
            cacheMap.put(obj.getString("url"), obj);
        }
        for (i = 0; i < list.size(); ++i) {
            obj = list.getJSONObject(i);
            cacheMap.put(obj.getString("url"), obj);
        }
        cacheList = new JSONArray();
        cacheList.addAll(cacheMap.values());
        this.getPageCache().put(ATTACHMENT_CACHE, cacheList.toJSONString());
    }

    public void remove(UploadEvent e) {
        Object[] urls = e.getUrls();
        if (null == urls || urls.length == 0) {
            return;
        }
        HashSet<String> deleteUrls = new HashSet<String>();
        for (Object url : urls) {
            Map urlMap = (Map)url;
            String deleteUrl = (String)urlMap.get("url");
            if (!StringUtil.isNotBlank((CharSequence)deleteUrl)) continue;
            deleteUrls.add(deleteUrl);
        }
        JSONArray cacheList = this.getAttachmentCache();
        Iterator iter = cacheList.iterator();
        while (iter.hasNext()) {
            JSONObject obj = (JSONObject)iter.next();
            if (!deleteUrls.contains(obj.getString("url"))) continue;
            iter.remove();
        }
        this.getPageCache().put(ATTACHMENT_CACHE, cacheList.toJSONString());
    }

    public static FormShowParameter show(CloseCallBack callback) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId(FORM_NUMBER);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(callback);
        return param;
    }
}

