/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.warn.kit;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.util.StringUtils;

public class FileKit {
    private static final String USER_HOME = System.getProperty("user.home");
    private static final Log LOG = LogFactory.getLog(FileKit.class);
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";

    public static String getAppPath(AppMetadata appMeta) {
        String bizAppNumber = appMeta.getNumber();
        return USER_HOME + File.separator + "KINGDEEDOWNLOAD" + File.separator + bizAppNumber;
    }

    public static String getTracePath(AppMetadata appMeta) {
        String traceId = RequestContext.get().getTraceId();
        return FileKit.getAppPath(appMeta) + File.separator + traceId;
    }

    public static String getBizPath(AppMetadata appMeta) {
        String bizAppNumber = appMeta.getNumber();
        String appVersion = appMeta.getAppElement().getVersion();
        return FileKit.getTracePath(appMeta) + File.separator + "datamodel" + File.separator + appVersion + File.separator + "main" + File.separator + bizAppNumber;
    }

    public static String getExportPath(AppMetadata appMeta, String category) {
        return FileKit.getBizPath(appMeta) + File.separator + category;
    }

    @Deprecated
    public static void mkdirs(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static void writeFile(File file, String content) {
        boolean flag;
        if (file.exists() && !(flag = file.delete())) {
            LOG.error(ResManager.loadKDString((String)"\u6587\u4ef6\u5220\u9664\u5931\u8d25", (String)"DeleteFileError", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);){
            boolean flag2 = file.createNewFile();
            if (!flag2) {
                LOG.error(ResManager.loadKDString((String)"\u6587\u4ef6\u521b\u5efa\u5931\u8d25", (String)"CreateFileError", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
            writer.write(content);
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    @Deprecated
    public static void zipFile(File src, String zipFromDir, File desc) {
        boolean flag;
        if (desc.exists() && !(flag = desc.delete())) {
            LOG.error(ResManager.loadKDString((String)"\u6587\u4ef6\u5220\u9664\u5931\u8d25", (String)"DeleteFileError", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
        try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(desc.getCanonicalFile())));){
            FileKit.zipFile(src, zipFromDir, out);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private static void zipFile(File file, String zipFromDir, ZipOutputStream out) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (null != files) {
                for (File f : files) {
                    FileKit.zipFile(f, zipFromDir, out);
                }
            }
        } else {
            int index;
            String path;
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException e) {
                throw new KDBizException(e.getMessage());
            }
            int n = index = StringUtils.isEmpty((String)zipFromDir) ? -1 : path.indexOf(zipFromDir);
            if (index != -1) {
                String zipPath = path.substring(index);
                try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file.getCanonicalPath()));){
                    int n2;
                    ZipEntry entry = new ZipEntry(zipPath);
                    entry.setMethod(8);
                    out.putNextEntry(entry);
                    byte[] buf = new byte[1024];
                    while ((n2 = in.read(buf)) != -1) {
                        out.write(buf, 0, n2);
                    }
                    out.closeEntry();
                }
                catch (IOException e) {
                    throw new KDBizException(e.getMessage());
                }
            }
        }
    }

    public static void deleteFile(File file) {
        if (null == file || !file.exists()) {
            return;
        }
        boolean flag = false;
        if (file.isDirectory()) {
            File[] list = file.listFiles();
            if (null != list) {
                for (File f : list) {
                    FileKit.deleteFile(f);
                }
            }
            if (!(flag = file.delete())) {
                LOG.error(ResManager.loadKDString((String)"\u6587\u4ef6\u5220\u9664\u5931\u8d25", (String)"DeleteFileError", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
            return;
        }
        flag = file.delete();
        if (!flag) {
            LOG.error(ResManager.loadKDString((String)"\u6587\u4ef6\u5220\u9664\u5931\u8d25", (String)"DeleteFileError", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
    }

    public static boolean endWithOne(String fileName, String ... suffixes) {
        if (null == fileName || null == suffixes || suffixes.length == 0) {
            return false;
        }
        for (String suffix : suffixes) {
            if (!fileName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }
}

