/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.warn.kit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.earlywarn.warn.EWPlugin;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.util.StringUtils;

public class IdePluginKit {
    public static final String ENABLED = "Enabled";

    public static List<?> getPluginsArray(Object val) {
        List plugins = new ArrayList();
        if (val != null && StringUtils.isNotEmpty((String)val.toString())) {
            plugins = SerializationUtils.fromJsonStringToList((String)val.toString(), Map.class);
        }
        return plugins;
    }

    public static String getJson(List<Map<String, Object>> plugins) {
        String pluginJson = plugins == null || plugins.isEmpty() ? "" : SerializationUtils.toJsonString(plugins);
        return pluginJson;
    }

    public static FormShowParameter buildShowParams(String formId, List<?> plugins, CloseCallBack callback) {
        FormShowParameter showParam = new FormShowParameter();
        showParam.setFormId("ide_plugins");
        showParam.getOpenStyle().setShowType(ShowType.Modal);
        showParam.setCustomParam("value", plugins);
        showParam.setCustomParam("formId", (Object)formId);
        showParam.setCustomParam("modelType", (Object)"ScriptInitial");
        showParam.setCloseCallBack(callback);
        return showParam;
    }

    public static List<EWPlugin> getEWPlugins(String json) {
        if (StringUtils.isEmpty((String)json)) {
            return new ArrayList<EWPlugin>();
        }
        List<Map> plugins = IdePluginKit.getPluginsArray(json);
        if (plugins == null) {
            return new ArrayList<EWPlugin>();
        }
        ArrayList<EWPlugin> results = new ArrayList<EWPlugin>(10);
        for (Map plugin : plugins) {
            EWPlugin ewPlugin = new EWPlugin();
            Integer type = (Integer)plugin.get("Type");
            type = type == null ? 0 : type;
            ewPlugin.setType(type);
            if (plugin.get(ENABLED) instanceof Boolean) {
                ewPlugin.setEnabled((Boolean)plugin.get(ENABLED));
            } else {
                ewPlugin.setEnabled(Boolean.parseBoolean((String)plugin.get(ENABLED)));
            }
            ewPlugin.setClassName((String)plugin.get("ClassName"));
            ewPlugin.setDescription((String)plugin.get("Description"));
            results.add(ewPlugin);
        }
        return results;
    }

    public static String getIdeJson(List<EWPlugin> plugins) {
        ArrayList results = new ArrayList(10);
        for (EWPlugin plugin : plugins) {
            HashMap<String, Object> p = new HashMap<String, Object>();
            p.put(ENABLED, plugin.isEnabled());
            p.put("Type", plugin.getType());
            p.put("ClassName", plugin.getClassName());
            p.put("Description", plugin.getDescription());
            results.add(p);
        }
        return SerializationUtils.toJsonString(results);
    }
}

