/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.earlywarn.warn.widget;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.designer.earlywarn.warn.kit.IdePluginKit;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.earlywarn.warn.EWPlugin;
import kd.bos.entity.earlywarn.warn.EarlyWarnDataSourceType;
import kd.bos.entity.earlywarn.warn.EarlyWarnElement;
import kd.bos.metadata.earlywarn.warn.EarlyWarnMetadata;
import kd.bos.metadata.earlywarn.warn.EarlyWarnTemplate;

public class EarlyWarnHolder {
    private static final String NUMBER = "number";
    private static final String BIZ_APP = "biz_app";
    private static final String NAME = "name";
    private static final String DATA_SOURCE = "data_source";
    private static final String CONDITION_FORM = "condition_form";
    public static final String DATA_SOURCE_PLUGIN = "plugin_get_data";
    public static final String WRITE_OUT_PLUGIN = "plugin_write_out";
    public static final String MESSAGE_COMPILER_PLUGIN = "plugin_message_compiler";
    public static final String MESSAGE_HANDLER_PLUGIN = "plugin_message_handler";
    public static final String CUSTOM_RECEIVER_PLUGIN = "plugin_custom_receiver";
    public static final List<String> PLUGINS = Arrays.asList("plugin_get_data", "plugin_write_out", "plugin_message_compiler", "plugin_message_handler", "plugin_custom_receiver");
    private IDataModel model;

    public EarlyWarnHolder(IDataModel model) {
        this.model = model;
    }

    public String getNumber() {
        return this.getStr(NUMBER);
    }

    public DynamicObject getBizApp() {
        return this.getDynamicObject(BIZ_APP);
    }

    public OrmLocaleValue getName() {
        return (OrmLocaleValue)this.model.getValue(NAME);
    }

    private DynamicObject getDynamicObject(String key) {
        return (DynamicObject)this.model.getValue(key);
    }

    private String getStr(String key) {
        return (String)this.model.getValue(key);
    }

    private String getFid(String key) {
        DynamicObject obj = this.getDynamicObject(key);
        if (null == obj) {
            return "";
        }
        String primaryKey = obj.getDynamicObjectType().getPrimaryKey().getName();
        return (String)obj.get(primaryKey);
    }

    public DynamicObject getDataSource() {
        return this.getDynamicObject(DATA_SOURCE);
    }

    public DynamicObject getCustomConditionForm() {
        return this.getDynamicObject(CONDITION_FORM);
    }

    public EarlyWarnMetadata buildMeta() {
        EarlyWarnMetadata metadata = EarlyWarnTemplate.createBlankEarlyWarn();
        metadata.setNumber(this.getNumber());
        metadata.setLeaf(true);
        OrmLocaleValue name = this.getName();
        HashMap<String, String> localNameMap = new HashMap<String, String>(16);
        for (String loId : name.keySet()) {
            localNameMap.put(loId, name.get((Object)loId));
        }
        metadata.setName(LocaleString.fromMap((Map)LocaleString.fromMap(localNameMap)));
        metadata.setBizappId(this.getFid(BIZ_APP));
        EarlyWarnElement element = metadata.getWarnElement();
        DynamicObject dataSource = this.getDynamicObject(DATA_SOURCE);
        String dataSourceModelType = dataSource == null ? "" : (String)dataSource.get("modeltype");
        String dataSourceType = EarlyWarnDataSourceType.getByModelType(dataSourceModelType).getName();
        String dataSourceId = dataSource == null ? "" : dataSource.getString("id");
        element.setDataSourceId(dataSourceId);
        element.setDataSourceType(dataSourceType);
        element.setConditionFormId(this.getFid(CONDITION_FORM));
        element.setDataSources(this.getPlugins(DATA_SOURCE_PLUGIN));
        element.setWriteOuts(this.getPlugins(WRITE_OUT_PLUGIN));
        element.setMessageCompilers(this.getPlugins(MESSAGE_COMPILER_PLUGIN));
        element.setMessageHandlers(this.getPlugins(MESSAGE_HANDLER_PLUGIN));
        element.setCustomReceivers(this.getPlugins(CUSTOM_RECEIVER_PLUGIN));
        return metadata;
    }

    private List<EWPlugin> getPlugins(String key) {
        String json = (String)this.model.getValue(key);
        return IdePluginKit.getEWPlugins(json);
    }
}

