/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.earlywarn.warn;

import java.util.Arrays;
import kd.bos.util.StringUtils;

public enum EarlyWarnDataSourceType {
    BILL("bill"),
    BASEDATA("basedata"),
    REPORT("report"),
    CUSTOM("custom");

    private String name;

    private EarlyWarnDataSourceType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static EarlyWarnDataSourceType getByName(String name) {
        return Arrays.stream(EarlyWarnDataSourceType.values()).filter(t -> t.getName().equals(name)).findFirst().orElse(null);
    }

    public static EarlyWarnDataSourceType getByModelType(String type) {
        if (StringUtils.isEmpty((String)type)) {
            return CUSTOM;
        }
        switch (type) {
            case "BillFormModel": {
                return BILL;
            }
            case "BaseFormModel": {
                return BASEDATA;
            }
            case "ReportFormModel": {
                return REPORT;
            }
        }
        return CUSTOM;
    }
}

