/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.earlywarn.warnschedule.messageconfig;

import java.io.Serializable;
import java.util.Arrays;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.MultiLangEnumBridge;
import kd.bos.message.api.MessageChannels;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;

@KSObject
public class WarnMessageSendType
implements Serializable {
    private static final String BOS_ENTITY_CORE = "bos-entity-core";
    private static final long serialVersionUID = 46762318703224537L;
    private Object id;
    private String name;
    private String value;

    public WarnMessageSendType() {
    }

    @Deprecated
    public WarnMessageSendType(SendType sendType) {
        this.name = sendType.name;
        this.value = sendType.value;
    }

    public WarnMessageSendType(Object id, String name, String value) {
        this.id = id;
        this.name = name;
        this.value = value;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @SimplePropertyAttribute(isPrimaryKey=true)
    @KSMethod
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @SimplePropertyAttribute
    @KSMethod
    public Object getId() {
        return this.id;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public String getRealSendType() {
        String channel = this.getValue();
        SendType type = this.getSendType();
        if (null == type) {
            return channel;
        }
        if (SendType.MessageCenter == type) {
            channel = MessageChannels.MC.getNumber();
        }
        if (SendType.Email == type) {
            channel = MessageChannels.EMAIL.getNumber();
        }
        if (SendType.Yzj == type) {
            channel = MessageChannels.YUNZHIJIA.getNumber();
        }
        if (SendType.Sms == type) {
            channel = MessageChannels.SMS.getNumber();
        }
        if (SendType.QyWeixin == type) {
            channel = MessageChannels.WEIXINQY.getNumber();
        }
        return channel;
    }

    public SendType getSendType() {
        return SendType.getBy(this.value);
    }

    public static enum SendType {
        MessageCenter(new MultiLangEnumBridge("\u6d88\u606f\u4e2d\u5fc3", "WarnMessageSendType_0", "bos-entity-core"), "message_center"),
        Yzj(new MultiLangEnumBridge("\u4e91\u4e4b\u5bb6", "WarnMessageSendType_1", "bos-entity-core"), "yzj"),
        Sms(new MultiLangEnumBridge("\u77ed\u4fe1", "WarnMessageSendType_2", "bos-entity-core"), "sms"),
        Email(new MultiLangEnumBridge("\u90ae\u4ef6", "WarnMessageSendType_3", "bos-entity-core"), "email"),
        QyWeixin(new MultiLangEnumBridge("\u4f01\u4e1a\u5fae\u4fe1", "WarnMessageSendType_4", "bos-entity-core"), "qyweixin");

        private String name;
        private String value;
        private MultiLangEnumBridge bridge = null;

        private SendType(String name, String value) {
            this.name = name;
            this.value = value;
        }

        private SendType(MultiLangEnumBridge bridge, String value) {
            this.bridge = bridge;
            this.value = value;
        }

        public String getName() {
            if (this.bridge != null) {
                return this.bridge.loadKDString();
            }
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public static SendType getBy(String value) {
            return Arrays.stream(SendType.values()).filter(t -> t.getValue().equals(value)).findFirst().orElse(null);
        }
    }
}

