/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.earlywarn.warnschedule;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.earlywarn.warnschedule.RunCycle;
import kd.bos.entity.earlywarn.warnschedule.WarnSchedule;
import kd.bos.isv.ISVService;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.DesignMetaL;
import kd.bos.metadata.earlywarn.warnschedule.DesignWarnScheduleMeta;
import kd.bos.metadata.earlywarn.warnschedule.DesignWarnScheduleMetaL;
import kd.bos.service.KDDateUtils;

public class WarnScheduleMetadata
extends AbstractMetadata {
    private WarnSchedule warnSchedule = new WarnSchedule();
    public static final String DEV_TYPE_ORIGIN = "0";
    public static final String DEV_TYPE_INHREIT = "1";
    public static final String DEV_TYPE_EXTEND = "2";

    @SimplePropertyAttribute(isPrimaryKey=true)
    public String getId() {
        return this.warnSchedule.getId();
    }

    public void setId(String id) {
        this.warnSchedule.setId(id);
    }

    @SimplePropertyAttribute
    public String getNumber() {
        return this.warnSchedule.getNumber();
    }

    public void setNumber(String number) {
        this.warnSchedule.setNumber(number);
    }

    public LocaleString getName() {
        return this.warnSchedule.getName();
    }

    public void setName(LocaleString name) {
        this.warnSchedule.setName(name);
    }

    @ComplexPropertyAttribute
    public WarnSchedule getWarnSchedule() {
        return this.warnSchedule;
    }

    public void setWarnSchedule(WarnSchedule warnSchedule) {
        this.warnSchedule = warnSchedule;
    }

    public IDataEntityType getDesingerMetaType() {
        return OrmUtils.getDataEntityType(DesignWarnScheduleMeta.class);
    }

    public IDataEntityType getDesingerMetaLType() {
        return OrmUtils.getDataEntityType(DesignWarnScheduleMetaL.class);
    }

    protected void setDesignMeta(DesignMeta designMeta) {
        super.setDesignMeta(designMeta);
        Long currentUserId = Long.valueOf(RequestContext.get().getUserId());
        Date now = KDDateUtils.now();
        DesignWarnScheduleMeta meta = (DesignWarnScheduleMeta)designMeta;
        meta.setNumber(this.getNumber());
        meta.setModelType("WarnScheduleModel");
        meta.setIsv(ISVService.getISVInfo().getId());
        meta.setModifierId(currentUserId);
        meta.setModifyDate(now);
        DesignWarnScheduleMeta dbMeta = null;
        try {
            IDataEntityType metaType = OrmUtils.getDataEntityType(DesignWarnScheduleMeta.class);
            dbMeta = (DesignWarnScheduleMeta)((Object)BusinessDataReader.read((Object)designMeta.getId(), (IDataEntityType)metaType, (Boolean)false));
            meta.setCreatorId(dbMeta.getCreatorId());
            meta.setCreateDate(dbMeta.getCreateDate());
            meta.setLastSyncTime(dbMeta.getLastSyncTime());
        }
        catch (Exception e) {
            meta.setCreatorId(currentUserId);
            meta.setCreateDate(now);
        }
        WarnSchedule schedule = this.getWarnSchedule();
        meta.setEarlyWarnId(schedule.getEarlyWarnId());
        meta.setBizappId(schedule.getBizAppId());
        meta.setEnable(schedule.isEnable());
        meta.setByEntry(schedule.isByEntry());
        meta.setDisableIntegrity(schedule.isDisableIntegrity());
        RunCycle runCycle = schedule.getRunCycle();
        Date startDate = KDDateUtils.parseDate((String)runCycle.getStartDate());
        meta.setStartDate(startDate);
        Date endDate = StringUtils.isBlank((CharSequence)runCycle.getEndDate()) ? null : KDDateUtils.parseDate((String)runCycle.getEndDate());
        meta.setEndDate(endDate);
        meta.setMonitorPeriodRange(runCycle.getMonitorPeriodRange());
        meta.setMonitorFrequency(runCycle.getMonitorFrequency());
        meta.setJobId(schedule.getJobId());
        meta.setPlanId(schedule.getPlanId());
        if (null != schedule.getLastSyncTime()) {
            meta.setLastSyncTime(schedule.getLastSyncTime());
        }
    }

    protected void setDesignMetaL(String localeId, DesignMetaL designMetaL) {
        super.setDesignMetaL(localeId, designMetaL);
        designMetaL.setName((String)this.getName().getItem(localeId));
    }
}

