/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.earlywarn.engine.action;

import java.util.Collections;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.entity.earlywarn.warn.EarlyWarnDataSourceType;
import kd.bos.entity.earlywarn.warn.EarlyWarnElement;
import kd.bos.service.earlywarn.engine.action.EngineLog;
import kd.bos.service.earlywarn.engine.action.IEarlyWarnAction;

public class DataSourceAction
implements IEarlyWarnAction {
    private static final String BOS_EARLYWARN = "bos-earlywarn";

    private String getActionTag() {
        return EngineLog.toMultiLangJson("DataSourceAction_0", BOS_EARLYWARN);
    }

    @Override
    public void execute(EarlyWarnContext context, EngineLog log) {
        String msg;
        log.logBatch(this.getActionTag(), EngineLog.toMultiLangJson("DataSourceAction_1", BOS_EARLYWARN));
        EarlyWarnElement earlyWarn = context.getEarlyWarn();
        String dataSourceId = earlyWarn.getDataSourceId();
        EarlyWarnDataSourceType dataSourceType = earlyWarn.getDataSourceTypeObj();
        switch (dataSourceType) {
            case BILL: {
                msg = EngineLog.toMultiLangWithArgsJson("DataSourceAction_4", BOS_EARLYWARN, Collections.singletonList(dataSourceId));
                break;
            }
            case BASEDATA: {
                msg = EngineLog.toMultiLangWithArgsJson("DataSourceAction_5", BOS_EARLYWARN, Collections.singletonList(dataSourceId));
                break;
            }
            case REPORT: {
                msg = EngineLog.toMultiLangWithArgsJson("DataSourceAction_6", BOS_EARLYWARN, Collections.singletonList(dataSourceId));
                break;
            }
            default: {
                msg = EngineLog.toMultiLangJson("DataSourceAction_2", BOS_EARLYWARN);
            }
        }
        log.logBatch(this.getActionTag(), msg);
    }
}

