/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.earlywarn.engine.action;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.entity.earlywarn.warn.EarlyWarnElement;
import kd.bos.entity.earlywarn.warn.plugin.IEarlyWarnDataSource;
import kd.bos.entity.earlywarn.warnschedule.WarnCondition;
import kd.bos.entity.earlywarn.warnschedule.WarnSchedule;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.earlywarn.engine.action.EngineLog;
import kd.bos.service.earlywarn.engine.action.IEarlyWarnAction;
import kd.bos.service.earlywarn.impl.DefaultEarlyWarnBillDataSource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateUtils;

public class GetDataAction
implements IEarlyWarnAction {
    private static final String BOS_EARLYWARN = "bos-earlywarn";
    private static final Log logger = LogFactory.getLog(GetDataAction.class);
    private static final SimpleDateFormat firstSecondOfDayFormat = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
    private static final SimpleDateFormat lastSecondOfDayFormat = new SimpleDateFormat("yyyy-MM-dd 23:59:59");

    private String getActionTag() {
        return EngineLog.toMultiLangJson("GetDataAction_0", BOS_EARLYWARN);
    }

    @Override
    public void execute(EarlyWarnContext context, EngineLog log) {
        log.logBatch(this.getActionTag(), EngineLog.toMultiLangJson("GetDataAction_1", BOS_EARLYWARN));
        IEarlyWarnDataSource dataSourcePlugIn = this.getDataSource(context);
        if (null == dataSourcePlugIn) {
            log.logBatch(this.getActionTag(), EngineLog.toMultiLangJson("GetDataAction_2", BOS_EARLYWARN));
            return;
        }
        EarlyWarnElement earlyWarn = context.getEarlyWarn();
        WarnSchedule warnSchedule = context.getWarnSchedule();
        WarnCondition warnCondition = warnSchedule.getWarnCondition();
        String dataSource = earlyWarn.getDataSourceId();
        log.logBatch(this.getActionTag(), EngineLog.toMultiLangJson("GetDataAction_3", BOS_EARLYWARN));
        this.replaceCustomFilterRow(warnCondition.getFilterCondition());
        List<QFilter> qFilters = dataSourcePlugIn.buildFilter(dataSource, warnCondition.getFilterCondition(), context);
        log.logBatch(this.getActionTag(), EngineLog.toMultiLangJson("GetDataAction_4", BOS_EARLYWARN));
        DynamicObjectCollection list = dataSourcePlugIn.getData(dataSource, qFilters, context);
        context.setWarnDataList(list);
        int size = list == null ? 0 : list.size();
        log.logBatch(this.getActionTag(), EngineLog.toMultiLangWithArgsJson("GetDataAction_5", BOS_EARLYWARN, Collections.singletonList(String.valueOf(size))));
    }

    private IEarlyWarnDataSource getDataSource(EarlyWarnContext context) {
        EarlyWarnElement earlyWarn = context.getEarlyWarn();
        IEarlyWarnDataSource dataSource = earlyWarn.getDataSource();
        if (null != dataSource) {
            return dataSource;
        }
        switch (earlyWarn.getDataSourceTypeObj()) {
            case BASEDATA: 
            case BILL: {
                return new DefaultEarlyWarnBillDataSource();
            }
        }
        return null;
    }

    private void replaceCustomFilterRow(FilterCondition filterCondition) {
        if (filterCondition == null) {
            return;
        }
        List filterRow = filterCondition.getFilterRow();
        Date today = new Date();
        for (SimpleFilterRow simpleFilterRow : filterRow) {
            String endDayFilterValue;
            String startDayFilterValue;
            int afterNDaysValue;
            Object valueObj;
            FilterValue filterValue;
            if ("earlywarn_afterNDays".equals(simpleFilterRow.getCompareType())) {
                filterValue = this.getFilterValueForDateType(simpleFilterRow);
                if (filterValue == null || !this.checkValueIsNumber(valueObj = filterValue.getValue())) continue;
                int ndaysAfterValue = Integer.parseInt((String)valueObj);
                boolean moreThanZero = ndaysAfterValue >= 0;
                Date nDaysAfterDate = DateUtils.addDays((Date)today, (int)ndaysAfterValue);
                CompareTypeEnum compareTypeEnum = moreThanZero ? CompareTypeEnum.GREATER : CompareTypeEnum.LESS;
                String dayFilterValue = moreThanZero ? lastSecondOfDayFormat.format(nDaysAfterDate) : firstSecondOfDayFormat.format(nDaysAfterDate);
                simpleFilterRow.setCompareType(compareTypeEnum.getId());
                filterValue.setValue((Object)dayFilterValue);
                continue;
            }
            if ("earlywarn_nDaysAfter".equals(simpleFilterRow.getCompareType())) {
                filterValue = this.getFilterValueForDateType(simpleFilterRow);
                if (filterValue == null) continue;
                simpleFilterRow.setCompareType(CompareTypeEnum.BETWEEN.getId());
                valueObj = filterValue.getValue();
                if (!this.checkValueIsNumber(valueObj)) continue;
                afterNDaysValue = Integer.parseInt((String)valueObj);
                boolean moreThanZero = afterNDaysValue >= 0;
                startDayFilterValue = moreThanZero ? firstSecondOfDayFormat.format(DateUtils.addDays((Date)today, (int)1)) : firstSecondOfDayFormat.format(DateUtils.addDays((Date)today, (int)afterNDaysValue));
                filterValue.setValue((Object)startDayFilterValue);
                endDayFilterValue = moreThanZero ? lastSecondOfDayFormat.format(DateUtils.addDays((Date)today, (int)afterNDaysValue)) : lastSecondOfDayFormat.format(DateUtils.addDays((Date)today, (int)-1));
                this.addEndDateFilterValue(simpleFilterRow, endDayFilterValue);
                continue;
            }
            if (!"earlywarn_atNDaysAfter".equals(simpleFilterRow.getCompareType()) || (filterValue = this.getFilterValueForDateType(simpleFilterRow)) == null) continue;
            simpleFilterRow.setCompareType(CompareTypeEnum.BETWEEN.getId());
            valueObj = filterValue.getValue();
            if (!this.checkValueIsNumber(valueObj)) continue;
            afterNDaysValue = Integer.parseInt((String)valueObj);
            Date startDate = DateUtils.addDays((Date)today, (int)afterNDaysValue);
            startDayFilterValue = firstSecondOfDayFormat.format(startDate);
            filterValue.setValue((Object)startDayFilterValue);
            endDayFilterValue = lastSecondOfDayFormat.format(startDate);
            this.addEndDateFilterValue(simpleFilterRow, endDayFilterValue);
        }
    }

    private void addEndDateFilterValue(SimpleFilterRow simpleFilterRow, String endDayFilterValue) {
        FilterValue fv = new FilterValue();
        fv.setId(Uuid16.create().toString());
        fv.setValue((Object)endDayFilterValue);
        simpleFilterRow.getValue().add(fv);
    }

    private boolean checkValueIsNumber(Object valueObj) {
        return valueObj instanceof String && NumberUtils.isParsable((String)((String)valueObj));
    }

    private FilterValue getFilterValueForDateType(SimpleFilterRow simpleFilterRow) {
        List filterValueList = simpleFilterRow.getValue();
        if (CollectionUtils.isEmpty((Collection)filterValueList) || filterValueList.size() != 1) {
            logger.warn("filterValueList is null or size != 1\uff0ccontinue...");
            return null;
        }
        return (FilterValue)filterValueList.get(0);
    }
}

