/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.earlywarn.engine.action;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.earlywarn.utils.MulilangConfig;
import kd.bos.entity.EntityType;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.entity.earlywarn.kit.StringTemplateParser;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.earlywarn.warn.EarlyWarnElement;
import kd.bos.entity.earlywarn.warn.EarlyWarnMessageInfo;
import kd.bos.entity.earlywarn.warn.YzjPublicNumberInfo;
import kd.bos.entity.earlywarn.warn.events.CustomReceiversArgs;
import kd.bos.entity.earlywarn.warn.events.MergeMessageArgs;
import kd.bos.entity.earlywarn.warn.impl.KDEarlyWarnCustomReceiver;
import kd.bos.entity.earlywarn.warn.plugin.IEarlyWarnCustomReceiver;
import kd.bos.entity.earlywarn.warn.plugin.IEarlyWarnMessageCompiler;
import kd.bos.entity.earlywarn.warn.plugin.IEarlyWarnMessageHandler;
import kd.bos.entity.earlywarn.warnschedule.MessageContent;
import kd.bos.entity.earlywarn.warnschedule.MessageContentFields;
import kd.bos.entity.earlywarn.warnschedule.MessageTableColumn;
import kd.bos.entity.earlywarn.warnschedule.WarnMessageConfig;
import kd.bos.entity.earlywarn.warnschedule.WarnSchedule;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.RelationReceiverTypeEnum;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageReceiver;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageReceiverType;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageReceiverTypeEnum;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageSendType;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.IUserService;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.service.ServiceFactory;
import kd.bos.service.earlywarn.engine.MessageReceiver;
import kd.bos.service.earlywarn.engine.OrgReceiver;
import kd.bos.service.earlywarn.engine.action.EngineLog;
import kd.bos.service.earlywarn.engine.action.IEarlyWarnAction;
import kd.bos.service.earlywarn.impl.DefaultBillMessageCompiler;
import kd.bos.service.earlywarn.impl.DefaultWarnMessageHandler;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageAttachment;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class MessageAction
implements IEarlyWarnAction {
    public static final Log log = LogFactory.getLog(MessageAction.class);
    private static final String BOS_EARLYWARN = "bos-earlywarn";
    private static final char COMMA = ',';
    private boolean isExistMulilangConfig = false;

    private String getActionTag() {
        return EngineLog.toMultiLangJson("MessageAction_7", BOS_EARLYWARN);
    }

    @Override
    public void execute(EarlyWarnContext context, EngineLog log) {
        IEarlyWarnMessageCompiler compiler = this.getMessageCompiler(context);
        if (null == compiler) {
            return;
        }
        DynamicObjectCollection list = context.getWarnDataList();
        if (null == list || list.isEmpty()) {
            return;
        }
        WarnSchedule schedule = context.getWarnSchedule();
        boolean needMergeMessage = schedule.getMessageConfig().isMergeSendMessage();
        boolean isQuickProcessing = schedule.getMessageConfig().isQuickProcessing();
        IEarlyWarnMessageHandler handler = this.getMessageHandler(context, isQuickProcessing);
        if (needMergeMessage && list.size() > 1) {
            this.doSendMergeMessage(compiler, handler, list, context, log);
            return;
        }
        this.doSendSingleMessage(compiler, handler, list, context, log);
    }

    private IEarlyWarnMessageCompiler getMessageCompiler(EarlyWarnContext context) {
        EarlyWarnElement earlyWarn = context.getEarlyWarn();
        IEarlyWarnMessageCompiler compiler = earlyWarn.getMessageCompiler();
        if (null != compiler) {
            return compiler;
        }
        switch (earlyWarn.getDataSourceTypeObj()) {
            case BASEDATA: 
            case BILL: {
                return new DefaultBillMessageCompiler();
            }
        }
        return null;
    }

    private IEarlyWarnMessageHandler getMessageHandler(EarlyWarnContext context, boolean isQuickProcessing) {
        EarlyWarnElement earlyWarn = context.getEarlyWarn();
        IEarlyWarnMessageHandler handler = earlyWarn.getMessageHandler();
        if (null != handler) {
            return handler;
        }
        if (!isQuickProcessing) {
            return null;
        }
        switch (earlyWarn.getDataSourceTypeObj()) {
            case BASEDATA: 
            case BILL: {
                return new DefaultWarnMessageHandler(context);
            }
        }
        return null;
    }

    private void doSendMergeMessage(IEarlyWarnMessageCompiler compiler, IEarlyWarnMessageHandler handler, DynamicObjectCollection list, EarlyWarnContext context, EngineLog log) {
        log.logBatch(this.getActionTag(), EngineLog.toMultiLangJson("MessageAction_8", BOS_EARLYWARN));
        WarnSchedule schedule = context.getWarnSchedule();
        WarnMessageConfig messageConfig = schedule.getMessageConfig();
        String mergeTemplate = messageConfig.getMergeContent();
        String titleTemplate = messageConfig.getTitle();
        List<String> titleFields = this.getFieldsByTemplate(titleTemplate);
        String title = titleTemplate;
        MessageContent messageContent = messageConfig.getMergeMessageContent();
        String channels = this.getNotifyTypes(messageConfig);
        log.logBatch(this.getActionTag(), EngineLog.toMultiLangWithArgsJson("MessageAction_2", BOS_EARLYWARN, Collections.singletonList(channels)));
        MessageAttachment attachment = null;
        Map<Object, Object> groupMessages = new HashMap();
        Map<DynamicObjectCollection, List<MulilangConfig>> mulilangGroupConfigMap = null;
        MessageReceiver messageReceiver = new MessageReceiver();
        if (compiler != null) {
            List<MulilangConfig> mulilangConfigTemplates = messageConfig.getMulilangConfigs();
            if (compiler.isExistMulilangConfig(context, mulilangConfigTemplates)) {
                this.isExistMulilangConfig = true;
                mulilangGroupConfigMap = this.buildGroupMessagesByMulilang(compiler, list, context, mulilangConfigTemplates, messageReceiver);
            } else {
                groupMessages = this.getGroupMessages(compiler, list, context, mergeTemplate, messageContent, messageReceiver);
            }
            attachment = compiler.getMergeEmailMessageAttachment(context);
            String newMergeTitle = compiler.getMergeTitle(titleTemplate, titleFields, null, context);
            title = StringUtils.isNotBlank((CharSequence)newMergeTitle) ? newMergeTitle : titleTemplate;
        }
        Map<Object, Object> handleResult = new HashMap(3);
        List<YzjPublicNumberInfo> yzjPublicNumberList = MessageAction.getYZJPublicNumberList();
        if (null != handler) {
            EarlyWarnMessageInfo messageInfo = handler.mergeMessageBuilder(context);
            handleResult = this.getMassageHandleResult(messageInfo, handler, yzjPublicNumberList);
        }
        messageReceiver = this.getAllReceiverIds(list, context, messageReceiver);
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        if (MapUtils.isNotEmpty(mulilangGroupConfigMap)) {
            for (Map.Entry<DynamicObjectCollection, List<MulilangConfig>> entry : mulilangGroupConfigMap.entrySet()) {
                messageInfos.addAll(this.getMessageInfos(channels, title, "", entry.getValue(), (String)handleResult.get("contentUrl"), (String)handleResult.get("mobContentUrl"), messageReceiver.getGroupFieldReceiversByValue(entry.getKey()), (String)handleResult.get("publicNumber"), attachment, messageReceiver.getCustomReceivers(entry.getKey()), context, true));
            }
        } else if (MapUtils.isNotEmpty(groupMessages)) {
            for (Map.Entry<Object, Object> entry : groupMessages.entrySet()) {
                messageInfos.addAll(this.getMessageInfos(channels, title, (String)entry.getValue(), null, (String)handleResult.get("contentUrl"), (String)handleResult.get("mobContentUrl"), messageReceiver.getGroupFieldReceiversByValue((DynamicObjectCollection)entry.getKey()), (String)handleResult.get("publicNumber"), attachment, messageReceiver.getCustomReceivers((DynamicObjectCollection)entry.getKey()), context, true));
            }
        }
        MessageCenterServiceHelper.batchSendMessages(messageInfos);
        log.logBatch(this.getActionTag(), EngineLog.toMultiLangJson("MessageAction_3", BOS_EARLYWARN));
    }

    private Map<DynamicObjectCollection, List<MulilangConfig>> buildGroupMessagesByMulilang(IEarlyWarnMessageCompiler compiler, DynamicObjectCollection list, EarlyWarnContext context, List<MulilangConfig> mulilangConfigs, MessageReceiver messageReceiver) {
        HashMap<DynamicObjectCollection, List<MulilangConfig>> mulilangGroupMessages = new HashMap<DynamicObjectCollection, List<MulilangConfig>>(16);
        this.groupMessagesByFieldValue(compiler, list, context, null, messageReceiver, mulilangConfigs, mulilangGroupMessages);
        if (MapUtils.isEmpty(mulilangGroupMessages)) {
            ArrayList<String> mergeFields = new ArrayList<String>(16);
            ArrayList<String> titleFields = new ArrayList<String>(16);
            for (MulilangConfig mulilangConfig : mulilangConfigs) {
                String mergeTemplate = mulilangConfig.getMergeContent();
                mergeTemplate = mergeTemplate == null ? "" : mergeTemplate;
                mergeFields.addAll(this.getFieldsByTemplate(mergeTemplate));
                titleFields.addAll(this.getFieldsByTemplate(mulilangConfig.getTitle()));
            }
            List<MulilangConfig> newMulilangConfigs = compiler.buildMergeMulilangConfig(mulilangConfigs, mergeFields, titleFields, context);
            if (CollectionUtils.isNotEmpty(newMulilangConfigs)) {
                mulilangGroupMessages.put(list, newMulilangConfigs);
            }
        }
        return mulilangGroupMessages;
    }

    private Map<DynamicObjectCollection, String> getGroupMessages(IEarlyWarnMessageCompiler compiler, DynamicObjectCollection list, EarlyWarnContext context, String mergeTemplate, MessageContent messageContent, MessageReceiver messageReceiver) {
        HashMap<DynamicObjectCollection, String> groupMessages = new HashMap<DynamicObjectCollection, String>();
        if (messageContent != null) {
            groupMessages = this.groupMessagesByFieldValue(compiler, list, context, messageContent, messageReceiver, null, null);
        } else {
            mergeTemplate = mergeTemplate == null ? "" : mergeTemplate;
            List<String> mergeFields = this.getFieldsByTemplate(mergeTemplate);
            groupMessages.put(list, compiler.getMergeMessage(mergeTemplate, mergeFields, context));
        }
        return groupMessages;
    }

    private Map<DynamicObjectCollection, String> groupMessagesByFieldValue(IEarlyWarnMessageCompiler compiler, DynamicObjectCollection list, EarlyWarnContext context, MessageContent messageContent, MessageReceiver messageReceiver, List<MulilangConfig> mulilangConfigs, Map<DynamicObjectCollection, List<MulilangConfig>> mulilangGroupMessages) {
        HashMap<DynamicObjectCollection, String> contents = new HashMap<DynamicObjectCollection, String>(16);
        WarnMessageConfig messageConfig = context.getWarnSchedule().getMessageConfig();
        String groupField = messageConfig.getGroupField();
        MessageContentFields contentFields = new MessageContentFields();
        HashMap<MulilangConfig, MessageContentFields> muilangContentFieldMap = new HashMap<MulilangConfig, MessageContentFields>(16);
        ArrayList<String> titleFields = new ArrayList<String>(16);
        if (this.isExistMulilangConfig) {
            for (MulilangConfig mulilangConfig : mulilangConfigs) {
                titleFields.addAll(this.getFieldsByTemplate(mulilangConfig.getTitle()));
                MessageContentFields mulilangContentFields = this.getMessageContentFields(mulilangConfig.getMessageContent());
                if (mulilangContentFields == null) continue;
                muilangContentFieldMap.put(mulilangConfig, mulilangContentFields);
            }
        } else {
            contentFields = this.getMessageContentFields(messageContent);
        }
        if (StringUtils.isBlank((CharSequence)groupField)) {
            List<MulilangConfig> newMulilangConfigList;
            if (this.isExistMulilangConfig && muilangContentFieldMap.size() > 0 && CollectionUtils.isNotEmpty(newMulilangConfigList = compiler.buildGroupMergeMulilangConfig(muilangContentFieldMap, list, titleFields, context))) {
                mulilangGroupMessages.put(list, newMulilangConfigList);
            }
            if (!this.isExistMulilangConfig) {
                contents.put(list, compiler.getGroupMergeMessage(new MergeMessageArgs(messageContent, contentFields, list, context)));
            }
            return contents;
        }
        String[] splitFields = StringUtils.split((String)groupField, (String)".");
        DynamicObjectType dynamicObjectType = ((DynamicObject)list.get(0)).getDynamicObjectType();
        IDataEntityProperty property = (IDataEntityProperty)dynamicObjectType.getProperties().get((Object)splitFields[0]);
        if (null == property) {
            throw new KDException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5:%s\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u6d88\u606f\u5206\u7ec4\u4f9d\u636e\u5b57\u6bb5\u3002", (String)"MessageAction_100", (String)BOS_EARLYWARN, (Object[])new Object[0]), groupField));
        }
        HashMap<Object, DynamicObjectCollection> groupData = new HashMap<Object, DynamicObjectCollection>();
        for (DynamicObject dynamicObject : list) {
            Object value = dynamicObject.get(groupField);
            groupData.computeIfAbsent(value, v -> new DynamicObjectCollection()).add((Object)dynamicObject);
        }
        IEarlyWarnCustomReceiver customReceiver = this.getCustomReceiverPlugin(context);
        for (DynamicObjectCollection currentData : groupData.values()) {
            Set<Long> groupMessageReceivers;
            List<MulilangConfig> newMulilangConfigList;
            if (this.isExistMulilangConfig && muilangContentFieldMap.size() > 0 && CollectionUtils.isNotEmpty(newMulilangConfigList = compiler.buildGroupMergeMulilangConfig(muilangContentFieldMap, currentData, titleFields, context))) {
                mulilangGroupMessages.put(currentData, newMulilangConfigList);
            }
            if (!this.isExistMulilangConfig) {
                MergeMessageArgs mergeMessageArgs = new MergeMessageArgs(messageContent, contentFields, currentData, context);
                contents.put(currentData, compiler.getGroupMergeMessage(mergeMessageArgs));
            }
            if (customReceiver == null || !CollectionUtils.isNotEmpty(groupMessageReceivers = customReceiver.getGroupMessageReceivers(new CustomReceiversArgs(currentData, groupField)))) continue;
            messageReceiver.addGroupFieldReceivers(currentData, groupMessageReceivers);
        }
        return contents;
    }

    private MessageContentFields getMessageContentFields(MessageContent messageContent) {
        if (messageContent == null) {
            return null;
        }
        MessageContentFields contentFields = new MessageContentFields();
        StringTemplateParser parser = new StringTemplateParser();
        String messageHead = messageContent.getMessageHead();
        if (StringUtils.isNotBlank((CharSequence)messageHead)) {
            parser.parse(messageHead, field -> {
                contentFields.addMessageHeadField((String)field);
                return "";
            });
        }
        contentFields.setMessageTableFields(this.getMessageTableFields(messageContent.getTableColumns()));
        String messageEnd = messageContent.getMessageEnd();
        if (StringUtils.isNotBlank((CharSequence)messageEnd)) {
            parser.parse(messageEnd, field -> {
                contentFields.addMessageEndField((String)field);
                return "";
            });
        }
        return contentFields;
    }

    private List<String> getMessageTableFields(List<MessageTableColumn> tableColumns) {
        LinkedList<String> fields = new LinkedList<String>();
        if (CollectionUtils.isEmpty(tableColumns)) {
            return fields;
        }
        for (MessageTableColumn tableColumn : tableColumns) {
            String field = tableColumn.getField();
            if (StringUtils.isBlank((CharSequence)field)) continue;
            fields.add(field);
        }
        return fields;
    }

    private MessageReceiver getAllReceiverIds(DynamicObjectCollection list, EarlyWarnContext context, MessageReceiver messageReceiver) {
        MessageReceiver commonReceiverIds = this.getCommonReceiverIds(list, context, messageReceiver);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return commonReceiverIds;
        }
        list.forEach(data -> commonReceiverIds.addReceiverToGroup((DynamicObject)data, (Collection<Long>)this.getCustomReceiverIds((DynamicObject)data, context)));
        return commonReceiverIds;
    }

    private MessageReceiver getCommonReceiverIds(DynamicObjectCollection list, EarlyWarnContext context, MessageReceiver messageReceiver) {
        WarnMessageConfig messageConfig = context.getWarnSchedule().getMessageConfig();
        if (messageReceiver == null) {
            messageReceiver = new MessageReceiver();
        }
        List<WarnMessageReceiverType> receiverTypes = messageConfig.getReceiverTypes();
        HashSet<String> roleIds = new HashSet<String>();
        HashSet<OrgReceiver> orgReceivers = new HashSet<OrgReceiver>();
        HashMap<DynamicObject, Set<OrgReceiver>> orgReceiverGroup = new HashMap<DynamicObject, Set<OrgReceiver>>();
        for (WarnMessageReceiverType type : receiverTypes) {
            for (WarnMessageReceiver receiver : type.getReceivers()) {
                WarnMessageReceiverTypeEnum receiverType = receiver.getReceiverTypeObj();
                switch (receiverType) {
                    case User: {
                        String userId = receiver.getId();
                        messageReceiver.addCommonReceiver(Long.valueOf(userId));
                        break;
                    }
                    case Role: {
                        roleIds.add(receiver.getId());
                        break;
                    }
                    case Org: {
                        orgReceivers.add(new OrgReceiver(Long.valueOf(receiver.getId()), receiver.getRelationshipType(), receiver.getScope()));
                        break;
                    }
                    case RelationPerson: {
                        this.collectRelationPerson(receiver, list, messageReceiver, orgReceiverGroup);
                        break;
                    }
                    case ExternalPerson: {
                        this.collectExternalPerson(receiver, messageReceiver);
                        break;
                    }
                }
            }
        }
        this.collectRolePerson(roleIds, messageReceiver);
        this.collectOrgPerson(orgReceivers, messageReceiver, orgReceiverGroup);
        return messageReceiver;
    }

    private void collectExternalPerson(WarnMessageReceiver receiver, MessageReceiver messageReceiver) {
        if (StringUtils.equals((CharSequence)receiver.getRelation(), (CharSequence)"phone")) {
            messageReceiver.addCommonPhones(receiver.getId());
            return;
        }
        if (StringUtils.equals((CharSequence)receiver.getRelation(), (CharSequence)"email")) {
            messageReceiver.addCommonEmails(receiver.getId());
        }
    }

    private void collectOrgPerson(Set<OrgReceiver> orgReceivers, MessageReceiver messageReceiver, Map<DynamicObject, Set<OrgReceiver>> orgReceiverGroup) {
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        if (CollectionUtils.isNotEmpty(orgReceivers)) {
            ArrayList<Map<String, Object>> commonQueryParam = new ArrayList<Map<String, Object>>(orgReceivers.size());
            for (OrgReceiver orgReceiver : orgReceivers) {
                commonQueryParam.add(orgReceiver.convertToMap());
            }
            log.info("\u83b7\u53d6\u90e8\u95e8\u4e2d\u7684\u4eba\u5458\uff0c\u53c2\u6570\u4e3a\uff1a" + ((Object)commonQueryParam).toString());
            Map commonPerson = userService.getPersonByCondition(commonQueryParam);
            log.info("\u83b7\u53d6\u90e8\u95e8\u4e2d\u7684\u4eba\u5458\uff0c\u4eba\u5458\u4fe1\u606f\u4e3a\uff1a" + commonPerson.toString());
            commonPerson.values().forEach(p -> {
                if (p != null) {
                    messageReceiver.addCommonReceivers((Collection<Long>)p);
                }
            });
        }
        if (MapUtils.isNotEmpty(orgReceiverGroup)) {
            ArrayList groupQueryParam = new ArrayList();
            for (Set<OrgReceiver> receivers : orgReceiverGroup.values()) {
                if (CollectionUtils.isEmpty(receivers)) continue;
                receivers.forEach(r -> groupQueryParam.add(r.convertToMap()));
            }
            log.info("\u83b7\u53d6\u53d8\u91cf\u4e2d\u90e8\u95e8\u7684\u4eba\u5458\uff0c\u53c2\u6570\u4e3a\uff1a" + ((Object)groupQueryParam).toString());
            Map groupPerson = userService.getPersonByCondition(groupQueryParam);
            log.info("\u83b7\u53d6\u53d8\u91cf\u4e2d\u90e8\u95e8\u7684\u4eba\u5458\uff0c\u4eba\u5458\u4fe1\u606f\u4e3a\uff1a" + groupPerson.toString());
            for (Map.Entry<DynamicObject, Set<OrgReceiver>> entry : orgReceiverGroup.entrySet()) {
                DynamicObject key = entry.getKey();
                Set<OrgReceiver> orgReceiverSet = entry.getValue();
                if (CollectionUtils.isEmpty(orgReceiverSet)) continue;
                for (OrgReceiver orgReceiver : orgReceiverSet) {
                    messageReceiver.addReceiverToGroup(key, (Collection)groupPerson.get(String.valueOf(orgReceiver.getOrgId())));
                }
            }
        }
    }

    private void collectRolePerson(Set<String> roleIds, MessageReceiver messageReceiver) {
        if (CollectionUtils.isEmpty(roleIds)) {
            return;
        }
        Set enableUserIds = PermRoleHelper.getEnableUserIds(roleIds);
        messageReceiver.addCommonReceivers(enableUserIds);
    }

    private void collectRelationPerson(WarnMessageReceiver receiver, DynamicObjectCollection list, MessageReceiver messageReceiver, Map<DynamicObject, Set<OrgReceiver>> orgReceiversGroup) {
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        RelationReceiverTypeEnum relationTypeEnum = RelationReceiverTypeEnum.getBy(receiver.getRelationshipType());
        if (relationTypeEnum == null) {
            return;
        }
        for (DynamicObject data : list) {
            String fullFieldName = this.getFullFieldName(receiver.getField(), data);
            if (RelationReceiverTypeEnum.PERSON == relationTypeEnum) {
                messageReceiver.addReceiverToGroup(data, this.getRelationFieldValues(fullFieldName, data));
                continue;
            }
            if (RelationReceiverTypeEnum.ORG == relationTypeEnum) {
                HashSet orgReceivers = new HashSet();
                this.getRelationFieldValues(fullFieldName, data).forEach(v -> orgReceivers.add(new OrgReceiver((Long)v)));
                orgReceiversGroup.put(data, orgReceivers);
                continue;
            }
            if (RelationReceiverTypeEnum.EMAIL == relationTypeEnum) {
                messageReceiver.addEmailsGroup(data, this.getExternalReceivers(fullFieldName, data));
                continue;
            }
            if (RelationReceiverTypeEnum.PHONE != relationTypeEnum) continue;
            messageReceiver.addPhonesGroup(data, this.getExternalReceivers(fullFieldName, data));
        }
    }

    private String getFullFieldName(String field, DynamicObject data) {
        String[] splitFields = StringUtils.split((String)field, (String)".");
        IDataEntityProperty entityProperty = ((EntityType)data.getDataEntityType()).findProperty(splitFields[0]);
        if (entityProperty instanceof SubEntryProp) {
            return entityProperty.getParent().getName() + "." + field;
        }
        return field;
    }

    private Set<String> getExternalReceivers(String fieldName, DynamicObject data) {
        HashSet<String> fieldValues = new HashSet<String>();
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            return fieldValues;
        }
        String[] splitFields = StringUtils.split((String)fieldName, (String)".");
        Object value = data.get(splitFields[0]);
        if (value instanceof DynamicObjectCollection) {
            DynamicObjectCollection collection = (DynamicObjectCollection)value;
            for (DynamicObject dynamicObject : collection) {
                fieldValues.addAll(this.getExternalReceivers(this.getNextField(splitFields), dynamicObject));
            }
        } else if (value instanceof String) {
            fieldValues.add((String)value);
        }
        return fieldValues;
    }

    private String getNextField(String[] splitFields) {
        if (null == splitFields || splitFields.length <= 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < splitFields.length; ++i) {
            sb.append(splitFields[i]);
            if (i >= splitFields.length - 1) continue;
            sb.append('.');
        }
        return sb.toString();
    }

    private Set<Long> getRelationFieldValues(String fieldName, DynamicObject data) {
        HashSet<Long> fieldValues = new HashSet<Long>();
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            return fieldValues;
        }
        String[] splitFields = StringUtils.split((String)fieldName, (String)".");
        IDataEntityProperty property = (IDataEntityProperty)data.getDataEntityType().getProperties().get((Object)splitFields[0]);
        if (null == property) {
            return fieldValues;
        }
        Object value = data.get(splitFields[0]);
        if (value instanceof DynamicObjectCollection) {
            DynamicObjectCollection collection = (DynamicObjectCollection)value;
            if (property instanceof MulBasedataProp) {
                for (DynamicObject mulBaseData : collection) {
                    Object baseDataId = mulBaseData.get("fbasedataid_id");
                    fieldValues.add(baseDataId instanceof Long ? (Long)baseDataId : 0L);
                }
                return fieldValues;
            }
            for (DynamicObject dynamicObject : collection) {
                fieldValues.addAll(this.getRelationFieldValues(this.getNextField(splitFields), dynamicObject));
            }
        } else if (value instanceof DynamicObject) {
            Object id = ((DynamicObject)value).getPkValue();
            Long receiverId = id instanceof Number ? ((Number)id).longValue() : 0L;
            fieldValues.add(receiverId);
        } else if (value instanceof Number) {
            Long receiverId = ((Number)value).longValue();
            fieldValues.add(receiverId);
        }
        return fieldValues;
    }

    private List<Long> getCustomReceiverIds(DynamicObject object, EarlyWarnContext context) {
        LinkedList<Long> receiverIds = new LinkedList<Long>();
        WarnMessageConfig messageConfig = context.getWarnSchedule().getMessageConfig();
        List<WarnMessageReceiverType> receiverTypes = messageConfig.getReceiverTypes();
        for (WarnMessageReceiverType type : receiverTypes) {
            for (WarnMessageReceiver receiver : type.getReceivers()) {
                WarnMessageReceiverTypeEnum receiverType = receiver.getReceiverTypeObj();
                if (WarnMessageReceiverTypeEnum.CustomReceiver != receiverType) continue;
                IEarlyWarnCustomReceiver customReceiver = this.getCustomReceiver(context);
                DynamicObject[] dynamicObjects = null;
                if (object != null) {
                    dynamicObjects = BusinessDataServiceHelper.load((Object[])new Object[]{object.get("id")}, (DynamicObjectType)object.getDynamicObjectType());
                }
                receiverIds.addAll(customReceiver.getReceiverIds(context, dynamicObjects));
            }
        }
        return receiverIds;
    }

    private void doSendSingleMessage(IEarlyWarnMessageCompiler compiler, IEarlyWarnMessageHandler handler, DynamicObjectCollection list, EarlyWarnContext context, EngineLog log) {
        log.logBatch(this.getActionTag(), EngineLog.toMultiLangJson("MessageAction_4", BOS_EARLYWARN));
        WarnSchedule schedule = context.getWarnSchedule();
        WarnMessageConfig messageConfig = schedule.getMessageConfig();
        String singleTemplate = messageConfig.getSingleContent();
        String titleTemplate = messageConfig.getTitle();
        List<String> singleFields = this.getFieldsByTemplate(singleTemplate);
        List<String> titleFields = this.getFieldsByTemplate(titleTemplate);
        String channels = this.getNotifyTypes(messageConfig);
        log.logBatch(this.getActionTag(), EngineLog.toMultiLangWithArgsJson("MessageAction_2", BOS_EARLYWARN, Collections.singletonList(channels)));
        List<YzjPublicNumberInfo> yzjPublicNumberList = MessageAction.getYZJPublicNumberList();
        MessageReceiver messageReceiver = this.getCommonReceiverIds(list, context, null);
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        for (DynamicObject data : list) {
            MessageAttachment attachment = compiler.getSingleEmailMessageAttachment(data, context);
            Map<Object, Object> handleResult = new HashMap(3);
            if (null != handler) {
                EarlyWarnMessageInfo messageInfo = handler.singleMessageBuilder(data, context);
                handleResult = this.getMassageHandleResult(messageInfo, handler, yzjPublicNumberList);
            }
            messageReceiver.addReceiverToGroup(data, this.getCustomReceiverIds(data, context));
            String newSingleTitle = compiler.getSingleTitle(titleTemplate, titleFields, data, context);
            String title = StringUtils.isNotBlank((CharSequence)newSingleTitle) ? newSingleTitle : titleTemplate;
            String content = compiler.getSingleMessage(singleTemplate, singleFields, data, context);
            List<MulilangConfig> mulilangConfigTemplates = messageConfig.getMulilangConfigs();
            List<MulilangConfig> mulilangConfigs = new ArrayList<MulilangConfig>(16);
            if (compiler.isExistMulilangConfig(context, mulilangConfigTemplates)) {
                this.isExistMulilangConfig = true;
                mulilangConfigs = this.buildMulilangConfig(compiler, mulilangConfigTemplates, data, context);
            }
            messageInfos.addAll(this.getMessageInfos(channels, title, content, mulilangConfigs, (String)handleResult.get("contentUrl"), (String)handleResult.get("mobContentUrl"), messageReceiver.getReceiversByGroup(data), (String)handleResult.get("publicNumber"), attachment, messageReceiver.getCustomReceiversByGroup(data), context, false));
        }
        List msgIds = new ArrayList();
        Map sendResult = MessageCenterServiceHelper.batchSendMessages(messageInfos);
        Object successMsgIds = null;
        if (sendResult != null && sendResult.get("data") != null) {
            successMsgIds = ((Map)sendResult.get("data")).get("successMsgIds");
        }
        if (null != successMsgIds) {
            msgIds = successMsgIds;
        }
        ArrayList<String> args = new ArrayList<String>(2);
        args.add(String.valueOf(msgIds.size()));
        args.add(StringUtil.join(msgIds));
        log.logBatch(this.getActionTag(), EngineLog.toMultiLangWithArgsJson("MessageAction_5", BOS_EARLYWARN, args));
    }

    private List<MulilangConfig> buildMulilangConfig(IEarlyWarnMessageCompiler compiler, List<MulilangConfig> mulilangConfigTemplates, DynamicObject data, EarlyWarnContext context) {
        ArrayList<MulilangConfig> mulilangConfigs = new ArrayList<MulilangConfig>(mulilangConfigTemplates.size());
        for (MulilangConfig mulilangConfig : mulilangConfigTemplates) {
            String titleTemplate = mulilangConfig.getTitle();
            String singleTemplate = mulilangConfig.getSingleContent();
            List<String> singleFields = this.getFieldsByTemplate(singleTemplate);
            List<String> titleFields = this.getFieldsByTemplate(titleTemplate);
            singleFields.addAll(titleFields);
            MulilangConfig newMulilangConfig = compiler.buildSingleMulilangConfig(mulilangConfig, singleFields, data, context);
            if (newMulilangConfig == null) continue;
            mulilangConfigs.add(newMulilangConfig);
        }
        return mulilangConfigs;
    }

    private List<String> getFieldsByTemplate(String template) {
        StringTemplateParser parser = new StringTemplateParser();
        ArrayList<String> fields = new ArrayList<String>();
        parser.parse(template, macroField -> {
            if (StringUtil.isNotBlank((CharSequence)macroField)) {
                fields.add((String)macroField);
            }
            return "";
        });
        return fields;
    }

    private Map<String, String> getMassageHandleResult(EarlyWarnMessageInfo messageInfo, IEarlyWarnMessageHandler handler, List<YzjPublicNumberInfo> yzjPublicNumberList) {
        HashMap<String, String> result = new HashMap<String, String>(3);
        if (null == messageInfo) {
            result.put("contentUrl", "");
            result.put("mobContentUrl", "");
        } else {
            result.put("contentUrl", messageInfo.getContentUrl());
            result.put("mobContentUrl", messageInfo.getMobContentUrl());
        }
        YzjPublicNumberInfo publicNumberInfo = handler.getYZJMessagePublicNumber(yzjPublicNumberList);
        if (null == publicNumberInfo) {
            result.put("publicNumber", "");
        } else {
            result.put("publicNumber", publicNumberInfo.getPubNumber());
        }
        return result;
    }

    private String getNotifyTypes(WarnMessageConfig messageConfig) {
        List<WarnMessageSendType> sendTypes = messageConfig.getSendTypes();
        if (CollectionUtils.isEmpty(sendTypes)) {
            return "";
        }
        StringBuilder channels = new StringBuilder();
        for (WarnMessageSendType sendType : sendTypes) {
            channels.append(sendType.getRealSendType()).append(',');
        }
        return StringUtils.isBlank((CharSequence)channels) ? "" : channels.substring(0, channels.length() - 1);
    }

    private IEarlyWarnCustomReceiver getCustomReceiver(EarlyWarnContext context) {
        EarlyWarnElement earlyWarn = context.getEarlyWarn();
        IEarlyWarnCustomReceiver customReceiver = null;
        List<WarnMessageReceiverType> receiverTypes = context.getWarnSchedule().getMessageConfig().getReceiverTypes();
        for (WarnMessageReceiverType receiverType : receiverTypes) {
            if (!receiverType.getReceivers().get(0).getId().equals("custom_receiver")) continue;
            customReceiver = earlyWarn.getSelectedCustomReceiver(receiverType.getReceivers().get(0).getName());
        }
        if (customReceiver != null) {
            return customReceiver;
        }
        return new KDEarlyWarnCustomReceiver();
    }

    private IEarlyWarnCustomReceiver getCustomReceiverPlugin(EarlyWarnContext context) {
        EarlyWarnElement earlyWarn = context.getEarlyWarn();
        IEarlyWarnCustomReceiver customReceiver = null;
        List<WarnMessageReceiverType> receiverTypes = context.getWarnSchedule().getMessageConfig().getReceiverTypes();
        if (CollectionUtils.isEmpty(receiverTypes)) {
            return null;
        }
        for (WarnMessageReceiverType receiverType : receiverTypes) {
            List<WarnMessageReceiver> receiverTypeReceivers;
            if (!StringUtils.equals((CharSequence)receiverType.getType(), (CharSequence)"custom_receiver") || CollectionUtils.isEmpty(receiverTypeReceivers = receiverType.getReceivers())) continue;
            String pluginName = receiverTypeReceivers.get(0).getName();
            if (StringUtils.isBlank((CharSequence)pluginName)) break;
            customReceiver = earlyWarn.getSelectedCustomReceiver(pluginName);
        }
        return customReceiver;
    }

    private List<MessageInfo> getMessageInfos(String channels, String title, String content, List<MulilangConfig> mulilangConfigs, String contentUrl, String mobContentUrl, Set<Long> receiverIds, String publicNumber, MessageAttachment attachment, Map<String, List<String>> customReceivers, EarlyWarnContext context, boolean isMerge) {
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        MessageInfo messageInfo = new MessageInfo();
        this.setSendMC(channels, messageInfo);
        messageInfo.setType("warning");
        messageInfo.setTitle(title);
        messageInfo.setContent("[" + title + "]" + System.lineSeparator() + content);
        if (this.verifyMessageAttachment(attachment)) {
            messageInfo.setAttachment(attachment);
        }
        messageInfo.setNotifyType(channels);
        messageInfo.setContentUrl(contentUrl);
        messageInfo.setMobContentUrl(mobContentUrl);
        if (StringUtils.isNotBlank((CharSequence)publicNumber)) {
            messageInfo.setPubaccNumber(publicNumber);
        }
        this.checkDataIntegrity(title, content, receiverIds, customReceivers, mulilangConfigs, context, isMerge);
        if (CollectionUtils.isNotEmpty(mulilangConfigs)) {
            this.buildMsgContentByMulilangConfig(messageInfo, mulilangConfigs, isMerge);
        } else {
            messageInfo.setMessageTitle((ILocaleString)new LocaleString(title));
            messageInfo.setMessageContent((ILocaleString)new LocaleString("[" + title + "]" + System.lineSeparator() + content));
        }
        messageInfo.setSource("cts");
        messageInfo.setMessageTag((ILocaleString)ResManager.getLocaleString((String)"\u9884\u8b66\u6d88\u606f\u901a\u77e5", (String)"MessageAction_0", (String)BOS_EARLYWARN));
        messageInfo.setMessageSenderName((ILocaleString)ResManager.getLocaleString((String)"\u7cfb\u7edf\u53d1\u9001", (String)"MessageAction_1", (String)BOS_EARLYWARN));
        if (CollectionUtils.isNotEmpty(receiverIds)) {
            MessageInfo messageInfoForUser = messageInfo.copy();
            messageInfoForUser.setUserIds(new ArrayList<Long>(receiverIds));
            messageInfos.add(messageInfoForUser);
            log.info("\u6d88\u606f\u53d1\u9001\u5185\u90e8\u4eba\u5458\uff1a" + StringUtils.join((Object[])receiverIds.toArray(), (char)','));
        }
        if (MapUtils.isNotEmpty(customReceivers)) {
            MessageInfo messageInfoForCustom = messageInfo.copy();
            messageInfoForCustom.setParams(new HashMap<String, List<String>>(customReceivers));
            messageInfos.add(messageInfoForCustom);
        }
        this.splitMessageByChannels(channels, messageInfos, content, mulilangConfigs, isMerge);
        return messageInfos;
    }

    private void checkDataIntegrity(String title, String content, Set<Long> receiverIds, Map<String, List<String>> customReceivers, List<MulilangConfig> mulilangConfigs, EarlyWarnContext context, boolean isMerge) {
        String checkDataIntegrityTips = ResManager.loadKDString((String)"\u9884\u8b66\u65b9\u6848\u6267\u884c\u8fc7\u7a0b\u4e2d\u6807\u9898\u3001\u5185\u5bb9\u6216\u63a5\u6536\u4eba\u7684\u5b57\u6bb5\u503c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u65b9\u6848\u914d\u7f6e\u6216\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61\u63d2\u4ef6\u3002", (String)"MessageAction_101", (String)BOS_EARLYWARN, (Object[])new Object[0]);
        if (!context.getWarnSchedule().isDisableIntegrity()) {
            if (CollectionUtils.isEmpty(receiverIds) && MapUtils.isEmpty(customReceivers)) {
                log.info("title:" + title + "\ncontent:" + content);
                throw new KDBizException(checkDataIntegrityTips);
            }
            if (!this.isExistMulilangConfig) {
                if (StringUtils.isBlank((CharSequence)title) || StringUtils.isBlank((CharSequence)content)) {
                    log.info("title:" + title + "\ncontent:" + content);
                    throw new KDBizException(checkDataIntegrityTips);
                }
            } else {
                ArrayList<Boolean> isEmptyMulilangTitle = new ArrayList<Boolean>(mulilangConfigs.size());
                ArrayList<Boolean> isEmptyMulilangContent = new ArrayList<Boolean>(mulilangConfigs.size());
                for (MulilangConfig mulilangConfig : mulilangConfigs) {
                    isEmptyMulilangTitle.add(StringUtils.isBlank((CharSequence)mulilangConfig.getTitle()));
                    isEmptyMulilangContent.add(StringUtils.isBlank((CharSequence)(isMerge ? mulilangConfig.getMergeContent() : mulilangConfig.getSingleContent())));
                }
                if (!isEmptyMulilangTitle.contains(false) || !isEmptyMulilangContent.contains(false)) {
                    log.info("MulilangTitle OR MulilangContent Is Empty");
                    throw new KDBizException(checkDataIntegrityTips);
                }
            }
        }
    }

    private void buildMsgContentByMulilangConfig(MessageInfo messageInfo, List<MulilangConfig> mulilangConfigs, boolean isMerge) {
        LocaleString title = new LocaleString();
        LocaleString content = new LocaleString();
        for (MulilangConfig mulilangConfig : mulilangConfigs) {
            String langType = mulilangConfig.getLangType();
            String mulilangTitle = mulilangConfig.getTitle();
            title.setItem(langType, (Object)mulilangTitle);
            content.setItem(langType, (Object)("[" + mulilangTitle + "]" + (isMerge ? mulilangConfig.getMergeContent() : mulilangConfig.getSingleContent())));
        }
        messageInfo.setMessageTitle((ILocaleString)title);
        messageInfo.setMessageContent((ILocaleString)content);
    }

    private void splitMessageByChannels(String channels, List<MessageInfo> messageInfos, String content, List<MulilangConfig> mulilangConfigs, boolean isMerge) {
        String[] notifyTypes = channels.split(String.valueOf(','));
        StringBuilder noNeedTitleChannels = new StringBuilder();
        StringBuilder needTitleChannels = new StringBuilder();
        for (String notifyType : notifyTypes) {
            if (notifyType.equals(MessageChannels.MC.getNumber()) || notifyType.equals(MessageChannels.EMAIL.getNumber())) {
                noNeedTitleChannels.append(notifyType).append(',');
                continue;
            }
            needTitleChannels.append(notifyType).append(',');
        }
        if (StringUtils.isBlank((CharSequence)noNeedTitleChannels)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)needTitleChannels)) {
            for (MessageInfo messageInfo : messageInfos) {
                messageInfo.setContent(content);
                this.setMessageContentByMulilangConfig(content, mulilangConfigs, isMerge, messageInfo);
            }
            return;
        }
        String noNeedTitleChannelStr = noNeedTitleChannels.substring(0, noNeedTitleChannels.length() - 1);
        String needTitleChannelsStr = needTitleChannels.substring(0, needTitleChannels.length() - 1);
        ArrayList<MessageInfo> noNeedTitleMessageInfos = new ArrayList<MessageInfo>(messageInfos.size());
        for (MessageInfo messageInfo : messageInfos) {
            messageInfo.setNotifyType(needTitleChannelsStr);
            MessageInfo noNeedTitleMessageInfo = messageInfo.copy();
            this.setSendMC(needTitleChannelsStr, messageInfo);
            noNeedTitleMessageInfo.setNotifyType(noNeedTitleChannelStr);
            this.setSendMC(noNeedTitleChannelStr, noNeedTitleMessageInfo);
            noNeedTitleMessageInfo.setContent(content);
            this.setMessageContentByMulilangConfig(content, mulilangConfigs, isMerge, noNeedTitleMessageInfo);
            noNeedTitleMessageInfos.add(noNeedTitleMessageInfo);
        }
        messageInfos.addAll(noNeedTitleMessageInfos);
    }

    private void setMessageContentByMulilangConfig(String content, List<MulilangConfig> mulilangConfigs, boolean isMerge, MessageInfo messageInfo) {
        if (CollectionUtils.isNotEmpty(mulilangConfigs)) {
            LocaleString muilangContent = new LocaleString();
            for (MulilangConfig mulilangConfig : mulilangConfigs) {
                muilangContent.setItem(mulilangConfig.getLangType(), (Object)(isMerge ? mulilangConfig.getMergeContent() : mulilangConfig.getSingleContent()));
            }
            messageInfo.setMessageContent((ILocaleString)muilangContent);
        } else {
            messageInfo.setMessageContent((ILocaleString)new LocaleString(content));
        }
    }

    private void setSendMC(String channels, MessageInfo messageInfo) {
        if (!channels.contains(MessageChannels.MC.getNumber())) {
            HashMap<String, Boolean> params = new HashMap<String, Boolean>(1);
            params.put("noSaveMessage", true);
            messageInfo.setParams(params);
        }
    }

    private boolean verifyMessageAttachment(MessageAttachment attachment) {
        if (null == attachment) {
            return false;
        }
        if (null == attachment.getAttachments() || 0 == attachment.getAttachments().size()) {
            return false;
        }
        return null != attachment.getAttachmentNames() && 0 != attachment.getAttachmentNames().size();
    }

    private static List<YzjPublicNumberInfo> getYZJPublicNumberList() {
        ArrayList<YzjPublicNumberInfo> publicList = new ArrayList<YzjPublicNumberInfo>();
        Map publicNumbers = BusinessDataServiceHelper.loadFromCache((String)"msg_channel", (String)"mobileappconfig", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"yunzhijia")});
        if (null == publicNumbers || publicNumbers.size() == 0) {
            return publicList;
        }
        JSONArray publicNumberArr = null;
        for (DynamicObject value : publicNumbers.values()) {
            publicNumberArr = JSONArray.parseArray((String)value.getString("mobileappconfig"));
        }
        if (null != publicNumberArr) {
            for (int i = 0; i < publicNumberArr.size(); ++i) {
                JSONObject publicNumber = publicNumberArr.getJSONObject(i);
                String pubName = publicNumber.getString("pubaccname");
                String pubNumber = publicNumber.getString("pubaccnumber");
                String pubAppId = publicNumber.getString("appid");
                String pubApiUrl = publicNumber.getString("pubaccapiurl");
                String pubAccessUrl = publicNumber.getString("accrediturl");
                String pubId = publicNumber.getString("pubaccid");
                publicList.add(new YzjPublicNumberInfo(pubName, pubNumber, pubId, pubAppId, pubApiUrl, pubAccessUrl));
            }
        }
        return publicList;
    }
}

