/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.earlywarn.formula;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.entity.earlywarn.warnschedule.FormulaCondition;
import kd.bos.entity.earlywarn.warnschedule.WarnCondition;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.formula.OutValue;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.function.FunctionManage;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.function.UDFunctionVisitor;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.UDFunction;
import kd.bos.formula.excel.Visitor;
import kd.bos.service.earlywarn.formula.EWExpressionContext;
import kd.bos.service.earlywarn.var.IVariableMode;
import kd.bos.service.earlywarn.var.SourceFieldVariable;
import kd.bos.service.earlywarn.var.UnKnowVariable;

public class EWFormulaHandler {
    private String formula;
    private EWExpressionContext expressionContext;
    private Expr expr;
    private FunctionManage funcLib;
    private List<IVariableMode> vars = new ArrayList<IVariableMode>();
    private Set<String> funcs = new HashSet<String>();

    public EWFormulaHandler(EarlyWarnContext earlyWarnContext, BillEntityType billEntityType) {
        this.expressionContext = new EWExpressionContext(billEntityType);
        this.funcLib = this.getFuncLib();
        WarnCondition warnCondition = earlyWarnContext.getWarnSchedule().getWarnCondition();
        this.compileFormula(warnCondition.getFormulaCondition());
    }

    public Object getValue(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow) {
        this.expressionContext.setActiveRow(sourceRow);
        this.expressionContext.setProperties(fldProperties);
        Map<String, Object> ctx = this.getVarValues(this.expressionContext);
        BOSUDFunction[] funcInstances = this.createUDFunctions(this.expressionContext);
        return FormulaEngine.execExcelFormula((Expr)this.expr, ctx, (UDFunction[])funcInstances);
    }

    private Map<String, Object> getVarValues(EWExpressionContext expContext) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        for (IVariableMode var : this.getVars()) {
            OutValue value = new OutValue();
            if (!expContext.tryGetValue(var.getVar(), (OutValue<Object>)value).booleanValue()) {
                ctx.put(var.getVar(), null);
                return ctx;
            }
            Object item = value.get();
            if (item instanceof String) {
                item = ((String)item).trim();
            }
            ctx.put(var.getVar(), item);
        }
        return ctx;
    }

    private BOSUDFunction[] createUDFunctions(EWExpressionContext expContext) {
        if (this.getFuncs().isEmpty()) {
            return null;
        }
        ArrayList<BOSUDFunction> instances = new ArrayList<BOSUDFunction>();
        for (String funcName : this.getFuncs()) {
            if (!this.funcLib.getFuncMap().containsKey(funcName)) continue;
            BOSUDFunction instance = ((BOSUDFunction)this.funcLib.getFuncMap().get(funcName)).getInstance((ExpressionContext)expContext);
            instances.add(instance);
        }
        return instances.toArray(new BOSUDFunction[0]);
    }

    private void compileFormula(FormulaCondition formulaCondition) {
        if (formulaCondition == null) {
            return;
        }
        this.formula = formulaCondition.getExpression();
        if (StringUtils.isBlank((CharSequence)this.formula)) {
            return;
        }
        String[] varStrings = new String[]{};
        try {
            varStrings = FormulaEngine.extractVariables((String)this.formula);
            this.expr = FormulaEngine.parseFormula((String)this.formula);
            UDFunctionVisitor funVisitor = new UDFunctionVisitor();
            this.expr.accept((Visitor)funVisitor);
            this.funcs.addAll(funVisitor.getFuncNames());
        }
        catch (Exception exp) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.formula);
            sb.append("  \r\n");
            sb.append(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u89e3\u6790\u51fa\u9519\uff1a%s", (String)"EWFormulaHandler_0", (String)"bos-earlywarn", (Object[])new Object[0]), exp.getMessage()));
            throw new KDBizException((Throwable)exp, BosErrorCode.expressionParseFailed, new Object[]{sb.toString()});
        }
        BillEntityType mainEntityType = this.expressionContext.getSourceBill();
        for (String varString : varStrings) {
            String[] keyItems = StringUtils.split((String)varString, (String)".");
            IVariableMode var = this.buildVarMode(mainEntityType, varString, keyItems);
            this.vars.add(var);
        }
    }

    private IVariableMode buildVarMode(BillEntityType mainEntityType, String varString, String[] keyItems) {
        IVariableMode var = null;
        IDataEntityProperty property = mainEntityType.findProperty(keyItems[0]);
        if (property == null && mainEntityType.getProperties().containsKey((Object)keyItems[0])) {
            property = (IDataEntityProperty)mainEntityType.getProperties().get((Object)keyItems[0]);
        }
        if (property != null) {
            var = new SourceFieldVariable(varString, keyItems, property);
            return var;
        }
        var = new UnKnowVariable(varString, keyItems);
        return var;
    }

    public List<IVariableMode> getVars() {
        return this.vars;
    }

    public void setVars(List<IVariableMode> vars) {
        this.vars = vars;
    }

    public Set<String> getFuncs() {
        return this.funcs;
    }

    public void setFuncs(Set<String> funcs) {
        this.funcs = funcs;
    }

    private FunctionManage getFuncLib() {
        if (this.funcLib == null) {
            FunctionTypes functionTypes = FunctionTypes.getCommonFuncs();
            this.funcLib = FunctionManage.get((FunctionTypes)functionTypes);
        }
        return this.funcLib;
    }

    public String getFormula() {
        return this.formula;
    }
}

