/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.earlywarn.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.earlywarn.utils.MulilangConfig;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.entity.earlywarn.kit.StringTemplateParser;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.earlywarn.warn.plugin.IEarlyWarnDataSource;
import kd.bos.entity.earlywarn.warnschedule.MessageContent;
import kd.bos.entity.earlywarn.warnschedule.MessageTableColumn;
import kd.bos.entity.earlywarn.warnschedule.WarnMessageConfig;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageReceiver;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageReceiverType;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageReceiverTypeEnum;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.param.CustomParam;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.earlywarn.formula.EWFormulaHandler;
import kd.bos.service.earlywarn.var.IVariableMode;
import kd.bos.service.earlywarn.var.SourceFieldVariable;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

@KSObject(name="BillDataSourcePlugIn")
public class DefaultEarlyWarnBillDataSource
implements IEarlyWarnDataSource {
    private static final Log logger = LogFactory.getLog(DefaultEarlyWarnBillDataSource.class);
    private static final String TOTAL_COUNT = "totalCount";
    private static final String WARN_SCHEDULE = "warnSchedule";
    private static final String WARN_SCHEDULE_NAME = "warnSchedule.name";
    private static final String WARN_SCHEDULE_NUMBER = "warnSchedule.number";
    private static final String EARLY_WARN = "earlyWarn";
    private static final String EARLY_WARN_NAME = "earlyWarn.name";
    private static final String EARLY_WARN_NUMBER = "earlyWarn.number";
    private static final String BOS_EARLYWARN = "bos-earlywarn";

    @Override
    @KSMethod
    public TreeNode getSingleMessageFieldTree(String dataSource) {
        if (StringUtils.isBlank((CharSequence)dataSource)) {
            return new TreeNode();
        }
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setIncludeEntryEntityAsKeyPrefix(true);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)dataSource);
        TreeNode root = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainEntityType, (PropTreeBuildOption)option);
        root.setIsOpened(true);
        return root;
    }

    @Override
    @KSMethod
    public TreeNode getMergeMessageFieldTree(String dataSource) {
        TreeNode root = this.getSingleMessageFieldTree(dataSource);
        TreeNode totalCount = new TreeNode(root.getId(), TOTAL_COUNT, ResManager.loadKDString((String)"\u603b\u6761\u6570", (String)"DefaultEarlyWarnBillDataSource_1", (String)BOS_EARLYWARN, (Object[])new Object[0]));
        root.addChild(0, totalCount);
        TreeNode warnSchedule = new TreeNode(root.getId(), WARN_SCHEDULE, ResManager.loadKDString((String)"\u76d1\u63a7\u65b9\u6848", (String)"DefaultEarlyWarnBillDataSource_2", (String)BOS_EARLYWARN, (Object[])new Object[0]));
        warnSchedule.addChild(new TreeNode(WARN_SCHEDULE, WARN_SCHEDULE_NAME, ResManager.loadKDString((String)"\u540d\u79f0", (String)"DefaultEarlyWarnBillDataSource_3", (String)BOS_EARLYWARN, (Object[])new Object[0])));
        warnSchedule.addChild(new TreeNode(WARN_SCHEDULE, WARN_SCHEDULE_NUMBER, ResManager.loadKDString((String)"\u7f16\u7801", (String)"DefaultEarlyWarnBillDataSource_4", (String)BOS_EARLYWARN, (Object[])new Object[0])));
        root.addChild(1, warnSchedule);
        TreeNode earlyEarn = new TreeNode(root.getId(), EARLY_WARN, ResManager.loadKDString((String)"\u4e1a\u52a1\u9884\u8b66\u5bf9\u8c61", (String)"DefaultEarlyWarnBillDataSource_5", (String)BOS_EARLYWARN, (Object[])new Object[0]));
        earlyEarn.addChild(new TreeNode(EARLY_WARN, EARLY_WARN_NAME, ResManager.loadKDString((String)"\u540d\u79f0", (String)"DefaultEarlyWarnBillDataSource_3", (String)BOS_EARLYWARN, (Object[])new Object[0])));
        earlyEarn.addChild(new TreeNode(EARLY_WARN, EARLY_WARN_NUMBER, ResManager.loadKDString((String)"\u7f16\u7801", (String)"DefaultEarlyWarnBillDataSource_4", (String)BOS_EARLYWARN, (Object[])new Object[0])));
        root.addChild(2, earlyEarn);
        return root;
    }

    @Override
    @KSMethod
    public DynamicObjectCollection getData(String dataSource, List<QFilter> filterList, EarlyWarnContext context) {
        QFilter[] filters;
        if (StringUtils.isBlank((CharSequence)dataSource)) {
            return null;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)dataSource);
        if (StringUtils.isBlank((CharSequence)mainType.getAlias())) {
            throw new KDException(new ErrorCode("", String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90%1$s(%2$s)\u8868\u540d\u4e3a\u7a7a\u3002", (String)"DefaultEarlyWarnBillDataSource_6", (String)BOS_EARLYWARN, (Object[])new Object[0]), mainType.getDisplayName() == null ? "" : mainType.getDisplayName().getLocaleValue(), mainType.getName())), new Object[0]);
        }
        EWFormulaHandler formulaHandler = new EWFormulaHandler(context, (BillEntityType)mainType);
        QFilter[] qFilterSql = null;
        FilterCondition filterCondition = context.getWarnSchedule().getWarnCondition().getFilterCondition();
        QFilter[] qFilterArray = filters = filterList == null || filterList.isEmpty() ? null : filterList.toArray(new QFilter[filterList.size()]);
        if (filterCondition != null) {
            FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
            filterBuilder.buildFilter();
            if (filterBuilder.getQFilter() != null) {
                qFilterSql = new ArrayList<QFilter>(Collections.singletonList(filterBuilder.getQFilter())).toArray(new QFilter[1]);
            }
        } else {
            qFilterSql = filters;
        }
        Set<String> selectProperties = this.getSearchFields(mainType, context, filters, false);
        Set<String> formulaFields = this.addFormulaSourceFields(formulaHandler.getVars(), selectProperties);
        String useToQuerySelectedProp = this.handleComplexProps(selectProperties);
        DynamicObjectCollection queryResults = new DynamicObjectCollection();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)dataSource, (String)useToQuerySelectedProp, (QFilter[])qFilterSql, (String)"", (int)this.getLimitDataRows());
        List<Object> pkValues = this.filterAndFillData(formulaFields, dynamicObjects, queryResults, formulaHandler);
        if (context.getWarnSchedule().isByEntry() && queryResults.size() > 0) {
            String entrySelectedProp = StringUtils.join((Object[])this.getSearchFields(mainType, context, filters, true).toArray(), (String)",");
            DynamicObjectCollection allData = QueryServiceHelper.query((String)dataSource, (String)entrySelectedProp, (QFilter[])this.addPKValueQFilter(pkValues, qFilterSql), (String)"id asc");
            context.setPlainWarnData(allData);
        }
        return queryResults;
    }

    private int getLimitDataRows() {
        int defaultRows = 2000;
        try {
            Map customParameter = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)new CustomParam());
            String dataCount = (String)customParameter.get("EARLY_WARN_FILTER_DATA_COUNT");
            if (StringUtils.isNotBlank((CharSequence)dataCount)) {
                int customRows = Integer.parseInt(dataCount);
                return customRows >= 1 && customRows <= 5000 ? customRows : defaultRows;
            }
        }
        catch (Exception e) {
            logger.info("\u9884\u8b66\u83b7\u53d6\u81ea\u5b9a\u4e49\u7cfb\u7edf\u53c2\u6570\u62a5\u9519", (Object)e);
            return defaultRows;
        }
        return defaultRows;
    }

    private Set<String> addFormulaSourceFields(List<IVariableMode> vars, Set<String> selectFldStrings) {
        HashSet<String> formulaFields = new HashSet<String>();
        for (IVariableMode var : vars) {
            if (!(var instanceof SourceFieldVariable)) continue;
            SourceFieldVariable srcField = (SourceFieldVariable)var;
            String fldString = srcField.getFullPropName();
            selectFldStrings.add(fldString);
            formulaFields.add(fldString);
        }
        return formulaFields;
    }

    private List<Object> filterAndFillData(Set<String> formulaFields, DynamicObject[] dynamicObjects, DynamicObjectCollection queryResults, EWFormulaHandler formulaHandler) {
        ArrayList<Object> pkList = new ArrayList<Object>(dynamicObjects.length);
        if (dynamicObjects.length == 0 || StringUtils.isBlank((CharSequence)formulaHandler.getFormula())) {
            queryResults.addAll(Arrays.asList(dynamicObjects));
            return pkList;
        }
        HashMap<String, DynamicProperty> fieldProps = new HashMap<String, DynamicProperty>(formulaFields.size());
        IDataEntityType dataEntityType = dynamicObjects[0].getDataEntityType();
        for (String field : formulaFields) {
            DynamicProperty dynamicProperty = this.getFieldProp(field, dataEntityType);
            fieldProps.put(field, dynamicProperty);
        }
        try {
            for (DynamicObject row : dynamicObjects) {
                if (!((Boolean)formulaHandler.getValue(fieldProps, row)).booleanValue()) continue;
                queryResults.add((Object)row);
                pkList.add(row.getPkValue());
            }
        }
        catch (Exception exp) {
            logger.error((Throwable)exp);
            throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6267\u884c\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f\u3002", (String)"DefaultEarlyWarnBillDataSource_0", (String)BOS_EARLYWARN, (Object[])new Object[0]));
        }
        return pkList;
    }

    private DynamicProperty getFieldProp(String field, IDataEntityType dataEntityType) {
        if (StringUtils.isBlank((CharSequence)field)) {
            return null;
        }
        String[] keys = StringUtil.split((String)field, (String)".");
        if (keys.length == 1) {
            IDataEntityProperty prop = (IDataEntityProperty)dataEntityType.getProperties().get((Object)field);
            return prop == null ? null : (DynamicProperty)prop;
        }
        IDataEntityType propertyType = dataEntityType;
        IDataEntityProperty property = null;
        for (int i = 0; i < keys.length; ++i) {
            property = (IDataEntityProperty)propertyType.getProperties().get((Object)keys[i]);
            if (i == keys.length - 1) break;
            if (!(property instanceof BasedataProp)) {
                property = null;
                break;
            }
            propertyType = ((BasedataProp)property).getComplexType();
        }
        return property == null ? null : (DynamicProperty)property;
    }

    private QFilter[] addPKValueQFilter(List<Object> pkValues, QFilter[] qFilters) {
        if (CollectionUtils.isEmpty(pkValues)) {
            return qFilters;
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        if (null != qFilters && qFilters.length > 0) {
            Collections.addAll(qFilterList, qFilters);
        }
        QFilter pkFilter = new QFilter("id", "in", pkValues);
        qFilterList.add(pkFilter);
        return qFilterList.toArray(new QFilter[0]);
    }

    private Set<String> getSearchFields(MainEntityType mainEntityType, EarlyWarnContext context, QFilter[] filters, boolean isOnlyEntry) {
        WarnMessageConfig messageConfig;
        HashSet<String> fields = new HashSet<String>();
        fields.add(mainEntityType.getPrimaryKey().getName());
        if (null != filters) {
            for (QFilter filter : filters) {
                if (!StringUtils.isNotBlank((CharSequence)filter.getProperty())) continue;
                this.fetchField(mainEntityType, filter.getProperty(), fields, isOnlyEntry);
            }
        }
        if (null != (messageConfig = context.getWarnSchedule().getMessageConfig())) {
            this.fetchFields(mainEntityType, messageConfig.getSingleContent(), fields, isOnlyEntry);
            this.fetchFields(mainEntityType, messageConfig.getTitle(), fields, isOnlyEntry);
            boolean isMergeSendMessage = messageConfig.isMergeSendMessage();
            MessageContent mergeMessageContent = messageConfig.getMergeMessageContent();
            String mergeContent = messageConfig.getMergeContent();
            this.fetchMergeMessageFields(mainEntityType, fields, isMergeSendMessage, isOnlyEntry, mergeMessageContent, mergeContent);
            List<MulilangConfig> mulilangConfigs = messageConfig.getMulilangConfigs();
            if (!mulilangConfigs.isEmpty()) {
                this.fetchMulilangConfigFields(mainEntityType, mulilangConfigs, fields, isMergeSendMessage, isOnlyEntry);
            }
            List<WarnMessageReceiverType> receiverTypes = messageConfig.getReceiverTypes();
            for (WarnMessageReceiverType type : receiverTypes) {
                for (WarnMessageReceiver receiver : type.getReceivers()) {
                    WarnMessageReceiverTypeEnum receiverType;
                    if (!StringUtils.isNotBlank((CharSequence)receiver.getField()) || WarnMessageReceiverTypeEnum.RelationPerson != (receiverType = receiver.getReceiverTypeObj())) continue;
                    this.fetchField(mainEntityType, receiver.getField(), fields, isOnlyEntry);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)messageConfig.getGroupField())) {
                this.fetchField(mainEntityType, messageConfig.getGroupField(), fields, isOnlyEntry);
            }
        }
        return fields;
    }

    private String handleComplexProps(Set<String> selectProperties) {
        Object[] querySelectProperties = selectProperties.toArray(new String[0]);
        for (int i = 0; i < querySelectProperties.length; ++i) {
            if (!querySelectProperties[i].contains(".")) continue;
            int index = ((String)querySelectProperties[i]).indexOf(".");
            if ((index = ((String)querySelectProperties[i]).indexOf(".", index + 1)) == -1) continue;
            querySelectProperties[i] = ((String)querySelectProperties[i]).substring(0, index);
        }
        return StringUtils.join((Object[])querySelectProperties, (String)",");
    }

    private void fetchMulilangConfigFields(MainEntityType mainEntityType, List<MulilangConfig> mulilangConfigs, Set<String> fields, boolean isMergeSendMessage, boolean isOnlyEntry) {
        for (MulilangConfig mulilangConfig : mulilangConfigs) {
            this.fetchFields(mainEntityType, mulilangConfig.getTitle(), fields, isOnlyEntry);
            this.fetchFields(mainEntityType, mulilangConfig.getSingleContent(), fields, isOnlyEntry);
            MessageContent messageContent = mulilangConfig.getMessageContent();
            String mergeContent = mulilangConfig.getMergeContent();
            this.fetchMergeMessageFields(mainEntityType, fields, isMergeSendMessage, isOnlyEntry, messageContent, mergeContent);
        }
    }

    private void fetchMergeMessageFields(MainEntityType mainEntityType, Set<String> fields, boolean isMergeSendMessage, boolean isOnlyEntry, MessageContent messageContent, String mergeContent) {
        if (isMergeSendMessage) {
            if (null != messageContent) {
                this.fetchFields(mainEntityType, messageContent.getMessageHead(), fields, isOnlyEntry);
                this.fetchFields(mainEntityType, messageContent.getMessageEnd(), fields, isOnlyEntry);
                List<MessageTableColumn> tableColumns = messageContent.getTableColumns();
                if (CollectionUtils.isNotEmpty(tableColumns)) {
                    tableColumns.forEach(col -> {
                        if (StringUtils.isNotBlank((CharSequence)col.getField())) {
                            this.fetchField(mainEntityType, col.getField(), fields, isOnlyEntry);
                        }
                    });
                }
            } else {
                this.fetchFields(mainEntityType, mergeContent, fields, isOnlyEntry);
            }
        }
    }

    private void fetchFields(MainEntityType mainEntityType, String template, Set<String> fields, boolean isOnlyEntry) {
        if (null == mainEntityType || StringUtils.isBlank((CharSequence)template)) {
            return;
        }
        StringTemplateParser parser = new StringTemplateParser();
        parser.parse(template, macroName -> {
            this.fetchField(mainEntityType, (String)macroName, fields, isOnlyEntry);
            return "";
        });
    }

    private void fetchField(MainEntityType mainEntityType, String macroName, Set<String> fields, boolean isOnlyEntry) {
        DynamicObjectType type;
        String controlPropName;
        if (StringUtils.isBlank((CharSequence)macroName)) {
            return;
        }
        String[] arr = StringUtil.split((String)macroName, (String)".");
        if (null == arr || arr.length == 0) {
            return;
        }
        IDataEntityProperty property = mainEntityType.findProperty(arr[0]);
        if (null == property) {
            return;
        }
        if (property instanceof DecimalProp && StringUtils.isNotBlank((CharSequence)(controlPropName = ((DecimalProp)property).getControlPropName()))) {
            fields.add(controlPropName);
        }
        this.addControlPropNumber(mainEntityType, fields, arr, property);
        if (!isOnlyEntry) {
            fields.add(macroName);
            if (property instanceof DynamicCollectionProperty && null != (type = ((DynamicCollectionProperty)property).getDynamicCollectionItemPropertyType())) {
                String id = type.getPrimaryKey().getName();
                fields.add(StringUtils.join((Object[])new Object[]{arr[0], id}, (String)"."));
            }
        } else {
            if (property instanceof SubEntryProp) {
                return;
            }
            if (property instanceof EntryProp && null != (type = ((DynamicCollectionProperty)property).getDynamicCollectionItemPropertyType())) {
                String id = type.getPrimaryKey().getName();
                fields.add(StringUtils.join((Object[])new Object[]{arr[0], id}, (String)"."));
            }
        }
    }

    private void addControlPropNumber(MainEntityType mainEntityType, Set<String> fields, String[] arr, IDataEntityProperty property) {
        boolean supportProperty;
        if (arr.length <= 1) {
            return;
        }
        boolean bl = supportProperty = property instanceof EntryProp || property instanceof BasedataProp || property instanceof MulBasedataProp;
        if (!supportProperty) {
            return;
        }
        if (property instanceof EntryProp) {
            this.addControlForEntry(mainEntityType, fields, arr);
        } else if (property instanceof BasedataProp || property instanceof MulBasedataProp) {
            this.addControlForIBasedata(fields, arr, (IBasedataField)property);
        }
    }

    private void addControlForIBasedata(Set<String> fields, String[] arr, IBasedataField property) {
        String controlPropName;
        MainEntityType complexType = (MainEntityType)property.getComplexType();
        IDataEntityProperty prop = complexType.findProperty(arr[1]);
        if (prop instanceof DecimalProp && StringUtils.isNotBlank((CharSequence)(controlPropName = ((DecimalProp)prop).getControlPropName()))) {
            fields.add(arr[0] + "." + controlPropName);
        }
    }

    private void addControlForEntry(MainEntityType mainEntityType, Set<String> fields, String[] arr) {
        IDataEntityProperty entryProperty = mainEntityType.findProperty(arr[1]);
        if (entryProperty instanceof DecimalProp) {
            String controlPropName = ((DecimalProp)entryProperty).getControlPropName();
            if (StringUtils.isBlank((CharSequence)controlPropName)) {
                return;
            }
            Map allEntities = mainEntityType.getAllEntities();
            EntityType entryEntityType = (EntityType)allEntities.get(arr[0]);
            if (entryEntityType.findProperty(controlPropName) != null) {
                fields.add(arr[0] + "." + controlPropName);
            }
        } else if (entryProperty instanceof BasedataProp || entryProperty instanceof MulBasedataProp) {
            if (arr.length < 3) {
                return;
            }
            this.addControlForEntryIbaseData(fields, arr, (IBasedataField)entryProperty);
        }
    }

    private void addControlForEntryIbaseData(Set<String> fields, String[] arr, IBasedataField entryProperty) {
        String controlPropName;
        MainEntityType complexType = (MainEntityType)entryProperty.getComplexType();
        IDataEntityProperty prop = complexType.findProperty(arr[2]);
        if (prop instanceof DecimalProp && StringUtils.isNotBlank((CharSequence)(controlPropName = ((DecimalProp)prop).getControlPropName()))) {
            fields.add(arr[0] + "." + arr[1] + "." + controlPropName);
        }
    }

    @Override
    @KSMethod
    public List<QFilter> buildFilter(String dataSource, FilterCondition filterCondition, EarlyWarnContext context) {
        if (StringUtil.isBlank((CharSequence)dataSource) || null == filterCondition) {
            return new ArrayList<QFilter>();
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)dataSource);
        FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition);
        filterBuilder.buildFilter();
        return filterBuilder.getQFilters();
    }

    @Override
    @KSMethod
    public List<Map<String, Object>> getCommonFilterColumns(String dataSource) {
        if (StringUtils.isBlank((CharSequence)dataSource)) {
            return new ArrayList<Map<String, Object>>();
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)dataSource);
        EntityTypeUtil helper = new EntityTypeUtil();
        return helper.getFilterColumns((IDataEntityType)mainEntityType);
    }
}

