/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.earlywarn;

import java.util.Date;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.earlywarn.log.EarlyWarnDetailLog;
import kd.bos.entity.earlywarn.log.EarlyWarnLog;
import kd.bos.entity.earlywarn.log.WarnScheduleOperationType;
import kd.bos.entity.earlywarn.log.WarnScheduleStatus;
import kd.bos.entity.earlywarn.warnschedule.WarnSchedule;
import kd.bos.entity.earlywarn.warnschedule.WarnScheduleCache;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class EarlyWarnLogHelper {
    private static final String WARN_MONITOR_LOG = "warn_earlywarn_log";

    public static long createLog(String warnScheduleId, WarnScheduleOperationType operationType) {
        Long currentUserId = Long.valueOf(RequestContext.get().getUserId());
        WarnSchedule warnSchedule = WarnScheduleCache.load(warnScheduleId);
        Date now = KDDateUtils.now();
        long id = DBServiceHelper.genGlobalLongId();
        EarlyWarnLog log = new EarlyWarnLog();
        log.setId(id).setWarnScheduleId(warnScheduleId).setEarlyWarnId(warnSchedule.getEarlyWarnId()).setStartTime(now).setEndTime(now).setStatus(WarnScheduleStatus.Running.toString()).setOperationType(operationType.toString()).setOperatorId(currentUserId).setComment("");
        IDataEntityType type = OrmUtils.getDataEntityType(EarlyWarnLog.class);
        BusinessDataWriter.save((IDataEntityType)type, (Object[])new EarlyWarnLog[]{log});
        return id;
    }

    public static boolean existLog(long id) {
        return EarlyWarnLogHelper.findById(id, "id") != null;
    }

    @SdkInternal
    public static DynamicObject findById(long id, String fields) {
        try {
            return StringUtils.isNotBlank((CharSequence)fields) ? BusinessDataServiceHelper.loadSingle((Object)id, (String)WARN_MONITOR_LOG, (String)fields) : BusinessDataServiceHelper.loadSingle((Object)id, (String)WARN_MONITOR_LOG);
        }
        catch (Exception e) {
            return null;
        }
    }

    @SdkInternal
    public static EarlyWarnDetailLog createBlankDetailLog(long earlyWarnLogId, String action, String result) {
        String accountId;
        String cacheKey;
        long id = DBServiceHelper.genGlobalLongId();
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));
        Long seq = cache.inc(cacheKey = (accountId = RequestContext.get().getAccountId()) + "_EarlyWarnDetailLog:" + earlyWarnLogId, 28800);
        int seqValue = seq == null ? 1 : seq.intValue();
        EarlyWarnDetailLog log = new EarlyWarnDetailLog();
        log.setId(earlyWarnLogId).setEntryId(id).setSeq(seqValue).setAction(action).setCreateTime(KDDateUtils.now()).setResult(result).setLogformat("2").setResultTag("");
        return log;
    }

    public static void saveDetailLog(long earlyWarnLogId, String action, String result) {
        EarlyWarnDetailLog log = EarlyWarnLogHelper.createBlankDetailLog(earlyWarnLogId, action, result);
        IDataEntityType type = OrmUtils.getDataEntityType(EarlyWarnDetailLog.class);
        BusinessDataWriter.save((IDataEntityType)type, (Object[])new EarlyWarnDetailLog[]{log});
    }

    public static void batchSaveDetailLogs(List<EarlyWarnDetailLog> detailLogs) {
        if (detailLogs.isEmpty()) {
            return;
        }
        IDataEntityType type = OrmUtils.getDataEntityType(EarlyWarnDetailLog.class);
        BusinessDataWriter.save((IDataEntityType)type, (Object[])detailLogs.toArray(new EarlyWarnDetailLog[detailLogs.size()]));
    }

    public static void endLog(long id, WarnScheduleStatus status) {
        DynamicObject obj = EarlyWarnLogHelper.findById(id, null);
        if (null == obj) {
            return;
        }
        EarlyWarnLog log = new EarlyWarnLog(obj);
        Date endTime = KDDateUtils.now();
        long executeMillis = endTime.getTime() - log.getStartTime().getTime();
        log.setStatus(status.getStatus());
        log.setEndTime(endTime);
        log.setExecutionMillis(executeMillis);
        IDataEntityType type = OrmUtils.getDataEntityType(EarlyWarnLog.class);
        BusinessDataWriter.delete((IDataEntityType)type, (Object[])new Long[]{id});
        BusinessDataWriter.save((IDataEntityType)type, (Object[])new EarlyWarnLog[]{log});
    }

    @SdkInternal
    public static void cleanLogByDate(Date time) {
        if (null == time) {
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            DBRoute dbRoute = DBRoute.basedata;
            String detailSql = "delete from T_WARN_MONITOR_DETAILLOG where FCREATETIME <= ? ";
            DB.execute((DBRoute)dbRoute, (String)detailSql, (Object[])new SqlParameter[]{new SqlParameter(":FCREATETIME", 91, (Object)time)});
            String sql = "delete from T_WARN_MONITORLOG where FSTARTTIME <= ? ";
            DB.execute((DBRoute)dbRoute, (String)sql, (Object[])new SqlParameter[]{new SqlParameter(":FSTARTTIME", 91, (Object)time)});
        }
    }
}

