/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.formplugin;

import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.log.business.etl.ArchiveJobService;
import kd.bos.log.service.ArchiveLogSettingService;
import kd.bos.log.service.dto.LogSetting;
import kd.bos.threads.ThreadPools;
import org.apache.commons.lang3.StringUtils;

public class LogEtlTaskPagePlugin
extends AbstractFormPlugin
implements IDataModelChangeListener {
    private static final String TABLE_NAME_KEY = "tablename";
    private static final String DAYS_KEY = "days";
    private static final String CHECK_BOX_KEY = "checkbox";
    private static final String BTN_SAVE_KEY = "save";
    private static final String BTN_CMD_KEY = "cmd";
    private static final String BTN_REFRESH_KEY = "refresh";

    public void afterCreateNewData(EventObject e) {
        ArchiveLogSettingService logSettingService = new ArchiveLogSettingService();
        FieldEdit checkbox = (FieldEdit)this.getControl(CHECK_BOX_KEY);
        FieldEdit dayText = (FieldEdit)this.getControl(DAYS_KEY);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{TABLE_NAME_KEY});
        if (logSettingService.hasSetting()) {
            LogSetting logSetting = logSettingService.getLogSetting();
            this.getModel().setValue(TABLE_NAME_KEY, (Object)"t_log_app_archive_v3");
            this.getModel().setValue(DAYS_KEY, (Object)logSetting.getDay());
            if (!logSetting.getStatusBoolean()) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{DAYS_KEY});
            }
            checkbox.getModel().setValue(CHECK_BOX_KEY, (Object)logSetting.getStatusBoolean());
        } else {
            dayText.getModel().setValue(DAYS_KEY, (Object)180);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{DAYS_KEY});
            checkbox.getModel().setValue(CHECK_BOX_KEY, (Object)false);
        }
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "save": {
                try {
                    FieldEdit dayText = (FieldEdit)this.getControl(DAYS_KEY);
                    Integer days = (Integer)dayText.getModel().getValue(DAYS_KEY);
                    if (days > 720 || days < 1) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"LogEtlTaskPlugin_1", (String)"bos-log-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    this.updateSetting();
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"LogOperationSetFormPlugin_1", (String)"bos-log-formplugin", (Object[])new Object[0]));
                }
                catch (Exception ex) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"LogEtlTaskPlugin_1", (String)"bos-log-formplugin", (Object[])new Object[0]));
                }
                break;
            }
            case "cmd": {
                ArchiveLogSettingService archiveLogSettingService = new ArchiveLogSettingService();
                LogSetting logSetting = archiveLogSettingService.getLogSetting();
                if (archiveLogSettingService.exists()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b63\u5728\u5f52\u6863\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"LogEtlTaskPlugin_6", (String)"bos-log-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (logSetting.getStatusBoolean()) {
                    ThreadPools.executeOnce((String)"etl-log-task", (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ArchiveJobService archiveJobService = new ArchiveJobService();
                            archiveJobService.execute();
                        }
                    });
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"LogEtlTaskPlugin_3", (String)"bos-log-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f00\u542f\u81ea\u52a8\u5f52\u6863\u5e76\u4fdd\u5b58\u540e\u518d\u64cd\u4f5c\u3002", (String)"LogEtlTaskPlugin_4", (String)"bos-log-formplugin", (Object[])new Object[0]));
                break;
            }
            case "refresh": {
                BillList billList = (BillList)this.getControl("billlistap");
                billList.refresh();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f\u3002", (String)"LogEtlTaskPlugin_2", (String)"bos-log-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void updateSetting() {
        ArchiveLogSettingService logSettingService = new ArchiveLogSettingService();
        LogSetting logSetting = new LogSetting();
        logSetting.setStatus(this.getModel().getValue(CHECK_BOX_KEY).toString());
        logSetting.setDay((Integer)this.getModel().getValue(DAYS_KEY));
        logSetting.setTableName("t_log_app_archive_v3");
        logSettingService.updateLogSetting(logSetting);
    }

    private void updateSettingView() {
        boolean open = (Boolean)this.getModel().getValue(CHECK_BOX_KEY);
        if (open) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{DAYS_KEY});
            this.getModel().setValue(TABLE_NAME_KEY, (Object)"t_log_app_archive_v3");
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{DAYS_KEY});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)CHECK_BOX_KEY, (CharSequence)fieldKey)) {
            this.updateSettingView();
        }
    }
}

