/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.formplugin;

import java.lang.reflect.Field;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.redis.RedisSessionlessCache;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityItemTypes;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.SortType;
import kd.bos.entity.list.JoinProperty;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.list.SummaryResult;
import kd.bos.entity.list.option.ListUserOption;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.filter.CommonDateFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.filter.SchemeFilterView;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ChatEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.list.query.PageRowCacheUtils;
import kd.bos.list.query.impl.CountQuery;
import kd.bos.list.query.impl.SumQuery;
import kd.bos.log.formplugin.LogUpdateTask;
import kd.bos.log.utils.LogOperactionListutils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;

public class LogOperactionListPlugin
extends AbstractListPlugin
implements PagerClickListener {
    private static Log logger = LogFactory.getLog(LogOperactionListPlugin.class);
    public static final String ENTITY_LOG_SETTING = "bos_log_appsetting";
    public static final String ENTITY_LOG_OPERATION = "bos_log_operation";
    public static final String ENTITY_LOG_ARCHIVE = "bos_log_archive";

    public void addClickListeners(String ... arg0) {
        super.addClickListeners(arg0);
    }

    public void chat(ChatEvent e) {
        e.setCancel(true);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.setMaxPageSize(Integer.valueOf(100));
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        try {
            List comboItems = ((CommonDateFilterColumn)args.getCommonFilterColumns().get(0)).getComboItems();
            Iterator iterator = comboItems.iterator();
            while (iterator.hasNext()) {
                ComboItem comboItem = (ComboItem)iterator.next();
                if (!"24".equals(comboItem.getValue()) || this.getQueryMonthInterval() >= 3) continue;
                iterator.remove();
                break;
            }
            List<String> ids = Arrays.asList("1", "13", "11", "10", "61", "63", "92", "24");
            FilterContainerInitEvent event = args.getFilterContainerInitEvent();
            Field field = event.getClass().getDeclaredField("schemeFilterView");
            field.setAccessible(true);
            SchemeFilterView schemeFilterView = (SchemeFilterView)field.get(event);
            List filterColumns = schemeFilterView.getFilterColumns();
            for (FilterColumn column : filterColumns) {
                if (!"optime".equals(column.getFieldName())) continue;
                SchemeFilterColumn schemeFilterColumn = (SchemeFilterColumn)column;
                Field field1 = schemeFilterColumn.getClass().getDeclaredField("compareTypes");
                field1.setAccessible(true);
                List compareTypes = (List)field1.get(schemeFilterColumn);
                compareTypes.removeIf(temp -> !ids.contains(temp.getId()));
            }
        }
        catch (Exception e) {
            logger.error("\u79fb\u9664\u64cd\u4f5c\u65f6\u95f4\u8fc7\u53bb\u4e09\u4e2a\u6708\u51fa\u5f02\u5e38", (Throwable)e);
        }
        super.filterContainerInit(args);
    }

    public void setFilter(SetFilterEvent e) {
        List qfilters = e.getQFilters();
        if (!this.check(qfilters)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u65f6\u95f4\u67e5\u8be2\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc7%d\u4e2a\u6708\u3002", (String)"LogOperactionListPlugin_0", (String)"bos-log-formplugin", (Object[])new Object[0]), this.getQueryMonthInterval()));
        }
    }

    private int getQueryMonthInterval() {
        int intervalMonth = 3;
        return intervalMonth;
    }

    private boolean check(List<QFilter> qfilters) {
        int intervalMonth = this.getQueryMonthInterval();
        boolean checkResult = true;
        if (qfilters == null || qfilters.isEmpty()) {
            return true;
        }
        for (QFilter filter : qfilters) {
            if (!"optime".equals(filter.getProperty())) continue;
            String filterStr = filter.toString();
            List qfilterNests = filter.getNests(true);
            if (qfilterNests == null || qfilterNests.isEmpty()) continue;
            String startTime = null;
            String endTime = null;
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            startTime = filterStr.substring(0, filterStr.indexOf(39));
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            endTime = filterStr.substring(0, filterStr.indexOf(39));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                LocalDateTime start = LocalDateTime.parse(startTime, dateTimeFormatter);
                LocalDateTime end = LocalDateTime.parse(endTime, dateTimeFormatter);
                long duration = ChronoUnit.DAYS.between(start, end);
                if (duration > (long)(intervalMonth * 31)) {
                    checkResult = false;
                    continue;
                }
                checkResult = true;
            }
            catch (Exception px) {
                logger.error((Throwable)px);
                return checkResult;
            }
        }
        return checkResult;
    }

    public void initialize() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.setOrderBy("optime desc");
        super.initialize();
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String itemkey = evt.getOperateKey();
        OperationResult opResult = evt.getOperationResult();
        if (opResult != null && !opResult.isSuccess()) {
            return;
        }
        switch (itemkey) {
            case "bar_set": {
                this.showLogOperationSet();
                break;
            }
            case "bar_sync_log": {
                this.showUpgradeProgress();
                break;
            }
        }
    }

    private void showUpgradeProgress() {
        FormShowParameter para = new FormShowParameter();
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setFormId("bos_log_upgrade_new");
        para.setCustomParam("isOpenNewTab", (Object)Boolean.TRUE);
        this.getView().showForm(para);
    }

    public void clearUpgradeKey() {
        try (DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.log, (String)"SELECT FUPGRADESTATUS FROM T_LOG_APPSETTING");){
            Object upgradeStatus;
            if (!dataSet.isEmpty() && (upgradeStatus = dataSet.next().get("FUPGRADESTATUS")) != null && "kingdee".equals(String.valueOf(upgradeStatus))) {
                RedisSessionlessCache cache = (RedisSessionlessCache)CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("bos_log_sync", new DistributeCacheHAPolicy(true, true));
                String status = cache.get(LogUpdateTask.getLogCacheKeyPrefix() + "bos-base-log-upgrading");
                logger.info("\u8fdb\u884c\u65e5\u5fd7\u5347\u7ea7\u8fc7\u7a0b\u4e2dredis\u7f13\u5b58\u6570\u636e\u6e05\u9664\u64cd\u4f5c");
                cache.remove(new String[]{LogUpdateTask.getLogCacheKeyPrefix() + "bos-base-log-upgrading", LogUpdateTask.getLogCacheKeyPrefix() + "bos-base-log-sync-count", LogUpdateTask.getLogCacheKeyPrefix() + "bos-base-log-dump-count", LogUpdateTask.getLogCacheKeyPrefix() + "bos-base-log-step", LogUpdateTask.getLogCacheKeyPrefix() + "bos-base-log-total-sync-count", LogUpdateTask.getLogCacheKeyPrefix() + "bos-base-log-total-dump-count"});
            }
        }
    }

    public boolean isUpgradeFinish() {
        try (DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.log, (String)"SELECT FUPGRADESTATUS FROM T_LOG_APPSETTING");){
            Object upgradeStatus;
            if (!dataSet.isEmpty() && (upgradeStatus = dataSet.next().get("FUPGRADESTATUS")) != null && LogUpdateTask.UpgradeStatusEnum.FINISH.getValue().equals(String.valueOf(upgradeStatus))) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private void upgradeLog() {
        DLock lock = null;
        try {
            lock = DLock.create((String)"base_log_sync_lock");
            lock.lock();
            RedisSessionlessCache cache = (RedisSessionlessCache)CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("bos_log_sync", new DistributeCacheHAPolicy(true, true));
            String status = cache.get(LogUpdateTask.getLogCacheKeyPrefix() + "bos-base-log-upgrading");
            if (null != status) {
                if (LogUpdateTask.UpgradeStatusEnum.UPGRADING.getValue().equals(status)) {
                    this.showUpgradeProgress();
                } else if (LogUpdateTask.UpgradeStatusEnum.FINISH.getValue().equals(status)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u65e5\u5fd7\u5347\u7ea7\u5df2\u5b8c\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"LogOperactionListPlugin_4", (String)"bos-log-formplugin", (Object[])new Object[0]));
                } else if (LogUpdateTask.UpgradeStatusEnum.FAILED.getValue().equals(status)) {
                    this.showUpgradeProgress();
                }
            } else if (this.isUpgradeFinish()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u65e5\u5fd7\u5347\u7ea7\u5df2\u5b8c\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"LogOperactionListPlugin_4", (String)"bos-log-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u7cfb\u7edf\u5c06\u5728\u540e\u53f0\u6267\u884c\u65e5\u5fd7\u5347\u7ea7\u4efb\u52a1\uff0c\u662f\u5426\u73b0\u5728\u5347\u7ea7\uff1f", (String)"LogOperactionListPlugin_7", (String)"bos-log-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("upgrade_sure", (IFormPlugin)this));
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
        finally {
            if (null != lock) {
                lock.unlock();
            }
        }
    }

    private String calProgress(int current, int total) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        String result = numberFormat.format((float)current / (float)total * 100.0f);
        return result + "%";
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equalsIgnoreCase((CharSequence)"upgrade_retry", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                logger.info("\u65e5\u5fd7\u5347\u7ea7\u5931\u8d25\uff0c\u7528\u6237\u70b9\u51fb\u786e\u8ba4\u8fdb\u884c\u91cd\u8bd5");
                this.doUpgrade();
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"upgrade_sure", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            logger.info("\u7528\u6237\u70b9\u51fb\u786e\u8ba4\u8fdb\u884c\u5347\u7ea7\uff0c\u5f00\u59cb\u8fdb\u884c\u65e5\u5fd7\u5347\u7ea7");
            this.doUpgrade();
        }
    }

    private void doUpgrade() {
        DLock lock = null;
        try {
            lock = DLock.create((String)"base_log_sync_lock_do");
            lock.lock();
            RedisSessionlessCache cache = (RedisSessionlessCache)CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("bos_log_sync", new DistributeCacheHAPolicy(true, true));
            cache.put(LogUpdateTask.getLogCacheKeyPrefix() + "bos-base-log-upgrading", LogUpdateTask.UpgradeStatusEnum.UPGRADING.getValue(), 2, TimeUnit.DAYS);
            ThreadPools.executeOnce((String)"upgrade-log", (Runnable)new LogUpdateTask());
            this.showUpgradeProgress();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (null != lock) {
                lock.unlock();
            }
        }
    }

    private void showLogOperationSet() {
        FormShowParameter para = new FormShowParameter();
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setFormId("bos_log_appsetting_new");
        para.setCustomParam("isOpenNewTab", (Object)Boolean.TRUE);
        this.getView().showForm(para);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
    }

    public void pagerClick(PagerClickEvent arg0) {
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
    }

    class LogOperactionListProviderImpl
    extends ListDataProvider {
        private ListUserOption listUserOption;

        LogOperactionListProviderImpl() {
        }

        public void setListUserOption(ListUserOption listUserOption) {
            this.listUserOption = listUserOption;
            super.setListUserOption(listUserOption);
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection LogDatas = this.getLogData(start, limit);
            int dataCount = this.getDataCount();
            this.getQueryResult().setDataCount(dataCount);
            this.getQueryResult().setCollection(LogDatas);
            return LogDatas;
        }

        private QFilter[] getQfilter() {
            String filterJson = LogOperactionListPlugin.this.getPageCache().get("filter");
            QFilter[] filter = null;
            if (StringUtils.isNotEmpty((CharSequence)filterJson)) {
                List list = (List)SerializationUtils.fromJsonString((String)filterJson, List.class);
                filter = new QFilter[list.size()];
                int i = 0;
                for (String qfilterStr : list) {
                    filter[i++] = QFilter.fromSerializedString((String)qfilterStr);
                }
            }
            return filter;
        }

        public int getDataCount() {
            ORM orm = ORM.create();
            int opLength = orm.count(((Object)((Object)this)).getClass().getName(), LogOperactionListPlugin.ENTITY_LOG_OPERATION, this.getQfilter());
            int archivesLength = orm.count(((Object)((Object)this)).getClass().getName(), LogOperactionListPlugin.ENTITY_LOG_ARCHIVE, this.getQfilter());
            return opLength + archivesLength;
        }

        private DynamicObjectCollection getLogData(int start, int limit) {
            String selectList = "id, ' ' fseq, user.name,bizapp.name,bizobj.name,optime,clienttype,clientip,archivetime,opname,opdescription,clientname,org.name";
            String orderBys = "optime desc";
            ORM orm = ORM.create();
            QFilter[] filters = this.getQfilter();
            QueryBuilder queryBuilder = this.getLogQueryBuilder(start, limit);
            int count = orm.count(((Object)((Object)this)).getClass().getName(), LogOperactionListPlugin.ENTITY_LOG_OPERATION, filters);
            int countArchive = orm.count(((Object)((Object)this)).getClass().getName(), LogOperactionListPlugin.ENTITY_LOG_ARCHIVE, filters);
            DynamicObjectCollection colOperations = null;
            try (DataSet ds = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), LogOperactionListPlugin.ENTITY_LOG_OPERATION, selectList, filters, orderBys, start, limit);
                 DataSet dsArchive = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), LogOperactionListPlugin.ENTITY_LOG_ARCHIVE, selectList, filters, orderBys, start, limit);
                 DataSet d2 = ds.union(dsArchive);){
                String pageId = PageRowCacheUtils.getPageId();
                PageRowCacheUtils.touchFlag();
                colOperations = LogOperactionListutils.cacheDataSet(((Object)((Object)this)).getClass().getName(), pageId, queryBuilder, d2);
            }
            this.getQueryResult().setDataCount(count + countArchive);
            return colOperations;
        }

        QueryBuilder getLogQueryBuilder(int start, int limit) {
            QueryBuilder queryBuilder = new QueryBuilder();
            ArrayList<String> selectFields = new ArrayList<String>();
            ArrayList<String> sortFields = new ArrayList<String>();
            ArrayList<ListField> summaryFields = new ArrayList<ListField>();
            ArrayList<ListField> decimalFields = new ArrayList<ListField>();
            MainEntityType dt = new MainEntityType();
            dt.setName("QueryObject");
            String seqField = null;
            for (ListField listField : this.getListFields()) {
                FilterField filterField;
                String fieldName = this.registerLogProperty((DynamicObjectType)dt, listField);
                if (fieldName == null) continue;
                if (listField.isSeq()) {
                    seqField = fieldName;
                } else if (!selectFields.contains(fieldName)) {
                    selectFields.add(fieldName);
                }
                if (listField.getSummary() == 1) {
                    summaryFields.add(listField);
                }
                if (listField.getSortType() != null && listField.getSortType() != SortType.NotOrder && !sortFields.contains(fieldName)) {
                    sortFields.add(String.format("%s %s", listField.getFieldName(), listField.getSortType().name()));
                }
                if ((filterField = FilterField.create((MainEntityType)((MainEntityType)this.getEntityType()), (String)listField.getListFieldKey())) == null || !(filterField.getFieldProp() instanceof DecimalProp)) continue;
                decimalFields.add(listField);
            }
            String orderBy = String.join((CharSequence)",", sortFields);
            if (StringUtils.isNotBlank((CharSequence)this.getOrderByExpr())) {
                orderBy = this.getOrderByExpr();
            } else if (StringUtils.isBlank((CharSequence)orderBy)) {
                if (this.getEntityType() instanceof BasedataEntityType) {
                    BasedataEntityType basedataEntityType = (BasedataEntityType)this.getEntityType();
                    orderBy = String.format("%s", basedataEntityType.getNumberProperty());
                } else if (this.getEntityType() instanceof BillEntityType) {
                    BillEntityType billEntityType = (BillEntityType)this.getEntityType();
                    orderBy = String.format("%s", billEntityType.getBillNo());
                }
                if (this.getPKFields().size() > 1 && StringUtils.isNotBlank((CharSequence)orderBy)) {
                    orderBy = orderBy + "," + ((ListField)this.getPKFields().get(1)).getFieldName().split("\\.")[0] + ".seq";
                } else if (this.getPKFields().size() > 1 && StringUtils.isBlank((CharSequence)orderBy)) {
                    orderBy = ((ListField)this.getPKFields().get(1)).getFieldName().split("\\.")[0] + ".seq";
                }
            }
            ArrayList myPKFields = new ArrayList(this.getPKFields());
            queryBuilder.setDecimalFields(decimalFields);
            queryBuilder.setSumFields(summaryFields);
            queryBuilder.setEntityName(this.getEntityType().getName());
            queryBuilder.setEntityType((IDataEntityType)this.getEntityType());
            queryBuilder.setSelectFields(String.join((CharSequence)",", selectFields));
            queryBuilder.setPkFields(myPKFields);
            queryBuilder.setSeqField(seqField);
            queryBuilder.setReturnEntityType((DynamicObjectType)dt);
            queryBuilder.setStart(start);
            queryBuilder.setLimit(limit);
            queryBuilder.setFilters(this.getQFilters().toArray(new QFilter[0]));
            queryBuilder.setOrderBys(orderBy);
            if (this.listUserOption == null) {
                this.listUserOption = new ListUserOption();
            }
            queryBuilder.setMergeRow(this.listUserOption.isMergeRow());
            return queryBuilder;
        }

        public int getRealCount() {
            QueryBuilder queryBuilder = this.getLogQueryBuilder(0, -1);
            return CountQuery.getCount((QueryBuilder)queryBuilder);
        }

        public int getBillDataCount() {
            QueryBuilder queryBuilder = this.getLogQueryBuilder(0, -1);
            return CountQuery.getBillDataCount((QueryBuilder)queryBuilder);
        }

        public List<SummaryResult> getSummaryResults() {
            return SumQuery.getSummaryResults((QueryBuilder)this.getLogQueryBuilder(0, -1));
        }

        private String registerLogProperty(DynamicObjectType dt, ListField listField) {
            Object srcFieldProp = listField.isSeq() ? new DynamicSimpleProperty(listField.getFieldName(), Integer.class, (Object)0) : this.getLogSelectProp(listField.getFieldName());
            if (srcFieldProp instanceof ISimpleProperty) {
                return this.registerLogProperty(dt, listField, (ISimpleProperty)srcFieldProp);
            }
            if (srcFieldProp instanceof IComplexProperty) {
                return this.registerLogProperty(dt, listField, (IComplexProperty)srcFieldProp);
            }
            throw new KDException(BosErrorCode.fieldNotExist, new Object[]{this.getEntityType().getName(), listField.getFieldName()});
        }

        private IDataEntityProperty getLogSelectProp(String key) {
            Object prop;
            String[] keys = key.split("\\.");
            if (keys.length > 1) {
                prop = this.getEntityType().findProperty(keys[0]);
                if ((prop instanceof EntryProp || prop instanceof JoinProperty) && (prop = (IDataEntityProperty)((ICollectionProperty)prop).getItemType().getProperties().get((Object)keys[1])) instanceof SubEntryProp) {
                    prop = (IDataEntityProperty)((SubEntryProp)prop).getItemType().getProperties().get((Object)keys[2]);
                }
                if (prop == null) {
                    prop = this.getEntityType().findProperty(key);
                }
            } else {
                prop = this.getEntityType().getPrimaryKey().getName().equals(key) ? this.getEntityType().getPrimaryKey() : this.getEntityType().findProperty(key);
            }
            return prop;
        }

        private String registerLogProperty(DynamicObjectType dt, ListField listField, ISimpleProperty srcFieldProp) {
            String propName = listField.getFieldName();
            DynamicProperty sp = dt.getProperty(propName);
            if (sp == null) {
                DynamicSimpleProperty property;
                Class<String> propertyType = srcFieldProp.getPropertyType();
                if (propertyType == ILocaleString.class) {
                    propertyType = String.class;
                }
                if (srcFieldProp instanceof ItemClassTypeProp) {
                    ItemClassTypeProp newProp = new ItemClassTypeProp();
                    ItemClassTypeProp srcProp = (ItemClassTypeProp)srcFieldProp;
                    newProp.getItemTypes().putAll(srcProp.getItemTypes());
                    newProp.setName(propName);
                    property = newProp;
                } else {
                    property = new DynamicSimpleProperty(propName, propertyType, null);
                }
                if (((ListField)this.getPKFields().get(0)).getFieldName().equalsIgnoreCase(listField.getFieldName())) {
                    property.setPrimaryKey(true);
                }
                property.setDbType(srcFieldProp.getDbType());
                sp = dt.registerSimpleProperty(property);
            }
            listField.setFieldProp((IDataEntityProperty)sp);
            listField.setSrcFieldProp((IDataEntityProperty)srcFieldProp);
            for (ListField pkField : this.getPKFields()) {
                if (!propName.equalsIgnoreCase(listField.getFieldName())) continue;
                pkField.setFieldProp((IDataEntityProperty)sp);
                pkField.setSrcFieldProp((IDataEntityProperty)srcFieldProp);
            }
            for (ListField keyField : this.getPKFields()) {
                if (!propName.equalsIgnoreCase(listField.getFieldName())) continue;
                keyField.setFieldProp((IDataEntityProperty)sp);
                keyField.setSrcFieldProp((IDataEntityProperty)srcFieldProp);
            }
            return propName;
        }

        private String registerLogProperty(DynamicObjectType dt, ListField listField, IComplexProperty srcFieldProp) {
            String propName = FilterField.buildPropORMFullName((IDataEntityProperty)srcFieldProp);
            DynamicProperty p = dt.getProperty(propName);
            if (p == null) {
                String refIdPropName = srcFieldProp.getName() + "_Id";
                BasedataProp baseProp = (BasedataProp)TypesContainer.createInstance(srcFieldProp.getClass());
                baseProp.setName(propName);
                baseProp.setDbIgnore(true);
                baseProp.setRefIdPropName(refIdPropName);
                if (baseProp instanceof ItemClassProp) {
                    FilterField itemTypeFld;
                    String itemTypePropName = ((ItemClassProp)srcFieldProp).getTypePropName();
                    if (StringUtils.isNotBlank((CharSequence)itemTypePropName) && (itemTypeFld = FilterField.create((MainEntityType)((MainEntityType)this.getEntityType()), (String)itemTypePropName)) != null) {
                        itemTypePropName = itemTypeFld.getFullFieldName();
                    }
                    ((ItemClassProp)baseProp).setTypePropName(itemTypePropName);
                } else {
                    baseProp.setComplexType(srcFieldProp.getComplexType());
                }
                if (baseProp instanceof FlexProp) {
                    ((FlexProp)baseProp).setFlexTypeId(((FlexProp)srcFieldProp).getFlexTypeId());
                    ((FlexProp)baseProp).setBasePropertyKey(((FlexProp)srcFieldProp).getBasePropertyKey());
                }
                dt.addProperty((DynamicProperty)baseProp);
                p = baseProp;
                DynamicSimpleProperty refIdProp = (DynamicSimpleProperty)EntityItemTypes.clone((IDataEntityProperty)((BasedataProp)srcFieldProp).getRefIdProp());
                baseProp.setRefIdProp((IDataEntityProperty)refIdProp);
                dt.registerSimpleProperty(refIdProp);
            }
            listField.setFieldProp((IDataEntityProperty)p);
            listField.setSrcFieldProp((IDataEntityProperty)srcFieldProp);
            return propName;
        }
    }
}

