/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.log.service.util.UserFormatCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class LogSettingsFormPlugin
extends AbstractFormPlugin {
    public static final String OPUSERFORMAT = "opuserformat";
    public static final String USERTYPE = "usertype";

    public void afterBindData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        super.afterBindData(e);
        this.getLogSetting(params);
        this.getView().getModel().setDataChanged(false);
    }

    private void getLogSetting(Map<String, Object> params) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(8);
        if (!ObjectUtils.isEmpty(params) && !ObjectUtils.isEmpty((Object)params.get(USERTYPE))) {
            Object setting;
            this.getModel().setValue(USERTYPE, params.get(USERTYPE));
            qFilterList.add(new QFilter(USERTYPE, "=", params.get(USERTYPE)));
            Object[] logSetting = BusinessDataServiceHelper.load((String)"bos_log_settings", (String)"id,opuserformat,usertype", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]));
            if (!ObjectUtils.isEmpty((Object[])logSetting) && !ObjectUtils.isEmpty((Object)(setting = logSetting[0]).get(OPUSERFORMAT))) {
                this.getModel().setValue(OPUSERFORMAT, setting.get(OPUSERFORMAT));
                this.getModel().setValue(USERTYPE, params.get(USERTYPE));
                this.getView().updateView(OPUSERFORMAT);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"bar_app_setting_save"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        switch (((Control)evt.getSource()).getKey()) {
            case "bar_app_setting_save": {
                this.saveLogSetting();
            }
        }
    }

    private void saveLogSetting() {
        String select = String.valueOf(this.getModel().getValue(OPUSERFORMAT));
        String userType = String.valueOf(this.getModel().getValue(USERTYPE));
        if (StringUtils.isBlank((CharSequence)select)) {
            return;
        }
        Object[] logSetting = BusinessDataServiceHelper.load((String)"bos_log_settings", (String)"id,opuserformat,usertype", (QFilter[])new QFilter[]{new QFilter(USERTYPE, "=", (Object)userType)});
        Object setting = null;
        setting = !ObjectUtils.isEmpty((Object[])logSetting) ? logSetting[0] : BusinessDataServiceHelper.newDynamicObject((String)"bos_log_settings");
        setting.set(OPUSERFORMAT, this.getModel().getValue(OPUSERFORMAT));
        setting.set(USERTYPE, this.getModel().getValue(USERTYPE));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{setting});
        UserFormatCache.modifyUserFormat((String)select, (String)userType);
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        parentView.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"LogOperationSetFormPlugin_1", (String)"bos-log-formplugin", (Object[])new Object[0]));
        this.getView().sendFormAction(parentView);
        this.getView().close();
    }
}

