/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.formplugin;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.redis.RedisSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.QueryTimeout;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;

public class LogUpdateTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(LogUpdateTask.class);
    private static final String[] COLUMN = new String[]{"FID", "FUSERID", "FBIZAPPID", "FORGID", "FBIZOBJID", "FCLIENTIP", "FCLIENTTYPE", "FOPTIME", "FOPNAMEE", "FOPDESCRIPTIONE", "FCLIENTNAMEE", "FUSERNAME", "FBIZAPPNAME", "FBIZOBJNAME", "FORGNAME", "FMODIFYBILLID", "FMODIFYCONTENT", "FMODIFYCONTENT_TAG", "FMODIFYFIELDS", "FMODIFYBILLNO"};
    private static final String TABLE = "T_LOG_ARCHIVE";
    private String writeRecordSql;
    private int syncCount = 0;
    private RedisSessionlessCache cache;
    private static final String PREFIX = "bos-base-log-";
    public static final String TOTAL_SYNC_COUNT_CACHE_KEY = "bos-base-log-total-sync-count";
    public static final String SYNC_COUNT_CACHE_KEY = "bos-base-log-sync-count";
    public static final String UPGRADING_CACHE_KEY = "bos-base-log-upgrading";
    public static final String STEP_CACHE_KEY = "bos-base-log-step";
    public static final String TOTAL_DUMP_COUNT_CACHE_KEY = "bos-base-log-total-dump-count";
    public static final String DUMP_COUNT_CACHE_KEY = "bos-base-log-dump-count";
    public static final String FAILED_MESSAGE_KEY = "bos-base-log-failed-message";
    private UpgradeStatusEnum currentStep = UpgradeStatusEnum.UPGRADING;

    public LogUpdateTask() {
        this.cache = (RedisSessionlessCache)CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("bos_log_sync", new DistributeCacheHAPolicy(true, true));
    }

    @Override
    public void run() {
        block7: {
            try {
                this.saveUpgradeStartTime();
                long startTime = System.currentTimeMillis();
                if (this.cache.contains(LogUpdateTask.getLogCacheKeyPrefix() + STEP_CACHE_KEY)) {
                    String status = this.cache.get(LogUpdateTask.getLogCacheKeyPrefix() + STEP_CACHE_KEY);
                    if (UpgradeStatusEnum.PRE_FINISH.getValue().equals(status)) {
                        this.currentStep = UpgradeStatusEnum.PRE_FINISH;
                    } else if (UpgradeStatusEnum.FINISH.getValue().equals(status)) {
                        this.currentStep = UpgradeStatusEnum.FINISH;
                    }
                }
                this.cache.incrBy(LogUpdateTask.getLogCacheKeyPrefix() + SYNC_COUNT_CACHE_KEY, 0);
                if (UpgradeStatusEnum.UPGRADING == this.currentStep) {
                    this.pre();
                }
                this.syncCount = 0;
                this.cache.incrBy(LogUpdateTask.getLogCacheKeyPrefix() + DUMP_COUNT_CACHE_KEY, 0);
                this.doPostWithRetry(9);
                this.currentStep = UpgradeStatusEnum.FINISH;
                this.cache.put(LogUpdateTask.getLogCacheKeyPrefix() + UPGRADING_CACHE_KEY, UpgradeStatusEnum.FINISH.getValue());
                this.saveUpgradeFinalStatus();
                long spendTime = System.currentTimeMillis() - startTime;
                logger.info("\u4e1a\u52a1\u65e5\u5fd7\u6570\u636e\u5347\u7ea7\u5b8c\u6210\u6240\u82b1\u8d39\u65f6\u957f\uff1a" + spendTime + "\u6beb\u79d2");
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                logger.info("\u65e5\u5fd7\u5347\u7ea7\u51fa\u73b0\u5f02\u5e38\uff0c\u5347\u7ea7\u5931\u8d25");
                this.cache.put(LogUpdateTask.getLogCacheKeyPrefix() + FAILED_MESSAGE_KEY, ExceptionUtils.getStackTrace((Throwable)e));
                this.cache.put(LogUpdateTask.getLogCacheKeyPrefix() + UPGRADING_CACHE_KEY, UpgradeStatusEnum.FAILED.getValue());
                if (UpgradeStatusEnum.UPGRADING != this.currentStep && UpgradeStatusEnum.PRE_FINISH != this.currentStep) break block7;
                this.cache.remove(new String[]{LogUpdateTask.getLogCacheKeyPrefix() + DUMP_COUNT_CACHE_KEY});
            }
        }
    }

    private void saveUpgradeFinalStatus() {
        try (DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.log, (String)"SELECT FID FROM T_LOG_APPSETTING");){
            if (!dataSet.isEmpty()) {
                Object id = dataSet.next().get("FID");
                if (id != null) {
                    String updateSql = "UPDATE T_LOG_APPSETTING SET FUPGRADESTATUS='" + UpgradeStatusEnum.FINISH.getValue() + "'" + " WHERE FID='" + id + "'";
                    logger.info("\u65e5\u5fd7\u5347\u7ea7\u66f4\u65b0\u6700\u7ec8\u7684\u5347\u7ea7\u72b6\u6001\u6267\u884csql:" + updateSql);
                    DB.execute((DBRoute)DBRoute.log, (String)updateSql);
                }
            } else {
                DynamicObject setObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_log_appsetting");
                setObj.set("upgradestatus", (Object)UpgradeStatusEnum.FINISH.getValue());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{setObj});
            }
        }
    }

    private Integer getCount(String sql, DBRoute dbRoute) {
        String countSql = "select count(1) c from(" + sql + ") C";
        try (DataSet countDs = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)dbRoute, (String)countSql);){
            Integer count;
            Integer n = count = ((Row)countDs.iterator().next()).getInteger(0);
            return n;
        }
    }

    private int getKey(Object id, Object localeId) {
        int key = id != null && localeId != null ? id.hashCode() + localeId.hashCode() : (id == null && localeId != null ? localeId.hashCode() : (id != null ? id.hashCode() : -1));
        return key;
    }

    private Map<Integer, Object> dataSetToMap(String sql, DBRoute dbRoute) {
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)dbRoute, (String)sql);){
            if (!ds.isEmpty()) {
                HashMap<Integer, Object> map = new HashMap<Integer, Object>(16);
                while (ds.hasNext()) {
                    Row row = ds.next();
                    Object id = row.get(0);
                    Object name = row.get(1);
                    Object localeId = row.get(2);
                    int key = this.getKey(id, localeId);
                    map.put(key, name);
                }
                HashMap<Integer, Object> hashMap = map;
                return hashMap;
            }
        }
        return null;
    }

    private boolean isEmpty(Object obj) {
        if (null == obj) {
            return true;
        }
        return StringUtils.isEmpty((CharSequence)StringUtils.deleteWhitespace((String)String.valueOf(obj)));
    }

    private Object getName(Map<Integer, Object> map, Object id, Object localeId) {
        if (map != null && !map.isEmpty()) {
            Object name = map.get(this.getKey(id, localeId));
            if (this.isEmpty(name)) {
                return this.getActualName(map, id);
            }
            return name;
        }
        return "";
    }

    private Object getActualName(Map<Integer, Object> map, Object id) {
        Object tempName = map.get(this.getKey(id, Lang.zh_CN.toString()));
        Object actualName = this.isEmpty(tempName) ? (this.isEmpty(tempName = map.get(this.getKey(id, Lang.zh_TW.toString()))) ? ((tempName = map.get(this.getKey(id, Lang.en_US.toString()))) == null ? "" : tempName) : tempName) : tempName;
        return actualName;
    }

    public void pre() {
        this.writeRecordSql = this.calcWriteRecordSql(COLUMN, TABLE);
        String querySql = "SELECT A.FID,A.FUSERID,A.FBIZAPPID,A.FORGID,A.FBIZOBJID,A.FCLIENTIP,A.FCLIENTTYPE,A.FOPTIME,B.FOPNAME,B.FOPDESCRIPTION,B.FCLIENTNAME,B.FLOCALEID,A.FOPNAMEE,A.FOPDESCRIPTIONE,A.FCLIENTNAMEE,A.FMODIFYBILLID,A.FMODIFYCONTENT,A.FMODIFYCONTENT_TAG,A.FMODIFYFIELDS,A.FMODIFYBILLNO FROM T_LOG_APP A LEFT JOIN T_LOG_APP_L B ON A.FID=B.FID";
        logger.info("\u63d2\u5165sql:" + this.writeRecordSql);
        int batchSize = 1000;
        Integer count = this.getCount(querySql, DBRoute.log);
        logger.info("Dataset \u603b\u5171\u7684\u6570\u636e\u91cf\u4e3a\uff1a" + count);
        this.cache.put(LogUpdateTask.getLogCacheKeyPrefix() + TOTAL_SYNC_COUNT_CACHE_KEY, String.valueOf(count));
        try {
            ArrayList<Object[]> writeBuffer = new ArrayList<Object[]>(batchSize);
            try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.log, (String)querySql);){
                Map<Integer, Object> userMap = this.dataSetToMap("SELECT G.FId \"user.id\", CASE WHEN B.ftruename IS NULL THEN G.ftruename WHEN B.ftruename = '' THEN G.ftruename WHEN B.ftruename = ' ' THEN G.ftruename ELSE B.ftruename END \"user.name\" ,B.FLOCALEID \"localeid\" FROM t_SEC_User G LEFT JOIN t_SEC_User_L B ON B.FId=G.FId", DBRoute.base);
                Map<Integer, Object> orgMap = this.dataSetToMap("SELECT H.FId \"org.id\", CASE WHEN E.FName IS NULL THEN H.FName WHEN E.FName = '' THEN H.FName WHEN E.FName = ' ' THEN H.FName ELSE E.FName END \"org.name\",E.FLOCALEID FROM t_ORG_ORG H LEFT JOIN t_ORG_ORG_L E ON E.FId=H.FId", DBRoute.base);
                Map<Integer, Object> appMap = this.dataSetToMap("SELECT C.FId \"bizapp.id\", C.fname \"bizapp.name\",C.FLOCALEID FROM t_meta_bizapp_L C", DBRoute.meta);
                Map<Integer, Object> objMap = this.dataSetToMap("SELECT D.FNumber \"bizobj.id\", D.fname \"bizobj.name\",D.FLOCALEID FROM t_meta_formdesign_L D", DBRoute.meta);
                while (ds.hasNext()) {
                    Object obj;
                    Object[] record = new Object[COLUMN.length];
                    Row row = ds.next();
                    for (int j = 0; j < 12; ++j) {
                        obj = row.get(j);
                        if (j == 1 || j == 3) {
                            record[j] = obj == null ? Integer.valueOf(0) : obj;
                        } else {
                            Object object = record[j] = obj == null ? "" : obj;
                            if (j == 8 && obj == null) {
                                Object opNameObj = row.get(12);
                                Object object2 = record[j] = opNameObj == null ? "" : opNameObj;
                            }
                            if (j == 9 && obj == null) {
                                Object descriptionObj = row.get(13);
                                Object object3 = record[j] = descriptionObj == null ? "" : descriptionObj;
                            }
                            if (j == 10 && obj == null) {
                                Object clientNameObj = row.get(14);
                                Object object4 = record[j] = clientNameObj == null ? "" : clientNameObj;
                            }
                        }
                        if (j != 11) continue;
                        Object userID = row.get(1);
                        Object appId = row.get(2);
                        Object orgId = row.get(3);
                        Object objId = row.get(4);
                        record[11] = this.getName(userMap, userID, obj);
                        record[12] = this.getName(appMap, appId, obj);
                        record[13] = this.getName(objMap, objId, obj);
                        record[14] = this.getName(orgMap, orgId, obj);
                    }
                    for (int k = 15; k < 20; ++k) {
                        obj = row.get(k);
                        record[k] = obj == null ? "" : obj;
                    }
                    writeBuffer.add(record);
                    if (writeBuffer.size() < batchSize) continue;
                    this.batchInsertWithDowngrade(writeBuffer);
                    writeBuffer.clear();
                }
                if (!writeBuffer.isEmpty()) {
                    this.batchInsertWithDowngrade(writeBuffer);
                    writeBuffer.clear();
                }
            }
            this.currentStep = UpgradeStatusEnum.PRE_FINISH;
            this.cache.put(LogUpdateTask.getLogCacheKeyPrefix() + STEP_CACHE_KEY, UpgradeStatusEnum.PRE_FINISH.getValue());
        }
        catch (Exception e) {
            logger.info("\u4e1a\u52a1\u64cd\u4f5c\u65e5\u5fd7\u6570\u636e\u4ece\u8868T_LOG_APP\u5168\u91cf\u540c\u6b65\u81f3\u8868T_LOG_ARCHIVE\u51fa\u73b0\u5f02\u5e38\uff0c\u672c\u6b21\u5347\u7ea7\u64cd\u4f5c\u7ec8\u6b62\uff0c\u540e\u7eed\u8f6c\u50a8\u5347\u7ea7\u5c06\u4e0d\u518d\u6267\u884c\u3002");
            throw e;
        }
        finally {
            logger.info("Dataset \u63d2\u5165T_LOG_ARCHIVE\u7684\u6570\u636e\u91cf\u4e3a\uff1a" + this.syncCount);
        }
    }

    public String calcWriteRecordSql(String[] column, String table) {
        ArrayList<String> valueHolders = new ArrayList<String>(column.length);
        for (int i = 0; i < column.length; ++i) {
            valueHolders.add("?");
        }
        String writeSqlTemplate = "INSERT INTO %s (" + StringUtils.join((Object[])column, (String)",") + ") VALUES(" + StringUtils.join(valueHolders, (String)",") + ")";
        return String.format(writeSqlTemplate, table);
    }

    public int doPostWithRetry(int retryTimes) {
        Exception last = null;
        for (int i = 0; i < retryTimes; ++i) {
            try {
                return this.post();
            }
            catch (Exception e) {
                last = e;
                if (i + 1 >= retryTimes) continue;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        String msg = String.format(ResManager.loadKDString((String)"T_LOG_ARCHIVE\u8868\u56de\u5199\u6570\u636e\u81f3T_LOG_APP\u91cd\u8bd5%1$s\u6b21\u4f9d\u65e7\u5931\u8d25\uff1a%2$s", (String)"LogUpdateTask_0", (String)"bos-log-formplugin", (Object[])new Object[0]), retryTimes, ExceptionUtils.getStackTrace((Throwable)last));
        throw new RuntimeException(msg);
    }

    public void saveUpgradeStartTime() {
        long startTime = System.currentTimeMillis() / 1000L;
        String id = null;
        Long lastTime = null;
        String sql = "SELECT FID,FDUMPEDCOUNT FROM T_LOG_APPSETTING";
        try (DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.log, (String)sql);){
            if (!dataSet.isEmpty()) {
                Row row = dataSet.next();
                id = row.getString(0);
                lastTime = row.getLong(1);
            }
        }
        if (null != id) {
            if (lastTime == null || lastTime <= 0L) {
                String updateSql = "UPDATE T_LOG_APPSETTING SET FDUMPEDCOUNT=" + startTime + " WHERE FID='" + id + "'";
                DB.execute((DBRoute)DBRoute.log, (String)updateSql);
            }
        } else {
            DynamicObject setObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_log_appsetting");
            setObj.set("dumpedcount", (Object)startTime);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{setObj});
        }
    }

    private String getUpgradeStartTime() {
        Long startTime;
        String sql = "SELECT FID,FDUMPEDCOUNT FROM T_LOG_APPSETTING";
        try (DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.log, (String)sql);){
            if (!dataSet.isEmpty()) {
                Row row = dataSet.next();
                startTime = row.getLong(1);
            } else {
                startTime = System.currentTimeMillis();
            }
        }
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochSecond(startTime), ZoneId.systemDefault());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return localDateTime.format(formatter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int post() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime dayAgo = now.minusDays(this.loadLogSetData());
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String sql = "SELECT " + StringUtils.join((Object[])COLUMN, (String)",") + " FROM T_LOG_ARCHIVE WHERE FOPTIME > " + String.format("{ts'%s'}", dayAgo.format(timeFormatter));
        String countSql = "select count(1) c from(" + sql + ") C";
        try (DataSet countDs = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.log, (String)countSql);){
            int count = ((Row)countDs.iterator().next()).getInteger(0);
            logger.info("\u5f85\u8f6c\u50a8Dataset \u603b\u5171\u7684\u6570\u636e\u91cf\u4e3a\uff1a" + count);
            this.cache.put(LogUpdateTask.getLogCacheKeyPrefix() + TOTAL_DUMP_COUNT_CACHE_KEY, String.valueOf(count));
        }
        logger.info("\u6267\u884c\u7684\u67e5\u8be2sql\u8bed\u53e5\u3010" + sql + "\u3011");
        this.writeRecordSql = this.calcWriteRecordSql(COLUMN, "T_LOG_APP");
        logger.info("\u6267\u884c\u7684\u63d2\u5165sql\u8bed\u53e5\u3010" + this.writeRecordSql + "\u3011");
        try {
            var7_8 = null;
            try (QueryTimeout timeout = DB.timeout((int)60000);){
                String deleteSql = "DELETE FROM  T_LOG_APP  WHERE FOPTIME < " + String.format("{ts'%s'}", this.getUpgradeStartTime());
                logger.info("t_log_app \u6570\u636e\u6e05\u7406\u8bed\u53e5\uff1a" + deleteSql);
                DB.execute((DBRoute)DBRoute.log, (String)deleteSql);
                int batchSize = 1000;
                ArrayList<Object[]> writeBuffer = new ArrayList<Object[]>(batchSize);
                try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.log, (String)sql);){
                    while (ds.hasNext()) {
                        Row row = ds.next();
                        Object[] record = new Object[COLUMN.length];
                        for (int j = 0; j < COLUMN.length; ++j) {
                            record[j] = row.get(j);
                        }
                        writeBuffer.add(record);
                        if (writeBuffer.size() < batchSize) continue;
                        this.batchInsert(writeBuffer);
                        writeBuffer.clear();
                    }
                }
                if (!writeBuffer.isEmpty()) {
                    this.batchInsert(writeBuffer);
                    writeBuffer.clear();
                }
                int n = 1;
                return n;
            }
            catch (Throwable throwable) {
                var7_8 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.info("T_LOG_ARCHIVE\u8868\u56de\u5199\u6570\u636e\u81f3T_LOG_APP\u5f02\u5e38\uff0c\u672c\u6b21\u6570\u636e\u5e93\u4e8b\u7269\u56de\u6eda");
            this.cache.put(LogUpdateTask.getLogCacheKeyPrefix() + DUMP_COUNT_CACHE_KEY, "0");
            throw e;
        }
    }

    private void batchInsert(List<Object[]> records) {
        try (TXHandle h = TX.requiresNew((String)"dump_log_data_downgrade_new");){
            DB.executeBatch((DBRoute)DBRoute.log, (String)this.writeRecordSql, records);
            this.syncCount += records.size();
            this.cache.incrBy(LogUpdateTask.getLogCacheKeyPrefix() + DUMP_COUNT_CACHE_KEY, records.size());
        }
        catch (Exception e) {
            if (e.getCause().toString().contains("java.sql.SQLException")) {
                logger.info("dump sql \u8bed\u53e5\u63d2\u5165\u7684\u5f02\u5e38\uff0c\u56de\u6eda\u672c\u6b21\u6279\u91cf\u63d2\u5165\uff0c\u91c7\u7528\u6bcf\u6b21\u5199\u5165\u4e00\u884c\u65b9\u5f0f\u63d0\u4ea4");
                for (Object[] record : records) {
                    try {
                        this.insertOne(record);
                        ++this.syncCount;
                        this.cache.incrBy(LogUpdateTask.getLogCacheKeyPrefix() + DUMP_COUNT_CACHE_KEY, 1);
                    }
                    catch (Exception ignore) {
                        logger.info("dump \u8be5\u6761\u8bb0\u5f55\u4e3a\u810f\u6570\u636e\uff0crecord id \u4e3a\uff1a" + record[0]);
                    }
                }
            }
            throw e;
        }
    }

    private void insertOne(Object[] record) {
        try (TXHandle h = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.log, (String)this.writeRecordSql, (Object[])record);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void batchInsertWithDowngrade(List<Object[]> records) {
        try (TXHandle h = TX.requiresNew((String)"sync_log_data_downgrade_new");){
            DB.executeBatch((DBRoute)DBRoute.log, (String)this.writeRecordSql, records);
            this.syncCount += records.size();
            this.cache.incrBy(LogUpdateTask.getLogCacheKeyPrefix() + SYNC_COUNT_CACHE_KEY, records.size());
        }
        catch (Exception e) {
            if (e.getCause().toString().contains("java.sql.SQLException")) {
                logger.info("sql \u8bed\u53e5\u63d2\u5165\u7684\u5f02\u5e38\uff0c\u56de\u6eda\u672c\u6b21\u6279\u91cf\u63d2\u5165\uff0c\u91c7\u7528\u6bcf\u6b21\u5199\u5165\u4e00\u884c\u65b9\u5f0f\u63d0\u4ea4");
                for (Object[] record : records) {
                    try {
                        this.insertOne(record);
                        ++this.syncCount;
                        this.cache.incrBy(LogUpdateTask.getLogCacheKeyPrefix() + SYNC_COUNT_CACHE_KEY, 1);
                    }
                    catch (Exception ignore) {
                        logger.info("\u8be5\u6761\u8bb0\u5f55\u4e3a\u810f\u6570\u636e\uff0crecord id \u4e3a\uff1a" + record[0]);
                    }
                }
            }
            throw e;
        }
    }

    private Long loadLogSetData() {
        String sql = "SELECT FAPPLOGRETAINDAYS FROM T_LOG_APPSETTING";
        try (DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.log, (String)sql);){
            if (!dataSet.isEmpty()) {
                Row row = dataSet.next();
                Long retainDay = row.getLong(0);
                Long l = retainDay != null && retainDay > 0L ? retainDay : 180L;
                return l;
            }
        }
        return 180L;
    }

    public static String getLogCacheKeyPrefix() {
        return RequestContext.get().getTenantId() + "-" + RequestContext.get().getAccountId() + "-";
    }

    public void syncBakData() {
        List<String> bakTableColumns = this.getBakColumns();
        if (bakTableColumns == null || bakTableColumns.size() == 0) {
            logger.error("\u4e0a\u673a\u64cd\u4f5c\u65e5\u5fd7\u5386\u53f2\u6570\u636e\u8fc1\u79fb\u3010T_LOG_APP_BAK\u8868\u4e0d\u5b58\u5728\u3011");
            return;
        }
        ArrayList<String> searchColumn = new ArrayList<String>(bakTableColumns.size());
        for (String column : bakTableColumns) {
            searchColumn.add("A." + column);
        }
        this.writeRecordSql = this.calcWriteRecordSql(COLUMN, "T_LOG_APP");
        String querySql = "SELECT " + String.join((CharSequence)",", searchColumn) + ",B.FOPNAME FOPNAMEX,B.FOPDESCRIPTION FOPDESCRIPTIONX,B.FCLIENTNAME FCLIENTNAMEX,B.FLOCALEID  FROM T_LOG_APP_BAK A LEFT JOIN T_LOG_APP_L B ON A.FID=B.FID";
        logger.info("\u67e5\u8be2\u7684t_log_app_bak sql :" + querySql);
        int batchSize = 1000;
        try {
            ArrayList<Object[]> writeBuffer = new ArrayList<Object[]>(batchSize);
            try {
                Map<Integer, Object> userMap = this.dataSetToMap("SELECT G.FId \"user.id\", CASE WHEN B.ftruename IS NULL THEN G.ftruename WHEN B.ftruename = '' THEN G.ftruename WHEN B.ftruename = ' ' THEN G.ftruename ELSE B.ftruename END \"user.name\" ,B.FLOCALEID \"localeid\" FROM t_SEC_User G LEFT JOIN t_SEC_User_L B ON B.FId=G.FId", DBRoute.base);
                Map<Integer, Object> orgMap = this.dataSetToMap("SELECT H.FId \"org.id\", CASE WHEN E.FName IS NULL THEN H.FName WHEN E.FName = '' THEN H.FName WHEN E.FName = ' ' THEN H.FName ELSE E.FName END \"org.name\",E.FLOCALEID FROM t_ORG_ORG H LEFT JOIN t_ORG_ORG_L E ON E.FId=H.FId", DBRoute.base);
                Map<Integer, Object> appMap = this.dataSetToMap("SELECT C.FId \"bizapp.id\", C.fname \"bizapp.name\",C.FLOCALEID FROM t_meta_bizapp_L C", DBRoute.meta);
                Map<Integer, Object> objMap = this.dataSetToMap("SELECT D.FNumber \"bizobj.id\", D.fname \"bizobj.name\",D.FLOCALEID FROM t_meta_formdesign_L D", DBRoute.meta);
                try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.log, (String)querySql);){
                    while (ds.hasNext()) {
                        Object[] record = new Object[COLUMN.length];
                        Row row = ds.next();
                        try {
                            for (int i = 0; i < COLUMN.length; ++i) {
                                Object localeId;
                                String column = COLUMN[i];
                                Object value = null;
                                if (this.contain(bakTableColumns, column.toLowerCase())) {
                                    value = row.get(column.toLowerCase());
                                }
                                if (i == 1 || i == 3) {
                                    record[i] = value == null ? Integer.valueOf(0) : value;
                                    continue;
                                }
                                Object object = record[i] = value == null ? "" : value;
                                if (i == 8 && this.isObjectEmpty(value)) {
                                    Object opNameObj = row.get("fopnamex");
                                    Object object2 = record[i] = opNameObj == null ? "" : opNameObj;
                                }
                                if (i == 9 && this.isObjectEmpty(value)) {
                                    Object descriptionObj = row.get("fopdescriptionx");
                                    Object object3 = record[i] = descriptionObj == null ? "" : descriptionObj;
                                }
                                if (i == 10 && this.isObjectEmpty(value)) {
                                    Object clientNameObj = row.get("fclientnamex");
                                    Object object4 = record[i] = clientNameObj == null ? "" : clientNameObj;
                                }
                                if (i == 11) {
                                    localeId = row.get("flocaleid");
                                    Object userID = row.get("fuserid");
                                    record[i] = this.getName(userMap, userID, localeId);
                                }
                                if (i == 12) {
                                    localeId = row.get("flocaleid");
                                    Object appId = row.get("fbizappid");
                                    record[i] = this.getName(appMap, appId, localeId);
                                }
                                if (i == 13) {
                                    localeId = row.get("flocaleid");
                                    Object objId = row.get("fbizobjid");
                                    record[i] = this.getName(objMap, objId, localeId);
                                }
                                if (i != 14) continue;
                                localeId = row.get("flocaleid");
                                Object orgId = row.get("forgid");
                                record[i] = this.getName(orgMap, orgId, localeId);
                            }
                            writeBuffer.add(record);
                        }
                        catch (Exception ignore) {
                            logger.error((Throwable)ignore);
                        }
                        if (writeBuffer.size() < batchSize) continue;
                        this.batchInsertWithDowngrade(writeBuffer);
                        writeBuffer.clear();
                    }
                }
                if (!writeBuffer.isEmpty()) {
                    this.batchInsertWithDowngrade(writeBuffer);
                    writeBuffer.clear();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Exception e) {
            logger.info("\u4e1a\u52a1\u64cd\u4f5c\u65e5\u5fd7\u6570\u636e\u4ece\u8868T_LOG_APP_BAK\u5168\u91cf\u540c\u6b65\u81f3\u8868T_LOG_APP\u51fa\u73b0\u5f02\u5e38\uff0c\u672c\u6b21\u5347\u7ea7\u64cd\u4f5c\u7ec8\u6b62\uff0c\u540e\u7eed\u8f6c\u50a8\u5347\u7ea7\u5c06\u4e0d\u518d\u6267\u884c\u3002");
            throw e;
        }
        finally {
            logger.info("Dataset \u63d2\u5165T_LOG_ARCHIVE\u7684\u6570\u636e\u91cf\u4e3a\uff1a" + this.syncCount);
        }
    }

    public List<String> getBakColumns() {
        boolean exist = DB.exitsTable((DBRoute)DBRoute.log, (String)"T_LOG_APP_BAK");
        if (exist) {
            return DB.getColumnNames((DBRoute)DBRoute.log, (String)"T_LOG_APP_BAK");
        }
        return null;
    }

    public boolean contain(List<String> columns, String target) {
        for (String column : columns) {
            if (!target.equalsIgnoreCase(column)) continue;
            return true;
        }
        return false;
    }

    public boolean isObjectEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        try {
            return StringUtils.isEmpty((CharSequence)String.valueOf(obj).trim());
        }
        catch (Exception ignore) {
            return false;
        }
    }

    public static enum UpgradeStatusEnum {
        UPGRADING("0"),
        PRE_FINISH("2"),
        FINISH("1"),
        FAILED("-1");

        private String value;

        private UpgradeStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

