/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.formplugin;

import java.text.SimpleDateFormat;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;

public class LogUpgradeProgressPlugin
extends AbstractFormPlugin {
    private static final String ICON_INIT = "image_init";
    private static final String ICON_SUCCESS = "image_success";
    private static final String ICON_FAIL = "image_fail";
    private static final String ICON_UPGRADING = "image_upgrading";
    private static final String LABEL_STATUS = "upgrade_status";
    private static final String LABEL_STEP = "current_step";
    private static final String LABEL_TIME = "time_range";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map<String, Object> upgradeInfo = this.getUpgradeInfo();
        this.updateIcon(upgradeInfo);
        this.updateDetail(upgradeInfo);
    }

    private void updateIcon(Map<String, Object> upgradeInfo) {
        Object value;
        String status = null;
        if (upgradeInfo != null && upgradeInfo.size() > 0 && (value = upgradeInfo.get("status")) != null) {
            status = String.valueOf(value);
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{ICON_SUCCESS});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{ICON_INIT});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{ICON_FAIL});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{ICON_UPGRADING});
        Label label = (Label)this.getView().getControl(LABEL_STATUS);
        if ("1".equals(status)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ICON_SUCCESS});
            label.setText(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f", (String)"LogUpgradeProgressPlugin_3", (String)"bos-log-formplugin", (Object[])new Object[0]));
        } else if ("-1".equals(status)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ICON_FAIL});
            label.setText(ResManager.loadKDString((String)"\u5347\u7ea7\u5931\u8d25", (String)"LogUpgradeProgressPlugin_2", (String)"bos-log-formplugin", (Object[])new Object[0]));
        } else if ("0".equals(status)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ICON_UPGRADING});
            label.setText(ResManager.loadKDString((String)"\u5347\u7ea7\u4e2d", (String)"LogUpgradeProgressPlugin_1", (String)"bos-log-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ICON_INIT});
            label.setText(ResManager.loadKDString((String)"\u5f85\u5347\u7ea7", (String)"LogUpgradeProgressPlugin_8", (String)"bos-log-formplugin", (Object[])new Object[0]));
        }
    }

    private void updateDetail(Map<String, Object> upgradeInfo) {
        Label labelStep = (Label)this.getView().getControl(LABEL_STEP);
        Label labelTime = (Label)this.getView().getControl(LABEL_TIME);
        if (upgradeInfo != null && upgradeInfo.size() > 0) {
            Object status = upgradeInfo.get("status");
            if (status == null) {
                labelStep.setText(ResManager.loadKDString((String)"\u65e0", (String)"LogUpgradeProgressPlugin_9", (String)"bos-log-formplugin", (Object[])new Object[0]));
                labelTime.setText(ResManager.loadKDString((String)"\u65e0", (String)"LogUpgradeProgressPlugin_9", (String)"bos-log-formplugin", (Object[])new Object[0]));
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat(ResManager.loadKDString((String)"yyyy\u5e74MM\u6708", (String)"LogUpgradeProgressPlugin_7", (String)"bos-log-formplugin", (Object[])new Object[0]));
                if ("1".equals(String.valueOf(status))) {
                    labelStep.setText(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"LogUpgradeProgressPlugin_10", (String)"bos-log-formplugin", (Object[])new Object[0]));
                    Object upgradeStartTime = upgradeInfo.get("upgradeStartTime");
                    StringBuilder time = new StringBuilder(ResManager.loadKDString((String)"\u521d\u59cb\u65f6\u95f4", (String)"LogUpgradeProgressPlugin_11", (String)"bos-log-formplugin", (Object[])new Object[0]));
                    time.append("-");
                    long endTime = Long.parseLong(String.valueOf(upgradeStartTime));
                    time.append(sdf.format(endTime * 1000L));
                    labelTime.setText(time.toString());
                } else {
                    Object stepValue = upgradeInfo.get("step");
                    if (stepValue != null) {
                        String step = String.valueOf(stepValue);
                        Long start = null;
                        Long end = null;
                        Object tempTime = null;
                        Object upgradeStartTime = upgradeInfo.get("upgradeStartTime");
                        if ("1".equals(step)) {
                            labelStep.setText(ResManager.loadKDString((String)"\u6570\u636e\u8fc1\u79fb", (String)"LogUpgradeProgressPlugin_4", (String)"bos-log-formplugin", (Object[])new Object[0]));
                            boolean exist = DB.exitsTable((DBRoute)DBRoute.log, (String)"T_LOG_APP_BAK");
                            tempTime = !exist ? upgradeInfo.get("searchAppTime") : upgradeInfo.get("searchAppBakTime");
                        } else if ("2".equals(step)) {
                            labelStep.setText(ResManager.loadKDString((String)"\u6570\u636e\u6e05\u7406", (String)"LogUpgradeProgressPlugin_5", (String)"bos-log-formplugin", (Object[])new Object[0]));
                            tempTime = upgradeInfo.get("deleteAppTime");
                        } else if ("3".equals(step)) {
                            labelStep.setText(ResManager.loadKDString((String)"\u6570\u636e\u8f6c\u50a8", (String)"LogUpgradeProgressPlugin_6", (String)"bos-log-formplugin", (Object[])new Object[0]));
                            tempTime = upgradeInfo.get("searchArchiveTime");
                        } else {
                            labelStep.setText(ResManager.loadKDString((String)"\u65e0", (String)"LogUpgradeProgressPlugin_9", (String)"bos-log-formplugin", (Object[])new Object[0]));
                        }
                        if (tempTime != null && Long.parseLong(String.valueOf(tempTime)) > 0L) {
                            start = Long.parseLong(String.valueOf(tempTime));
                            end = start - 2592000L;
                        } else if (upgradeStartTime != null) {
                            start = Long.parseLong(String.valueOf(upgradeStartTime));
                            end = start - 2592000L;
                        }
                        if (start != null && start > 0L) {
                            String startTimeValue = sdf.format(start * 1000L);
                            String endTimeValue = sdf.format(end * 1000L);
                            labelTime.setText(endTimeValue + "-" + startTimeValue);
                        }
                    }
                }
            }
        } else {
            labelStep.setText(ResManager.loadKDString((String)"\u65e0", (String)"LogUpgradeProgressPlugin_9", (String)"bos-log-formplugin", (Object[])new Object[0]));
            labelTime.setText(ResManager.loadKDString((String)"\u65e0", (String)"LogUpgradeProgressPlugin_9", (String)"bos-log-formplugin", (Object[])new Object[0]));
        }
    }

    public Map<String, Object> getUpgradeInfo() {
        String sql = "SELECT FUPGRADESTATUS,FCURRENTSTEP,FSEARCHAPPTIME,FSEARCHAPPBAKTIME,FDELETEAPPTIME, FSEARCHARCHIVETIME,FDUMPEDCOUNT FROM T_LOG_APPSETTING";
        try (DataSet dataSet = DB.queryDataSet((String)LogUpgradeProgressPlugin.class.getName(), (DBRoute)DBRoute.log, (String)sql);){
            if (!dataSet.isEmpty()) {
                HashMap<String, Object> result = new HashMap<String, Object>(16);
                Row row = dataSet.next();
                String status = row.getString(0);
                String step = row.getString(1);
                Long searchAppTime = row.getLong(2);
                Long searchAppBakTime = row.getLong(3);
                Long deleteAppTime = row.getLong(4);
                Long searchArchiveTime = row.getLong(5);
                Long upgradeStartTime = row.getLong(6);
                result.put("status", status);
                result.put("step", step);
                result.put("searchAppTime", searchAppTime);
                result.put("searchAppBakTime", searchAppBakTime);
                result.put("deleteAppTime", deleteAppTime);
                result.put("searchArchiveTime", searchArchiveTime);
                result.put("upgradeStartTime", upgradeStartTime);
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            Map<String, Object> map = null;
            return map;
        }
    }
}

