/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.formplugin;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.logbill.LogBillListPlugin;
import kd.bos.log.formplugin.LoginLogListDataProvider;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.util.SessionComUtil;
import kd.bos.orm.query.QFilter;
import org.apache.commons.lang3.StringUtils;

public class LoginLogListPluginV2
extends LogBillListPlugin {
    private static final String USERID = "userId";
    protected static Map<String, Map<String, String>> clientType;
    protected static Map<String, Map<String, String>> thirdAppType;
    private static Log logger;

    public void setFilter(SetFilterEvent e) {
        LoginLogListPluginV2.initClient();
        List qFilters = e.getQFilters();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter != null) {
            String userId = (String)formShowParameter.getCustomParam(USERID);
            String limitDate = (String)formShowParameter.getCustomParam("limitDate");
            QFilter filter = null;
            if (StringUtils.isNotEmpty((CharSequence)userId)) {
                filter = new QFilter("userid", "=", (Object)Long.parseLong(userId));
            }
            if (StringUtils.isNotBlank((CharSequence)limitDate)) {
                Date date = this.addDateFilter(Integer.parseInt(limitDate));
                QFilter qFilter = new QFilter("opdate", ">=", (Object)date);
                if (filter != null) {
                    filter.and(qFilter);
                } else {
                    filter = qFilter;
                }
            }
            qFilters.add(filter);
            e.setOrderBy("");
        }
    }

    private Date addDateFilter(int limitDate) {
        try {
            LocalDate today = LocalDate.now();
            LocalDate nDaysAgo = today.minusDays(limitDate);
            Instant instant = nDaysAgo.atStartOfDay(ZoneId.systemDefault()).toInstant();
            Date date = Date.from(instant);
            return date;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    protected static void initClient() {
        clientType = SessionComUtil.getClients((String)"CLIENT_TYPE");
        thirdAppType = SessionComUtil.getClients((String)"THIRD_APP_TYPE");
    }

    public static String getExtendClientName(Map<String, String> client) {
        if (null != client) {
            return client.get(RequestContext.get().getLang().name());
        }
        return null;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new LoginLogListDataProvider(this.getView()));
    }

    static {
        logger = LogFactory.getLog(LoginLogListPluginV2.class);
    }
}

