/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.formplugin;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.redis.RedisSessionlessCache;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Button;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.log.formplugin.LogUpdateTask;
import kd.bos.threads.ThreadPools;
import org.apache.commons.lang3.StringUtils;

public class UpgradeProgressPlugin
extends AbstractFormPlugin {
    private static final String PROGRESSBAR = "progressbarap";
    private static final String BUTTON_RETRY = "retry";
    private static final String BUTTON_CLOSE = "close";
    private static final String ICON_SYNC_SUCCESS = "syncsuccess";
    private static final String ICON_SYNC_FAIL = "syncfail";
    private static final String ICON_SYNCING = "syncing";
    private static final String LABEL_SYNC_ERROR = "syncerror";
    private static final String ICON_DUMP_SUCCESS = "dumpsuccess";
    private static final String ICON_DUMP_FAIL = "dumpfail";
    private static final String ICON_DUMPING = "dumping";
    private static final String LABEL_DUMP_ERROR = "dumperror";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateView(null);
        this.updateButton(false);
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBAR);
        progressBar.start();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ICON_SYNC_FAIL, BUTTON_RETRY, LABEL_SYNC_ERROR, LABEL_DUMP_ERROR});
        final ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBAR);
        progressBar.addProgressListener(new ProgresssListener(){

            public void onProgress(ProgressEvent progressEvent) {
                RedisSessionlessCache cache = (RedisSessionlessCache)CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("bos_log_sync", new DistributeCacheHAPolicy(true, true));
                String status = cache.get(LogUpdateTask.getLogCacheKeyPrefix() + "bos-base-log-upgrading");
                int percent = UpgradeProgressPlugin.this.getProgress(cache);
                if (LogUpdateTask.UpgradeStatusEnum.UPGRADING.getValue().equals(status)) {
                    String step = cache.get(LogUpdateTask.getLogCacheKeyPrefix() + "bos-base-log-step");
                    UpgradeProgressPlugin.this.updateView(LogUpdateTask.UpgradeStatusEnum.UPGRADING);
                    if (LogUpdateTask.UpgradeStatusEnum.PRE_FINISH.getValue().equals(step)) {
                        UpgradeProgressPlugin.this.updateView(LogUpdateTask.UpgradeStatusEnum.PRE_FINISH);
                    }
                    percent = percent >= 100 ? 99 : percent;
                    this.setProgress(progressEvent, percent);
                } else if (LogUpdateTask.UpgradeStatusEnum.FINISH.getValue().equals(status)) {
                    UpgradeProgressPlugin.this.updateView(LogUpdateTask.UpgradeStatusEnum.FINISH);
                    UpgradeProgressPlugin.this.updateButton(false);
                    this.setProgress(progressEvent, 100);
                    HashMap<String, LocaleString> map = new HashMap<String, LocaleString>(16);
                    map.put("text", new LocaleString(ResManager.loadKDString((String)"\u5173\u95ed", (String)"UpgradeProgressPlugin_0", (String)"bos-log-formplugin", (Object[])new Object[0])));
                    UpgradeProgressPlugin.this.getView().updateControlMetadata(UpgradeProgressPlugin.BUTTON_CLOSE, map);
                } else if (LogUpdateTask.UpgradeStatusEnum.FAILED.getValue().equals(status)) {
                    percent = percent >= 100 ? 99 : percent;
                    this.setProgress(progressEvent, percent);
                    UpgradeProgressPlugin.this.updateView(LogUpdateTask.UpgradeStatusEnum.FAILED);
                    String step = cache.get(LogUpdateTask.getLogCacheKeyPrefix() + "bos-base-log-step");
                    if (LogUpdateTask.UpgradeStatusEnum.PRE_FINISH.getValue().equals(step)) {
                        UpgradeProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{UpgradeProgressPlugin.ICON_SYNC_FAIL});
                        UpgradeProgressPlugin.this.getView().setVisible(Boolean.valueOf(true), new String[]{UpgradeProgressPlugin.ICON_SYNC_SUCCESS});
                        UpgradeProgressPlugin.this.updateErrorView(false, cache.get(LogUpdateTask.getLogCacheKeyPrefix() + "bos-base-log-failed-message"));
                    } else {
                        UpgradeProgressPlugin.this.getView().setVisible(Boolean.valueOf(false), new String[]{UpgradeProgressPlugin.ICON_DUMP_FAIL});
                        UpgradeProgressPlugin.this.updateErrorView(true, cache.get(LogUpdateTask.getLogCacheKeyPrefix() + "bos-base-log-failed-message"));
                    }
                    UpgradeProgressPlugin.this.updateButton(true);
                    progressBar.stop();
                }
            }

            private void setProgress(ProgressEvent progress, int per) {
                progress.setProgress(per);
                UpgradeProgressPlugin.this.getModel().setValue("percent", (Object)(per + "%"));
            }
        });
    }

    private int getProgress(RedisSessionlessCache cache) {
        int percent = 0;
        String totalObj = cache.get(LogUpdateTask.getLogCacheKeyPrefix() + "bos-base-log-total-sync-count");
        String currentObj = cache.get(LogUpdateTask.getLogCacheKeyPrefix() + "bos-base-log-sync-count");
        if (StringUtils.isNotEmpty((CharSequence)totalObj) && StringUtils.isNotEmpty((CharSequence)currentObj)) {
            int total = Integer.parseInt(totalObj);
            int current = Integer.parseInt(currentObj);
            percent = UpgradeProgressPlugin.calProgress(current, total);
            if (cache.contains(LogUpdateTask.getLogCacheKeyPrefix() + "bos-base-log-dump-count")) {
                String dumpTotalObj = cache.get(LogUpdateTask.getLogCacheKeyPrefix() + "bos-base-log-total-dump-count");
                String dumpCurrentObj = cache.get(LogUpdateTask.getLogCacheKeyPrefix() + "bos-base-log-dump-count");
                if (StringUtils.isNotEmpty((CharSequence)dumpTotalObj) && StringUtils.isNotEmpty((CharSequence)dumpCurrentObj)) {
                    int dumpTotal = Integer.parseInt(dumpTotalObj);
                    int dumpCurrent = Integer.parseInt(dumpCurrentObj);
                    percent += UpgradeProgressPlugin.calProgress(dumpCurrent, dumpTotal);
                }
            }
        }
        return percent;
    }

    private void updateButton(boolean retry) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BUTTON_CLOSE});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BUTTON_RETRY});
        if (retry) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BUTTON_RETRY});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BUTTON_CLOSE});
        }
    }

    private void updateView(LogUpdateTask.UpgradeStatusEnum step) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{ICON_SYNC_SUCCESS});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{ICON_SYNC_FAIL});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{ICON_DUMP_SUCCESS});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{ICON_DUMP_FAIL});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{ICON_SYNCING});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{ICON_DUMPING});
        if (LogUpdateTask.UpgradeStatusEnum.UPGRADING == step) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ICON_SYNCING});
        } else if (LogUpdateTask.UpgradeStatusEnum.PRE_FINISH == step) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ICON_SYNC_SUCCESS});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ICON_DUMPING});
        } else if (LogUpdateTask.UpgradeStatusEnum.FINISH == step) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ICON_SYNC_SUCCESS});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ICON_DUMP_SUCCESS});
        } else if (LogUpdateTask.UpgradeStatusEnum.FAILED == step) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ICON_SYNC_FAIL});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ICON_DUMP_FAIL});
        }
    }

    private void updateErrorView(boolean isSyncError, String errorMsg) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{LABEL_SYNC_ERROR});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{LABEL_DUMP_ERROR});
        if (errorMsg != null) {
            if (isSyncError) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{LABEL_SYNC_ERROR});
                this.getModel().setValue(LABEL_SYNC_ERROR, (Object)errorMsg);
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{LABEL_DUMP_ERROR});
                this.getModel().setValue(LABEL_DUMP_ERROR, (Object)errorMsg);
            }
        }
    }

    private static int calProgress(int dividend, int divisor) {
        BigDecimal base = new BigDecimal(50);
        BigDecimal a = new BigDecimal(dividend);
        BigDecimal b = new BigDecimal(divisor);
        BigDecimal result = a.divide(b, 3, 3);
        BigDecimal last = result.multiply(base);
        return last.intValue();
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Button && BUTTON_RETRY.equals(key = ((Button)source).getKey())) {
            this.updateButton(false);
            this.updateErrorView(false, null);
            this.updateView(null);
            RedisSessionlessCache cache = (RedisSessionlessCache)CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("bos_log_sync", new DistributeCacheHAPolicy(true, true));
            cache.put(LogUpdateTask.getLogCacheKeyPrefix() + "bos-base-log-upgrading", LogUpdateTask.UpgradeStatusEnum.UPGRADING.getValue(), 2, TimeUnit.DAYS);
            ThreadPools.executeOnceIncludeRequestContext((String)"upgrade-log", (Runnable)new LogUpdateTask());
            ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBAR);
            progressBar.start();
        }
    }
}

