/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.resource.cache.CacheKeyUtil;
import kd.bos.form.IPageCache;
import org.apache.commons.lang3.StringUtils;

public class EsSearchPluginCacheUtils {
    private static final String PREVIOUS_KEY = "previous";
    private static final String NEXT_KEY = "next";
    private static final String CURRENT_KEY = "current";

    public static String searchConditionKey() {
        return CacheKeyUtil.getAcctId() + "log-search-elasticsearch";
    }

    public static String propertiesCacheKey() {
        return CacheKeyUtil.getAcctId() + "log-search-elasticsearch-properties";
    }

    public static String propertiesSearchAfterKey() {
        return CacheKeyUtil.getAcctId() + "log-search-elasticsearch-search-after-properties";
    }

    public static String propertiesPageIndexKey() {
        return CacheKeyUtil.getAcctId() + "log-search-elasticsearch-page-index-properties";
    }

    public static String propertiesTotalPageKey() {
        return CacheKeyUtil.getAcctId() + "log-search-elasticsearch-page-total-properties";
    }

    public static void initSearchAfterToCache(IPageCache cache) {
        JSONObject data = new JSONObject();
        data.put(CURRENT_KEY, (Object)new Object[0]);
        data.put(NEXT_KEY, (Object)new Object[0]);
        JSONObject previous = new JSONObject();
        previous.put("1", (Object)new Object[0]);
        data.put(PREVIOUS_KEY, (Object)previous);
        cache.put(EsSearchPluginCacheUtils.propertiesSearchAfterKey(), data.toJSONString());
    }

    public static void updateSearchAfterToCache(IPageCache cache, Object[] current, Object[] next) {
        JSONObject previous;
        JSONObject data = new JSONObject();
        data.put(CURRENT_KEY, (Object)current);
        data.put(NEXT_KEY, (Object)next);
        String cacheValue = cache.get(EsSearchPluginCacheUtils.propertiesSearchAfterKey());
        if (StringUtils.isNotEmpty((CharSequence)cacheValue)) {
            JSONObject temp = JSON.parseObject((String)cacheValue);
            previous = temp.getJSONObject(PREVIOUS_KEY);
            long currentPage = EsSearchPluginCacheUtils.getCurrentPageIndex(cache);
            previous.put(String.valueOf(currentPage + 1L), (Object)current);
        } else {
            previous = new JSONObject();
            previous.put(String.valueOf(EsSearchPluginCacheUtils.getCurrentPageIndex(cache)), (Object)new Object[0]);
        }
        data.put(PREVIOUS_KEY, (Object)previous);
        cache.put(EsSearchPluginCacheUtils.propertiesSearchAfterKey(), data.toJSONString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object[] getSearchAfterFromCache(IPageCache cache, Step currentStep) {
        String cacheValue = cache.get(EsSearchPluginCacheUtils.propertiesSearchAfterKey());
        if (Step.INIT == currentStep) {
            return new Object[0];
        }
        if (Step.NEXT == currentStep) {
            if (!StringUtils.isNotEmpty((CharSequence)cacheValue)) return new Object[0];
            JSONObject temp = JSON.parseObject((String)cacheValue);
            JSONArray array = temp.getJSONArray(NEXT_KEY);
            if (array == null || array.size() <= 0) return new Object[0];
            Object[] searchAfter = new Object[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                searchAfter[i] = array.get(i);
            }
            return searchAfter;
        }
        if (Step.PREVIOUS == currentStep) {
            long index;
            if (!StringUtils.isNotEmpty((CharSequence)cacheValue)) return new Object[0];
            JSONObject temp = JSON.parseObject((String)cacheValue);
            JSONObject previous = temp.getJSONObject(PREVIOUS_KEY);
            JSONArray array = previous.getJSONArray(String.valueOf(index = (long)EsSearchPluginCacheUtils.getCurrentPageIndex(cache) + 1L));
            if (array == null || array.size() <= 0) return new Object[0];
            Object[] searchAfter = new Object[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                searchAfter[i] = array.get(i);
            }
            return searchAfter;
        }
        if (!StringUtils.isNotEmpty((CharSequence)cacheValue)) return new Object[0];
        JSONObject temp = JSON.parseObject((String)cacheValue);
        JSONArray array = temp.getJSONArray(CURRENT_KEY);
        if (array == null || array.size() <= 0) return new Object[0];
        Object[] searchAfter = new Object[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            searchAfter[i] = array.get(i);
        }
        return searchAfter;
    }

    public static int getCurrentPageIndex(IPageCache cache) {
        String temp = cache.get(EsSearchPluginCacheUtils.propertiesPageIndexKey());
        if (StringUtils.isNotEmpty((CharSequence)temp)) {
            return Integer.parseInt(temp);
        }
        return 1;
    }

    public static void updatePageIndex(IPageCache cache, Step currentStep) {
        int currentPage;
        if (Step.INIT == currentStep) {
            currentPage = 1;
        } else if (Step.NEXT == currentStep) {
            int last = EsSearchPluginCacheUtils.getCurrentPageIndex(cache);
            currentPage = last + 1;
        } else {
            int last = EsSearchPluginCacheUtils.getCurrentPageIndex(cache);
            currentPage = last - 1;
        }
        cache.put(EsSearchPluginCacheUtils.propertiesPageIndexKey(), String.valueOf(currentPage));
    }

    public static void saveTotalPageToCache(IPageCache cache, long totalPage) {
        cache.put(EsSearchPluginCacheUtils.propertiesTotalPageKey(), String.valueOf(totalPage));
    }

    public static long getTotalPageFromCache(IPageCache cache) {
        String total = cache.get(EsSearchPluginCacheUtils.propertiesTotalPageKey());
        if (StringUtils.isNotEmpty((CharSequence)total)) {
            return Long.parseLong(total);
        }
        return 0L;
    }

    public static enum Step {
        INIT(1),
        NEXT(2),
        PREVIOUS(3),
        CURRENT(4);

        private int value;

        private Step(int value) {
            this.value = value;
        }
    }
}

