/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.RowUtil;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.RowFactory;
import kd.bos.algo.util.ArrayKey;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.list.SummaryResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.list.query.Mapper;
import kd.bos.list.query.QueryUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.util.DisCardUtil;
import kd.bos.util.StringUtils;

public class LogOperactionListutils {
    public static List<Row> dsToRows(String pageId, DataSet ds, QueryBuilder qb) {
        boolean isSum;
        HashMap<String, SummaryResult> sumResultsMap = new HashMap<String, SummaryResult>(16);
        boolean bl = isSum = !qb.getSumFields().isEmpty();
        if (isSum) {
            for (ListField sumField : qb.getSumFields()) {
                SummaryResult summaryResult = new SummaryResult(sumField.getListFieldKey().replace('.', '_'), new BigDecimal("0"), sumField.getSummary());
                sumResultsMap.put(sumField.getListFieldKey().replace('.', '_'), summaryResult);
            }
        }
        int pkSize = qb.getPkFields().size();
        ArrayList<Row> dealRows = new ArrayList<Row>();
        Object prePK = null;
        int seqIndex = 1;
        RowMeta dsRowMeta = ds.getRowMeta();
        QueryUtils queryUtils = new QueryUtils(qb);
        int n = dsRowMeta.getFieldCount();
        HashMap<String, Mapper> mappers = new HashMap<String, Mapper>();
        for (int i = 0; i < n; ++i) {
            DynamicProperty property = qb.getReturnEntityType().getProperty(dsRowMeta.getField(i).getName());
            if (property == null) continue;
            Mapper mapper = new Mapper();
            mapper.index = i;
            mapper.property = property instanceof BasedataProp ? ((BasedataProp)property).getRefIdProp() : property;
            mappers.put(dsRowMeta.getField(i).getName().toLowerCase(), mapper);
        }
        for (Row row : ds) {
            Row perRow = RowUtil.persist((Row)row);
            if (isSum) {
                queryUtils.addRowSummaryResult(perRow, mappers, sumResultsMap);
            }
            Row seqRow = null;
            String sqFieldStr = qb.getSeqField();
            if (StringUtils.isEmpty((String)sqFieldStr)) {
                seqRow = perRow;
            } else if (pkSize > 1 && qb.isMergeRow()) {
                String pkStr = qb.getEntityType().getPrimaryKey().getName();
                Object curPK = perRow.get(pkStr);
                if (prePK != null && !curPK.equals(prePK)) {
                    ++seqIndex;
                }
                prePK = curPK;
                seqRow = LogOperactionListutils.rowAddField(perRow, qb.getSeqField(), (DataType)DataType.IntegerType, seqIndex);
            } else {
                seqRow = LogOperactionListutils.rowAddField(perRow, qb.getSeqField(), (DataType)DataType.IntegerType, seqIndex);
                ++seqIndex;
            }
            dealRows.add(seqRow);
        }
        return dealRows;
    }

    public static DynamicObjectCollection cacheDataSet(String algoKey, String pageId, QueryBuilder queryBuilder, DataSet ds) {
        List<Row> dsLs = LogOperactionListutils.dsToRows(pageId, ds, queryBuilder);
        DynamicObjectCollection collection = LogOperactionListutils.getDynObjByPks(algoKey, queryBuilder, dsLs);
        return collection;
    }

    public static Row rowAddField(Row row, String fieldName, DataType fieldType, Object fieldValue) {
        RowMeta rowMeta = ((AbstractRow)row).getRowMeta();
        RowMeta newRowMeta = LogOperactionListutils.rowMetaAddField(rowMeta, fieldName, fieldType);
        Object[] rowValues = RowUtil.toArray((Row)row);
        int len = rowValues.length;
        Object[] newValues = new Object[len + 1];
        System.arraycopy(rowValues, 0, newValues, 0, len);
        newValues[len] = fieldValue;
        return RowFactory.createRow((RowMeta)newRowMeta, (Object[])newValues);
    }

    public static RowMeta rowMetaAddField(RowMeta rowMeta, String fieldName, DataType fieldType) {
        int count = rowMeta.getFieldCount();
        String[] fieldNames = new String[count + 1];
        DataType[] dataTypes = new DataType[count + 1];
        List dsDataType = rowMeta.getTypes();
        for (int i = 0; i < count; ++i) {
            fieldNames[i] = rowMeta.getFieldName(i);
            dataTypes[i] = (DataType)dsDataType.get(i);
        }
        fieldNames[count] = fieldName;
        dataTypes[count] = fieldType;
        return RowMetaFactory.createRowMeta((String[])fieldNames, (DataType[])dataTypes);
    }

    public static Object[] getPksValue(List<ListField> pkFields, Row row) {
        ArrayList<Object> pkValues = new ArrayList<Object>();
        for (ListField field : pkFields) {
            String pk = field.getFieldName();
            Object pkObj = row.get(pk);
            if (pkObj == null || "0".equals(pkObj + "")) continue;
            pkValues.add(pkObj);
        }
        return pkValues.toArray();
    }

    public static DynamicObjectCollection getDynObjByPks(String algoKey, QueryBuilder qb, List<Row> rows) {
        Object filterPk;
        final List pkFields = qb.getPkFields();
        int pkSize = pkFields.size();
        int rowSize = rows.size();
        QFilter[] filters = new QFilter[pkSize];
        int index = 0;
        for (ListField field : pkFields) {
            boolean entryHaveNull = false;
            ArrayList<Object> pkObjValues = new ArrayList<Object>(rowSize);
            filterPk = field.getFieldName();
            for (int i = 0; i < rowSize; ++i) {
                Object object = rows.get(i).get((String)filterPk);
                if (object == null || "0".equals(object + "")) {
                    entryHaveNull = true;
                    continue;
                }
                pkObjValues.add(rows.get(i).get((String)filterPk));
            }
            filters[index] = new QFilter((String)filterPk, "in", pkObjValues);
            if (entryHaveNull) {
                filters[index] = filters[index].or(QFilter.isNull((String)filterPk));
            }
            ++index;
        }
        List<Row> dsLs = null;
        RowMeta dsRowMeta = null;
        try {
            ORM orm = ORM.create();
            orm.setDataEntityType(qb.getEntityName(), qb.getEntityType());
            DataSet ds = orm.queryDataSet(algoKey, qb.getEntityName(), qb.getSelectFields(), filters, null);
            filterPk = null;
            try {
                dsRowMeta = ds.getRowMeta();
                Throwable throwable = null;
                try (DataSet dsArchive = orm.queryDataSet(algoKey, "bos_log_archive", qb.getSelectFields(), filters, null);
                     DataSet dataSet = ds.union(dsArchive);){
                    dsLs = LogOperactionListutils.dsToRows(dataSet);
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable dsArchive) {
                filterPk = dsArchive;
                throw dsArchive;
            }
            finally {
                if (ds != null) {
                    if (filterPk != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable dsArchive) {
                            ((Throwable)filterPk).addSuppressed(dsArchive);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        catch (Exception e) {
            DisCardUtil.discard();
        }
        if (dsLs == null || dsRowMeta == null) {
            return new DynamicObjectCollection();
        }
        String seqField = qb.getSeqField();
        final HashMap<ArrayKey, Integer> sortMap = new HashMap<ArrayKey, Integer>(rows.size());
        int sortIndex = 0;
        for (Row row : rows) {
            Object[] objectArray = LogOperactionListutils.getPksValue(pkFields, row);
            ArrayKey ak = new ArrayKey(objectArray);
            sortMap.put(ak, ++sortIndex);
        }
        dsLs.sort(new Comparator<Row>(){

            @Override
            public int compare(Row row1, Row row2) {
                Object[] row1KeyValues = LogOperactionListutils.getPksValue(pkFields, row1);
                Object[] row2KeyValues = LogOperactionListutils.getPksValue(pkFields, row2);
                ArrayKey row1Ak = new ArrayKey(row1KeyValues);
                ArrayKey row2Ak = new ArrayKey(row2KeyValues);
                return ((Integer)sortMap.get(row1Ak)).compareTo((Integer)sortMap.get(row2Ak));
            }
        });
        if (StringUtils.isEmpty((String)seqField)) {
            return LogOperactionListutils.toDynamicObjectCollection(qb.getReturnEntityType(), dsLs.iterator(), dsRowMeta);
        }
        HashMap<ArrayKey, Integer> seqMap = new HashMap<ArrayKey, Integer>(rows.size());
        for (Row row : rows) {
            Object[] keyValues = LogOperactionListutils.getPksValue(pkFields, row);
            ArrayKey ak = new ArrayKey(keyValues);
            seqMap.put(ak, (Integer)row.get(seqField));
        }
        ArrayList<Row> arrayList = new ArrayList<Row>(dsLs.size());
        for (Row row : dsLs) {
            Object[] rowKeyValues = LogOperactionListutils.getPksValue(pkFields, row);
            ArrayKey rowAk = new ArrayKey(rowKeyValues);
            int seqIndex = (Integer)seqMap.get(rowAk);
            arrayList.add(LogOperactionListutils.rowAddField(row, seqField, (DataType)DataType.IntegerType, seqIndex));
        }
        RowMeta rowMeta = LogOperactionListutils.rowMetaAddField(dsRowMeta, seqField, (DataType)DataType.IntegerType);
        return LogOperactionListutils.toDynamicObjectCollection(qb.getReturnEntityType(), arrayList.iterator(), rowMeta);
    }

    private static DynamicObjectCollection toDynamicObjectCollection(DynamicObjectType dt, Iterator<Row> iter, RowMeta rowMeta) {
        DynamicObjectCollection ret = new DynamicObjectCollection(dt, null);
        int n = rowMeta.getFieldCount();
        ArrayList<Mapper> mappers = new ArrayList<Mapper>(n);
        for (int i = 0; i < n; ++i) {
            DynamicProperty property = dt.getProperty(rowMeta.getField(i).getName());
            if (property == null) continue;
            Mapper mapper = new Mapper();
            mapper.index = i;
            mapper.property = property instanceof BasedataProp ? ((BasedataProp)property).getRefIdProp() : property;
            mappers.add(mapper);
        }
        while (iter.hasNext()) {
            DynamicObject obj = new DynamicObject(dt);
            Row row = iter.next();
            for (Mapper mp : mappers) {
                mp.property.setValueFast((Object)obj, row.get(mp.index));
            }
            ret.add((Object)obj);
        }
        BusinessDataReader.loadRefence((Object[])ret.toArray((Object[])new DynamicObject[ret.size()]), (IDataEntityType)ret.getDynamicObjectType());
        return ret;
    }

    private static List<Row> dsToRows(DataSet ds) {
        ArrayList<Row> dsLs = new ArrayList<Row>();
        for (Row row : ds) {
            dsLs.add(RowUtil.persist((Row)row));
        }
        return dsLs;
    }

    private static List<Row> getLimitRows(List<Row> rows, int begin, final int limit) {
        final Iterator<Row> iter = rows.iterator();
        for (int i = 0; i < begin && iter.hasNext(); ++i) {
            iter.next();
        }
        Iterator<Row> limitIter = new Iterator<Row>(){
            private int i = 0;

            @Override
            public Row next() {
                return (Row)iter.next();
            }

            @Override
            public boolean hasNext() {
                if (++this.i > limit) {
                    return false;
                }
                return iter.hasNext();
            }
        };
        ArrayList<Row> limitRows = new ArrayList<Row>();
        while (limitIter.hasNext()) {
            limitRows.add((Row)limitIter.next());
        }
        return limitRows;
    }

    private void cacheRows(String pageId, QueryBuilder qb, List<Row> rows) {
        if (!qb.getSumFields().isEmpty()) {
            List pkFields = qb.getPkFields();
            int pkSize = pkFields.size();
            String seqField = qb.getSeqField();
            boolean seqIsEntity = StringUtils.isEmpty((String)seqField);
            String[] fieldNames = new String[pkSize];
            DataType[] dataTypes = new DataType[pkSize];
            for (int i = 0; i < pkSize; ++i) {
                fieldNames[i] = ((ListField)pkFields.get(i)).getFieldName();
                dataTypes[i] = ((ListField)pkFields.get(i)).getSrcFieldProp() instanceof LongProp ? DataType.LongType : DataType.StringType;
            }
            RowMeta idRowMeta = RowMetaFactory.createRowMeta((String[])fieldNames, (DataType[])dataTypes);
            for (Row row : rows) {
                Object[] values = new Object[pkSize];
                for (int i = 0; i < pkSize; ++i) {
                    values[i] = row.get(((ListField)pkFields.get(i)).getFieldName());
                }
                Row idRow = RowFactory.createRow((RowMeta)idRowMeta, (Object[])values);
                if (seqIsEntity) continue;
                LogOperactionListutils.rowAddField(idRow, seqField, (DataType)DataType.IntegerType, row.get(seqField));
            }
        }
    }

    class IdRunner
    implements Runnable {
        private String pageId;
        private QueryBuilder qb;
        private List<Row> rows;
        private RequestContext rc;

        public IdRunner(String pageId, QueryBuilder qb, List<Row> rows, RequestContext rc) {
            this.pageId = pageId;
            this.qb = qb;
            this.rows = rows;
            this.rc = rc;
        }

        @Override
        public void run() {
            RequestContext.set((RequestContext)this.rc);
            LogOperactionListutils.this.cacheRows(this.pageId, this.qb, this.rows);
        }
    }
}

