/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.log.service.LogSettingService;
import kd.bos.log.service.dto.LogSetting;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ArchiveLogSettingService
implements LogSettingService {
    private static final String ENTITY_LOG_ELT_SETTING = "bos_log_etl_setting";
    private static final String ENTITY_LOG_ETL_TASK = "bos_log_etl_task";
    private LogSetting archiveLogSetting;
    private DynamicObject etlJobSettingDo;

    public ArchiveLogSettingService() {
        QFilter[] qFilters = null;
        this.etlJobSettingDo = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_LOG_ELT_SETTING, qFilters);
        if (this.etlJobSettingDo == null) {
            this.archiveLogSetting = new LogSetting();
            this.archiveLogSetting.setStatus("false");
        } else {
            LogSetting logSetting = new LogSetting();
            logSetting.setStatus((String)this.etlJobSettingDo.get("status"));
            logSetting.setDay(this.etlJobSettingDo.getInt("archivedays"));
            logSetting.setTableName((String)this.etlJobSettingDo.get("tablename"));
            this.archiveLogSetting = logSetting;
        }
    }

    @Override
    public LogSetting getLogSetting() {
        return this.archiveLogSetting;
    }

    @Override
    public boolean hasSetting() {
        return this.etlJobSettingDo != null;
    }

    @Override
    public void updateLogSetting(LogSetting logSetting) {
        if (this.hasSetting()) {
            this.etlJobSettingDo.set("status", (Object)logSetting.getStatus());
            this.etlJobSettingDo.set("archivedays", (Object)logSetting.getDay());
            this.etlJobSettingDo.set("tablename", (Object)logSetting.getTableName());
            SaveServiceHelper.update((DynamicObject)this.etlJobSettingDo);
        } else {
            DynamicObject res;
            DynamicObject dobj = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_LOG_ELT_SETTING);
            dobj.set("status", (Object)logSetting.getStatus());
            dobj.set("archivedays", (Object)logSetting.getDay());
            dobj.set("tablename", (Object)logSetting.getTableName());
            Object[] result = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dobj});
            this.etlJobSettingDo = res = (DynamicObject)result[0];
        }
        this.archiveLogSetting = logSetting;
    }

    public boolean exists() {
        return QueryServiceHelper.exists((String)ENTITY_LOG_ETL_TASK, (QFilter[])new QFilter[]{new QFilter("status", "=", (Object)"STARTING").and("starttime", ">=", (Object)this.getYesterday())});
    }

    private Date getYesterday() {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(new Date());
            ((Calendar)calendar).add(5, -1);
            return sdf.parse(sdf.format(calendar.getTime()));
        }
        catch (ParseException e) {
            e.getMessage();
            return new Date();
        }
    }
}

