/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.exception.ORMArgInvalidException;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IEntryType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.form.flex.FlexValueFormatUtils;
import kd.bos.log.api.EntityModifyInfo;
import kd.bos.log.api.FieldModifyInfo;
import kd.bos.log.api.IBizModifyDirtyManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;

@Deprecated
public class BizModifyDirtyManager
implements IBizModifyDirtyManager {
    private static Log log = LogFactory.getLog(BizModifyDirtyManager.class);
    private MainEntityType _mainEntityType;
    private DynamicObject[] _successObjs;
    protected Map<String, String[]> _modifyFields = new HashMap<String, String[]>();
    protected String[] _monitorFields = null;
    private Map<String, Tuple<String, String>> _modifyContent = new HashMap<String, Tuple<String, String>>();
    private Map<String, EntityModifyInfo> _modifyInfos = new HashMap<String, EntityModifyInfo>();
    private Map<String, String> _modifyFlag = new HashMap<String, String>();
    private String _operate;
    private FormatObject _format;

    public void init(DynamicObjectType dynamicObjectType, DynamicObject[] successObjs, String operate) {
        this._mainEntityType = (MainEntityType)dynamicObjectType;
        this._successObjs = successObjs;
        this._operate = operate;
        try {
            String[] monitorFields = this.getMonitorFields();
            if (monitorFields.length > 0) {
                this._format = InteServiceHelper.getUserFormat((Long)Long.parseLong(RequestContext.get().getUserId()));
                this.build();
            }
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Object)e);
        }
    }

    public String[] getModifyFieldsFullNameInMonitor(String pkValue) {
        EntityModifyInfo info = this._modifyInfos.get(pkValue);
        if (info == null) {
            return new String[0];
        }
        List modifyFields = info.getModifyFields();
        if (modifyFields == null || modifyFields.size() == 0) {
            return new String[0];
        }
        return modifyFields.toArray(new String[0]);
    }

    private String[] getMonitorFields() {
        List<String> ruleFields = this.getMonitorRule();
        HashSet<String> set = new HashSet<String>(16);
        for (String ruleField : ruleFields) {
            String[] oldArr = ruleField.split(",");
            for (int i = 1; i < oldArr.length; ++i) {
                set.add(oldArr[i].substring(oldArr[i].lastIndexOf("(") + 1, oldArr[i].length() - 1));
            }
        }
        String[] array = new String[set.size()];
        set.toArray(array);
        this._monitorFields = array;
        return this._monitorFields;
    }

    public Tuple<String, String> getModifyContent(String pkValue) {
        return this._modifyContent.get(pkValue);
    }

    public EntityModifyInfo getEntityModifyInfo(String pkValue) {
        return this._modifyInfos.get(pkValue);
    }

    public String getModifyFlag(String pkValue) {
        String r = this._modifyFlag.get(pkValue);
        if (r == null) {
            r = "";
        }
        return r;
    }

    private void build() {
        if (this._successObjs == null || this._successObjs.length == 0) {
            return;
        }
        for (DynamicObject mainObj : this._successObjs) {
            Object pkValObj = mainObj.getPkValue();
            if (pkValObj == null) continue;
            String pkValStr = pkValObj.toString();
            boolean isDelete_MainObj = this.isDeleteOperate();
            boolean isNew_MainObj = !mainObj.getDataEntityState().getFromDatabase() && !isDelete_MainObj;
            DynamicObject cacheObj = null;
            if (isDelete_MainObj) {
                cacheObj = BusinessDataServiceHelper.loadSingleFromCache((Object)pkValObj, (String)this._mainEntityType.getName());
            } else if (!isNew_MainObj) {
                cacheObj = BusinessDataServiceHelper.loadSingleFromCache((Object)pkValObj, (DynamicObjectType)mainObj.getDynamicObjectType());
            }
            EntityModifyInfo info = this.buildMainEntry(mainObj, cacheObj, isDelete_MainObj, isNew_MainObj);
            this.buildContent(pkValStr, info);
        }
    }

    public void buildContent(String pkValStr, EntityModifyInfo info) {
        if (info != null) {
            ObjectMapper mapper = new ObjectMapper();
            String modifyContentStr = null;
            try {
                modifyContentStr = mapper.writeValueAsString((Object)info);
            }
            catch (IOException e) {
                log.debug(e.getMessage());
            }
            this._modifyFlag.put(pkValStr, info.getFlag());
            this._modifyContent.put(pkValStr, (Tuple<String, String>)new Tuple((Object)info.toString(), (Object)modifyContentStr));
            this._modifyInfos.put(pkValStr, info);
        }
    }

    private EntityModifyInfo buildMainEntry(DynamicObject mainObj, DynamicObject oldMainObj, boolean isDelete_MainObj, boolean isNew_MainObj) {
        FieldModifyInfo fieldModifyInfo;
        IDataEntityType mainEntityType = mainObj.getDataEntityType();
        String pkValueStr = mainObj.getPkValue().toString();
        ArrayList<IDataEntityProperty> maimDirtyProps = new ArrayList<IDataEntityProperty>();
        boolean isUpdate_MainObj = !isDelete_MainObj && !isNew_MainObj;
        EntityModifyInfo mainModifyInfo = new EntityModifyInfo();
        mainModifyInfo.setKeyID(pkValueStr);
        String billNo = this.getBillNo(mainObj);
        if (!StringUtils.isBlank((CharSequence)billNo)) {
            mainModifyInfo.setCaption(billNo);
        }
        if (isDelete_MainObj) {
            this.parseDirtyProp(oldMainObj, maimDirtyProps, null, false);
            for (IDataEntityProperty maimDirtyProp : maimDirtyProps) {
                fieldModifyInfo = this.buildFieldModifyInfo(mainObj, oldMainObj, maimDirtyProp, isDelete_MainObj);
                mainModifyInfo.addField(maimDirtyProp.getName(), fieldModifyInfo);
            }
            mainModifyInfo.setFlag("-");
        } else if (isNew_MainObj) {
            this.parseDirtyProp(mainObj, maimDirtyProps, null, false);
            for (IDataEntityProperty maimDirtyProp : maimDirtyProps) {
                fieldModifyInfo = this.buildFieldModifyInfo(mainObj, oldMainObj, maimDirtyProp, isDelete_MainObj);
                mainModifyInfo.addField(maimDirtyProp.getName(), fieldModifyInfo);
            }
            mainModifyInfo.setFlag("+");
        } else {
            this.parseDirtyProp(mainObj, maimDirtyProps, null, true);
            for (IDataEntityProperty maimDirtyProp : maimDirtyProps) {
                fieldModifyInfo = this.buildFieldModifyInfo(mainObj, oldMainObj, maimDirtyProp, isDelete_MainObj);
                mainModifyInfo.addField(maimDirtyProp.getName(), fieldModifyInfo);
            }
        }
        if (isDelete_MainObj) {
            mainEntityType = oldMainObj.getDataEntityType();
        }
        for (ICollectionProperty subEntryProperty : mainEntityType.getProperties().getCollectionProperties(false)) {
            DynamicObjectCollection oldSubObjs;
            String subEntryName = subEntryProperty.getName().toLowerCase();
            if (subEntryProperty instanceof DynamicLocaleProperty) continue;
            if (subEntryProperty instanceof MulBasedataProp) {
                FieldModifyInfo fieldModifyInfo2;
                String mulBasedataPropValue;
                DynamicObjectCollection mulSelObjs;
                MulBasedataProp mulbdProp = (MulBasedataProp)subEntryProperty;
                if (isDelete_MainObj) {
                    mulSelObjs = (DynamicObjectCollection)subEntryProperty.getValueFast((Object)oldMainObj);
                    mulBasedataPropValue = this.getMulBasedataPropValue(mulSelObjs, mulbdProp);
                    if (StringUtils.isBlank((CharSequence)mulBasedataPropValue)) continue;
                    fieldModifyInfo2 = new FieldModifyInfo(null, (Object)mulBasedataPropValue, subEntryProperty.getDisplayName().toString());
                    mainModifyInfo.addField(subEntryProperty.getName(), fieldModifyInfo2);
                    continue;
                }
                if (isNew_MainObj) {
                    mulSelObjs = (DynamicObjectCollection)subEntryProperty.getValueFast((Object)mainObj);
                    mulBasedataPropValue = this.getMulBasedataPropValue(mulSelObjs, mulbdProp);
                    if (StringUtils.isBlank((CharSequence)mulBasedataPropValue)) continue;
                    fieldModifyInfo2 = new FieldModifyInfo(null, (Object)mulBasedataPropValue, subEntryProperty.getDisplayName().toString());
                    mainModifyInfo.addField(subEntryProperty.getName(), fieldModifyInfo2);
                    continue;
                }
                mulSelObjs = (DynamicObjectCollection)subEntryProperty.getValueFast((Object)mainObj);
                mulBasedataPropValue = this.getMulBasedataPropValue(mulSelObjs, mulbdProp);
                DynamicObjectCollection mulSelObjs_Old = (DynamicObjectCollection)subEntryProperty.getValueFast((Object)oldMainObj);
                String mulBasedataPropValue_Old = this.getMulBasedataPropValue(mulSelObjs_Old, mulbdProp);
                if ((StringUtils.isBlank((CharSequence)mulBasedataPropValue) || mulBasedataPropValue.equals(mulBasedataPropValue_Old)) && (StringUtils.isBlank((CharSequence)mulBasedataPropValue_Old) || mulBasedataPropValue_Old.equals(mulBasedataPropValue))) continue;
                FieldModifyInfo fieldModifyInfo3 = new FieldModifyInfo((Object)mulBasedataPropValue_Old, (Object)mulBasedataPropValue, subEntryProperty.getDisplayName().toString());
                mainModifyInfo.addField(subEntryProperty.getName(), fieldModifyInfo3);
                continue;
            }
            if (isDelete_MainObj) {
                DynamicObjectCollection oldSubObjs2 = oldMainObj != null ? (DynamicObjectCollection)subEntryProperty.getValueFast((Object)oldMainObj) : null;
                if (oldSubObjs2 == null) continue;
                for (int index = 0; index < oldSubObjs2.size(); ++index) {
                    int i = index;
                    DynamicObject oldSubObj = (DynamicObject)oldSubObjs2.get(index);
                    EntityModifyInfo subModifyInfo = this.buildSubEntry(isDelete_MainObj, isNew_MainObj, false, true, subEntryProperty, index, null, oldSubObj, subEntryProperty.getName());
                    if (subModifyInfo == null || subModifyInfo.isEmpty()) continue;
                    mainModifyInfo.addChild(subEntryName, subModifyInfo);
                }
                continue;
            }
            if (!this.isEntryInMonitor(subEntryName)) continue;
            DynamicObjectCollection subObjs = (DynamicObjectCollection)subEntryProperty.getValueFast((Object)mainObj);
            DynamicObjectCollection dynamicObjectCollection = oldSubObjs = oldMainObj != null ? (DynamicObjectCollection)subEntryProperty.getValueFast((Object)oldMainObj) : null;
            if (subObjs != null) {
                for (int index = 0; index < subObjs.size(); ++index) {
                    EntityModifyInfo subModifyInfo;
                    boolean isNewRow;
                    int i = index;
                    DynamicObject subObj = (DynamicObject)subObjs.get(index);
                    Object subObjPkValue = subObj.getPkValue();
                    if (subObjPkValue == null) continue;
                    DynamicObject oldSubObj = null;
                    boolean bl = isNewRow = oldSubObjs == null || !oldSubObjs.stream().anyMatch(y -> y.getPkValue().equals(subObjPkValue));
                    if (!isNewRow && oldSubObjs != null) {
                        oldSubObj = oldSubObjs.stream().filter(o -> subObjPkValue.equals(o.getPkValue())).findFirst().get();
                    }
                    if ((subModifyInfo = this.buildSubEntry(isDelete_MainObj, isNew_MainObj, isNewRow, false, subEntryProperty, index, subObj, oldSubObj, subEntryProperty.getName())) == null || subModifyInfo.isEmpty()) continue;
                    mainModifyInfo.addChild(subEntryName, subModifyInfo);
                }
            }
            if (!isUpdate_MainObj || oldSubObjs == null || this._monitorFields == null || subObjs == null) continue;
            List deletedSubObjs = null;
            try {
                deletedSubObjs = oldSubObjs.stream().filter(v -> v != null && v.getPkValue() != null).filter(s -> !subObjs.stream().filter(v -> v != null && v.getPkValue() != null).anyMatch(y -> s.getPkValue().equals(y.getPkValue()))).collect(Collectors.toList());
            }
            catch (NullPointerException e) {
                log.error(e.getMessage());
            }
            if (deletedSubObjs == null) continue;
            for (DynamicObject deletedSubObj : deletedSubObjs) {
                EntityModifyInfo subModifyInfo = this.buildSubEntry(isDelete_MainObj, isNew_MainObj, false, true, subEntryProperty, oldSubObjs.indexOf((Object)deletedSubObj), null, deletedSubObj, subEntryProperty.getName());
                if (subModifyInfo == null || subModifyInfo.isEmpty()) continue;
                mainModifyInfo.addChild(subEntryName, subModifyInfo);
            }
        }
        return mainModifyInfo;
    }

    private EntityModifyInfo buildSubEntry(boolean isDelete_MainObj, boolean isNew_MainObj, boolean isNewRow, boolean isDeleteRow, ICollectionProperty collectionProperty, int indexOfEntry, DynamicObject obj, DynamicObject oldObj, String parentPropertyPath) {
        FieldModifyInfo fieldModifyInfo;
        IDataEntityProperty entrySeq;
        String pkValueStr;
        Object newRowPkValue = obj != null ? obj.getPkValue() : null;
        Object oldRowPkValue = oldObj != null ? oldObj.getPkValue() : null;
        String string = pkValueStr = newRowPkValue != null ? newRowPkValue.toString() : String.valueOf(oldRowPkValue);
        if (StringUtils.isBlank((CharSequence)pkValueStr)) {
            return null;
        }
        String entryDisplayName = collectionProperty.getDisplayName().getLocaleValue();
        DynamicObjectType subObjectType = obj != null ? obj.getDynamicObjectType() : oldObj.getDynamicObjectType();
        String seqStr = "" + (indexOfEntry + 1);
        if (subObjectType instanceof IEntryType && (entrySeq = ((IEntryType)subObjectType).getSeqProperty()) != null) {
            try {
                Object seqVal = entrySeq.getValue((Object)(obj != null ? obj : oldObj));
                if (seqVal != null) {
                    seqStr = seqVal.toString();
                }
            }
            catch (ORMArgInvalidException e) {
                log.debug(e.getMessage());
            }
        }
        String caption = entryDisplayName + "." + seqStr;
        EntityModifyInfo entityModifyInfo = new EntityModifyInfo(pkValueStr, caption);
        ArrayList<IDataEntityProperty> dirtyProps = new ArrayList<IDataEntityProperty>();
        if (isDelete_MainObj) {
            this.parseDirtyProp(oldObj, dirtyProps, collectionProperty.getName(), false);
            for (IDataEntityProperty dirtyProp : dirtyProps) {
                fieldModifyInfo = this.buildFieldModifyInfo(obj, oldObj, dirtyProp, isDelete_MainObj);
                entityModifyInfo.addField(dirtyProp.getName(), fieldModifyInfo);
            }
            entityModifyInfo.setFlag("-");
        } else if (isNew_MainObj) {
            this.parseDirtyProp(obj, dirtyProps, collectionProperty.getName(), false);
            for (IDataEntityProperty dirtyProp : dirtyProps) {
                fieldModifyInfo = this.buildFieldModifyInfo(obj, oldObj, dirtyProp, isDeleteRow);
                entityModifyInfo.addField(dirtyProp.getName(), fieldModifyInfo);
            }
            entityModifyInfo.setFlag("+");
        } else {
            if (isDeleteRow) {
                this.parseDirtyProp(oldObj, dirtyProps, collectionProperty.getName(), false);
            } else {
                this.parseDirtyProp(obj, dirtyProps, collectionProperty.getName(), true);
            }
            for (IDataEntityProperty dirtyProp : dirtyProps) {
                fieldModifyInfo = this.buildFieldModifyInfo(obj, oldObj, dirtyProp, isDeleteRow);
                entityModifyInfo.addField(dirtyProp.getName(), fieldModifyInfo);
            }
        }
        if (isDeleteRow || isDelete_MainObj) {
            entityModifyInfo.setFlag("-");
        } else if (isNew_MainObj || isNewRow) {
            entityModifyInfo.setFlag("+");
        }
        if (isDelete_MainObj) {
            subObjectType = oldObj.getDynamicObjectType();
        }
        for (ICollectionProperty subEntryProperty : subObjectType.getProperties().getCollectionProperties(false)) {
            List deletedSubObjs;
            String subEntryName = subEntryProperty.getName().toLowerCase();
            if (subEntryProperty instanceof DynamicLocaleProperty) continue;
            if (subEntryProperty instanceof MulBasedataProp) {
                FieldModifyInfo fieldModifyInfo2;
                String mulBasedataPropValue;
                DynamicObjectCollection mulSelObjs;
                MulBasedataProp mulbdProp = (MulBasedataProp)subEntryProperty;
                if (isDelete_MainObj) {
                    mulSelObjs = (DynamicObjectCollection)subEntryProperty.getValueFast((Object)oldObj);
                    mulBasedataPropValue = this.getMulBasedataPropValue(mulSelObjs, mulbdProp);
                    if (StringUtils.isBlank((CharSequence)mulBasedataPropValue)) continue;
                    fieldModifyInfo2 = new FieldModifyInfo(null, (Object)mulBasedataPropValue, subEntryProperty.getDisplayName().toString());
                    entityModifyInfo.addField(subEntryProperty.getName(), fieldModifyInfo2);
                    continue;
                }
                if (isNew_MainObj) {
                    mulSelObjs = (DynamicObjectCollection)subEntryProperty.getValueFast((Object)obj);
                    mulBasedataPropValue = this.getMulBasedataPropValue(mulSelObjs, mulbdProp);
                    if (StringUtils.isBlank((CharSequence)mulBasedataPropValue)) continue;
                    fieldModifyInfo2 = new FieldModifyInfo(null, (Object)mulBasedataPropValue, subEntryProperty.getDisplayName().toString());
                    entityModifyInfo.addField(subEntryProperty.getName(), fieldModifyInfo2);
                    continue;
                }
                mulSelObjs = (DynamicObjectCollection)subEntryProperty.getValueFast((Object)obj);
                mulBasedataPropValue = this.getMulBasedataPropValue(mulSelObjs, mulbdProp);
                DynamicObjectCollection mulSelObjs_Old = (DynamicObjectCollection)subEntryProperty.getValueFast((Object)oldObj);
                String mulBasedataPropValue_Old = this.getMulBasedataPropValue(mulSelObjs_Old, mulbdProp);
                if ((StringUtils.isBlank((CharSequence)mulBasedataPropValue) || mulBasedataPropValue.equals(mulBasedataPropValue_Old)) && (StringUtils.isBlank((CharSequence)mulBasedataPropValue_Old) || mulBasedataPropValue_Old.equals(mulBasedataPropValue))) continue;
                FieldModifyInfo fieldModifyInfo3 = new FieldModifyInfo((Object)mulBasedataPropValue_Old, (Object)mulBasedataPropValue, subEntryProperty.getDisplayName().toString());
                entityModifyInfo.addField(subEntryProperty.getName(), fieldModifyInfo3);
                continue;
            }
            if (isDelete_MainObj) {
                DynamicObjectCollection oldSubObjs;
                if (!this.isEntryInMonitor(subEntryName) || (oldSubObjs = oldObj != null ? (DynamicObjectCollection)subEntryProperty.getValueFast((Object)oldObj) : null) == null) continue;
                for (int index = 0; index < oldSubObjs.size(); ++index) {
                    int i = index;
                    DynamicObject oldSubObj = (DynamicObject)oldSubObjs.get(index);
                    EntityModifyInfo subModifyInfo = this.buildSubEntry(isDelete_MainObj, isNew_MainObj, false, false, subEntryProperty, index, null, oldSubObj, parentPropertyPath + "." + subEntryProperty.getName());
                    if (subModifyInfo == null || subModifyInfo.isEmpty()) continue;
                    entityModifyInfo.addChild(subEntryName, subModifyInfo);
                }
                continue;
            }
            if (!this.isEntryInMonitor(subEntryName)) continue;
            DynamicObjectCollection subObjs = (DynamicObjectCollection)subEntryProperty.getValueFast((Object)obj);
            DynamicObjectCollection oldSubObjs = oldObj != null ? (DynamicObjectCollection)subEntryProperty.getValueFast((Object)oldObj) : null;
            for (int index = 0; index < subObjs.size(); ++index) {
                EntityModifyInfo subModifyInfo;
                boolean isSubObjNewRow;
                int i = index;
                DynamicObject subObj = (DynamicObject)subObjs.get(index);
                Object subObjPkValue = subObj.getPkValue();
                if (subObjPkValue == null) continue;
                DynamicObject oldSubObj = null;
                boolean bl = isSubObjNewRow = oldSubObjs == null || !oldSubObjs.stream().anyMatch(y -> y.getPkValue().equals(subObjPkValue));
                if (!isSubObjNewRow && oldSubObjs != null) {
                    oldSubObj = oldSubObjs.stream().filter(o -> subObjPkValue.equals(o.getPkValue())).findFirst().get();
                }
                if ((subModifyInfo = this.buildSubEntry(isDelete_MainObj, isNew_MainObj, isSubObjNewRow, false, subEntryProperty, index, subObj, oldSubObj, parentPropertyPath + "." + subEntryProperty.getName())) == null || subModifyInfo.isEmpty()) continue;
                entityModifyInfo.addChild(subEntryName, subModifyInfo);
            }
            if (isNew_MainObj || oldSubObjs == null || (deletedSubObjs = oldSubObjs.stream().filter(s -> !subObjs.stream().anyMatch(y -> y.getPkValue().equals(s.getPkValue()))).collect(Collectors.toList())) == null) continue;
            for (DynamicObject deletedSubObj : deletedSubObjs) {
                EntityModifyInfo subModifyInfo = this.buildSubEntry(isDelete_MainObj, isNew_MainObj, false, true, subEntryProperty, oldSubObjs.indexOf((Object)deletedSubObj), null, deletedSubObj, parentPropertyPath + "." + subEntryProperty.getName());
                if (subModifyInfo == null || subModifyInfo.isEmpty()) continue;
                entityModifyInfo.addChild(subEntryName, subModifyInfo);
            }
        }
        return entityModifyInfo;
    }

    private FieldModifyInfo buildFieldModifyInfo(DynamicObject obj, DynamicObject oldObj, IDataEntityProperty property, boolean isDelete) {
        LocaleString name = property.getDisplayName();
        String displayName = null;
        displayName = name != null ? name.toString() : property.getName();
        String newValue = null;
        if (obj != null && !isDelete) {
            newValue = this.getPropertyValue(obj, property);
        }
        String oldValue = null;
        if (oldObj != null) {
            oldValue = this.getPropertyValue(oldObj, property);
        }
        return new FieldModifyInfo((Object)oldValue, (Object)newValue, displayName);
    }

    private void parseDirtyProp(DynamicObject obj, List<IDataEntityProperty> dirtyProps, String entityPropName, boolean isUpdate) {
        ArrayList<IDataEntityProperty> monitorProps = new ArrayList<IDataEntityProperty>();
        this.parseDirtyPropByMonitor(obj, monitorProps, entityPropName);
        if (monitorProps.size() == 0) {
            return;
        }
        if (isUpdate) {
            ArrayList<IDataEntityProperty> dirtyStateProps = new ArrayList<IDataEntityProperty>();
            this.parseDirtyPropByState(obj, dirtyStateProps, entityPropName);
            if (dirtyStateProps.size() == 0) {
                return;
            }
            for (IDataEntityProperty dirtyStateProp : dirtyStateProps) {
                if (!monitorProps.contains(dirtyStateProp)) continue;
                dirtyProps.add(dirtyStateProp);
            }
        } else {
            dirtyProps.addAll(monitorProps);
        }
        dirtyProps.sort((m1, m2) -> Integer.compare(m1.getOrdinal(), m2.getOrdinal()));
    }

    private void parseDirtyPropByMonitor(DynamicObject obj, List<IDataEntityProperty> dirtyProps, String entityPropName) {
        if (this._monitorFields == null || this._monitorFields.length == 0) {
            return;
        }
        DataEntityPropertyCollection properties = obj.getDataEntityType().getProperties();
        String[] stringArray = this._monitorFields;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            IDataEntityProperty prop;
            String monitorField;
            String theField = monitorField = stringArray[i];
            if (entityPropName == null && monitorField.indexOf(46) > 0) continue;
            if (entityPropName != null) {
                theField = theField.replace(entityPropName + ".", "");
            }
            if ((prop = (IDataEntityProperty)properties.get((Object)theField)) == null) continue;
            dirtyProps.add(prop);
        }
    }

    private void parseDirtyPropByState(DynamicObject obj, List<IDataEntityProperty> dirtyProps, String entityPropName) {
        Iterator iterator = obj.getDataEntityState().getBizChangedProperties().iterator();
        while (iterator.hasNext()) {
            IDataEntityProperty property;
            IDataEntityProperty realProperty = property = (IDataEntityProperty)iterator.next();
            if (property instanceof PKFieldProp && property.getName().endsWith("_id")) {
                String bdPropName = property.getName().substring(0, property.getName().length() - 3);
                realProperty = (IDataEntityProperty)property.getParent().getProperties().get((Object)bdPropName);
                if (realProperty == null) {
                    realProperty = property;
                }
            }
            dirtyProps.add(realProperty);
        }
    }

    private List<String> getMonitorRule() {
        String pkValue = this._successObjs[0].getDataEntityType().getName();
        Map rulesMap = BusinessDataServiceHelper.loadFromCache((String)"al_rule_setting", (String)"modifyfields", (QFilter[])new QFilter[]{new QFilter("bizobj", "=", (Object)pkValue), new QFilter("enable", "=", (Object)Character.valueOf('1'))});
        if (rulesMap.size() == 0) {
            return new ArrayList<String>();
        }
        return rulesMap.values().stream().map(v -> v.get("modifyfields").toString()).collect(Collectors.toList());
    }

    private boolean isEntryInMonitor(String entryPropertyName) {
        if (this._monitorFields == null || this._monitorFields.length == 0 || entryPropertyName == null) {
            return false;
        }
        for (String monitorField : this._monitorFields) {
            if (!monitorField.toLowerCase(Locale.ENGLISH).startsWith(entryPropertyName.toLowerCase(Locale.ENGLISH))) continue;
            return true;
        }
        return false;
    }

    private String getPropertyValue(DynamicObject dynamicObject, IDataEntityProperty dynamicProperty) {
        if (dynamicProperty instanceof DynamicSimpleProperty) {
            if (dynamicProperty instanceof IFieldHandle) {
                if (dynamicProperty instanceof TimeProp) {
                    TimeProp timeProp = (TimeProp)dynamicProperty;
                    Object timePropObj = timeProp.getBasePropDisplayValue((Object)dynamicObject);
                    return timePropObj != null ? timePropObj.toString() : null;
                }
                try {
                    Object[] val;
                    IFieldHandle fldHandle = (IFieldHandle)dynamicProperty;
                    ListField listField = new ListField(dynamicProperty.getName());
                    listField.setSrcFieldProp(dynamicProperty);
                    listField.setFieldProp(dynamicProperty);
                    AbstractColumnDesc listColumnDesc = fldHandle.getListColumnDesc(listField);
                    listColumnDesc.setUserFormat(this._format);
                    listColumnDesc.setFormaType(2);
                    Object valueObj = listColumnDesc.getValue(dynamicObject);
                    if (valueObj instanceof Object[] && (val = (Object[])valueObj) != null && val.length > 0) {
                        Object o = val[0];
                        return o != null ? o.toString() : null;
                    }
                    return valueObj != null ? valueObj.toString() : null;
                }
                catch (Exception e1) {
                    try {
                        IFieldHandle fldHandle = (IFieldHandle)dynamicProperty;
                        Object dispValueObj = fldHandle.getBasePropDisplayValue((Object)dynamicObject);
                        return dispValueObj != null ? dispValueObj.toString() : null;
                    }
                    catch (Exception e) {
                        return dynamicObject.getString(dynamicProperty.getName());
                    }
                }
            }
            return dynamicObject.getString(dynamicProperty.getName());
        }
        if (dynamicProperty instanceof DynamicComplexProperty) {
            DynamicObject obj = null;
            try {
                if (dynamicProperty instanceof FlexProp) {
                    List flexValues = (List)FlexValueFormatUtils.getListDisplayValue((DynamicObject)dynamicObject, (FlexProp)((FlexProp)dynamicProperty), (String)((FlexProp)dynamicProperty).getBasePropertyKey());
                    ArrayList<String> displayValues = new ArrayList<String>();
                    for (Map item : flexValues) {
                        String alias = (String)item.get("alias");
                        if (!StringUtils.isNotBlank((CharSequence)alias)) continue;
                        displayValues.add(alias);
                    }
                    return String.join((CharSequence)"; ", displayValues);
                }
                obj = dynamicObject.getDynamicObject(dynamicProperty);
                return Optional.ofNullable(obj).map(s -> s.getString("name")).orElse(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private String getMulBasedataPropValue(DynamicObjectCollection mulSelObjs, MulBasedataProp mulbdProp) {
        if (mulSelObjs == null || mulSelObjs.size() == 0 || mulbdProp == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (DynamicObject mulSelObj : mulSelObjs) {
            String value;
            IComplexProperty refBaseProp = mulbdProp.getRefBaseProp();
            DynamicObject refBaseObj = (DynamicObject)refBaseProp.getValue((Object)mulSelObj);
            Object displayPropObj = refBaseObj.get(mulbdProp.getDisplayProp());
            if (displayPropObj == null || StringUtils.isBlank((CharSequence)(value = displayPropObj.toString()))) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(value);
        }
        return sb.toString();
    }

    private boolean isDeleteOperate() {
        return "delete".equals(this._operate);
    }

    private String getBillNo(DynamicObject dynamicObject) {
        IDataEntityProperty billNoProp = null;
        if (this._mainEntityType instanceof BasedataEntityType) {
            BasedataEntityType bdType = (BasedataEntityType)this._mainEntityType;
            if (StringUtils.isNotBlank((CharSequence)bdType.getNumberProperty())) {
                billNoProp = this._mainEntityType.findProperty(bdType.getNumberProperty());
            }
        } else if (this._mainEntityType instanceof BillEntityType) {
            billNoProp = this._mainEntityType.findProperty(((BillEntityType)this._mainEntityType).getBillNo());
        }
        if (billNoProp != null) {
            return (String)billNoProp.getValue((Object)dynamicObject);
        }
        return "";
    }
}

