/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.service;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.ksql.util.StringUtil;
import kd.bos.lang.Lang;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.log.model.AdminLogConstant;
import kd.bos.log.service.NameQueryService;
import kd.bos.log.service.elasticsearch.ElasticsearchService;
import kd.bos.log.service.util.CommonUtils;
import kd.bos.log.service.util.EsPropertiesUtils;
import kd.bos.log.service.util.LocaleValueUtils;
import kd.bos.log.service.util.UserFormatCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.log.LogInAppInfo;
import kd.bos.login.utils.log.OperateConfirmLog;
import kd.bos.logorm.LogORM;
import kd.bos.permission.model.AdminType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;

public class LogSaveService {
    private static final String[] COLUMN = new String[]{"FID", "FUSERID", "FBIZAPPID", "FORGID", "FBIZOBJID", "FCLIENTIP", "FCLIENTTYPE", "FOPTIME", "FOPNAMEE", "FOPDESCRIPTIONE", "FCLIENTNAMEE", "FUSERNAME", "FBIZAPPNAME", "FBIZOBJNAME", "FORGNAME", "FMODIFYBILLID", "FMODIFYCONTENT", "FMODIFYCONTENT_TAG", "FMODIFYFIELDS", "FMODIFYBILLNO"};
    private static final String TABLE_NAME = "T_LOG_APP";
    private static final int BATCH_SIZE = 1000;
    private static Log logger = LogFactory.getLog(LogSaveService.class);
    private final String USERNAME_KEY = "userName";
    private final String ACCOUNT_KEY = "account";
    private final String NUMBER_KEY = "number";
    private final String APP_KEY = "bizAppName";
    private final String OBJ_KEY = "bizObjName";
    private final String ORG_KEY = "orgName";
    private final String TYPE_KEY = "bos-mservice-log";
    private static final String COLUMN_KEY = "id,name";

    public void saveAuditLog(List<AppLogInfo> logInfos) {
        String insertSql = this.calcWriteRecordSql(COLUMN, TABLE_NAME);
        ArrayList<Object[]> writeBuffer = new ArrayList<Object[]>(logInfos.size());
        String[] ids = ID.genStringIds((int)logInfos.size());
        for (int i = 0; i < logInfos.size(); ++i) {
            AppLogInfo appLogInfo = logInfos.get(i);
            Object[] record = new Object[COLUMN.length];
            record[0] = ids[i];
            record[1] = appLogInfo.getUserID();
            record[2] = appLogInfo.getBizAppID();
            record[3] = appLogInfo.getOrgID();
            record[4] = appLogInfo.getBizObjID();
            record[5] = appLogInfo.getClientIP();
            record[6] = appLogInfo.getClientType();
            record[7] = appLogInfo.getOpTime();
            record[8] = appLogInfo.getOpName();
            if (kd.bos.util.StringUtils.isNotEmpty((String)appLogInfo.getOpDescription())) {
                record[9] = appLogInfo.getOpDescription().length() > 255 ? appLogInfo.getOpDescription().substring(0, 255) : appLogInfo.getOpDescription();
            }
            record[10] = appLogInfo.getClientName();
            try {
                DynamicObject user;
                if (0L != appLogInfo.getUserID() && null != (user = BusinessDataServiceHelper.loadSingleFromCache((Object)appLogInfo.getUserID(), (String)"bos_user", (String)COLUMN_KEY))) {
                    record[11] = user.getLocaleString("name").getLocaleValue();
                }
            }
            catch (Exception user) {
                // empty catch block
            }
            try {
                DynamicObject app;
                if (kd.bos.util.StringUtils.isNotEmpty((String)appLogInfo.getBizAppID()) && null != (app = BusinessDataServiceHelper.loadSingleFromCache((Object)appLogInfo.getBizAppID(), (String)"bos_devportal_bizapp", (String)COLUMN_KEY))) {
                    record[12] = app.getLocaleString("name").getLocaleValue();
                }
            }
            catch (Exception app) {
                // empty catch block
            }
            try {
                DynamicObject obj;
                if (kd.bos.util.StringUtils.isNotEmpty((String)appLogInfo.getBizObjID()) && null != (obj = BusinessDataServiceHelper.loadSingleFromCache((Object)appLogInfo.getBizObjID(), (String)"bos_objecttype", (String)COLUMN_KEY))) {
                    record[13] = obj.getLocaleString("name").getLocaleValue();
                }
            }
            catch (Exception obj) {
                // empty catch block
            }
            try {
                DynamicObject org;
                if (0L != appLogInfo.getOrgID() && null != (org = BusinessDataServiceHelper.loadSingleFromCache((Object)appLogInfo.getOrgID(), (String)"bos_org", (String)COLUMN_KEY))) {
                    record[14] = org.getLocaleString("name").getLocaleValue();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            record[15] = appLogInfo.getModifyBillID() == null ? "" : appLogInfo.getModifyBillID();
            record[16] = appLogInfo.getModifyContent() == null ? "" : CommonUtils.getLogContent(appLogInfo.getModifyContent());
            record[17] = appLogInfo.getModifyContentTag() == null ? "" : appLogInfo.getModifyContentTag();
            record[18] = appLogInfo.getModifyFields() == null ? "" : appLogInfo.getModifyFields();
            record[19] = appLogInfo.getModifyBillNo() == null ? "" : appLogInfo.getModifyBillNo();
            writeBuffer.add(record);
            if (writeBuffer.size() < 1000) continue;
            this.batchInsert(writeBuffer, insertSql);
            writeBuffer.clear();
        }
        if (!writeBuffer.isEmpty()) {
            this.batchInsert(writeBuffer, insertSql);
            writeBuffer.clear();
        }
    }

    private String calcWriteRecordSql(String[] column, String table) {
        ArrayList<String> valueHolders = new ArrayList<String>(column.length);
        for (int i = 0; i < column.length; ++i) {
            valueHolders.add("?");
        }
        String writeSqlTemplate = "INSERT INTO %s (" + org.apache.commons.lang3.StringUtils.join((Object[])column, (String)",") + ") VALUES(" + org.apache.commons.lang3.StringUtils.join(valueHolders, (String)",") + ")";
        return String.format(writeSqlTemplate, table);
    }

    private void batchInsert(List<Object[]> records, String sql) {
        DB.executeBatch((DBRoute)DBRoute.log, (String)sql, records);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLoginLog(List<AppLogInfo> logInfos, String accountId, String tenantId) {
        Account account = AccountUtils.getCorrectAccount((String)accountId, (String)tenantId);
        Properties dataBaseProperties = AccountUtils.getTenantDBInfoByRoutekey((Account)account, (String)"log");
        Connection conn = null;
        String insertSql = this.calcWriteRecordSql(COLUMN, TABLE_NAME);
        try {
            conn = MCDBUtil.getConnection((Properties)dataBaseProperties);
            String select = this.getOpUserFormat();
            if (logInfos.size() <= 1000) {
                this.batchRawInsert(logInfos, conn, insertSql, account, select);
            } else {
                ArrayList<AppLogInfo> buffer = new ArrayList<AppLogInfo>(10);
                for (AppLogInfo appLogInfo : logInfos) {
                    buffer.add(appLogInfo);
                    if (buffer.size() < 1000) continue;
                    this.batchRawInsert(buffer, conn, insertSql, account, select);
                    buffer.clear();
                }
                if (!buffer.isEmpty()) {
                    this.batchRawInsert(buffer, conn, insertSql, account, select);
                    buffer.clear();
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchRawInsert(List<AppLogInfo> records, Connection conn, String writeRecordSql, Account account, String select) {
        PreparedStatement preparedStatement = null;
        try {
            conn.setAutoCommit(false);
            preparedStatement = conn.prepareStatement(writeRecordSql);
            String[] ids = ID.genStringIds((int)records.size());
            for (int i = 0; i < records.size(); ++i) {
                Object name;
                AppLogInfo appLogInfo = records.get(i);
                preparedStatement.setString(1, ids[i]);
                preparedStatement.setLong(2, appLogInfo.getUserID());
                preparedStatement.setString(3, appLogInfo.getBizAppID());
                preparedStatement.setLong(4, appLogInfo.getOrgID());
                preparedStatement.setString(5, appLogInfo.getBizObjID());
                preparedStatement.setString(6, appLogInfo.getClientIP());
                preparedStatement.setString(7, appLogInfo.getClientType());
                preparedStatement.setTimestamp(8, new Timestamp(appLogInfo.getOpTime().getTime()));
                preparedStatement.setString(9, appLogInfo.getOpName());
                if (kd.bos.util.StringUtils.isNotEmpty((String)appLogInfo.getOpDescription())) {
                    preparedStatement.setString(10, appLogInfo.getOpDescription().length() > 255 ? appLogInfo.getOpDescription().substring(0, 255) : appLogInfo.getOpDescription());
                }
                preparedStatement.setString(11, appLogInfo.getClientName() == null || "".equals(appLogInfo.getClientName()) ? " " : appLogInfo.getClientName());
                try {
                    if (appLogInfo.getUserID() != null) {
                        if (appLogInfo.getUserID() == 0L) {
                            preparedStatement.setString(12, ResManager.loadKDString((String)"\u672a\u77e5\u7528\u6237", (String)"LogSaveService_0", (String)"bos-mservice-log", (Object[])new Object[0]));
                        } else if (appLogInfo.getUserID() == -1L) {
                            preparedStatement.setString(12, ResManager.loadKDString((String)"\u533f\u540d\u7528\u6237", (String)"LogSaveService_1", (String)"bos-mservice-log", (Object[])new Object[0]));
                        } else {
                            name = NameQueryService.getUserName(account, appLogInfo.getLanguage(), appLogInfo.getUserID());
                            if ("name+number".equals(select)) {
                                preparedStatement.setString(12, (String)name.f0 + " " + (String)name.f2);
                            } else if ("name+username".equals(select)) {
                                preparedStatement.setString(12, (String)name.f0 + " " + (String)name.f1);
                            } else if ("name+phone".equals(select)) {
                                preparedStatement.setString(12, (String)name.f0 + " " + (String)name.f3);
                            } else {
                                preparedStatement.setString(12, (String)name.f0);
                            }
                        }
                    } else {
                        preparedStatement.setString(12, ResManager.loadKDString((String)"\u7a7a\u7528\u6237", (String)"LogSaveService_2", (String)"bos-mservice-log", (Object[])new Object[0]));
                    }
                }
                catch (Exception ignore) {
                    logger.error("\u67e5\u8be2\u767b\u5f55\u65e5\u5fd7\u7528\u6237\u4fe1\u606f\u53d1\u751f\u5f02\u5e38\uff1a", (Throwable)ignore);
                    preparedStatement.setString(12, ResManager.loadKDString((String)"\u672a\u77e5\u7528\u6237", (String)"LogSaveService_0", (String)"bos-mservice-log", (Object[])new Object[0]));
                }
                try {
                    if (kd.bos.util.StringUtils.isNotEmpty((String)appLogInfo.getBizAppID())) {
                        name = NameQueryService.getAppName(account, appLogInfo.getLanguage(), appLogInfo.getBizAppID());
                        preparedStatement.setString(13, (String)name);
                    } else {
                        preparedStatement.setString(13, ResManager.loadKDString((String)"\u7a7a\u5e94\u7528", (String)"LogSaveService_3", (String)"bos-mservice-log", (Object[])new Object[0]));
                    }
                }
                catch (Exception ignore) {
                    logger.error("\u67e5\u8be2\u767b\u5f55\u65e5\u5fd7\u5e94\u7528\u4fe1\u606f\u53d1\u751f\u5f02\u5e38\uff1a", (Throwable)ignore);
                    preparedStatement.setString(13, ResManager.loadKDString((String)"\u672a\u77e5\u5e94\u7528", (String)"LogSaveService_4", (String)"bos-mservice-log", (Object[])new Object[0]));
                }
                try {
                    if (kd.bos.util.StringUtils.isNotEmpty((String)appLogInfo.getBizObjID())) {
                        name = NameQueryService.getObjName(account, appLogInfo.getLanguage(), appLogInfo.getBizObjID());
                        preparedStatement.setString(14, (String)name);
                    } else {
                        preparedStatement.setString(14, ResManager.loadKDString((String)"\u7a7a\u5bf9\u8c61", (String)"LogSaveService_5", (String)"bos-mservice-log", (Object[])new Object[0]));
                    }
                }
                catch (Exception ignore) {
                    logger.error("\u67e5\u8be2\u767b\u5f55\u65e5\u5fd7\u5bf9\u8c61\u4fe1\u606f\u53d1\u751f\u5f02\u5e38\uff1a", (Throwable)ignore);
                    preparedStatement.setString(14, ResManager.loadKDString((String)"\u672a\u77e5\u5bf9\u8c61", (String)"LogSaveService_6", (String)"bos-mservice-log", (Object[])new Object[0]));
                }
                try {
                    if (appLogInfo.getOrgID() != null) {
                        if (appLogInfo.getOrgID() == 0L) {
                            preparedStatement.setString(15, ResManager.loadKDString((String)"\u672a\u77e5\u7ec4\u7ec7", (String)"LogSaveService_7", (String)"bos-mservice-log", (Object[])new Object[0]));
                        } else if (appLogInfo.getOrgID() == -1L) {
                            preparedStatement.setString(15, ResManager.loadKDString((String)"\u533f\u540d\u7ec4\u7ec7", (String)"LogSaveService_8", (String)"bos-mservice-log", (Object[])new Object[0]));
                        } else {
                            name = NameQueryService.getOrgName(account, appLogInfo.getLanguage(), appLogInfo.getOrgID());
                            preparedStatement.setString(15, (String)name);
                        }
                    } else {
                        preparedStatement.setString(15, ResManager.loadKDString((String)"\u7a7a\u7ec4\u7ec7", (String)"LogSaveService_9", (String)"bos-mservice-log", (Object[])new Object[0]));
                    }
                }
                catch (Exception ignore) {
                    logger.error("\u67e5\u8be2\u767b\u5f55\u65e5\u5fd7\u7ec4\u7ec7\u4fe1\u606f\u53d1\u751f\u5f02\u5e38\uff1a", (Throwable)ignore);
                    preparedStatement.setString(15, ResManager.loadKDString((String)"\u672a\u77e5\u7ec4\u7ec7", (String)"LogSaveService_7", (String)"bos-mservice-log", (Object[])new Object[0]));
                }
                preparedStatement.setString(16, appLogInfo.getModifyBillID() == null ? " " : appLogInfo.getModifyBillID());
                preparedStatement.setString(17, appLogInfo.getModifyContent() == null ? " " : CommonUtils.getLogContent(appLogInfo.getModifyContent()));
                preparedStatement.setString(18, appLogInfo.getModifyContentTag() == null ? " " : appLogInfo.getModifyContentTag());
                preparedStatement.setString(19, appLogInfo.getModifyFields() == null ? " " : appLogInfo.getModifyFields());
                preparedStatement.setString(20, appLogInfo.getModifyBillNo() == null ? " " : appLogInfo.getModifyBillNo());
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            conn.commit();
        }
        catch (Exception ignore) {
            logger.error("\u767b\u5f55\u65e5\u5fd7\u5199\u5165\u53d1\u751f\u5f02\u5e38\uff1a", (Throwable)ignore);
        }
        finally {
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public void saveToEs(List<AppLogInfo> records, String index) throws IOException {
        ArrayList<Map<String, Object>> data;
        ElasticsearchService service;
        JSONObject properties = EsPropertiesUtils.getTenantEsProperties();
        if (properties != null && properties.size() > 0) {
            service = ElasticsearchService.getInstance();
            data = new ArrayList<Map<String, Object>>(records.size());
            for (AppLogInfo record : records) {
                HashMap<String, Object> temp = new HashMap<String, Object>(16);
                temp.put("id", ID.genStringId());
                temp.put("userId", record.getUserID());
                temp.put("bizAppId", record.getBizAppID());
                temp.put("bizObjId", record.getBizObjID());
                temp.put("orgId", record.getOrgID());
                temp.put("opTime", record.getOpTime().getTime());
                temp.put("clientType", record.getClientType());
                temp.put("clientIp", record.getClientIP());
                temp.put("status", record.getStatus());
                String opName = LogSaveService.getOpName(record);
                temp.put("opName", opName);
                temp.put("opDescription", record.getOpDescription());
                if (record instanceof OpLogAppInfo) {
                    OpLogAppInfo logAppInfo = (OpLogAppInfo)record;
                    temp.put("opKey", logAppInfo.getOpKey());
                    temp.put("keyword", logAppInfo.getKeyWord());
                    String opDesc = logAppInfo.getOpDescription();
                    opDesc = LogSaveService.getOpDisplayDesc(Lang.zh_CN, opDesc, logAppInfo.getOpDescProjId(), logAppInfo.getOpDescResId(), logAppInfo.getOpDescArgs());
                    temp.put("opDescription", opDesc);
                }
                temp.put("clientName", record.getClientName());
                try {
                    if (record.getUserID() != null) {
                        if (record.getUserID() == 0L) {
                            temp.put("userName", ResManager.loadKDString((String)"\u672a\u77e5\u59d3\u540d", (String)"LogSaveService_10", (String)"bos-mservice-log", (Object[])new Object[0]));
                            temp.put("account", ResManager.loadKDString((String)"\u672a\u77e5\u7528\u6237\u540d", (String)"LogSaveService_11", (String)"bos-mservice-log", (Object[])new Object[0]));
                            temp.put("number", ResManager.loadKDString((String)"\u672a\u77e5\u5de5\u53f7", (String)"LogSaveService_12", (String)"bos-mservice-log", (Object[])new Object[0]));
                        } else if (record.getUserID() == -1L) {
                            temp.put("userName", ResManager.loadKDString((String)"\u533f\u540d\u59d3\u540d", (String)"LogSaveService_13", (String)"bos-mservice-log", (Object[])new Object[0]));
                            temp.put("account", ResManager.loadKDString((String)"\u533f\u540d\u7528\u6237\u540d", (String)"LogSaveService_14", (String)"bos-mservice-log", (Object[])new Object[0]));
                            temp.put("number", ResManager.loadKDString((String)"\u533f\u540d\u5de5\u53f7", (String)"LogSaveService_15", (String)"bos-mservice-log", (Object[])new Object[0]));
                        } else {
                            DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)record.getUserID(), (String)"bos_user", (String)"id,name,number,username");
                            if (null != user) {
                                String userName = LocaleValueUtils.getName(user, "name");
                                temp.put("userName", userName);
                                String account = user.getString("userName");
                                temp.put("account", account);
                                String number = user.getString("number");
                                temp.put("number", number);
                            } else {
                                temp.put("userName", ResManager.loadKDString((String)"\u59d3\u540d\u4e0d\u5b58\u5728", (String)"LogSaveService_16", (String)"bos-mservice-log", (Object[])new Object[0]));
                                temp.put("account", ResManager.loadKDString((String)"\u7528\u6237\u540d\u4e0d\u5b58\u5728", (String)"LogSaveService_17", (String)"bos-mservice-log", (Object[])new Object[0]));
                                temp.put("number", ResManager.loadKDString((String)"\u5de5\u53f7\u4e0d\u5b58\u5728", (String)"LogSaveService_18", (String)"bos-mservice-log", (Object[])new Object[0]));
                            }
                        }
                    } else {
                        temp.put("userName", ResManager.loadKDString((String)"\u7a7a\u59d3\u540d", (String)"LogSaveService_19", (String)"bos-mservice-log", (Object[])new Object[0]));
                        temp.put("account", ResManager.loadKDString((String)"\u7a7a\u7528\u6237\u540d", (String)"LogSaveService_20", (String)"bos-mservice-log", (Object[])new Object[0]));
                        temp.put("number", ResManager.loadKDString((String)"\u7a7a\u5de5\u53f7", (String)"LogSaveService_21", (String)"bos-mservice-log", (Object[])new Object[0]));
                    }
                }
                catch (Exception ignore) {
                    temp.put("userName", ResManager.loadKDString((String)"\u672a\u77e5\u59d3\u540d", (String)"LogSaveService_10", (String)"bos-mservice-log", (Object[])new Object[0]));
                    temp.put("account", ResManager.loadKDString((String)"\u672a\u77e5\u7528\u6237\u540d", (String)"LogSaveService_11", (String)"bos-mservice-log", (Object[])new Object[0]));
                    temp.put("number", ResManager.loadKDString((String)"\u672a\u77e5\u5de5\u53f7", (String)"LogSaveService_12", (String)"bos-mservice-log", (Object[])new Object[0]));
                }
                try {
                    if (kd.bos.util.StringUtils.isNotEmpty((String)record.getBizAppID())) {
                        DynamicObject app = BusinessDataServiceHelper.loadSingleFromCache((Object)record.getBizAppID(), (String)"bos_devportal_bizapp", (String)COLUMN_KEY);
                        if (null != app) {
                            String appName = LocaleValueUtils.getName(app, "name");
                            temp.put("bizAppName", appName);
                        } else {
                            temp.put("bizAppName", ResManager.loadKDString((String)"\u5e94\u7528\u540d\u4e0d\u5b58\u5728", (String)"LogSaveService_22", (String)"bos-mservice-log", (Object[])new Object[0]));
                        }
                    } else {
                        temp.put("bizAppName", ResManager.loadKDString((String)"\u7a7a\u5e94\u7528", (String)"LogSaveService_3", (String)"bos-mservice-log", (Object[])new Object[0]));
                    }
                }
                catch (Exception ignore) {
                    temp.put("bizAppName", ResManager.loadKDString((String)"\u672a\u77e5\u5e94\u7528", (String)"LogSaveService_4", (String)"bos-mservice-log", (Object[])new Object[0]));
                }
                try {
                    if (kd.bos.util.StringUtils.isNotEmpty((String)record.getBizObjID())) {
                        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)record.getBizObjID(), (String)"bos_objecttype", (String)COLUMN_KEY);
                        if (null != obj) {
                            String objName = LocaleValueUtils.getName(obj, "name");
                            temp.put("bizObjName", objName);
                        } else {
                            temp.put("bizObjName", ResManager.loadKDString((String)"\u5bf9\u8c61\u540d\u4e0d\u5b58\u5728", (String)"LogSaveService_23", (String)"bos-mservice-log", (Object[])new Object[0]));
                        }
                    } else {
                        temp.put("bizObjName", ResManager.loadKDString((String)"\u7a7a\u5bf9\u8c61", (String)"LogSaveService_5", (String)"bos-mservice-log", (Object[])new Object[0]));
                    }
                }
                catch (Exception ignore) {
                    temp.put("bizObjName", ResManager.loadKDString((String)"\u672a\u77e5\u5bf9\u8c61", (String)"LogSaveService_6", (String)"bos-mservice-log", (Object[])new Object[0]));
                }
                try {
                    if (record.getOrgID() != null) {
                        if (record.getOrgID() == 0L) {
                            temp.put("orgName", ResManager.loadKDString((String)"\u672a\u77e5\u7ec4\u7ec7", (String)"LogSaveService_7", (String)"bos-mservice-log", (Object[])new Object[0]));
                        } else if (record.getOrgID() == -1L) {
                            temp.put("orgName", ResManager.loadKDString((String)"\u533f\u540d\u7ec4\u7ec7", (String)"LogSaveService_8", (String)"bos-mservice-log", (Object[])new Object[0]));
                        } else {
                            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)record.getOrgID(), (String)"bos_org", (String)COLUMN_KEY);
                            if (null != org) {
                                String orgName = LocaleValueUtils.getName(org, "name");
                                temp.put("orgName", orgName);
                            } else {
                                temp.put("orgName", ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u4e0d\u5b58\u5728", (String)"LogSaveService_24", (String)"bos-mservice-log", (Object[])new Object[0]));
                            }
                        }
                    } else {
                        temp.put("orgName", ResManager.loadKDString((String)"\u7a7a\u7ec4\u7ec7", (String)"LogSaveService_9", (String)"bos-mservice-log", (Object[])new Object[0]));
                    }
                }
                catch (Exception ignore) {
                    temp.put("orgName", ResManager.loadKDString((String)"\u672a\u77e5\u7ec4\u7ec7", (String)"LogSaveService_7", (String)"bos-mservice-log", (Object[])new Object[0]));
                }
                data.add(temp);
            }
        } else {
            throw new RuntimeException("write msg log to Elasticsearch, config is empty");
        }
        service.batchSave(data, index);
    }

    public static String getOpDisplayDesc(Lang lang, String opDesc, String opDescProj, String opDescRes, String opDescArgs) {
        if (StringUtils.isNotBlank((CharSequence)opDescProj) && StringUtils.isNotBlank((CharSequence)opDescRes) && StringUtils.isNotBlank((CharSequence)opDesc)) {
            try {
                if (StringUtils.isNotBlank((CharSequence)opDescArgs)) {
                    List descArgs = (List)SerializationUtils.fromJsonString((String)opDescArgs, List.class);
                    if (descArgs != null && !descArgs.isEmpty()) {
                        opDesc = ResManager.loadKDString((Lang)lang, (String)opDesc, (String)opDescRes, (String)opDescProj, (Object[])descArgs.toArray());
                    }
                } else {
                    opDesc = ResManager.loadKDString((Lang)lang, (String)opDesc, (String)opDescRes, (String)opDescProj, (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                logger.warn("operate detail loadKDString error:", (Throwable)e);
            }
        }
        return opDesc;
    }

    public static String getOpName(AppLogInfo logInfo) {
        List entityOperate;
        if (!(logInfo instanceof OpLogAppInfo)) {
            return logInfo.getOpName();
        }
        OpLogAppInfo opLogAppInfo = (OpLogAppInfo)logInfo;
        if (kd.bos.util.StringUtils.isEmpty((String)opLogAppInfo.getOpName()) && kd.bos.util.StringUtils.isNotEmpty((String)opLogAppInfo.getBizObjID()) && kd.bos.util.StringUtils.isNotEmpty((String)opLogAppInfo.getOpKey()) && CollectionUtils.isNotEmpty((Collection)(entityOperate = EntityMetadataCache.getDataEntityOperate((String)opLogAppInfo.getBizObjID())))) {
            for (Map op : entityOperate) {
                Object name = op.get("name");
                Object key = op.get("key");
                if (!(name instanceof Map) || !StringUtil.equals((String)opLogAppInfo.getOpKey(), (String)String.valueOf(key))) continue;
                Map localName = (Map)name;
                String displayName = String.valueOf(localName.getOrDefault(Lang.zh_CN.toString(), key));
                opLogAppInfo.setOpName(displayName);
                return displayName;
            }
        }
        return opLogAppInfo.getOpName();
    }

    private String getOpUserFormat() {
        String select = "name";
        String sql = "SELECT FID,FAPPLOGRETAINDAYS,FOPUSERFORMAT FROM T_LOG_APPSETTING";
        try (DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.log, (String)sql);){
            if (!dataSet.isEmpty()) {
                Row row = dataSet.next();
                select = row.getString(2);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return select;
    }

    public void saveSupperAdminLog(List<AppLogInfo> logInfos) {
        ArrayList<DynamicObject> logObjs = new ArrayList<DynamicObject>(8);
        for (AppLogInfo appLogInfo : logInfos) {
            DynamicObject appLogObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_log_admin_operation");
            appLogObj.set(AdminLogConstant.PROPERTY_USER_ID, (Object)appLogInfo.getUserID());
            AdminType adminType = PermissionServiceHelper.getAdminType((long)appLogInfo.getUserID());
            DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)appLogInfo.getUserID(), (String)"bos_user", (String)"name,username");
            appLogObj.set("userName", (Object)this.getUserName(user, adminType.toString()));
            appLogObj.set(AdminLogConstant.PROPERTY_BIZ_APP_ID, (Object)appLogInfo.getBizAppID());
            if (kd.bos.util.StringUtils.isNotEmpty((String)appLogInfo.getBizAppID())) {
                AppInfo appInfo = AppMetadataCache.getAppInfo((String)appLogInfo.getBizAppID());
                if (null != appInfo) {
                    appLogObj.set("bizAppName", (Object)appInfo.getName());
                } else {
                    appLogObj.set("bizAppName", (Object)ResManager.loadKDString((String)"\u5e94\u7528\u540d\u4e0d\u5b58\u5728", (String)"LogConsumer_4", (String)"bos-mservice-log", (Object[])new Object[0]));
                }
            } else {
                appLogObj.set("bizAppName", (Object)ResManager.loadKDString((String)"\u7a7a\u5e94\u7528", (String)"LogConsumer_5", (String)"bos-mservice-log", (Object[])new Object[0]));
            }
            appLogObj.set(AdminLogConstant.PROPERTY_BIZ_OBJ_ID, (Object)appLogInfo.getBizObjID());
            if (kd.bos.util.StringUtils.isNotEmpty((String)appLogInfo.getBizObjID())) {
                DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)appLogInfo.getBizObjID(), (String)"bos_objecttype", (String)COLUMN_KEY);
                if (null != obj) {
                    appLogObj.set("bizObjName", (Object)LocaleValueUtils.getName(obj, "name"));
                } else {
                    appLogObj.set("bizObjName", (Object)ResManager.loadKDString((String)"\u5bf9\u8c61\u540d\u4e0d\u5b58\u5728", (String)"LogConsumer_6", (String)"bos-mservice-log", (Object[])new Object[0]));
                }
            } else {
                appLogObj.set("bizObjName", (Object)ResManager.loadKDString((String)"\u7a7a\u5bf9\u8c61", (String)"LogConsumer_7", (String)"bos-mservice-log", (Object[])new Object[0]));
            }
            appLogObj.set(AdminLogConstant.PROPERTY_ORG_ID, (Object)appLogInfo.getOrgID());
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)appLogInfo.getOrgID(), (String)"bos_org", (String)COLUMN_KEY);
            if (null != org) {
                appLogObj.set("orgName", (Object)LocaleValueUtils.getName(org, "name"));
            } else {
                appLogObj.set("orgName", (Object)ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u4e0d\u5b58\u5728", (String)"LogConsumer_8", (String)"bos-mservice-log", (Object[])new Object[0]));
            }
            appLogObj.set(AdminLogConstant.PROPERTY_OP_TIME, (Object)appLogInfo.getOpTime());
            appLogObj.set(AdminLogConstant.PROPERTY_CLIENT_TYPE, (Object)appLogInfo.getClientType());
            appLogObj.set(AdminLogConstant.PROPERTY_CLIENT_IP, (Object)appLogInfo.getClientIP());
            appLogObj.set(AdminLogConstant.PROPERTY_CLIENT_NAME, (Object)appLogInfo.getClientName());
            String opName = LogSaveService.getOpName(appLogInfo);
            appLogObj.set(AdminLogConstant.PROPERTY_OP_NAME, (Object)opName);
            String opDesc = appLogInfo.getOpDescription();
            if (appLogInfo instanceof OpLogAppInfo) {
                OpLogAppInfo logAppInfo = (OpLogAppInfo)appLogInfo;
                opDesc = LogSaveService.getOpDisplayDesc(Lang.zh_CN, opDesc, logAppInfo.getOpDescProjId(), logAppInfo.getOpDescResId(), logAppInfo.getOpDescArgs());
            }
            if (kd.bos.util.StringUtils.isNotEmpty((String)opDesc)) {
                appLogObj.set(AdminLogConstant.PROPERTY_OP_DESCRIPTION, (Object)(opDesc.length() > 255 ? opDesc.substring(0, 255) : opDesc));
            }
            appLogObj.set(AdminLogConstant.PROPERTY_OP_MODIFYBILLID, (Object)appLogInfo.getModifyBillID());
            appLogObj.set(AdminLogConstant.PROPERTY_OP_MODIFYBILLNO, (Object)appLogInfo.getModifyBillNo());
            appLogObj.set(AdminLogConstant.PROPERTY_OP_MODIFYCONTENT, (Object)CommonUtils.getLogContent(appLogInfo.getModifyContent()));
            appLogObj.set(AdminLogConstant.PROPERTY_OP_MODIFYFIELDS, (Object)appLogInfo.getModifyFields());
            appLogObj.set(AdminLogConstant.PROPERTY_USER_TYPE, (Object)adminType.toString());
            logObjs.add(appLogObj);
        }
        if (!logObjs.isEmpty()) {
            LogORM logORM = LogORM.create();
            logORM.insert(logObjs);
        }
    }

    public void saveLoginLog(List<AppLogInfo> appLogInfoList) {
        String entityName = "bos_login_log_new";
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        ArrayList<DynamicObject> objects = new ArrayList<DynamicObject>(8);
        for (int i = 0; i < appLogInfoList.size(); ++i) {
            LogInAppInfo logInAppInfo;
            String extendClientName;
            AppLogInfo appLogInfo = appLogInfoList.get(i);
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)entityType);
            DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)appLogInfo.getUserID(), (String)"bos_user", (String)"name,username");
            dynamicObject.set("username", (Object)this.getUserName(user, null));
            dynamicObject.set("userid", (Object)appLogInfo.getUserID());
            dynamicObject.set("opname", (Object)appLogInfo.getOpName());
            dynamicObject.set("opdesc", (Object)appLogInfo.getOpDescription());
            dynamicObject.set("opdate", (Object)new Date());
            dynamicObject.set("clientname", (Object)appLogInfo.getClientName());
            String clientIp = appLogInfo.getClientIP();
            if (kd.bos.util.StringUtils.isNotEmpty((String)clientIp)) {
                dynamicObject.set("clientip", (Object)clientIp.split(",")[0]);
            }
            dynamicObject.set("bizappid", (Object)appLogInfo.getBizAppID());
            if (appLogInfo instanceof LogInAppInfo && kd.bos.util.StringUtils.isNotEmpty((String)(extendClientName = (logInAppInfo = (LogInAppInfo)appLogInfo).getExtendClientName()))) {
                dynamicObject.set("extendfield1", (Object)extendClientName.toUpperCase());
            }
            if (kd.bos.util.StringUtils.isNotEmpty((String)appLogInfo.getBizAppID())) {
                DynamicObject app = BusinessDataServiceHelper.loadSingleFromCache((Object)appLogInfo.getBizAppID(), (String)"bos_devportal_bizapp", (String)COLUMN_KEY);
                if (null != app) {
                    String appName = LocaleValueUtils.getName(app, "name");
                    dynamicObject.set("bizappname", (Object)appName);
                } else {
                    dynamicObject.set("bizappname", (Object)ResManager.loadKDString((String)"\u5e94\u7528\u540d\u4e0d\u5b58\u5728", (String)"LogSaveService_22", (String)"bos-mservice-log", (Object[])new Object[0]));
                }
            } else {
                dynamicObject.set("bizappname", (Object)ResManager.loadKDString((String)"\u7a7a\u5e94\u7528", (String)"LogSaveService_3", (String)"bos-mservice-log", (Object[])new Object[0]));
            }
            dynamicObject.set("orgid", (Object)appLogInfo.getOrgID());
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)appLogInfo.getOrgID(), (String)"bos_org", (String)COLUMN_KEY);
            if (null != org) {
                dynamicObject.set("orgname", (Object)LocaleValueUtils.getName(org, "name"));
            } else {
                dynamicObject.set("orgname", (Object)ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u4e0d\u5b58\u5728", (String)"LogConsumer_8", (String)"bos-mservice-log", (Object[])new Object[0]));
            }
            dynamicObject.getDataEntityType().getPrimaryKey().setValueFast((Object)dynamicObject, (Object)ID.genLongId());
            objects.add(dynamicObject);
        }
        if (!objects.isEmpty()) {
            LogORM logORM = LogORM.create();
            logORM.insert(objects);
        }
    }

    private String getUserName(DynamicObject user, String usertype) {
        String format = UserFormatCache.getUserFormat(usertype);
        String[] columns = format.split("\\+");
        if (null != user) {
            StringBuilder opUser = new StringBuilder();
            for (String column : columns) {
                try {
                    String value = LocaleValueUtils.getName(user, column);
                    if (value != null) {
                        opUser.append(value);
                    }
                    opUser.append(" ");
                }
                catch (Exception e) {
                    opUser.append(" ");
                }
            }
            return opUser.toString().trim();
        }
        return ResManager.loadKDString((String)"\u7528\u6237\u540d\u4e0d\u5b58\u5728", (String)"LogConsumer_0", (String)"bos-mservice-log", (Object[])new Object[0]);
    }

    public void saveAuthOpLog(OperateConfirmLog confirmLog) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"bos_authoperate_log");
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)mainEntityType);
        dynamicObject.set("bizobj", (Object)confirmLog.getFormNumber());
        dynamicObject.set("verifyoperate", (Object)confirmLog.getVerifyOperate());
        dynamicObject.set("verifymode", (Object)confirmLog.getVerifyMode());
        dynamicObject.set("authoperateresult", (Object)confirmLog.getOpResult());
        dynamicObject.set("operatedate", (Object)confirmLog.getOpDate());
        dynamicObject.set("operateuser", (Object)confirmLog.getOpUser());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }
}

