/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.service;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.lang.Lang;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.service.LogSaveService;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class LogServiceImpl
implements ILogService {
    private static final int BATCH_SIZE = 1000;

    public void addLog(AppLogInfo appLogInfo) {
        if (appLogInfo == null) {
            return;
        }
        if (appLogInfo.getLogType() == 3) {
            this.addOpLog(appLogInfo);
            return;
        }
        ArrayList<AppLogInfo> appLogInfoList = new ArrayList<AppLogInfo>(1);
        appLogInfoList.add(appLogInfo);
        this.addBatchLog(appLogInfoList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOpLog(AppLogInfo appLogInfo) {
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("base", "log_service");){
            pub.publish((Object)appLogInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatchLog(List<AppLogInfo> appLogInfoList) {
        if (appLogInfoList == null || appLogInfoList.isEmpty()) {
            return;
        }
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("base", "log_service");){
            Long loginUser = 0L;
            Long loginOrgId = 0L;
            String loginClient = "";
            String loginClientIP = "";
            if (RequestContext.get() != null) {
                if (StringUtils.isNotEmpty((CharSequence)RequestContext.get().getUserId())) {
                    loginUser = Long.parseLong(RequestContext.get().getUserId());
                }
                loginOrgId = RequestContext.get().getOrgId();
                if (StringUtils.isNotEmpty((CharSequence)RequestContext.get().getClient())) {
                    loginClient = RequestContext.get().getClient();
                }
                if (StringUtils.isNotEmpty((CharSequence)RequestContext.get().getLoginIP())) {
                    loginClientIP = RequestContext.get().getLoginIP();
                }
            }
            Date currentTime = new Date();
            ArrayList<AppLogInfo> messageBuffer = new ArrayList<AppLogInfo>(1000);
            Iterator<AppLogInfo> iterator = appLogInfoList.iterator();
            while (iterator.hasNext()) {
                AppLogInfo appLogInfo;
                Long userId = (appLogInfo = iterator.next()).getUserID();
                appLogInfo.setUserID(userId == null ? loginUser : userId);
                Long orgId = appLogInfo.getOrgID();
                appLogInfo.setOrgID(orgId == null ? loginOrgId : orgId);
                Date opTime = appLogInfo.getOpTime();
                appLogInfo.setOpTime(opTime == null ? currentTime : opTime);
                String clientType = appLogInfo.getClientType();
                appLogInfo.setClientType(StringUtils.isEmpty((CharSequence)clientType) ? loginClient : clientType);
                String clientIP = appLogInfo.getClientIP();
                appLogInfo.setClientIP(StringUtils.isEmpty((CharSequence)clientIP) ? loginClientIP : clientIP);
                String clientName = appLogInfo.getClientName();
                appLogInfo.setClientName(StringUtils.isEmpty((CharSequence)clientName) ? loginClient : clientName);
                messageBuffer.add(appLogInfo);
                if (messageBuffer.size() < 1000) continue;
                pub.publish(messageBuffer);
                if (Boolean.getBoolean("lightweightdeploy")) {
                    messageBuffer = new ArrayList(1000);
                    continue;
                }
                messageBuffer.clear();
            }
            if (!messageBuffer.isEmpty()) {
                pub.publish(messageBuffer);
                if (Boolean.getBoolean("lightweightdeploy")) {
                    return;
                }
                messageBuffer.clear();
            }
        }
    }

    public List<Map<String, Object>> getOperationLogByUserId(Long userId, int month, int top) {
        if (top >= 3000) {
            top = 3000;
        }
        if (month >= 12) {
            month = 12;
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(8);
        qFilterList.add(new QFilter("optime", ">=", (Object)this.getDateFilter(month)));
        qFilterList.add(new QFilter("user", "=", (Object)userId));
        List<Map<String, Object>> result1 = this.getOpLogV3(top, qFilterList);
        if (result1 != null) {
            return result1;
        }
        return this.getOpLogV2(top, qFilterList);
    }

    private List<Map<String, Object>> getOpLogV2(int top, List<QFilter> qFilterList) {
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"bos_log_operation_web", (String)"id,bizapp.id,bizobj.id,bizappname,bizobjname,opnamee,opdescriptione,optime", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]), (String)"optime desc", (int)top);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(8);
        for (DynamicObject data : array) {
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            map.put("bizAppId", data.get("bizapp.id"));
            map.put("bizappname", data.get("bizappname"));
            map.put("bizObjId", data.get("bizobj.id"));
            map.put("bizobjname", data.get("bizobjname"));
            map.put("opName", data.getString("opnamee"));
            map.put("opDescription", data.getString("opdescriptione"));
            map.put("opTime", data.get("optime"));
            result.add(map);
        }
        return result;
    }

    private List<Map<String, Object>> getOpLogV3(int top, List<QFilter> qFilterList) {
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"bos_log_operation_v3", (String)"id,bizapp.id,bizobj.id,bizobj.number,opname,opkey,opproj,opres,opdesc,opdescproj,opdescres,opdescargs,keyword,optime", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]), (String)"optime desc", (int)top);
        if (array != null && array.length > 0) {
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(8);
            HashSet<String> entityNums = new HashSet<String>();
            for (DynamicObject objData : array) {
                String entityNum = LogServiceImpl.valueOf(objData.get("bizobj.number"));
                String opkey = LogServiceImpl.valueOf(objData.get("opkey"));
                String opproj = LogServiceImpl.valueOf(objData.get("opproj"));
                String opres = LogServiceImpl.valueOf(objData.get("opres"));
                if (!StringUtils.isBlank((CharSequence)opproj) || !StringUtils.isBlank((CharSequence)opres) || !StringUtils.isNotBlank((CharSequence)opkey)) continue;
                entityNums.add(String.valueOf(entityNum));
            }
            HashMap operateMap = entityNums.isEmpty() ? new HashMap(4) : EntityMetadataCache.getDataEntityOperations(entityNums);
            for (DynamicObject data : array) {
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                map.put("bizAppId", data.get("bizapp.id"));
                map.put("bizappname", "");
                map.put("bizObjId", data.get("bizobj.id"));
                map.put("bizobjname", "");
                map.put("opTime", data.get("optime"));
                String opname = LogServiceImpl.valueOf(data.get("opname"));
                String entityNum = LogServiceImpl.valueOf(data.get("bizobj.number"));
                String opkey = LogServiceImpl.valueOf(data.get("opkey"));
                String opproj = LogServiceImpl.valueOf(data.get("opproj"));
                String opres = LogServiceImpl.valueOf(data.get("opres"));
                if (LogServiceImpl.isZHCNEnv()) {
                    map.put("opName", opname);
                } else {
                    Map localName;
                    Object localValue;
                    Object name;
                    Optional<Map> option;
                    List maps;
                    String displayOpName;
                    String string = displayOpName = StringUtils.isNotBlank((CharSequence)opkey) ? opkey : opname;
                    if (StringUtils.isNotBlank((CharSequence)opproj) && StringUtils.isNotBlank((CharSequence)opres) && StringUtils.isNotBlank((CharSequence)opname)) {
                        displayOpName = ResManager.loadKDString((String)opname, (String)opres, (String)opproj, (Object[])new Object[0]);
                    } else if (!StringUtils.isBlank((CharSequence)opkey) && !StringUtils.isBlank((CharSequence)entityNum) && CollectionUtils.isNotEmpty((Collection)(maps = (List)operateMap.get(entityNum))) && (option = maps.stream().filter(item -> StringUtils.equals((CharSequence)String.valueOf(item.get("key")), (CharSequence)opkey)).findAny()).isPresent() && (name = option.get().get("name")) instanceof Map && (localValue = (localName = (Map)name).get(RequestContext.get().getLang().toString())) != null) {
                        displayOpName = LogServiceImpl.valueOf(localValue);
                    }
                    map.put("opName", displayOpName);
                }
                String opDesc = LogServiceImpl.valueOf(data.get("opdesc"));
                String opDescProj = LogServiceImpl.valueOf(data.get("opdescproj"));
                String opDescRes = LogServiceImpl.valueOf(data.get("opdescres"));
                String opDescArgs = LogServiceImpl.valueOf(data.get("opdescargs"));
                opDesc = LogSaveService.getOpDisplayDesc(Lang.get(), opDesc, opDescProj, opDescRes, opDescArgs);
                map.put("opDescription", opDesc);
                result.add(map);
            }
            return result;
        }
        return null;
    }

    private Date getDateFilter(int month) {
        LocalDate today = LocalDate.now();
        LocalDate nDaysAgo = today.minusMonths(month);
        Instant instant = nDaysAgo.atStartOfDay(ZoneId.systemDefault()).toInstant();
        Date date = Date.from(instant);
        return date;
    }

    private static String valueOf(Object val) {
        if (val != null && StringUtils.isNotBlank((CharSequence)val.toString())) {
            return (String)val;
        }
        return "";
    }

    private static boolean isZHCNEnv() {
        return RequestContext.get().getLang() == Lang.zh_CN;
    }
}

