/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.service;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.log.service.util.LocaleValueUtils;
import org.apache.flink.api.java.tuple.Tuple4;

public class NameQueryService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tuple4<String, String, String, String> getUserName(Account account, String language, long userId) {
        Properties dataBaseProperties = AccountUtils.getTenantDBInfoByRoutekey((Account)account, (String)DBRoute.base.getRouteKey());
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String name = ResManager.loadKDString((String)"\u59d3\u540d\u4e0d\u5b58\u5728", (String)"LogSaveService_16", (String)"bos-mservice-log", (Object[])new Object[0]);
        String userName = ResManager.loadKDString((String)"\u7528\u6237\u540d\u4e0d\u5b58\u5728", (String)"NameQueryService_0", (String)"bos-mservice-log", (Object[])new Object[0]);
        String number = ResManager.loadKDString((String)"\u5de5\u53f7\u4e0d\u5b58\u5728", (String)"NameQueryService_1", (String)"bos-mservice-log", (Object[])new Object[0]);
        String sql = "SELECT G.FId \"user.id\", CASE WHEN B.ftruename IS NULL THEN G.ftruename WHEN B.ftruename = '' THEN G.ftruename WHEN B.ftruename = ' ' THEN G.ftruename ELSE B.ftruename END \"user.name\" ,B.FLOCALEID \"localeid\",U.FUSERNAME,G.FNUMBER,G.FPHONE FROM t_SEC_User G LEFT JOIN t_SEC_User_L B ON B.FId=G.FId LEFT JOIN t_sec_user_u U ON U.FID=G.FID WHERE G.FID=?";
        String phone = "";
        try {
            conn = MCDBUtil.getConnection((Properties)dataBaseProperties);
            preparedStatement = conn.prepareStatement(sql);
            preparedStatement.setLong(1, userId);
            resultSet = preparedStatement.executeQuery();
            HashMap<String, String> localeValue = new HashMap<String, String>(16);
            while (resultSet.next()) {
                String localeId = resultSet.getString(3);
                String tempName = resultSet.getString(2);
                userName = resultSet.getString(4);
                number = resultSet.getString(5);
                phone = resultSet.getString(6);
                if (!StringUtils.isNotBlank((CharSequence)localeId) || !StringUtils.isNotBlank((CharSequence)name)) continue;
                localeValue.put(localeId, tempName);
            }
            name = LocaleValueUtils.getName(localeValue, language, name);
        }
        catch (Exception exception) {
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return new Tuple4((Object)name, (Object)userName, (Object)number, (Object)phone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOrgName(Account account, String language, long orgId) {
        Properties dataBaseProperties = AccountUtils.getTenantDBInfoByRoutekey((Account)account, (String)DBRoute.base.getRouteKey());
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String name = ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u4e0d\u5b58\u5728", (String)"NameQueryService_2", (String)"bos-mservice-log", (Object[])new Object[0]);
        String sql = "SELECT H.FId \"org.id\", CASE WHEN E.FName IS NULL THEN H.FName WHEN E.FName = '' THEN H.FName WHEN E.FName = ' ' THEN H.FName ELSE E.FName END \"org.name\",E.FLOCALEID FROM t_ORG_ORG H LEFT JOIN t_ORG_ORG_L E ON E.FId=H.FId WHERE H.FID=? ";
        try {
            conn = MCDBUtil.getConnection((Properties)dataBaseProperties);
            preparedStatement = conn.prepareStatement(sql);
            preparedStatement.setLong(1, orgId);
            resultSet = preparedStatement.executeQuery();
            HashMap<String, String> localeValue = new HashMap<String, String>(16);
            while (resultSet.next()) {
                String localeId = resultSet.getString(3);
                String tempName = resultSet.getString(2);
                if (!StringUtils.isNotBlank((CharSequence)localeId) || !StringUtils.isNotBlank((CharSequence)name)) continue;
                localeValue.put(localeId, tempName);
            }
            name = LocaleValueUtils.getName(localeValue, language, name);
        }
        catch (Exception exception) {
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAppName(Account account, String language, String appId) {
        Properties dataBaseProperties;
        try {
            dataBaseProperties = AccountUtils.getTenantDBInfoByRoutekey((Account)account, (String)DBRoute.meta.getRouteKey());
        }
        catch (Exception ignore) {
            dataBaseProperties = AccountUtils.getTenantDBInfoByRoutekey((Account)account, (String)DBRoute.base.getRouteKey());
        }
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String name = ResManager.loadKDString((String)"\u5e94\u7528\u540d\u4e0d\u5b58\u5728", (String)"NameQueryService_3", (String)"bos-mservice-log", (Object[])new Object[0]);
        String sql = "SELECT C.FId \"bizapp.id\", C.fname \"bizapp.name\",C.FLOCALEID FROM t_meta_bizapp_L C WHERE C.FID=?";
        try {
            conn = MCDBUtil.getConnection((Properties)dataBaseProperties);
            preparedStatement = conn.prepareStatement(sql);
            preparedStatement.setString(1, appId);
            resultSet = preparedStatement.executeQuery();
            HashMap<String, String> localeValue = new HashMap<String, String>(16);
            while (resultSet.next()) {
                String localeId = resultSet.getString(3);
                String tempName = resultSet.getString(2);
                if (!StringUtils.isNotBlank((CharSequence)localeId) || !StringUtils.isNotBlank((CharSequence)name)) continue;
                localeValue.put(localeId, tempName);
            }
            name = LocaleValueUtils.getName(localeValue, language, name);
        }
        catch (Exception exception) {
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getObjName(Account account, String language, String objId) {
        Properties dataBaseProperties;
        try {
            dataBaseProperties = AccountUtils.getTenantDBInfoByRoutekey((Account)account, (String)DBRoute.meta.getRouteKey());
        }
        catch (Exception ignore) {
            dataBaseProperties = AccountUtils.getTenantDBInfoByRoutekey((Account)account, (String)DBRoute.base.getRouteKey());
        }
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String name = ResManager.loadKDString((String)"\u5bf9\u8c61\u540d\u4e0d\u5b58\u5728", (String)"NameQueryService_4", (String)"bos-mservice-log", (Object[])new Object[0]);
        String sql = "SELECT D.FNumber \"bizobj.id\", D.fname \"bizobj.name\",D.FLOCALEID FROM t_meta_formdesign_L D WHERE D.FNUMBER=?";
        try {
            conn = MCDBUtil.getConnection((Properties)dataBaseProperties);
            preparedStatement = conn.prepareStatement(sql);
            preparedStatement.setString(1, objId);
            resultSet = preparedStatement.executeQuery();
            HashMap<String, String> localeValue = new HashMap<String, String>(16);
            while (resultSet.next()) {
                String localeId = resultSet.getString(3);
                String tempName = resultSet.getString(2);
                if (!StringUtils.isNotBlank((CharSequence)localeId) || !StringUtils.isNotBlank((CharSequence)name)) continue;
                localeValue.put(localeId, tempName);
            }
            name = LocaleValueUtils.getName(localeValue, language, name);
        }
        catch (Exception exception) {
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return name;
    }
}

