/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.service.elasticsearch;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.log.service.util.EsPropertiesUtils;
import kd.bos.log.service.util.TimeUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class ElasticsearchService {
    private static final Log logger = LogFactory.getLog(ElasticsearchService.class);
    private final ConcurrentHashMap<String, RestHighLevelClient> clientMap = new ConcurrentHashMap();
    private static final String HOST_KEY = "log";
    private static final Object lockObj = new Object();

    public static ElasticsearchService getInstance() {
        return Holder.instance;
    }

    private ElasticsearchService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RestHighLevelClient getClient() {
        String accountId = RequestContext.get().getAccountId();
        String key = accountId + HOST_KEY;
        RestHighLevelClient restHighLevelClient = this.clientMap.get(key);
        if (restHighLevelClient != null) {
            return restHighLevelClient;
        }
        Object object = lockObj;
        synchronized (object) {
            restHighLevelClient = this.clientMap.get(key);
            if (restHighLevelClient != null) {
                return restHighLevelClient;
            }
            Properties config = this.initConfig();
            if (config != null) {
                String hostName = config.getProperty("hostname");
                int port = Integer.parseInt(config.getProperty("port", "9200"));
                String scheme = config.getProperty("scheme", "http");
                final String userName = config.getProperty("userName");
                final String password = config.getProperty("password");
                String[] ips = hostName.split(",");
                HttpHost[] host = new HttpHost[ips.length];
                for (int i = 0; i < ips.length; ++i) {
                    host[i] = new HttpHost(ips[i], port, scheme);
                }
                RestClientBuilder builder = RestClient.builder((HttpHost[])host);
                builder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(){

                    public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpAsyncClientBuilder) {
                        BasicCredentialsProvider credentialsProvider = null;
                        if (StringUtils.isNotEmpty((CharSequence)userName) && StringUtils.isNotEmpty((CharSequence)password)) {
                            credentialsProvider = new BasicCredentialsProvider();
                            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
                        }
                        if (credentialsProvider != null) {
                            httpAsyncClientBuilder.disableAuthCaching();
                            httpAsyncClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                        }
                        IOReactorConfig ioReactorConfig = new IOReactorConfig();
                        ioReactorConfig.setIoThreadCount(4);
                        httpAsyncClientBuilder.setDefaultIOReactorConfig(ioReactorConfig);
                        httpAsyncClientBuilder.setThreadFactory((ThreadFactory)new NamedThreadFactory());
                        httpAsyncClientBuilder.setMaxConnTotal(4);
                        httpAsyncClientBuilder.setMaxConnPerRoute(1);
                        return httpAsyncClientBuilder;
                    }
                });
                this.clientMap.putIfAbsent(key, new RestHighLevelClient(builder));
                restHighLevelClient = this.clientMap.get(key);
            }
        }
        return restHighLevelClient;
    }

    private Properties initConfig() {
        JSONObject properties = EsPropertiesUtils.getTenantEsProperties();
        if (properties != null && properties.size() > 0) {
            Properties cfg = new Properties();
            cfg.put("hostname", properties.getString("host"));
            cfg.put("port", properties.getString("port"));
            cfg.put("userName", properties.getString("userName"));
            cfg.put("password", properties.getString("passwd"));
            cfg.put("scheme", properties.getString("schema"));
            return cfg;
        }
        return null;
    }

    public boolean indexExist(String index) {
        RestHighLevelClient restHighLevelClient = this.getClient();
        if (restHighLevelClient == null) {
            logger.info("\u64cd\u4f5c\u65e5\u5fd7\u83b7\u53d6index\u65f6client\u4e3a\u7a7a");
            return false;
        }
        boolean exists = false;
        GetIndexRequest getIndexRequest = new GetIndexRequest(new String[]{index});
        getIndexRequest.humanReadable(true);
        try {
            exists = restHighLevelClient.indices().exists(getIndexRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            logger.error("\u64cd\u4f5c\u65e5\u5fd7\u5224\u65adElasticsearch\u73af\u5883 index \u662f\u5426\u5b58\u5728\u5f02\u5e38", (Throwable)e);
        }
        return exists;
    }

    public XContentBuilder mapping() throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject().startObject("properties").startObject("id").field("type", "keyword").endObject().startObject("userId").field("type", "long").endObject().startObject("bizAppId").field("type", "keyword").endObject().startObject("bizObjId").field("type", "keyword").endObject().startObject("orgId").field("type", "long").endObject().startObject("opTime").field("type", "date").field("format", "epoch_millis||yyyy-MM-dd HH:mm:ss").endObject().startObject("clientType").field("type", "keyword").endObject().startObject("clientIp").field("type", "text").endObject().startObject("opDescription").field("type", "text").field("analyzer", "standard").field("search_analyzer", "standard").endObject().startObject("opName").field("type", "text").field("analyzer", "standard").field("search_analyzer", "standard").endObject().startObject("clientName").field("type", "text").field("analyzer", "standard").field("search_analyzer", "standard").endObject().startObject("userName").field("type", "text").field("analyzer", "standard").field("search_analyzer", "standard").endObject().startObject("bizAppName").field("type", "text").field("analyzer", "standard").field("search_analyzer", "standard").endObject().startObject("bizObjName").field("type", "text").field("analyzer", "standard").field("search_analyzer", "standard").endObject().startObject("orgName").field("type", "text").field("analyzer", "standard").field("search_analyzer", "standard").endObject().startObject("number").field("type", "keyword").endObject().startObject("account").field("type", "keyword").endObject().endObject().endObject();
        return builder;
    }

    public boolean createIndex(String index) throws IOException {
        if (StringUtils.isEmpty((CharSequence)index)) {
            logger.error("\u64cd\u4f5c\u65e5\u5fd7\u521b\u5efaindex\u65f6index\u4e3a\u7a7a");
            return false;
        }
        RestHighLevelClient restHighLevelClient = this.getClient();
        if (restHighLevelClient == null) {
            logger.info("\u64cd\u4f5c\u65e5\u5fd7\u521b\u5efaindex\u65f6client\u4e3a\u7a7a");
            return false;
        }
        Properties config = this.initConfig();
        if (config == null) {
            return false;
        }
        int numberOfShards = Integer.parseInt(config.getProperty("number_of_shards", "5"));
        int numberOfReplicas = Integer.parseInt(config.getProperty("number_of_replicas", "1"));
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(index);
        createIndexRequest.settings(Settings.builder().put("index.number_of_shards", numberOfShards).put("index.number_of_replicas", numberOfReplicas));
        createIndexRequest.mapping(this.mapping());
        CreateIndexResponse response = restHighLevelClient.indices().create(createIndexRequest, RequestOptions.DEFAULT);
        boolean acknowledged = response.isAcknowledged();
        boolean shardsAcknowledged = response.isShardsAcknowledged();
        if (acknowledged || shardsAcknowledged) {
            logger.info("\u521b\u5efa\u7d22\u5f15\u6210\u529f\uff01\u7d22\u5f15\u540d\u79f0\u4e3a:\u3010" + index + "\u3011");
            return true;
        }
        return false;
    }

    public int batchSave(List<Map<String, Object>> records, String index) throws IOException {
        if (StringUtils.isEmpty((CharSequence)index)) {
            logger.error("\u64cd\u4f5c\u65e5\u5fd7\u6570\u636e\u6279\u91cf\u4fdd\u5b58\u65f6index\u4e3a\u7a7a");
            return -1;
        }
        RestHighLevelClient restHighLevelClient = this.getClient();
        if (restHighLevelClient == null) {
            logger.info("\u64cd\u4f5c\u65e5\u5fd7\u6570\u636e\u6279\u91cf\u4fdd\u5b58\u65f6client\u4e3a\u7a7a");
            return -1;
        }
        if (records.size() > 1) {
            BulkRequest bulkRequest = new BulkRequest();
            for (Map<String, Object> record : records) {
                IndexRequest request = new IndexRequest(index, "_doc", String.valueOf(record.get("id")));
                request.source(record);
                bulkRequest.add(request);
            }
            BulkResponse responses = restHighLevelClient.bulk(bulkRequest, RequestOptions.DEFAULT);
            return responses.status().getStatus();
        }
        if (records.size() == 1) {
            Map<String, Object> record = records.get(0);
            IndexRequest indexRequest = new IndexRequest(index, "_doc", String.valueOf(record.get("id")));
            indexRequest.source(record);
            IndexResponse response = restHighLevelClient.index(indexRequest, RequestOptions.DEFAULT);
            return response.status().getStatus();
        }
        return -1;
    }

    public SearchHits search(Map<String, Object> condition, String index) throws IOException {
        long start = System.currentTimeMillis();
        if (StringUtils.isEmpty((CharSequence)index)) {
            logger.error("\u4e0a\u673a\u64cd\u4f5c\u65e5\u5fd7\u67e5\u8be2\uff0cindex \u4e3a\u7a7a");
            return null;
        }
        RestHighLevelClient restHighLevelClient = this.getClient();
        if (restHighLevelClient == null) {
            logger.info("\u64cd\u4f5c\u65e5\u5fd7\u6570\u636e\u67e5\u8be2\u65f6client\u4e3a\u7a7a");
            return null;
        }
        String[] indices = index.split(",");
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.indices(indices);
        searchRequest.types(new String[]{"_doc"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        this.handleQueryBuilder(boolQueryBuilder, (List)condition.get("search"));
        if (!condition.containsKey("opTime")) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"opTime").lte((Object)TimeUtils.formatTime(LocalDateTime.now())));
        } else {
            String[] opTime = (String[])condition.get("opTime");
            String startTime = opTime[0];
            String endTime = opTime[1];
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"opTime").gte((Object)TimeUtils.getTimeStamp(startTime, "yyyy-MM-dd HH:mm:ss")).lte((Object)TimeUtils.getTimeStamp(endTime, "yyyy-MM-dd HH:mm:ss")));
        }
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        searchSourceBuilder.from(0);
        Integer size = Integer.parseInt(String.valueOf(condition.get("limit")));
        searchSourceBuilder.trackTotalHits(true);
        searchSourceBuilder.size(size.intValue());
        searchSourceBuilder.sort("opTime", SortOrder.DESC);
        searchSourceBuilder.fetchSource(new String[]{"orgName", "clientName", "userName", "bizObjName", "number", "clientType", "opTime", "opName", "clientIp", "bizAppName", "opDescription", "account"}, null);
        Object[] searchAfter = (Object[])condition.get("searchAfter");
        if (searchAfter != null && searchAfter.length > 0) {
            searchSourceBuilder.searchAfter(searchAfter);
        }
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
        logger.info("elasticsearch\u6570\u636e\u67e5\u8be2\u82b1\u8d39\u65f6\u957f\uff1a" + (System.currentTimeMillis() - start) + ",took:" + searchResponse.getTook().getMillis() + ",\u5339\u914d\u6570\u636e:" + searchResponse.getHits().getTotalHits());
        if (searchResponse.status() == RestStatus.OK) {
            return searchResponse.getHits();
        }
        return null;
    }

    public void close() throws IOException {
        RestHighLevelClient restHighLevelClient = this.getClient();
        if (restHighLevelClient != null) {
            restHighLevelClient.close();
            String accountId = RequestContext.get().getAccountId();
            String key = accountId + HOST_KEY;
            this.clientMap.remove(key);
        }
    }

    public double getIndexCapacity(String index) {
        if (StringUtils.isEmpty((CharSequence)index)) {
            logger.error("\u64cd\u4f5c\u65e5\u5fd7\u6570\u636e\u67e5\u8be2index\u5bb9\u91cf\u65f6index\u4e3a\u7a7a");
            return -1.0;
        }
        RestHighLevelClient restHighLevelClient = this.getClient();
        if (restHighLevelClient == null) {
            logger.info("\u64cd\u4f5c\u65e5\u5fd7\u6570\u636e\u67e5\u8be2index\u5bb9\u91cf\u65f6client\u4e3a\u7a7a");
            return -1.0;
        }
        double size = -1.0;
        try {
            Request request = new Request("GET", index + "/_stats");
            Response response = restHighLevelClient.getLowLevelClient().performRequest(request);
            ObjectMapper mapper = new ObjectMapper();
            Map jsonMap = (Map)mapper.readValue(response.getEntity().getContent(), Map.class);
            Map all = (Map)jsonMap.get("_all");
            Map primaries = (Map)all.get("primaries");
            Map store = (Map)primaries.get("store");
            long capacity = Long.parseLong(String.valueOf(store.get("size_in_bytes")));
            BigDecimal a = new BigDecimal(capacity);
            BigDecimal b = new BigDecimal(1024);
            size = a.divide(b, 2, 4).doubleValue();
        }
        catch (Exception e) {
            logger.error("\u64cd\u4f5c\u65e5\u5fd7\u67e5\u8be2index\u5bb9\u91cf\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return size;
    }

    public Map<String, Object> getIndexStats(String index) {
        if (StringUtils.isEmpty((CharSequence)index)) {
            logger.error("\u64cd\u4f5c\u65e5\u5fd7\u6570\u636e\u67e5\u8be2index\u72b6\u6001\u65f6index\u4e3a\u7a7a");
            return null;
        }
        RestHighLevelClient restHighLevelClient = this.getClient();
        if (restHighLevelClient == null) {
            logger.info("\u64cd\u4f5c\u65e5\u5fd7\u6570\u636e\u67e5\u8be2index\u72b6\u6001\u65f6client\u4e3a\u7a7a");
            return null;
        }
        try {
            Request request = new Request("GET", index + "/_stats");
            Response response = restHighLevelClient.getLowLevelClient().performRequest(request);
            ObjectMapper mapper = new ObjectMapper();
            Map jsonMap = (Map)mapper.readValue(response.getEntity().getContent(), Map.class);
            return jsonMap;
        }
        catch (Exception e) {
            logger.error("\u64cd\u4f5c\u65e5\u5fd7\u6570\u636e\u67e5\u8be2index\u72b6\u6001\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
            return null;
        }
    }

    public Set<String> getAllIndexInElasticsearch() {
        RestHighLevelClient restHighLevelClient = this.getClient();
        if (restHighLevelClient == null) {
            logger.info("\u64cd\u4f5c\u65e5\u5fd7\u6570\u636e\u67e5\u8be2index\u72b6\u6001\u65f6client\u4e3a\u7a7a");
            return Collections.emptySet();
        }
        try {
            Request request = new Request("GET", "_stats");
            Response response = restHighLevelClient.getLowLevelClient().performRequest(request);
            ObjectMapper mapper = new ObjectMapper();
            Map jsonMap = (Map)mapper.readValue(response.getEntity().getContent(), Map.class);
            Map indices = (Map)jsonMap.get("indices");
            return indices.keySet();
        }
        catch (Exception e) {
            logger.error("\u64cd\u4f5c\u65e5\u5fd7\u6570\u636e\u67e5\u8be2\u6240\u6709index\u5217\u8868\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
            return Collections.emptySet();
        }
    }

    private void handleQueryBuilder(BoolQueryBuilder boolQueryBuilder, List<Map<String, Object>> condition) {
        if (CollectionUtils.isNotEmpty(condition)) {
            for (int i = 0; i < condition.size(); ++i) {
                Map<String, Object> temp = condition.get(i);
                List fieldName = (List)temp.get("fieldName");
                List values = (List)temp.get("value");
                BoolQueryBuilder tempQuery = new BoolQueryBuilder();
                for (int j = 0; j < fieldName.size(); ++j) {
                    String key = (String)fieldName.get(j);
                    for (String value : values) {
                        tempQuery.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)key, (Object)value).slop(0));
                    }
                }
                boolQueryBuilder.filter((QueryBuilder)tempQuery);
            }
        }
    }

    static class NamedThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger POOL_SEQ = new AtomicInteger(1);
        private final AtomicInteger mThreadNum = new AtomicInteger(1);
        private final String mPrefix;
        private final boolean mDaemo;
        private final ThreadGroup mGroup;

        public NamedThreadFactory() {
            this("pool-log-elasticsearch-" + POOL_SEQ.getAndIncrement(), false);
        }

        public NamedThreadFactory(String prefix) {
            this(prefix, false);
        }

        public NamedThreadFactory(String prefix, boolean daemo) {
            this.mPrefix = prefix + "-thread-";
            this.mDaemo = daemo;
            SecurityManager s = System.getSecurityManager();
            this.mGroup = s == null ? Thread.currentThread().getThreadGroup() : s.getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable runnable) {
            String name = this.mPrefix + this.mThreadNum.getAndIncrement();
            Thread ret = new Thread(this.mGroup, runnable, name, 0L);
            ret.setDaemon(this.mDaemo);
            return ret;
        }
    }

    private static class Holder {
        public static final ElasticsearchService instance = new ElasticsearchService();

        private Holder() {
        }
    }
}

