/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.service.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.context.RequestContext;
import kd.bos.encrypt.Encrypters;

public class EsPropertiesUtils {
    private static final String CONFIG_KEY = "esloginfo";

    public static JSONObject getTenantEsProperties() {
        String tenantInfo = System.getProperty(String.format("mc.tenant.%s.data", RequestContext.get().getTenantId()));
        JSONArray jsonArray = JSONArray.parseArray((String)tenantInfo);
        if (jsonArray == null || jsonArray.size() <= 0) {
            return null;
        }
        String accountId = RequestContext.get().getAccountId();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String dataCenterId = jsonObject.getString("datacenterid");
            if (!accountId.equals(dataCenterId) || !jsonObject.containsKey((Object)CONFIG_KEY) || jsonObject.getJSONArray(CONFIG_KEY) == null || jsonObject.getJSONArray(CONFIG_KEY).size() <= 0) continue;
            JSONArray esConfig = jsonObject.getJSONArray(CONFIG_KEY);
            for (int j = 0; j < esConfig.size(); ++j) {
                JSONObject temp = esConfig.getJSONObject(j);
                String indexTep = temp.getString("indexTep");
                if (indexTep == null || !indexTep.contains("log_operation_log")) continue;
                return EsPropertiesUtils.decodePwd(temp);
            }
        }
        return null;
    }

    public static String getTenantEsHost() {
        JSONObject properties = EsPropertiesUtils.getTenantEsProperties();
        if (properties != null) {
            return properties.getString("host");
        }
        return null;
    }

    public static String getTenantEsSchema() {
        JSONObject properties = EsPropertiesUtils.getTenantEsProperties();
        if (properties != null) {
            return properties.getString("schema");
        }
        return null;
    }

    public static String getTenantEsUser() {
        JSONObject properties = EsPropertiesUtils.getTenantEsProperties();
        if (properties != null) {
            return properties.getString("userName");
        }
        return null;
    }

    public static String getTenantEsPwd() {
        JSONObject properties = EsPropertiesUtils.getTenantEsProperties();
        if (properties != null) {
            return properties.getString("passwd");
        }
        return null;
    }

    public static String getTenantEsPort() {
        JSONObject properties = EsPropertiesUtils.getTenantEsProperties();
        if (properties != null) {
            return properties.getString("port");
        }
        return null;
    }

    public static String getTenantEsIndexTep() {
        JSONObject properties = EsPropertiesUtils.getTenantEsProperties();
        if (properties != null) {
            return properties.getString("indexTep");
        }
        return null;
    }

    public static JSONObject getTenantEsIndexStrategy() {
        JSONObject properties = EsPropertiesUtils.getTenantEsProperties();
        if (properties != null) {
            String temp = properties.getString("createStrategy");
            return JSON.parseObject((String)temp);
        }
        return null;
    }

    private static JSONObject decodePwd(JSONObject raw) {
        if (raw.containsKey((Object)"passwd")) {
            String pwd = raw.getString("passwd");
            raw.put("passwd", (Object)Encrypters.decode((String)pwd));
        }
        return raw;
    }
}

