/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.service.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public class TimeUtils {
    public static Long getMorningMills() {
        LocalDateTime time = LocalDateTime.now();
        LocalDateTime morning = LocalDateTime.of(time.getYear(), time.getMonth(), time.getDayOfMonth(), 0, 0, 0);
        return morning.toInstant(ZoneOffset.of("+8")).toEpochMilli();
    }

    public static LocalDateTime getMorningTime() {
        LocalDateTime time = LocalDateTime.now();
        LocalDateTime morning = LocalDateTime.of(time.getYear(), time.getMonth(), time.getDayOfMonth(), 0, 0, 0);
        return morning;
    }

    public static String formatTime(LocalDateTime time) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return time.format(formatter);
    }

    public static String formatTime(LocalDateTime time, String format) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        return time.format(formatter);
    }

    public static Long getTimeStamp(String time, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            return sdf.parse(time).getTime();
        }
        catch (ParseException parseException) {
            return 0L;
        }
    }
}

