/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login;

import kd.sdk.annotation.SdkPublic;

@SdkPublic
public enum LoginClientEnum {
    WEB(1, "web"),
    MOBILE(1, "mobile"),
    API(1, "api"),
    WEBSERVICE(1, "webservice"),
    BATCH(2, "batch"),
    WORKFLOW(2, "workflow"),
    CHAT(2, "chat"),
    TRIPSI(2, "TRIPSI"),
    MQ(2, "MQ"),
    MSERVICE_SDK(2, "MserviceSDK"),
    NEWAPI(2, "newapi"),
    CLOUD_DEVELOPER(2, "cloud_developer");

    private int level;
    private String desc;

    private LoginClientEnum(int level, String desc) {
        this.level = level;
        this.desc = desc;
    }

    public static LoginClientEnum getLoginClientByValue(String client) {
        for (LoginClientEnum current : LoginClientEnum.values()) {
            if (!current.getDesc().equalsIgnoreCase(client)) continue;
            return current;
        }
        return null;
    }

    public String getDesc() {
        return this.desc;
    }

    public static LoginClientEnum getClientForLevel1(LoginClientEnum clientEnum) {
        LoginClientEnum clientEnumDefault = WEB;
        if (clientEnum == null) {
            return clientEnumDefault;
        }
        if (clientEnum.level == 1) {
            return clientEnum;
        }
        if (clientEnum.level == 2 && clientEnum == NEWAPI) {
            return API;
        }
        return clientEnumDefault;
    }

    public static String getClientDescForLevel1(LoginClientEnum clientEnum) {
        return LoginClientEnum.getClientForLevel1(clientEnum).getDesc();
    }
}

