/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import javax.imageio.ImageIO;
import kd.bos.login.utils.StringUtils;

public class VerifyCode {
    private int w = 80;
    private int h = 40;
    private SecureRandom r = StringUtils.getRandom();
    private String[] fontNames = new String[]{"Monospaced"};
    private String codes = "23456789abcdefghjkmnpqrstuvwxyzABCEFGHIJKLMNPQRSTUVWXYZ";
    private Color bgColor = new Color(255, 255, 255);
    private String text;

    private Color randomColor() {
        int red = this.r.nextInt(200);
        int green = this.r.nextInt(200);
        int blue = this.r.nextInt(200);
        return new Color(red, green, blue);
    }

    private Font randomFont() {
        int index = this.r.nextInt(this.fontNames.length);
        String fontName = this.fontNames[index];
        int style = this.r.nextInt(2) * 2 + 1;
        int size = this.r.nextInt(6) + 22;
        return new Font(fontName, style, size);
    }

    private void drawLine(BufferedImage image) {
        int num = 3;
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        g2.setColor(this.getRandColor(160, 200));
        for (int i = 0; i < num; ++i) {
            int x = this.r.nextInt(this.w - 1);
            int y = this.r.nextInt(this.h - 1);
            int xl = this.r.nextInt(6) + 1;
            int yl = this.r.nextInt(12) + 1;
            g2.drawLine(x, y, x + xl + 60, y + yl + 10);
        }
        float yawpRate = 0.05f;
        int area = (int)(yawpRate * (float)this.w * (float)this.h);
        for (int i = 0; i < area; ++i) {
            int x = this.r.nextInt(this.w);
            int y = this.r.nextInt(this.h);
            int rgb = this.getRandomIntColor();
            image.setRGB(x, y, rgb);
        }
    }

    private Color getRandColor(int fc, int bc) {
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int rl = fc + this.r.nextInt(bc - fc);
        int g = fc + this.r.nextInt(bc - fc);
        int b = fc + this.r.nextInt(bc - fc);
        return new Color(rl, g, b);
    }

    private int getRandomIntColor() {
        int[] rgb = this.getRandomRgb();
        int color = 0;
        for (int c : rgb) {
            color <<= 8;
            color |= c;
        }
        return color;
    }

    private int[] getRandomRgb() {
        int[] rgb = new int[3];
        for (int i = 0; i < 3; ++i) {
            rgb[i] = this.r.nextInt(255);
        }
        return rgb;
    }

    private char randomChar() {
        int index = this.r.nextInt(this.codes.length());
        return this.codes.charAt(index);
    }

    private BufferedImage createImage() {
        BufferedImage image = new BufferedImage(this.w, this.h, 1);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        g2.setColor(this.bgColor);
        g2.fillRect(0, 0, this.w, this.h);
        return image;
    }

    public BufferedImage getImage() {
        BufferedImage image = this.createImage();
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            String s = this.randomChar() + "";
            sb.append(s);
            float x = (float)i * 1.0f * (float)this.w / 4.0f;
            g2.setFont(this.randomFont());
            g2.setColor(this.randomColor());
            int y = this.h - 10;
            g2.drawString(s, x, (float)y);
        }
        this.text = sb.toString();
        this.drawLine(image);
        return image;
    }

    public String getText() {
        return this.text;
    }

    public static void output(BufferedImage image, OutputStream out) throws IOException {
        ImageIO.write((RenderedImage)image, "JPEG", out);
    }
}

