/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.actions;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.api.ApiRequestContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.api.model.AccountVO;
import kd.bos.entity.param.CustomParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.actions.LoginAction;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.login.api.model.Detail;
import kd.bos.login.api.model.FileTypeEnum;
import kd.bos.login.api.model.Schema;
import kd.bos.login.api.service.SchemaService;
import kd.bos.login.lang.LangContext;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.model.AuthSignatureResult;
import kd.bos.login.model.Language;
import kd.bos.login.model.ThirdAuthApp;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.login.service.ILoginExtService;
import kd.bos.login.service.ThirdAppService;
import kd.bos.login.thirdauth.app.dingding.DDAppInfo;
import kd.bos.login.thirdauth.app.dingding.DDConfigSign;
import kd.bos.login.thirdauth.app.dingding.DDUtils;
import kd.bos.login.thirdauth.app.sky.SkyUtils;
import kd.bos.login.thirdauth.app.tencent.CorpObj;
import kd.bos.login.thirdauth.app.tencent.WxqyhUtils;
import kd.bos.login.thirdauth.app.tencent.wechat.WXBizMsgCrypt;
import kd.bos.login.user.DefaultParameterService;
import kd.bos.login.user.LanguageService;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.user.PrivacyPolicyService;
import kd.bos.login.user.PswStrategyService;
import kd.bos.login.util.GlobalDeployUtils;
import kd.bos.login.utils.CommonZIPUtils;
import kd.bos.login.utils.Constants;
import kd.bos.login.utils.ContentTypeConstants;
import kd.bos.login.utils.HttpClientUtils;
import kd.bos.login.utils.JSONUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.ParametersUtils;
import kd.bos.login.utils.SHAUtils;
import kd.bos.login.utils.SecurityUtils;
import kd.bos.login.utils.SessionUtils;
import kd.bos.login.utils.StrategeUtils;
import kd.bos.login.utils.account.LoginAccount;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.session.SessionInfo;
import kd.bos.session.SessionKeys;
import kd.bos.session.SessionManager;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.BeanUtils;
import kd.bos.util.CollectionUtils;
import kd.bos.util.RevProxyUtil;
import org.apache.commons.lang.StringUtils;

public class ApiInterfaceAction {
    private static final String BINDING_FLAG = "bindingflag";
    private static final String BOS_LOGIN = "bos-login";
    private static final String SYS_ERROE_CONTACT_ADMIN = "System error, please contact system administrator.";
    private static final String API_INTERFACE_ACTION_0 = "ApiInterfaceAction_0";
    private static final String ACCOUNT_ID = "accountId";
    private static final String SUCCESS = "success";
    private static final String API_INTERFACE_ACTION_4 = "ApiInterfaceAction_4";
    private static final String USER_ID = "userId";
    public static final int DEFAULT_USER_SOURCE_TYPE_COSMIC = 2;
    private static final String ENABLE_RSA_ECB_OAEP = "enable_rsa_ecb_oaep";
    private static Log logger = LogFactory.getLog(ApiInterfaceAction.class);

    public void getAllDatacenters(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Lang lang = LoginLangUtils.getLoginLanguage(request);
        LoginLangUtils.setLang(lang);
        try {
            List<Account> centerList = LoginAccountFactory.createInstanceByDefault(request).getAccounts();
            List<AccountVO> voList = centerList.stream().map(v -> this.getAccountVo((Account)v)).collect(Collectors.toList());
            if (centerList != null && (voList == null || voList.size() <= 0)) {
                Account accountCenter = LoginAccountFactory.createInstanceByDefault(request).getAccount();
                voList.add(this.getAccountVo(accountCenter));
            }
            List<Map<String, Object>> mapList = this.handleDatacenter(voList, RevProxyUtil.getTenantCode((HttpServletRequest)request));
            String result = SerializationUtils.toJsonString(mapList);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
        }
        catch (KDException ex) {
            logger.info(ex.getMessage());
            ErrorCode code = ex.getErrorCode();
            String resp = LoginUtils.getLoginResponse(String.valueOf(code.getCode()), ex.getMessage());
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)resp);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            String resp = LoginUtils.getLoginResponse("1", SYS_ERROE_CONTACT_ADMIN + e.getMessage());
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)resp);
        }
    }

    private AccountVO getAccountVo(Account center) {
        AccountVO vo = new AccountVO();
        vo.setAccountId(center.getAccountId());
        vo.setAccountName(center.getAccountName());
        vo.setAccountNumber(center.getAccountNumber());
        vo.setDefault(center.isDefault());
        vo.setDefaultUserSourceType(2);
        return vo;
    }

    public static List<Map<String, Object>> getAttachments(String pkId) {
        Object object = DispatchServiceHelper.invokeBOSService("FormService", "getAttachmentUrlsByPkId", pkId);
        return (List)object;
    }

    public void checkUserExisting(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String userNo;
        boolean isOk = false;
        String tenantAlias = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        if (StringUtils.isNotEmpty((String)tenantAlias) && StringUtils.isNotEmpty((String)(userNo = request.getParameter("phone")))) {
            String accountIdParameter = request.getParameter(ACCOUNT_ID);
            isOk = LoginUserService.checkUserExisting(tenantAlias, accountIdParameter, userNo);
        }
        HashMap<String, Boolean> returnMap = new HashMap<String, Boolean>(8);
        returnMap.put(SUCCESS, isOk);
        String sJson = JSONUtils.toString(returnMap);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)sJson);
    }

    public void getAllDetails(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String schemeId;
            String tenantAlias = RevProxyUtil.getTenantCode((HttpServletRequest)request);
            List<Object> detailList = new ArrayList();
            if (StringUtils.isNotEmpty((String)tenantAlias) && StringUtils.isNotEmpty((String)(schemeId = request.getParameter("schemeId")))) {
                String accountIdParameter = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty()).getAccountId();
                detailList = SchemaService.getAllDetails(tenantAlias, accountIdParameter, schemeId);
            }
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)SerializationUtils.toJsonString(detailList));
        }
        catch (KDException ex) {
            logger.error((Throwable)ex);
            ErrorCode code = ex.getErrorCode();
            String resp = LoginUtils.getLoginResponse(String.valueOf(code.getCode()), ex.getMessage());
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)resp);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            String resp = LoginUtils.getLoginResponse("1", SYS_ERROE_CONTACT_ADMIN + e.getMessage());
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)resp);
        }
    }

    public void getDetailByID(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String tenantAlias = RevProxyUtil.getTenantCode((HttpServletRequest)request);
            Detail detail = null;
            if (StringUtils.isNotEmpty((String)tenantAlias)) {
                String schemeId = request.getParameter("schemeId");
                String entryId = request.getParameter("entryId");
                if (StringUtils.isNotEmpty((String)schemeId)) {
                    String accountIdParameter = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty()).getAccountId();
                    detail = SchemaService.getDetailByID(tenantAlias, accountIdParameter, schemeId, entryId);
                }
            }
            if (detail != null) {
                FileTypeEnum typeEnum = FileTypeEnum.getFileTypeEnumByFileType(detail.getFileType());
                switch (typeEnum) {
                    case CSS: {
                        LoginUtils.writeResponseResult((ServletResponse)response, detail.getFileContent(), ContentTypeConstants.CSS);
                        break;
                    }
                    case JS: {
                        LoginUtils.writeResponseResult((ServletResponse)response, detail.getFileContent(), ContentTypeConstants.JS);
                        break;
                    }
                    default: {
                        LoginUtils.writeResponseResult((ServletResponse)response, detail.getFileContent(), ContentTypeConstants.JS);
                    }
                }
            }
        }
        catch (KDException ex) {
            logger.error((Throwable)ex);
            ErrorCode code = ex.getErrorCode();
            String resp = LoginUtils.getLoginResponse(String.valueOf(code.getCode()), ex.getMessage());
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)resp);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            String resp = LoginUtils.getLoginResponse("1", SYS_ERROE_CONTACT_ADMIN + e.getMessage());
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)resp);
        }
    }

    public static void getDetailByPath(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            RequestContext rc = RequestContext.get();
            Object detail = null;
            if (rc != null) {
                Schema schema;
                String path = request.getRequestURI();
                String pagePath = ApiInterfaceAction.getCorrectPagePath(request, path);
                String templateId = null;
                String fullPath = null;
                int firstSignIndex = pagePath.indexOf("/");
                if (firstSignIndex > 0) {
                    templateId = pagePath.substring(0, firstSignIndex);
                    if (firstSignIndex < pagePath.length()) {
                        fullPath = pagePath.substring(firstSignIndex + 1, pagePath.length());
                    }
                }
                String version = "v10";
                String pkID = null;
                if (templateId != null && (schema = SchemaService.getPKIByPath(rc.getAccountId(), templateId)) != null) {
                    pkID = schema.getfID();
                    String tVersion = schema.getVersion();
                    if (StringUtils.isNotEmpty((String)tVersion)) {
                        tVersion = tVersion.replace(".", "");
                        version = tVersion = tVersion.replace("-", "");
                    }
                }
                if (pkID == null) {
                    throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u8bbf\u95ee\u7684URL\u4e0d\u6b63\u786e\uff0c\u9519\u8bef\u7684URL\u4e3a%s\u3002", (String)"ApiInterfaceAction_1", (String)BOS_LOGIN, (Object[])new Object[0]), path)});
                }
                List<Map<String, Object>> resultInfo = ApiInterfaceAction.getAttachments(pkID);
                if (resultInfo == null || resultInfo.size() < 1) {
                    throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u63d2\u4ef6\u5fae\u670d\u52a1\u8fd4\u56de\u7ed3\u679c\u63a5\u53e3\u4e0d\u6b63\u786e\u3002", (String)"ApiInterfaceAction_2", (String)BOS_LOGIN, (Object[])new Object[0]), new Object[0])});
                }
                String url = (String)resultInfo.get(0).get("url");
                String filePath = (String)resultInfo.get(0).get("name");
                String fileType = (String)resultInfo.get(0).get("type");
                String unzipFilePath = ApiInterfaceAction.getUnzipFilePath(pkID);
                unzipFilePath = unzipFilePath + version;
                ApiInterfaceAction.handleZIPInfo(request, response, fullPath, url, filePath, fileType, unzipFilePath);
            }
        }
        catch (KDException ex) {
            logger.error((Throwable)ex);
            ErrorCode code = ex.getErrorCode();
            String resp = LoginUtils.getLoginResponse(String.valueOf(code.getCode()), ex.getMessage());
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)resp);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            String resp = LoginUtils.getLoginResponse("1", SYS_ERROE_CONTACT_ADMIN + e.getMessage());
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void handleZIPInfo(HttpServletRequest request, HttpServletResponse response, String fullPath, String url, String filePath, String fileType, String unzipFilePath) throws IOException {
        File lastFile = ApiInterfaceAction.getQueryFile(fullPath, unzipFilePath);
        if (lastFile != null && lastFile.exists() && lastFile.canRead()) {
            LoginUtils.writeResponseStream(request, response, lastFile, ApiInterfaceAction.getFileName(fullPath));
            return;
        }
        Class<ApiInterfaceAction> clazz = ApiInterfaceAction.class;
        synchronized (ApiInterfaceAction.class) {
            File downloadFile = HttpClientUtils.download(url, unzipFilePath + filePath);
            if (downloadFile != null && ("zip".equals(fileType) || "rar".equals(fileType))) {
                CommonZIPUtils.unzip(downloadFile, unzipFilePath, false);
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            if (lastFile == null || !lastFile.exists() || !lastFile.canRead()) return;
            LoginUtils.writeResponseStream(request, response, lastFile, ApiInterfaceAction.getFileName(fullPath));
            return;
        }
    }

    private static String getFileName(String fullPath) {
        String returnValue = fullPath;
        if (fullPath != null && fullPath.contains(File.separator)) {
            returnValue = fullPath.substring(fullPath.lastIndexOf(File.separator), fullPath.length());
        }
        return returnValue;
    }

    private static File getQueryFile(String fullPath, String unzipFilePath) {
        File returnFile = new File(SecurityUtils.normalize(unzipFilePath + File.separator + fullPath));
        return returnFile;
    }

    private static String getUnzipFilePath(String pkID) {
        String unzipRoot = System.getProperty("download.plugin_temp.unzip_path");
        if (StringUtils.isEmpty((String)unzipRoot)) {
            unzipRoot = "." + File.separator + "temp" + File.separator;
        }
        if (!unzipRoot.endsWith(File.separator)) {
            unzipRoot = unzipRoot + File.pathSeparator;
        }
        return unzipRoot + pkID;
    }

    public void getDetailByIDTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LoginUtils.writeResponseString(response, "document.write(\"<h1>this is a test</h1>\");", "sTest.js");
    }

    public void getPublicKey(HttpServletRequest request, HttpServletResponse response) {
        String accessKey = request.getParameter("accessKey");
        boolean isOK = false;
        String errorMessage = "";
        String publicKey = "";
        Account currentCenter = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty()).getAccount();
        try {
            if (StringUtils.isNotEmpty((String)accessKey)) {
                if (accessKey.trim().length() < 13) {
                    throw new KDException(LoginErrorCode.loginBizException, new Object[]{"Illegal operation."});
                }
                publicKey = LoginUtils.getPublicKeyByAccessKey(accessKey, currentCenter.getAccountId());
                isOK = true;
            } else {
                errorMessage = "Illegal operation.";
            }
        }
        catch (KDException e) {
            logger.error((Throwable)e);
            errorMessage = e.getMessage();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            errorMessage = "Illegal operation.";
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>(8);
        returnMap.put(SUCCESS, isOK);
        returnMap.put("errorMessage", errorMessage);
        returnMap.put("publicKey", publicKey);
        try {
            String sJson = JSONUtils.toString(returnMap);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)sJson);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
    }

    public void isNeedDisplayVerify(HttpServletRequest request, HttpServletResponse response) {
        String userName = request.getParameter(Constants.LOGIN_USER_KEY);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(8);
        boolean isNeed = false;
        try {
            String tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)request);
            if (LoginUtils.isForcedInputVerifyCode(tenantId)) {
                isNeed = true;
            }
            if (!LoginUtils.isIgnoreNeedVerifyCode() && !isNeed) {
                Map<String, Object> userMap = StrategeUtils.getUserId(request, userName);
                String userId = null;
                Account currentCenter = null;
                if (userMap != null && userMap.get(USER_ID) != null) {
                    userId = (String)userMap.get(USER_ID);
                    currentCenter = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty()).getAccount();
                    if (!kd.bos.login.utils.StringUtils.isEmpty(userId)) {
                        isNeed = StrategeUtils.isNeedDisplayVerifyCode(currentCenter, userMap, LoginClientEnum.WEB.toString());
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        map.put("isNeed", isNeed);
        try {
            String result = JSONUtils.toString(map);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
    }

    private static String getCorrectPagePath(HttpServletRequest request, String path) {
        int index;
        String returnPath = path;
        if (path != null && (index = path.indexOf("/kdctlres/")) != -1) {
            returnPath = path.substring(index + "/kdctlres/".length());
        }
        return returnPath;
    }

    public void getUserLanguage(HttpServletRequest request, HttpServletResponse response) {
        RequestContext rc = RequestContext.get();
        HashMap<String, String> map = new HashMap<String, String>(8);
        Lang lang = Lang.defaultLang();
        if (rc != null) {
            lang = rc.getLang();
            map.put(USER_ID, rc.getAccountId() + "_" + rc.getUserId());
        }
        map.put("language", lang.toString());
        try {
            Account currentCenter = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty()).getAccount();
            Lang defaultLang = LangContext.getDefaultLang();
            map.put("defaultLang", defaultLang == null ? "zh_CN" : defaultLang.name());
            map.put(ACCOUNT_ID, currentCenter.getAccountId());
            String result = JSONUtils.toString(map);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
    }

    public void isNeedNewFactor(HttpServletRequest request, HttpServletResponse response) {
        String userName = request.getParameter(Constants.LOGIN_USER_KEY);
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        boolean isNeed = false;
        try {
            Map<String, Object> userMap = StrategeUtils.getUserId(request, userName);
            Account currentCenter = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty()).getAccount();
            isNeed = LoginUtils.getIsNeedFactor(currentCenter, request, userMap);
            Map<String, Object> passwordStrategy = PswStrategyService.getPasswordStrategyByUserId(currentCenter, userMap);
            if (null != passwordStrategy.get("floginoptions") && "4".equals(passwordStrategy.get("floginoptions"))) {
                map.put("factor", "email");
                isNeed = true;
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        map.put("isNeed", isNeed);
        try {
            String result = JSONUtils.toString(map);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
    }

    public void getLoginErrorMessage(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        String globalSessionId = LoginUtils.getKDCookieValue(request);
        String message = "";
        if (StringUtils.isNotEmpty((String)globalSessionId)) {
            message = SessionUtils.getLoginExitMessageBySessionId(globalSessionId);
            String message1 = SessionUtils.getLoginExitMessageBySessionId(globalSessionId, "userDisable");
            if (StringUtils.isNotEmpty((String)message)) {
                SessionUtils.setLoginExitMessageBySessionId(globalSessionId, "", 0);
            } else if (StringUtils.isNotEmpty((String)message1)) {
                message = message1;
                map.put("confirmType", 4);
                map.put("buttonType", 0);
                CacheLoginData.setAttribute((String)"userDisable", (String)LoginUtils.getExistsCachkey(globalSessionId), (String)"", (int)0);
            }
        }
        map.put("message", message);
        try {
            String result = JSONUtils.toString(map);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
    }

    public void getCustomData(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String returnValue = "";
        Map<Object, Object> returnMap = new HashMap(8);
        try {
            returnMap = LoginUtils.getCustomDataMapNew(request, true);
            if (returnMap == null) {
                returnMap = new HashMap();
            }
            Account currentCenter = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty()).getAccount();
            List<Language> lList = LoginUtils.getAllLanguagesByAccount(currentCenter);
            String languages = SerializationUtils.toJsonString(lList);
            returnMap.put("languages", languages);
            returnMap.put("licenseType", LicenseServiceHelper.getLicenseType());
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        returnValue = JSON.toJSONString(returnMap);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)returnValue);
    }

    public void switchLanguage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Lang lang;
        boolean returnValue = false;
        if (RequestContext.get() != null && !(lang = LoginLangUtils.getLoginLanguage(request)).name().equals(RequestContext.get().getLang().name())) {
            Account currentCenter;
            List<Language> languageList;
            boolean needChange = false;
            String language = request.getParameter("language");
            if (StringUtils.isNotEmpty((String)language) && language.equals(lang.name()) && (languageList = LanguageService.getAllLanguage(currentCenter = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty()).getAccount())) != null) {
                for (Language langObj : languageList) {
                    if (!language.equalsIgnoreCase(langObj.getNumber())) continue;
                    needChange = true;
                    break;
                }
            }
            if (needChange) {
                String sessionId = RequestContext.get().getGlobalSessionId();
                SessionManager.editSessionValue((String)sessionId, (String)"language", (String)lang.name());
                returnValue = true;
            }
        }
        HashMap<String, Boolean> mpData = new HashMap<String, Boolean>(8);
        mpData.put("switched", returnValue);
        String sJson = JSONUtils.toString(mpData);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)sJson);
    }

    public void getWeixinData(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, Object> returnMap;
        boolean isOk;
        String errorMessage;
        block8: {
            String returnValue = "";
            errorMessage = "";
            isOk = false;
            returnMap = new HashMap<String, Object>(8);
            try {
                String url = request.getHeader("Referer");
                Account currentCenter = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty()).getAccount();
                CorpObj corpObj = WxqyhUtils.getCorpSecret(currentCenter);
                if (corpObj != null) {
                    String accessToken = WxqyhUtils.getAccess_token(corpObj.getCorpId(), corpObj.getCorpSecret(), currentCenter);
                    if (StringUtils.isEmpty((String)accessToken)) {
                        logger.info("wxqyh\uff1aaccess_token is null !");
                    } else {
                        String ticket = WxqyhUtils.getWeixinTicket(accessToken, currentCenter);
                        String nonceStr = kd.bos.util.StringUtils.randomWord((int)16);
                        Date now = new Date();
                        String timestamp = String.valueOf(now.getTime());
                        StringBuilder sb = new StringBuilder();
                        sb.append("jsapi_ticket=").append(ticket).append("&noncestr=").append(nonceStr).append("&timestamp=").append(timestamp).append("&url=").append(url);
                        logger.info(String.format("Weixin String=%s", sb.toString()));
                        String signature = SHAUtils.sha(sb.toString());
                        returnMap.put("appId", corpObj.getCorpId());
                        returnMap.put("timestamp", timestamp);
                        returnMap.put("nonceStr", nonceStr);
                        returnMap.put("signature", signature);
                        isOk = true;
                    }
                    break block8;
                }
                throw new Exception("corpId,corpSecret is not config.");
            }
            catch (KDException e) {
                logger.error((Throwable)e);
                errorMessage = e.getMessage();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                errorMessage = e.getMessage();
            }
        }
        returnMap.put(SUCCESS, isOk);
        returnMap.put("errorMessage", errorMessage);
        try {
            String sJson = JSONUtils.toString(returnMap);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)sJson);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
    }

    public void getAppTrdAuthData(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map<Object, Object> returnMap = new HashMap<String, Object>(8);
        Account currentCenter = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty()).getAccount();
        String url = request.getHeader("Referer");
        try {
            String appType = request.getParameter("apptype");
            String entryRole = request.getParameter("entryRole");
            if (url.contains("#")) {
                url = url.substring(0, url.indexOf("#"));
            }
            List<Object> authSignatureList = new ArrayList(2);
            if (StringUtils.isBlank((String)entryRole)) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{"entryRole is null."});
            }
            ThirdAuthApp thirdAuthAppInfo = this.getThirdAuthApp(request, appType, entryRole, url);
            authSignatureList = ThirdAppService.getAuthSignatureList(currentCenter, thirdAuthAppInfo);
            if (CollectionUtils.isNotEmpty(authSignatureList)) {
                returnMap = this.wrapAppTrdAuthData(authSignatureList);
                String sJson = JSONUtils.toString(returnMap);
                ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)sJson);
                return;
            }
        }
        catch (KDException e) {
            returnMap.put(SUCCESS, false);
            returnMap.put("message", e.getMessage());
            String sJson = JSONUtils.toString(returnMap);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)sJson);
            return;
        }
        String errorMessage = "";
        boolean isOk = false;
        String agentId = request.getParameter("agentId");
        url = request.getRequestURL().toString();
        if (url.contains("#")) {
            url = url.substring(0, url.indexOf("#"));
        }
        try {
            DDAppInfo appInfo = DDUtils.getAppInfo(currentCenter);
            if (appInfo == null) {
                throw new Exception("appkey or appSecret is null");
            }
            String accessToken = DDUtils.getAccess_token(appInfo.getAppkey(), appInfo.getAppsecret(), currentCenter);
            if (StringUtils.isEmpty((String)accessToken)) {
                logger.info("ddauth\uff1aaccess_token is null !");
                errorMessage = "access_token is null !";
            } else {
                String jsticket = DDUtils.getJsapiTicket(appInfo.getAppkey(), accessToken, currentCenter);
                String nonceStr = DDConfigSign.getRandomStr(16);
                Date now = new Date();
                long timestamp = now.getTime();
                Map<String, Object> params = ParametersUtils.getCommonParameters(currentCenter);
                Object corpId = params.get("ddcorpid");
                if (corpId == null || StringUtils.isEmpty((String)corpId.toString())) {
                    throw new Exception("corpId is not configure");
                }
                String sign = DDConfigSign.sign(jsticket, nonceStr, timestamp, url);
                logger.info("dd sign:" + sign);
                returnMap.put("agentId", agentId);
                returnMap.put("corpId", corpId);
                returnMap.put("timeStamp", timestamp);
                returnMap.put("nonceStr", nonceStr);
                returnMap.put("signature", sign);
                isOk = true;
            }
        }
        catch (Exception e) {
            logger.error("getAppTrdAuthData error:" + e);
            errorMessage = e.getMessage();
        }
        returnMap.put(SUCCESS, isOk);
        returnMap.put("errorMessage", errorMessage);
        try {
            String sJson = JSONUtils.toString(returnMap);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)sJson);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
    }

    private String getUserSourceType(Account account) {
        String userSourceType = account.getUserSourceTypeOutput();
        Map<String, Object> paramMap = ParametersUtils.getCommonParameters(account);
        if (paramMap != null && !paramMap.isEmpty()) {
            boolean globalDeploy;
            boolean isEnableWxBusiness;
            String temp = userSourceType.replace("[", "").replace("]", "");
            String[] typeList = temp.split(",");
            ArrayList<String> sourceTypeList = new ArrayList<String>(8);
            sourceTypeList.addAll(Arrays.asList(typeList));
            List typeResult = sourceTypeList.stream().filter(v -> !v.equals("3")).collect(Collectors.toList());
            boolean bl = isEnableWxBusiness = paramMap.containsKey("isenablewxqyh") && Boolean.parseBoolean(String.valueOf(paramMap.get("isenablewxqyh")));
            if (isEnableWxBusiness) {
                typeResult.add("6");
            }
            if (!(globalDeploy = GlobalDeployUtils.isGlobalDeploy((String)account.getTenantId())) && paramMap.containsKey("open_sms_login") && Boolean.parseBoolean(String.valueOf(paramMap.get("open_sms_login")))) {
                typeResult.add("7");
            }
            if (typeResult != null && typeResult.size() > 0) {
                userSourceType = String.format("[%S]", String.join((CharSequence)",", typeResult));
            }
        }
        return userSourceType;
    }

    public void verifyBindingFlag(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Lang lang = LoginLangUtils.getLoginLanguage(request);
        LoginLangUtils.setLang(lang);
        String tenantAlias = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        tenantAlias = LoginAction.getDefaultTenant(tenantAlias);
        String errorMessage = "";
        boolean isOK = false;
        boolean isSuccess = false;
        try {
            String bindingFlag = LoginUtils.getParamerter(request, BINDING_FLAG);
            if ("POST".equalsIgnoreCase(request.getMethod()) && "application/json".equalsIgnoreCase(request.getContentType()) && StringUtils.isEmpty((String)bindingFlag)) {
                ApiRequestContext.initThreadLocal((HttpServletRequest)request, (HttpServletResponse)response);
                ApiRequestContext ctx = ApiRequestContext.get();
                try {
                    Map mapReq = (Map)ctx.getPostData(HashMap.class);
                    if (mapReq != null) {
                        bindingFlag = (String)mapReq.get(BINDING_FLAG);
                    }
                }
                catch (Exception mapReq) {
                    // empty catch block
                }
            }
            String errorText = ResManager.loadKDString((String)"bindingflag\u53c2\u6570\u65e0\u6548\u6216\u5df2\u7ecf\u8fc7\u671f\u3002", (String)"ApiInterfaceAction_5", (String)BOS_LOGIN, (Object[])new Object[0]);
            if (StringUtils.isNotEmpty((String)bindingFlag)) {
                String sesssionId = EncreptSessionUtils.getSessionIdByBindingFlag((String)bindingFlag);
                if (StringUtils.isNotEmpty((String)sesssionId)) {
                    SessionInfo sessionInfo = LoginUtils.getSessinInfoBySessionId(sesssionId);
                    if (sessionInfo != null) {
                        isOK = true;
                    }
                } else {
                    errorMessage = errorText;
                }
            } else {
                errorMessage = errorText;
            }
            isSuccess = true;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            errorMessage = e.getMessage();
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>(8);
        returnMap.put(SUCCESS, isSuccess);
        returnMap.put("online", isOK);
        returnMap.put("errorMessage", errorMessage);
        try {
            String sJson = JSONUtils.toString(returnMap);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)sJson);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
    }

    public void queryParameters(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String customLoginClass;
        Lang lang = LoginLangUtils.getLoginLanguage(request);
        LoginLangUtils.setLang(lang);
        LoginAccount loginAccount = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty());
        Account currentCenter = loginAccount.getAccount();
        String tenantId = loginAccount.getTenantId();
        String userSourceType = "";
        int defaultUserSourceType = 2;
        boolean hasLDAP = false;
        String domain = "";
        boolean closeEncrypt = false;
        boolean forbidRememberPwd = false;
        Map<String, Object> paramMap = ParametersUtils.getCommonParameters(currentCenter);
        HashMap<String, Object> returnMap = new HashMap<String, Object>(8);
        returnMap.put(SUCCESS, false);
        try {
            Object closePwdEncrypt;
            returnMap.put(SUCCESS, true);
            hasLDAP = LoginUtils.isSupportLDAP(currentCenter);
            Map<String, String> ldapInfo = LoginUtils.getLdapInfo(currentCenter);
            if (hasLDAP) {
                domain = ResManager.loadKDString((String)"\u5df2\u542f\u7528AD\u57df\u8d26\u53f7\u5bc6\u7801\u767b\u5f55\u3002", (String)"ApiInterfaceAction_6", (String)BOS_LOGIN, (Object[])new Object[0]);
            }
            if (paramMap != null && !ObjectUtils.isEmpty((Object)(closePwdEncrypt = paramMap.get("close_login_encrypt"))) && Boolean.parseBoolean(closePwdEncrypt.toString())) {
                closeEncrypt = true;
            }
            userSourceType = this.getUserSourceType(currentCenter);
            Map<String, Object> customDataMap = LoginUtils.getCustomDataMapNew(request, true);
            String defaultUserSourceTypeStr = kd.bos.login.utils.StringUtils.getStringValue(customDataMap.get("defaultusersourcetype"));
            if (StringUtils.isNotEmpty((String)defaultUserSourceTypeStr)) {
                defaultUserSourceType = Integer.parseInt(defaultUserSourceTypeStr);
            }
            if (!userSourceType.contains(String.valueOf(defaultUserSourceType))) {
                defaultUserSourceType = 2;
            }
            if (paramMap != null && paramMap.get("forbid_remember_pwd") != null) {
                forbidRememberPwd = Boolean.parseBoolean(String.valueOf(paramMap.get("forbid_remember_pwd")));
            }
            returnMap.put("forbidRememberPwd", forbidRememberPwd);
        }
        catch (Throwable e) {
            logger.error("queryParameters#error", e);
        }
        returnMap.put("hasLDAP", hasLDAP);
        returnMap.put("domain", domain);
        returnMap.put("userSourceType", userSourceType);
        returnMap.put("defaultUserSourceType", defaultUserSourceType);
        returnMap.put("closeEncrypt", closeEncrypt);
        returnMap.put("needSignPrivacy", PrivacyPolicyService.enablePrivacy());
        if (kd.bos.util.StringUtils.isNotEmpty((String)SystemPropertyUtils.getProptyByTenant((String)ENABLE_RSA_ECB_OAEP, (String)tenantId)) && SystemPropertyUtils.getProptyByTenant((String)ENABLE_RSA_ECB_OAEP, (String)tenantId).equals("true")) {
            returnMap.put("rsaPadding", "oaep");
        }
        if ("true".equals(SystemPropertyUtils.getProptyByTenant((String)"enable_dataCenter_loginPage", (String)tenantId))) {
            returnMap.put("enableDataCenterLoginPage", true);
        }
        if (SessionKeys.isAccountSession((String)tenantId)) {
            returnMap.put("isAccountSession", true);
        }
        if (ParametersUtils.getBooleanParameters(currentCenter, "enable_soft_keyboard")) {
            returnMap.put("enableSoftKeyboard", true);
        }
        if (kd.bos.login.utils.StringUtils.isNotEmpty(customLoginClass = DefaultParameterService.getDefaultParamsConfig(currentCenter, "custom_dynamiccode_login_class"))) {
            returnMap.put("needCustomDynamicCode", true);
        }
        try {
            String sJson = JSONUtils.toString(returnMap);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)sJson);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
    }

    public void weChatCallBack(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Account currentCenter = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty()).getAccount();
        String type = request.getParameter("apptype");
        String result = "error";
        if ("kingdee_sky".equals(type)) {
            result = ThirdAppService.dealPushData(request);
        } else {
            String serviceCorpID;
            Map<String, Object> paramMap = ParametersUtils.getCommonParameters(currentCenter);
            String suiteID = request.getParameter("suiteID");
            String sToken = "";
            String sEncodingAESKey = "";
            if (paramMap != null && null != paramMap.get("qywxh_stoken")) {
                sToken = paramMap.get("qywxh_stoken").toString();
            }
            if (paramMap != null && null != paramMap.get("qywxh_aes_key")) {
                sEncodingAESKey = paramMap.get("qywxh_aes_key").toString();
            }
            if (StringUtils.isEmpty((String)sToken)) {
                logger.info("stoken is null");
            }
            if (StringUtils.isEmpty((String)sEncodingAESKey)) {
                logger.info("sEncodingAESKey is null");
            }
            if (StringUtils.isEmpty((String)(serviceCorpID = request.getParameter("serviceCorpID")))) {
                logger.info("serviceCorpID is null");
            }
            String msgSig = request.getParameter("msg_signature");
            String verifyTimeStamp = request.getParameter("timestamp");
            String verifyNonce = request.getParameter("nonce");
            String sVerifyEchoStr = request.getParameter("echostr");
            String corpId = request.getParameter("corpId");
            if (StringUtils.isEmpty((String)corpId)) {
                logger.info("corpId is null");
            }
            WXBizMsgCrypt wxcpt = null;
            try {
                if ("post".equals(request.getMethod().toLowerCase(Locale.ENGLISH))) {
                    if (StringUtils.isEmpty((String)suiteID)) {
                        logger.info("suiteID is null");
                        return;
                    }
                    wxcpt = new WXBizMsgCrypt(sToken, sEncodingAESKey, suiteID);
                    result = WxqyhUtils.dealWechatPushData(wxcpt, msgSig, verifyTimeStamp, verifyNonce);
                } else {
                    if (kd.bos.login.utils.StringUtils.isNotEmpty(corpId)) {
                        serviceCorpID = corpId;
                    }
                    wxcpt = new WXBizMsgCrypt(sToken, sEncodingAESKey, serviceCorpID);
                    result = WxqyhUtils.verifyURL(wxcpt, msgSig, verifyTimeStamp, verifyNonce, sVerifyEchoStr);
                }
            }
            catch (Exception e) {
                logger.info(e.getMessage());
            }
        }
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }

    private Map<String, Object> wrapAppTrdAuthData(List<AuthSignatureResult> authSignatureList) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        JSONObject authSignature = new JSONObject();
        for (AuthSignatureResult authSignatureResult : authSignatureList) {
            JSONObject json = new JSONObject();
            json.put("agentId", (Object)authSignatureResult.getAgentId());
            json.put("appId", (Object)authSignatureResult.getAppId());
            json.put("eid", (Object)authSignatureResult.getEid());
            json.put("signature", (Object)authSignatureResult.getSignature());
            json.put("timestamp", (Object)authSignatureResult.getTimestamp());
            json.put("nonce", (Object)authSignatureResult.getNonce());
            if ("agentConfig".equals(authSignatureResult.getConfigType())) {
                authSignature.put("agentConfig", (Object)json);
                continue;
            }
            authSignature.put("config", (Object)json);
        }
        if (ObjectUtils.isEmpty((Object)authSignature)) {
            result.put(SUCCESS, false);
            return result;
        }
        result.put(SUCCESS, true);
        result.put("errorCode", 0);
        result.put("data", authSignature);
        return result;
    }

    private ThirdAuthApp getThirdAuthApp(HttpServletRequest request, String appType, String entryRole, String url) {
        ThirdAuthApp thirdAuthAppInfo = new ThirdAuthApp();
        String eid = request.getParameter("eid");
        long thirdAppType = ThirdAppService.getThirdAppUserType(entryRole);
        thirdAuthAppInfo.setEntryRole(String.valueOf(thirdAppType));
        thirdAuthAppInfo.setErpRole(SkyUtils.getSystemEnv());
        thirdAuthAppInfo.setLightAppId(request.getParameter("lightAppId"));
        thirdAuthAppInfo.setCorpId(request.getParameter("corpId"));
        thirdAuthAppInfo.setAgentId(request.getParameter("agentId"));
        thirdAuthAppInfo.setSecret(request.getParameter("appSecret"));
        thirdAuthAppInfo.setAccessUrl(url);
        if ("kingdee_sky".equals(appType)) {
            DynamicObject[] data = ThirdAppService.getThirdappsConfigByCorpid(eid, thirdAppType);
            if (data != null && data.length > 0) {
                thirdAuthAppInfo.setCorpId(String.valueOf(data[0].get("corpid")));
                thirdAuthAppInfo.setSecret(String.valueOf(data[0].get("corpsecret")));
            }
            thirdAuthAppInfo.setMode("0");
        }
        return thirdAuthAppInfo;
    }

    private List<Map<String, Object>> handleDatacenter(List<AccountVO> voList, String tenantId) {
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>(8);
        for (AccountVO accountVO : voList) {
            HashMap<String, Object> data = new HashMap<String, Object>(8);
            data.put("kdcdc", accountVO.getAccountId());
            if (!"true".equals(SystemPropertyUtils.getProptyByTenant((String)"bos.svc.accountId.hidden", (String)tenantId))) {
                data.put(ACCOUNT_ID, accountVO.getAccountId());
            }
            data.put("accountName", accountVO.getAccountName());
            data.put("accountNumber", accountVO.getAccountNumber());
            data.put("default", accountVO.isDefault());
            data.put("userSourceType", accountVO.getUserSourceType());
            data.put("defaultUserSourceType", accountVO.getDefaultUserSourceType());
            result.add(data);
        }
        CustomParam customParam = new CustomParam();
        HashSet<String> keySet = new HashSet<String>(8);
        keySet.add("bos_svc_login_kdcdc_class");
        Map map = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)customParam);
        if (map != null && map.get("bos_svc_login_kdcdc_class") != null) {
            ILoginExtService loginExtService = (ILoginExtService)BeanUtils.getBean((String)((String)map.get("bos_svc_login_kdcdc_class")));
            result = loginExtService.handleDatacenter(result);
        }
        return result;
    }
}

