/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.actions;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.config.client.ConfigurationFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.encrypt.Encrypters;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.emun.MCDBType;
import kd.bos.login.mc.exception.MCInitException;
import kd.bos.login.mc.model.Database;
import kd.bos.login.mc.service.MCService;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.MCUtils;
import kd.bos.login.utils.MQUtils;
import kd.bos.login.utils.ZKUtils;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.RevProxyUtil;
import kd.bos.util.StringUtils;
import kd.bos.util.SystemProperties;

public class MCServerAction {
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_CONF_TYPE = "conf";
    private static final String PARAM_SESSION_ID = "sessionId";
    private static final String TYPE_AUTH = "doAuth";
    private static final String BOS_LOGIN = "bos-login";
    private static final String DEFAULT_ERROR_CODE = "0";
    private static final String DEFAULT_SUCCESS_CODE = "100";
    private static final String DEFAULT_NO_AUTH_CODE = "400";
    private static final int DEFAULT_AUTH_TIME = 5;
    private static final String ENTER_SEP = "\n";
    private static final String PARAM_SEP = "=";
    private static final String REDIS_URL_SEP = ":";
    private static final String REDIS_PWD_SEP = "/";
    private static final String FORMAT_S_S = "%s:%s";
    private static final String KEY_URL = "doUrl";
    private static final String URL_INFO = "mcserviceurl";
    private static final String LOGIN_USER_TYPE = "usersourcetype";
    private static final String LOGIN_SSO_PLUGIN = "ssoplugin";
    private static final String LOGIN_CONFIG_ENABLE = "mc_init_sso";
    private static final String KEY_DATABASE = "doDatabase";
    private static final String DB_TYPE = "dbtype";
    private static final String DB_HOST = "dbhost";
    private static final String DB_PORT = "dbport";
    private static final String DB_INSTANCE = "dbinstance";
    private static final String DB_USER = "dbuser";
    private static final String DB_PWD = "dbpassword";
    private static final String DB_NAME = "dbname";
    private static final String DB_CONNECTION = "dbconnection";
    private static final String KEY_REDIS = "doRedis";
    private static final String REDIS_MODEL = "redismodel";
    private static final String REDIS_URL = "redisurl";
    private static final String REDIS_PWD = "redispassword";
    private static final String REDIS_HOST = "redishost";
    private static final String REDIS_PORT = "redisport";
    private static final String KEY_MQ = "doMq";
    private static final String MQ_TYPE = "mqtype";
    private static final String MQ_HOST = "mqhost";
    private static final String MQ_PORT = "mqport";
    private static final String MQ_USER = "mquser";
    private static final String MQ_PWD = "mqpassword";
    private static final String MQ_V_HOST = "mqvhost";
    private static final String MQ_IP = "mqip";
    private static final String KEY_ES = "doEs";
    private static final String ES_URL = "esurl";
    private static final String ES_USERNAME = "esusername";
    private static final String ES_PWD = "espassword";
    private static final String LOG_ES = "logesurl";
    private static final String LOG_KAFKA = "logkafkaurl";
    private static final String MC_ROUTE_KEY = "sys";
    private static final int CONNECTION_TIMEOUT = 3000;
    private static final Log LOGGER = LogFactory.getLog(MCServerAction.class);

    public void dbSetting(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String type = request.getParameter(PARAM_TYPE);
        try {
            if (!TYPE_AUTH.equals(type)) {
                MCServerAction.checkAuthenticated(request);
            }
            Method method = this.getClass().getDeclaredMethod(type, HttpServletRequest.class, HttpServletResponse.class);
            method.invoke((Object)this, request, response);
        }
        catch (MCInitException e) {
            MCServerAction.error(response, e);
        }
        catch (NoSuchMethodException e) {
            MCServerAction.error(response, String.format(ResManager.loadKDString((String)"\u672a\u77e5\u7684\u8bf7\u6c42\u7c7b\u578b\uff1a%s", (String)"MCServerAction_0", (String)BOS_LOGIN, (Object[])new Object[0]), type));
        }
        catch (InvocationTargetException e) {
            Throwable exception = e.getTargetException();
            if (exception instanceof MCInitException) {
                MCServerAction.error(response, (MCInitException)exception);
            } else {
                MCServerAction.error(response, exception.getMessage());
            }
        }
        catch (Exception e) {
            MCServerAction.error(response, ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    public void doAuth(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String dbPsd = request.getParameter(DB_PWD);
        if (StringUtils.isEmpty((String)dbPsd)) {
            throw new MCInitException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6570\u636e\u5e93\u5bc6\u7801\u3002", (String)"MCServerAction_1", (String)BOS_LOGIN, (Object[])new Object[0]));
        }
        byte[] psd = Base64.getDecoder().decode(dbPsd);
        JSONObject settings = MCServerAction.getDBSettingsFromZK(request);
        if (settings.isEmpty()) {
            MCServerAction.success(response, ResManager.loadKDString((String)"\u672a\u521d\u59cb\u5316MC\uff0c\u65e0\u9700\u8ba4\u8bc1", (String)"MCServerAction_2", (String)BOS_LOGIN, (Object[])new Object[0]));
            return;
        }
        String tokenKey = MCServerAction.getTokenKey(settings, request);
        if (MCServerAction.getAuthTimes(tokenKey) >= 5) {
            throw new MCInitException(ResManager.loadKDString((String)"\u8eab\u4efd\u8ba4\u8bc1\u5df2\u9501\u5b9a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"MCServerAction_3", (String)BOS_LOGIN, (Object[])new Object[0]));
        }
        String pdFromZK = settings.getString(DB_PWD);
        String pdDecrypted = Encrypters.decode((String)pdFromZK);
        if (!Arrays.equals(psd, pdDecrypted.getBytes())) {
            int authTimes = MCServerAction.getAuthTimes(tokenKey) + 1;
            MCService.setMCInitToken(tokenKey, String.valueOf(authTimes));
            if (authTimes >= 5) {
                throw new MCInitException(ResManager.loadKDString((String)"\u8eab\u4efd\u8ba4\u8bc1\u5df2\u9501\u5b9a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"MCServerAction_3", (String)BOS_LOGIN, (Object[])new Object[0]));
            }
            int restChances = 5 - authTimes;
            throw new MCInitException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5\u3002\uff08\u4ecd\u53ef\u5c1d\u8bd5%s\u6b21\uff09", (String)"MCServerAction_4", (String)BOS_LOGIN, (Object[])new Object[0]), restChances));
        }
        MCService.setMCInitToken(tokenKey, Encrypters.encode((String)new String(psd)));
        Arrays.fill(psd, (byte)0);
        MCService.removeZKCache();
        MCServerAction.success(response, ResManager.loadKDString((String)"\u8ba4\u8bc1\u6210\u529f", (String)"MCServerAction_5", (String)BOS_LOGIN, (Object[])new Object[0]));
    }

    public void doUrl(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject res = MCService.getZKCache(KEY_URL);
        if (res.isEmpty()) {
            String url = request.getScheme() + "://" + request.getLocalAddr() + REDIS_URL_SEP + request.getLocalPort();
            res.put(URL_INFO, (Object)url);
            if (Boolean.getBoolean(LOGIN_CONFIG_ENABLE)) {
                res.putAll((Map)MCServerAction.getDCSettingsFromZK(request, LOGIN_USER_TYPE, LOGIN_SSO_PLUGIN));
            }
        }
        MCServerAction.success(response, res.toJSONString());
    }

    public void doDatabase(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject res = MCService.getZKCache(KEY_DATABASE);
        if (res.isEmpty()) {
            res = MCServerAction.getDBSettingsFromZK(request);
        }
        res.remove((Object)DB_PWD);
        MCServerAction.success(response, res.toJSONString());
    }

    public void doTestDatabase(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Database database = new Database(request);
        database.setTestConnection(true);
        MCService.getSelfConfigs(database, URL_INFO);
        MCServerAction.success(response, StringUtils.getEmpty());
    }

    public void doMq(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject res = MCService.getZKCache(KEY_MQ);
        if (!res.isEmpty()) {
            MCServerAction.success(response, res.toJSONString());
            return;
        }
        try {
            res = this.getMq(MCService.getZKUrl());
        }
        catch (Exception e) {
            LOGGER.info("get mq from zk error: " + e.getMessage());
        }
        if (res.isEmpty()) {
            res = MCServerAction.getMq(new Database());
        }
        MCServerAction.success(response, res.toJSONString());
    }

    public void doRedis(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject res = MCService.getZKCache(KEY_REDIS);
        if (!res.isEmpty()) {
            MCServerAction.success(response, res.toJSONString());
            return;
        }
        try {
            res = MCServerAction.getRedis(MCService.getZKUrl());
        }
        catch (Exception e) {
            LOGGER.info("get redis from zk error: " + e.getMessage());
        }
        if (res.isEmpty()) {
            res = MCServerAction.getRedis(new Database());
        }
        MCServerAction.success(response, res.toJSONString());
    }

    public void doEs(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject res = MCService.getZKCache(KEY_ES);
        if (!res.isEmpty()) {
            MCServerAction.success(response, res.toJSONString());
            return;
        }
        try {
            res = MCServerAction.getEs(MCService.getZKUrl());
        }
        catch (Exception e) {
            LOGGER.info("get es from zk error: " + e.getMessage());
        }
        MCServerAction.success(response, res.toJSONString());
    }

    public void doNext(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String confType = request.getParameter(PARAM_CONF_TYPE);
        if (StringUtils.isEmpty((String)confType)) {
            throw new MCInitException(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u914d\u7f6e\u6570\u636e\u7c7b\u578b", (String)"MCServerAction_6", (String)BOS_LOGIN, (Object[])new Object[0]));
        }
        JSONObject data = new JSONObject();
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String name = (String)params.nextElement();
            if (PARAM_CONF_TYPE.equals(name) || PARAM_TYPE.equals(name)) continue;
            String val = request.getParameter(name);
            if (name.contains("password")) {
                val = new String(Base64.getDecoder().decode(val));
            }
            if (LOGIN_SSO_PLUGIN.equals(name) && StringUtils.isNotEmpty((String)val)) {
                try {
                    Class.forName(val);
                }
                catch (Exception e) {
                    throw new MCInitException("doNext#" + val);
                }
            }
            data.put(name, (Object)val);
        }
        boolean isDatabase = KEY_DATABASE.equals(confType);
        if (isDatabase) {
            Database database = new Database(request);
            MCService.getSelfConfigs(database, URL_INFO);
        }
        if (!LoginUtils.isMCSingleMode()) {
            if (KEY_MQ.equals(confType)) {
                String mqType = data.getString(MQ_TYPE);
                if ("rabbitmq".equals(mqType)) {
                    MCServerAction.checkMQ(data);
                }
            } else if (KEY_REDIS.equals(confType)) {
                MCServerAction.checkRedis(data);
            }
        }
        if (!isDatabase) {
            MCService.setZKCache(confType, data);
        }
        MCServerAction.success(response, null);
    }

    public void doConfirm(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject info = MCService.getZKCache(StringUtils.getEmpty());
        JSONObject res = new JSONObject();
        for (Map.Entry e : info.entrySet()) {
            JSONObject cnf = (JSONObject)e.getValue();
            res.putAll((Map)cnf);
        }
        MCServerAction.success(response, res.toJSONString());
    }

    public void doSetting(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            MCService.setReplaceConfigs();
            MCServerAction.dbInitExecutor();
            MCServerAction.dbSaveExecutor();
            JSONObject settings = MCServerAction.getDBSettingsFromZK(request);
            String tenantCode = RevProxyUtil.getTenantCode((HttpServletRequest)request);
            settings.put("tenantCode", (Object)tenantCode);
            MCServerAction.zkSendExecutor(settings);
            MCServerAction.invalidAuthentication(settings, request);
            MCService.removeZKCache();
            MCServerAction.success(response, StringUtils.getEmpty());
        }
        catch (Exception e) {
            String msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            LOGGER.error(msg);
            throw new MCInitException(msg);
        }
    }

    private static void dbInitExecutor() {
        Database db = new Database();
        MCService.getSelfConfigs(db, URL_INFO);
        boolean needCreateDB = db.isNeedCreateDB();
        boolean needCreateTB = db.isNeedCreateTB();
        db.close();
        db.setWriteable();
        String instance = db.getInstance();
        if (needCreateDB) {
            LOGGER.info("dbInitExecutor#" + instance);
            String defaultInstance = StringUtils.getEmpty();
            if (db.getType().equals((Object)MCDBType.PG)) {
                defaultInstance = "postgres";
            }
            db.setInstance(defaultInstance);
            db.execute("create database " + instance);
        }
        if (needCreateTB) {
            LOGGER.info("dbInitExecutor#" + instance);
            try {
                db.exeSqlFile(instance);
            }
            catch (Exception e) {
                LOGGER.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                throw new MCInitException(ResManager.loadKDString((String)"\u5efa\u8868\u5931\u8d25\uff1a", (String)"MCServerAction_9", (String)BOS_LOGIN, (Object[])new Object[0]), e);
            }
        }
    }

    private static void dbSaveExecutor() {
        database.setWriteable();
        try (Database database = new Database();){
            database.connect(false);
            LOGGER.info("dbSaveExecutor...");
            MCService.saveDbConnection(database);
            LOGGER.info("dbSaveExecutor...");
            JSONObject cfs = new JSONObject();
            JSONObject data = MCService.getZKCache(KEY_URL);
            String url = data.getString(URL_INFO);
            cfs.put(URL_INFO, (Object)url);
            cfs.put(DB_NAME, (Object)database.getInstance());
            cfs.put(DB_CONNECTION, (Object)String.valueOf(1L));
            JSONObject mq = MCService.getZKCache(KEY_MQ);
            cfs.putAll((Map)mq);
            cfs.put(MQ_IP, mq.get((Object)MQ_HOST));
            JSONObject redis = MCService.getZKCache(KEY_REDIS);
            cfs.put(REDIS_MODEL, (Object)redis.getString(REDIS_MODEL));
            cfs.put(REDIS_URL, (Object)MCServerAction.getEncryptedRedisUrl(redis));
            cfs.putAll(MCUtils.getReplaceMap());
            MCService.saveSelfConfigs(database, cfs);
            LOGGER.info("dbSaveExecutor#");
            HashMap<String, String> commonConfigs = new HashMap<String, String>();
            commonConfigs.put("mc.server.url", url);
            MCService.updateCommonConfigs(database, commonConfigs);
            database.commit();
        }
    }

    private static void zkSendExecutor(JSONObject settings) {
        Database database = new Database();
        String zkUrl = MCService.getZKUrl();
        HashMap<String, String> kv = new HashMap<String, String>();
        JSONObject urlCache = MCService.getZKCache(KEY_URL);
        String accountId = settings.getString("accountId");
        if (StringUtils.isEmpty((String)accountId)) {
            accountId = StringUtils.randomNumber((int)19);
        }
        String tenantCode = settings.getString("tenantCode");
        String key = String.format("mc.tenant.%s.data", tenantCode);
        String value = MCService.getDBZKValue(database, accountId, urlCache.getString(LOGIN_SSO_PLUGIN));
        kv.put(MCService.getZKCommonPropPath(key), value);
        System.setProperty(key, value);
        MCServerAction.saveMq2ZK(kv);
        MCServerAction.saveRedis2ZK(kv);
        MCServerAction.saveEs2ZK(kv);
        MCServerAction.saveFileServer2ZK(kv);
        kv.put(MCService.getZKCommonVarPath("dubbo.zookeeper.ip_port"), zkUrl);
        kv.put(MCService.getZKCommonVarPath("Schedule.zk.server.ip_port"), zkUrl);
        String idBuilder = "IDService.store.path=/{{clusterName}}/runtime/{{appName}}/idService/store\nIDService.store.zookeeper=" + zkUrl + "\nIDService.worker=2\n";
        kv.put(MCService.getZKCommonPropPath("IDService.properties"), idBuilder);
        String domainUrl = SystemProperties.getWithEnv((String)"domain.contextUrl");
        if (StringUtils.isNotEmpty((String)domainUrl)) {
            kv.put(MCService.getZKCommonPropPath("domain.contextUrl"), domainUrl);
        }
        kv.put(MCService.getZKCommonPropPath("bos.ca.properties"), tenantCode + "_enableUseCA=false");
        kv.put(MCService.getZKCommonPropPath("imageServer.url"), "http://127.0.0.1:8100/fileserver");
        for (Map.Entry e : kv.entrySet()) {
            String node = (String)e.getKey();
            LOGGER.info("zkSendExecutor#" + node);
            ZKUtils.setZkData(zkUrl, node, (String)e.getValue());
        }
        ConfigurationFactory.reinit();
    }

    private static void checkAuthenticated(HttpServletRequest request) {
        if (!LoginUtils.isMCSystem()) {
            throw new MCInitException(ResManager.loadKDString((String)"\u82cd\u7a79\u4e0d\u652f\u6301\u521d\u59cb\u5316\u64cd\u4f5c\uff0c\u8bf7\u5230\u7ba1\u7406\u4e2d\u5fc3\u6267\u884c\u53d1\u5e03\u96c6\u7fa4", (String)"MCServerAction_10", (String)BOS_LOGIN, (Object[])new Object[0]));
        }
        JSONObject settings = MCServerAction.getDBSettingsFromZK(request);
        if (settings.isEmpty()) {
            return;
        }
        String tokenKey = MCServerAction.getTokenKey(settings, request);
        String token = MCService.getMCInitToken(tokenKey);
        if (StringUtils.isEmpty((String)token)) {
            throw new MCInitException(DEFAULT_NO_AUTH_CODE, ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u9700\u8981\u8ba4\u8bc1", (String)"MCServerAction_11", (String)BOS_LOGIN, (Object[])new Object[0]));
        }
        String pwdFromZK = settings.getString(DB_PWD);
        if (!Encrypters.decode((String)pwdFromZK).equals(Encrypters.decode((String)token))) {
            throw new MCInitException(DEFAULT_NO_AUTH_CODE, ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u9700\u8981\u8ba4\u8bc1", (String)"MCServerAction_11", (String)BOS_LOGIN, (Object[])new Object[0]));
        }
    }

    private static void invalidAuthentication(JSONObject settings, HttpServletRequest request) {
        if (settings.isEmpty()) {
            return;
        }
        String tokenKey = MCServerAction.getTokenKey(settings, request);
        MCService.removeMCInitToken(tokenKey);
    }

    private static int getAuthTimes(String tokenKey) {
        String token = MCService.getMCInitToken(tokenKey);
        if (StringUtils.isEmpty((String)token) || !StringUtils.isNumeric((String)token)) {
            return 0;
        }
        return Integer.parseInt(token);
    }

    private static String getTokenKey(JSONObject sets, HttpServletRequest request) {
        String src = sets.toJSONString();
        String encodedText = Base64.getEncoder().encodeToString(src.getBytes()).replaceAll("[\\\\/=]+", StringUtils.getEmpty());
        return encodedText.substring(encodedText.length() - 16);
    }

    private static JSONObject getDCSettingsFromZK(HttpServletRequest request, String ... keys) {
        JSONObject prop = MCServerAction.getZKTenantData(request);
        JSONObject res = new JSONObject();
        for (String key : keys) {
            res.put(key, prop.get((Object)key));
        }
        return res;
    }

    private static JSONObject getDBSettingsFromZK(HttpServletRequest request) {
        JSONObject prop = MCServerAction.getZKTenantData(request);
        JSONObject res = new JSONObject();
        if (Objects.isNull(prop.get((Object)"instancelist"))) {
            return res;
        }
        JSONArray instances = prop.getJSONArray("instancelist");
        for (Object it : instances) {
            JSONObject ins = (JSONObject)it;
            if (!Objects.nonNull(ins.get((Object)"routekey")) || !ins.getString("routekey").equals(MC_ROUTE_KEY)) continue;
            String mcDbType = prop.getString("mcdbtype");
            String type4Login = ins.getString(DB_TYPE);
            res.put(DB_TYPE, (Object)MCDBType.getCode(mcDbType, type4Login));
            res.put(DB_HOST, ins.get((Object)"dbip"));
            res.put(DB_PORT, ins.get((Object)DB_PORT));
            res.put(DB_USER, ins.get((Object)DB_USER));
            res.put(DB_INSTANCE, ins.get((Object)"dbinsatnce"));
            res.put(DB_PWD, ins.get((Object)DB_PWD));
            break;
        }
        res.put("clusterName", (Object)Instance.getClusterName());
        res.put("tenantCode", (Object)RevProxyUtil.getTenantCode((HttpServletRequest)request));
        String datacenterid = prop.getString("datacenterid");
        if (StringUtils.isNotEmpty((String)datacenterid)) {
            res.put("accountId", (Object)datacenterid);
        }
        return res;
    }

    private static JSONObject getZKTenantData(HttpServletRequest request) {
        String dbKey = String.format("mc.tenant.%s.data", RevProxyUtil.getTenantCode((HttpServletRequest)request));
        String zkValue = StringUtils.getEmpty();
        try {
            zkValue = ZKUtils.getZkData(MCService.getZKUrl(), MCService.getZKCommonPropPath(dbKey));
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
        }
        if (StringUtils.isEmpty((String)zkValue)) {
            return new JSONObject();
        }
        JSONArray tenantData = JSONArray.parseArray((String)zkValue);
        if (tenantData.isEmpty()) {
            return new JSONObject();
        }
        JSONObject prop = tenantData.getJSONObject(0);
        if (Objects.isNull(prop)) {
            return new JSONObject();
        }
        return prop;
    }

    private JSONObject getMq(String zkUrl) {
        JSONObject res = new JSONObject();
        res.put(MQ_TYPE, (Object)ZKUtils.getZkData(zkUrl, MCService.getZKCommonVarPath("mq.server.type")));
        res.put(MQ_HOST, (Object)ZKUtils.getZkData(zkUrl, MCService.getZKCommonVarPath("mq.server.ip")));
        res.put(MQ_PORT, (Object)ZKUtils.getZkData(zkUrl, MCService.getZKCommonVarPath("mq.server.port")));
        res.put(MQ_USER, (Object)ZKUtils.getZkData(zkUrl, MCService.getZKCommonVarPath("mq.server.user")));
        res.put(MQ_V_HOST, (Object)ZKUtils.getZkData(zkUrl, MCService.getZKCommonVarPath("mq.server.vhost")));
        return res;
    }

    private static JSONObject getRedis(String zkUrl) {
        JSONObject res = new JSONObject();
        String model = StringUtils.getEmpty();
        String redisUrl = StringUtils.getEmpty();
        String redisProp = ZKUtils.getZkData(zkUrl, MCService.getZKCommonPropPath("redis.properties"));
        if (StringUtils.isNotEmpty((String)redisProp)) {
            String param = redisProp.split(ENTER_SEP)[0];
            int idx = param.indexOf(PARAM_SEP);
            String redisUrlWithModel = param.substring(idx + 1);
            idx = redisUrlWithModel.indexOf(REDIS_URL_SEP);
            model = redisUrlWithModel.substring(0, idx);
            redisUrl = redisUrlWithModel.substring(idx + 1);
        }
        if (StringUtils.isEmpty((String)redisUrl) || redisUrl.contains("{{")) {
            try {
                redisUrl = ZKUtils.getZkData(zkUrl, MCService.getZKCommonVarPath("redis.serversForCache.ip_port"));
            }
            catch (Exception e) {
                LOGGER.info("get redis.serversForCache.ip_port from zk error: " + e.getMessage());
            }
        }
        if (StringUtils.isEmpty((String)model) || model.contains("{{")) {
            try {
                model = ZKUtils.getZkData(zkUrl, MCService.getZKCommonVarPath("redis.session.mode"));
            }
            catch (Exception e) {
                LOGGER.info("get redis.session.mode from zk error: " + e.getMessage());
            }
        }
        res.put(REDIS_MODEL, (Object)model);
        MCServerAction.getDisplayRedisUrl(res, redisUrl);
        return res;
    }

    private static JSONObject getEs(String zkUrl) {
        JSONObject res = new JSONObject();
        String monitorProp = ZKUtils.getZkData(zkUrl, MCService.getZKCommonPropPath("monitor.properties"));
        for (String prop : monitorProp.split(ENTER_SEP)) {
            String[] keyValue = prop.split(PARAM_SEP);
            String key = keyValue[0];
            String value = keyValue[1];
            if ("monitor.es.url".equals(key)) {
                res.put(ES_URL, (Object)value);
                continue;
            }
            if ("monitor.es.user".equals(key)) {
                res.put(ES_USERNAME, (Object)value);
                continue;
            }
            if (!"monitor.es.password".equals(key)) continue;
            res.put(ES_PWD, (Object)value);
        }
        res.put(LOG_ES, (Object)ZKUtils.getZkData(zkUrl, MCService.getZKCommonVarPath("log.es.ip_port")));
        res.put(LOG_KAFKA, (Object)ZKUtils.getZkData(zkUrl, MCService.getZKCommonVarPath("log.kafka.ip_port")));
        return res;
    }

    private static JSONObject getMq(Database database) {
        JSONObject res = MCService.getSelfConfigs(database, MQ_TYPE, MQ_IP, MQ_HOST, MQ_PORT, MQ_USER, MQ_V_HOST);
        if (StringUtils.isEmpty((String)res.getString(MQ_HOST))) {
            res.put(MQ_HOST, res.get((Object)MQ_IP));
        }
        return res;
    }

    private static JSONObject getRedis(Database database) {
        JSONObject res = MCService.getSelfConfigs(database, REDIS_MODEL, REDIS_URL, REDIS_HOST, REDIS_PORT);
        String host = res.getString(REDIS_HOST);
        if (StringUtils.isNotEmpty((String)host)) {
            res.put(REDIS_URL, (Object)String.format(FORMAT_S_S, host, res.get((Object)REDIS_PORT)));
        }
        if (Objects.nonNull(res.get((Object)REDIS_URL))) {
            MCServerAction.getDisplayRedisUrl(res, res.getString(REDIS_URL));
        }
        return res;
    }

    private static void getDisplayRedisUrl(JSONObject res, String url) {
        if (StringUtils.isEmpty((String)url)) {
            return;
        }
        int idx = url.indexOf(REDIS_PWD_SEP);
        if (idx == -1) {
            res.put(REDIS_URL, (Object)url);
        } else {
            res.put(REDIS_URL, (Object)url.substring(0, idx));
            res.put(REDIS_PWD, (Object)url.substring(idx + 1));
        }
    }

    private static String getEncryptedRedisUrl(JSONObject redis) {
        String url = redis.getString(REDIS_URL);
        String pwd = redis.getString(REDIS_PWD);
        if (StringUtils.isNotEmpty((String)pwd)) {
            if (!Encrypters.isEncrypted((String)pwd)) {
                pwd = Encrypters.encode((String)pwd);
            }
            url = url + REDIS_PWD_SEP + pwd;
        }
        return url;
    }

    private static void checkRedis(JSONObject data) {
        String redisUrl = data.getString(REDIS_URL);
        String pwd = data.getString(REDIS_PWD);
        if (StringUtils.isNotEmpty((String)pwd)) {
            redisUrl = redisUrl + REDIS_PWD_SEP + Encrypters.decode((String)pwd);
        }
        JedisClient client = null;
        try {
            String url = String.format(FORMAT_S_S, data.getString(REDIS_MODEL), redisUrl);
            String key = "doRedisredisurl";
            client = RedisFactory.getJedisClient((String)url);
            client.set(key, url);
            client.del(key);
        }
        catch (Exception e) {
            LOGGER.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw new MCInitException("checkRedis#" + e.getMessage());
        }
        finally {
            if (Objects.nonNull(client)) {
                client.close();
            }
        }
    }

    private static void checkMQ(JSONObject data) {
        Connection conn = null;
        Channel channel = null;
        try {
            conn = MQUtils.getConnection(data.getString(MQ_HOST), Integer.parseInt(data.getString(MQ_PORT)), data.getString(MQ_V_HOST), data.getString(MQ_USER), data.getString(MQ_PWD), 3000);
            String queueName = "mc.test";
            channel = conn.createChannel();
            channel.queueDeclare(queueName, false, false, false, null);
            String test = "test for mc initialize";
            channel.basicPublish("", queueName, null, test.getBytes());
            channel.queueDelete(queueName);
        }
        catch (Exception e) {
            LOGGER.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw new MCInitException("checkMQ#" + e.getMessage());
        }
        finally {
            if (null != channel) {
                try {
                    channel.close();
                }
                catch (Exception e) {
                    LOGGER.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
            }
            if (null != conn) {
                try {
                    conn.close();
                }
                catch (IOException e) {
                    LOGGER.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
            }
        }
    }

    private static void saveRedis2ZK(Map<String, String> kv) {
        kv.put(MCService.getZKCommonPropPath("redis.properties"), "redis.serversForCache={{redis.session.mode}}:{{redis.serversForCache.ip_port}}\nredis.serversForSession={{redis.session.mode}}:{{redis.serversForSession.ip_port}}\nredis.pool.maxTotal=200\nredis.defaulttimeout=28800");
        JSONObject data = MCService.getZKCache(KEY_REDIS);
        String url = MCServerAction.getEncryptedRedisUrl(data);
        kv.put(MCService.getZKCommonVarPath("redis.session.mode"), data.getString(REDIS_MODEL));
        kv.put(MCService.getZKCommonVarPath("redis.serversForCache.ip_port"), url);
        kv.put(MCService.getZKCommonVarPath("redis.serversForSession.ip_port"), url);
    }

    private static void saveMq2ZK(Map<String, String> kv) {
        kv.put(MCService.getZKCommonPropPath("mq.server"), "type={{mq.server.type}}\nhost={{mq.server.ip}}\nport={{mq.server.port}}\nuser={{mq.server.user}}\npassword={{mq.server.password}}\nvhost={{mq.server.vhost}}");
        JSONObject data = MCService.getZKCache(KEY_MQ);
        kv.put(MCService.getZKCommonVarPath("mq.server.type"), data.getString(MQ_TYPE));
        kv.put(MCService.getZKCommonVarPath("mq.server.ip"), data.getString(MQ_HOST));
        kv.put(MCService.getZKCommonVarPath("mq.server.port"), data.getString(MQ_PORT));
        kv.put(MCService.getZKCommonVarPath("mq.server.user"), data.getString(MQ_USER));
        kv.put(MCService.getZKCommonVarPath("mq.server.password"), Encrypters.encode((String)data.getString(MQ_PWD)));
        kv.put(MCService.getZKCommonVarPath("mq.server.vhost"), data.getString(MQ_V_HOST));
    }

    private static void saveEs2ZK(Map<String, String> kv) {
        JSONObject data = MCService.getZKCache(KEY_ES);
        String conf = String.format("monitor.es.url=%s\nmonitor.es.user=%s\nmonitor.es.password=%s\nmonitor.user=%s\nmonitor.password=%s", data.get((Object)ES_URL), data.get((Object)ES_USERNAME), data.get((Object)ES_PWD), data.get((Object)ES_USERNAME), data.get((Object)ES_PWD));
        kv.put(MCService.getZKCommonPropPath("monitor.properties"), conf);
        kv.put(MCService.getZKCommonVarPath("log.es.ip_port"), data.getString(LOG_ES));
        kv.put(MCService.getZKCommonVarPath("log.kafka.ip_port"), data.getString(LOG_KAFKA));
    }

    private static void saveFileServer2ZK(Map<String, String> kv) {
        String conf = "attachmentServer.maxFileSize=1052428800\nattachmentServer.tcpUrl={{attachmentServer.ip}}:{{attachmentServer.tcpport}}\nattachmentServer.url=http://{{attachmentServer.ip}}:{{attachmentServer.httpport}}/fileserver\nattachment.fileserver=http://{{attachment.fileserver.ip_port}}/attachment/download.do?path=/\nfileserver=http://{{attachmentServer.ip}}:{{attachmentServer.httpport}}/fileserver";
        kv.put(MCService.getZKCommonPropPath("attachmentServer.properties"), conf);
        String ip = "127.0.0.1";
        String port = "8100";
        kv.put(MCService.getZKCommonVarPath("attachmentServer.ip"), ip);
        kv.put(MCService.getZKCommonVarPath("attachmentServer.httpport"), port);
        kv.put(MCService.getZKCommonVarPath("attachmentServer.tcpport"), port);
        kv.put(MCService.getZKCommonVarPath("attachment.fileserver.ip_port"), ip + REDIS_URL_SEP + port);
    }

    private static void success(HttpServletResponse response, String data) throws Exception {
        JSONObject res = new JSONObject();
        res.put("errorcode", (Object)DEFAULT_SUCCESS_CODE);
        res.put("data", (Object)data);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)res.toJSONString());
    }

    private static void error(HttpServletResponse response, String msg) throws Exception {
        String resp = LoginUtils.getLoginResponse(DEFAULT_ERROR_CODE, msg);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)resp);
    }

    private static void error(HttpServletResponse response, MCInitException ex) throws Exception {
        JSONObject res = new JSONObject();
        res.put("errorcode", (Object)ex.getErrCode());
        res.put("description", (Object)ex.getMessage());
        res.put("description_cn", (Object)ex.getMessage());
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)res.toJSONString());
    }
}

