/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.actions;

import com.google.common.io.CharStreams;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.utils.HttpUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.util.StringUtils;

public class MobileLoginAction {
    private static Log logger = LogFactory.getLog(MobileLoginAction.class);
    private static String ACCOUNTID_EMPTY_STRING_BEGIN = "<input type=\"hidden\" id=\"accountId\" name=\"accountId\" value=\"";
    private static String ACCOUNTID_EMPTY_STRING_END = "\">";
    private String ACCOUNT_LIST_EMPTY_STRING_BEGIN = String.format(" <div class=\"input\"><span class='lable'>%s</span>", this.getDataCenterName());
    private static String ACCOUNT_LIST_EMPTY_STRING_END = "  </div> ";

    private String getDataCenterName() {
        return ResManager.loadKDString((String)"\u6570\u636e\u4e2d\u5fc3", (String)"MobileLoginAction_0", (String)"bos-login", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        Lang lang = LoginLangUtils.getLoginLanguage(servletRequest);
        LoginLangUtils.setLang(lang);
        OutputStreamWriter writer = null;
        InputStreamReader reader = null;
        InputStream in = null;
        try {
            servletResponse.setContentType("text/html;charset=utf-8");
            CharSequence html = null;
            in = this.getClass().getResourceAsStream("/mobile.tpl");
            reader = new InputStreamReader(in, "UTF-8");
            html = CharStreams.toString((Readable)reader);
            HashMap<String, CharSequence> m = new HashMap<String, CharSequence>();
            m.put("redirect", servletRequest.getParameter("redirect"));
            String accountString = "";
            String accountListString = "";
            String accountIdParameter = servletRequest.getParameter("accountId");
            if (StringUtils.isNotEmpty((String)accountIdParameter)) {
                accountString = this.ACCOUNT_LIST_EMPTY_STRING_BEGIN + ACCOUNTID_EMPTY_STRING_BEGIN + accountIdParameter + ACCOUNTID_EMPTY_STRING_END + ACCOUNT_LIST_EMPTY_STRING_END;
            } else {
                List<Account> centerList = LoginAccountFactory.createInstanceByDefault(servletRequest).getAccounts();
                if (centerList != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(this.ACCOUNT_LIST_EMPTY_STRING_BEGIN);
                    sb.append("<select name=\"accountId\" type=\"text\"  >");
                    for (Account account : centerList) {
                        sb.append("<option value='").append(account.getAccountId()).append("'>").append(account.getAccountName()).append(" </option>");
                    }
                    sb.append("</select>");
                    sb.append(ACCOUNT_LIST_EMPTY_STRING_END);
                    accountListString = sb.toString();
                }
            }
            m.put("accountList", accountListString);
            m.put("account", accountString);
            m.put("message", "");
            m.put("contextPath", servletRequest.getContextPath());
            html = LoginUtils.replacePlaceHolder(html, m);
            writer = new OutputStreamWriter((OutputStream)servletResponse.getOutputStream(), "utf-8");
            writer.write(html.toString());
            writer.flush();
            writer.close();
        }
        catch (KDException ex) {
            logger.error((Throwable)ex);
            ErrorCode code = ex.getErrorCode();
            HttpUtils.webAlertNoHeader(servletResponse, ex.getMessage());
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            KDException kd = new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458,%s", (String)"MobileLoginAction_1", (String)"bos-login", (Object[])new Object[]{e.getMessage()})});
            HttpUtils.webAlertNoHeader(servletResponse, kd.getMessage());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
        }
    }
}

